/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.service.impl;

import cn.kinyun.scrm.vip.cache.service.BlacklistCacheService;
import cn.kinyun.scrm.vip.cache.service.VersionedCache;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class BlacklistCacheServiceImpl
extends VersionedCache
implements BlacklistCacheService {
    private static final Logger log = LoggerFactory.getLogger(BlacklistCacheServiceImpl.class);
    private Map<Long, Set<String>> cache = Collections.emptyMap();
    @Value(value="${spring.redis.key.prefix}${spring.redis.key.blackListVersion:black_list_version}")
    private String versionRedisKey;

    @Override
    protected String getVersionRedisKey() {
        return this.versionRedisKey;
    }

    @Override
    protected Long getExpiredInSecond() {
        return 300L;
    }

    @Override
    public void newVersion() {
        super.reset();
    }

    @Override
    @Scheduled(fixedRate=5000L)
    public void refresh() {
        super.refresh();
    }

    @Override
    protected void initialize() {
        log.warn("\u6682\u4e0d\u652f\u6301\u9ed1\u540d\u5355");
        this.cache = Collections.emptyMap();
    }

    @Override
    public boolean inBlacklist(Long bizId, String wechatId) {
        log.debug("query if wechatId={} in bizId={} 's black list", (Object)wechatId, (Object)bizId);
        Set<String> ids = this.cache.get(bizId);
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        return ids.contains(wechatId);
    }
}

