/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.dto;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.cache.dto.WordHit;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class MatchedResult {
    public static final MatchedResult EMPTY = new MatchedResult();
    private final List<WordHit> hits = new ArrayList<WordHit>();
    private final List<String> words = new ArrayList<String>();
    private List<CachedReplyMsg> list;

    public void add(WordHit wordHit) {
        this.words.add(wordHit.getWord());
        this.hits.add(wordHit);
    }

    public void add(String word, CachedReplyMsg msg) {
        this.words.add(word);
        this.hits.add(new WordHit(word, Collections.singletonList(msg)));
    }

    public void add(String word, List<CachedReplyMsg> list) {
        this.words.add(word);
        this.hits.add(new WordHit(word, list));
    }

    public List<String> getWords() {
        return this.words;
    }

    public List<WordHit> getHits() {
        return this.hits;
    }

    public List<CachedReplyMsg> getList() {
        if (this.list != null) {
            return this.list;
        }
        if (this.hits.isEmpty()) {
            this.list = Collections.emptyList();
            return this.list;
        }
        LinkedHashSet<CachedReplyMsg> set = new LinkedHashSet<CachedReplyMsg>();
        for (WordHit r : this.hits) {
            if (!CollectionUtils.isNotEmpty(r.getList())) continue;
            set.addAll(r.getList());
        }
        this.list = Lists.newArrayList(set);
        return this.list;
    }

    public boolean isEmpty() {
        return this.hits.isEmpty();
    }

    public String toString() {
        return "MatchedResult(hits=" + this.getHits() + ", words=" + this.getWords() + ", list=" + this.getList() + ")";
    }
}

