/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.cache.dto;

import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.cache.dto.MatchedResult;
import cn.kinyun.scrm.vip.cache.dto.WordTree;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CachedReplyData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<String, List<String>> fuzzyMatched = Maps.newConcurrentMap();
    private Map<String, String> accurateMatched = Maps.newConcurrentMap();
    private Map<String, CachedReplyMsg> idToReplyMap = Maps.newConcurrentMap();
    private WordTree fuzzyDict = new WordTree();

    public void merge(Map<String, String> accurateMatched, Set<String> dict, Map<String, List<String>> wordToReplyIds, Map<String, CachedReplyMsg> idToReplyMap) {
        this.accurateMatched.putAll(accurateMatched);
        wordToReplyIds.forEach((key, value) -> {
            List<String> list = this.fuzzyMatched.get(key);
            if (list == null) {
                this.fuzzyMatched.put((String)key, (List<String>)value);
            } else {
                list.addAll((Collection<String>)value);
            }
        });
        this.fuzzyDict.addWords(dict);
        this.idToReplyMap.putAll(idToReplyMap);
    }

    public MatchedResult match(String message) {
        CachedReplyMsg r;
        MatchedResult result = new MatchedResult();
        String accurateId = this.accurateMatched.get(message);
        if (accurateId != null && (r = this.idToReplyMap.get(accurateId)) != null) {
            result.add(message, r);
            return result;
        }
        if (!this.fuzzyDict.isContainsWord(message)) {
            return MatchedResult.EMPTY;
        }
        List<String> words = this.fuzzyDict.getMatchedWords(message);
        for (String w : words) {
            List<String> ids = this.fuzzyMatched.get(w);
            ArrayList<CachedReplyMsg> list = new ArrayList<CachedReplyMsg>();
            for (String id : ids) {
                CachedReplyMsg r2 = this.idToReplyMap.get(id);
                if (r2 == null) continue;
                list.add(r2);
            }
            result.add(w, list);
        }
        return result;
    }

    public Map<String, List<String>> getFuzzyMatched() {
        return this.fuzzyMatched;
    }

    public Map<String, String> getAccurateMatched() {
        return this.accurateMatched;
    }

    public Map<String, CachedReplyMsg> getIdToReplyMap() {
        return this.idToReplyMap;
    }

    public WordTree getFuzzyDict() {
        return this.fuzzyDict;
    }

    public void setFuzzyMatched(Map<String, List<String>> fuzzyMatched) {
        this.fuzzyMatched = fuzzyMatched;
    }

    public void setAccurateMatched(Map<String, String> accurateMatched) {
        this.accurateMatched = accurateMatched;
    }

    public void setIdToReplyMap(Map<String, CachedReplyMsg> idToReplyMap) {
        this.idToReplyMap = idToReplyMap;
    }

    public void setFuzzyDict(WordTree fuzzyDict) {
        this.fuzzyDict = fuzzyDict;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachedReplyData)) {
            return false;
        }
        CachedReplyData other = (CachedReplyData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$fuzzyMatched = this.getFuzzyMatched();
        Map<String, List<String>> other$fuzzyMatched = other.getFuzzyMatched();
        if (this$fuzzyMatched == null ? other$fuzzyMatched != null : !((Object)this$fuzzyMatched).equals(other$fuzzyMatched)) {
            return false;
        }
        Map<String, String> this$accurateMatched = this.getAccurateMatched();
        Map<String, String> other$accurateMatched = other.getAccurateMatched();
        if (this$accurateMatched == null ? other$accurateMatched != null : !((Object)this$accurateMatched).equals(other$accurateMatched)) {
            return false;
        }
        Map<String, CachedReplyMsg> this$idToReplyMap = this.getIdToReplyMap();
        Map<String, CachedReplyMsg> other$idToReplyMap = other.getIdToReplyMap();
        if (this$idToReplyMap == null ? other$idToReplyMap != null : !((Object)this$idToReplyMap).equals(other$idToReplyMap)) {
            return false;
        }
        WordTree this$fuzzyDict = this.getFuzzyDict();
        WordTree other$fuzzyDict = other.getFuzzyDict();
        return !(this$fuzzyDict == null ? other$fuzzyDict != null : !((Object)this$fuzzyDict).equals(other$fuzzyDict));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CachedReplyData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<String>> $fuzzyMatched = this.getFuzzyMatched();
        result = result * 59 + ($fuzzyMatched == null ? 43 : ((Object)$fuzzyMatched).hashCode());
        Map<String, String> $accurateMatched = this.getAccurateMatched();
        result = result * 59 + ($accurateMatched == null ? 43 : ((Object)$accurateMatched).hashCode());
        Map<String, CachedReplyMsg> $idToReplyMap = this.getIdToReplyMap();
        result = result * 59 + ($idToReplyMap == null ? 43 : ((Object)$idToReplyMap).hashCode());
        WordTree $fuzzyDict = this.getFuzzyDict();
        result = result * 59 + ($fuzzyDict == null ? 43 : ((Object)$fuzzyDict).hashCode());
        return result;
    }

    public String toString() {
        return "CachedReplyData(fuzzyMatched=" + this.getFuzzyMatched() + ", accurateMatched=" + this.getAccurateMatched() + ", idToReplyMap=" + this.getIdToReplyMap() + ", fuzzyDict=" + this.getFuzzyDict() + ")";
    }
}

