/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.handler.common;

import cn.kinyun.link.common_dto.dto.BaseResponse;
import cn.kinyun.scrm.vip.cache.dto.CachedReplyMsg;
import cn.kinyun.scrm.vip.cache.service.ReplyOptionCacheService;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.common.MsgDigestHelper;
import cn.kinyun.scrm.vip.reply.dto.AutoReplyMessageDto;
import cn.kinyun.scrm.vip.reply.service.ReplySettingService;
import cn.kinyun.scrm.vip.service.PushMsgService;
import com.google.common.base.Objects;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.utils.SHA1Utils;
import com.kuaike.scrm.dal.vip.entity.VipWeworkContact;
import com.kuaike.scrm.dal.vip.mapper.VipWeworkContactMapper;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReplyMsgSendHelper {
    private static final Logger log = LoggerFactory.getLogger(ReplyMsgSendHelper.class);
    public static final String REF_FORMAT = "\u300c %s: %s \u300d\n- - - - - - - - - - - - - - -";
    @Autowired
    private MsgDigestHelper msgDigestHelper;
    @Autowired
    private ReplyOptionCacheService replyOptionCacheService;
    @Autowired
    private PushMsgService pushMsgService;
    @Autowired
    private ReplySettingService settingService;
    @Autowired
    private VipWeworkContactMapper weworkContactMapper;

    public boolean sendFriendOption(String text, List<CachedReplyMsg> matched) {
        log.info("send reply options with matched reply={}", matched);
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String weworkId = ctx.getWeworkId();
        String senderId = ctx.getSenderId();
        String content = this.replyOptionCacheService.buildOptions("\u4ee5\u4e0b\u5185\u5bb9\u662f\u5426\u80fd\u591f\u5e2e\u52a9\u5230\u60a8\uff1f\u60a8\u53ef\u4ee5\u56de\u590d\u6570\u5b57\u9009\u62e9\uff1a", matched);
        String digest = SHA1Utils.digest((String)content);
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        this.replyOptionCacheService.clearCache(bizId, weworkId, senderId);
        try {
            AutoReplyMessageDto message = new AutoReplyMessageDto();
            message.setMsgType(JsMsgType.TEXT.getValue());
            message.setContent(content);
            this.pushMsgService.push(weworkId, bizId, ctx.getCorpDigitId(), ctx.getConId(), Integer.valueOf(0), null, Collections.singletonList(message));
        }
        catch (Exception e) {
            log.error("send message failed, requestId={}, message={}", new Object[]{ctx.getRequestId(), content, e});
            return false;
        }
        String redisKey = this.replyOptionCacheService.getReplyOptionKey(bizId, weworkId, senderId);
        this.replyOptionCacheService.cache(redisKey, weworkId, bizId, text, matched);
        this.msgDigestHelper.cache(digest);
        return true;
    }

    public boolean sendFriendMsg(String question, String keyword, CachedReplyMsg cachedReplyMsg) {
        String ref;
        List replyMsgList;
        ReplyContext ctx = ReplyContextUtil.get();
        Long bizId = ctx.getBizId();
        String weworkId = ctx.getWeworkId();
        String digest = keyword;
        if (digest == null) {
            digest = cachedReplyMsg.getDigest();
        }
        if (this.msgDigestHelper.isCached(digest)) {
            return true;
        }
        String replyMessage = cachedReplyMsg.getMsg();
        try {
            replyMsgList = JacksonUtil.str2List((String)replyMessage, AutoReplyMessageDto.class);
            if (CollectionUtils.isEmpty((Collection)replyMsgList)) {
                log.warn("No reply message found: result={}", (Object)replyMessage);
                return false;
            }
        }
        catch (IOException e) {
            log.error("Failed parsing replyMessage, message={}", (Object)replyMessage, (Object)e);
            return false;
        }
        boolean isReferText = this.settingService.isReferFriendText(bizId);
        if (isReferText && StringUtils.isNotBlank((CharSequence)(ref = this.buildFriendRefText(question)))) {
            this.addReferText(ref, replyMsgList);
        }
        BaseResponse flag = this.pushMsgService.push(weworkId, bizId, ctx.getCorpDigitId(), ctx.getConId(), Integer.valueOf(0), null, replyMsgList);
        this.msgDigestHelper.cache(digest);
        if (flag == null || flag.getCode() != 0L) {
            log.error("send message failed, requestId={}, message={}", (Object)ctx.getRequestId(), (Object)replyMessage);
            return false;
        }
        return true;
    }

    private String buildFriendRefText(String question) {
        if (StringUtils.isBlank((CharSequence)question)) {
            return null;
        }
        ReplyContext ctx = ReplyContextUtil.get();
        VipWeworkContact contact = this.weworkContactMapper.getContact(ctx.getWeworkId(), ctx.getSenderId(), ctx.getCorpDigitId(), ctx.getBizId());
        if (contact == null) {
            log.warn("Wework contact not found, weworkId={}, senderId={}", (Object)ctx.getWeworkId(), (Object)ctx.getSenderId());
            return null;
        }
        String nickname = StringUtils.isNotBlank((CharSequence)contact.getRemark()) ? contact.getRemark() : contact.getNickname();
        return String.format(REF_FORMAT, nickname, question);
    }

    private void addReferText(String refText, List<AutoReplyMessageDto> replyMsgList) {
        AutoReplyMessageDto firstMsg = replyMsgList.get(0);
        if (Objects.equal((Object)firstMsg.getMsgType(), (Object)JsMsgType.TEXT.getValue())) {
            firstMsg.setContent(refText + "\n" + firstMsg.getContent());
        } else {
            AutoReplyMessageDto msg = new AutoReplyMessageDto();
            msg.setMsgType(JsMsgType.TEXT.getValue());
            msg.setContent(refText);
            msg.setSeq(Integer.valueOf(0));
            replyMsgList.add(0, msg);
        }
    }
}

