/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.vip.dispatcher;

import cn.kinyun.scrm.vip.cache.service.WeworkAccountCacheService;
import cn.kinyun.scrm.vip.context.ReplyContext;
import cn.kinyun.scrm.vip.context.ReplyContextUtil;
import cn.kinyun.scrm.vip.handler.FriendMsgRecvHandler;
import cn.kinyun.scrm.vip.handler.GroupMsgRecvHandler;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.vip.dto.CachedWeworkAccount;
import com.kuaike.scrm.vip.dto.model.WeworkMessage;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeworkMessageDispatcher {
    private static final Logger log = LoggerFactory.getLogger(WeworkMessageDispatcher.class);
    @Autowired
    private WeworkAccountCacheService weworkAccountCacheService;
    @Value(value="${wechatMessage.expireTime.friend:7200}")
    private long friendMsgExpiredTime;
    @Value(value="${wechatMessage.expireTime.group:600}")
    private long groupMsgExpiredTime;
    @Autowired
    private FriendMsgRecvHandler friendMsgRecvHandler;
    @Autowired
    private GroupMsgRecvHandler groupMsgRecvHandler;

    public void dispatch(WeworkMessage weworkMessage) {
        log.info("dispatch message requestId={}, contentType={}, conType={}, conId={}, msgId={}, appInfo={}", new Object[]{weworkMessage.getRequestId(), weworkMessage.getContentType(), weworkMessage.getConType(), weworkMessage.getConId(), weworkMessage.getMsgId(), weworkMessage.getAppInfo()});
        Integer conType = weworkMessage.getConType();
        if (conType == null) {
            log.warn("ConType is null");
            return;
        }
        if (StringUtils.isBlank((CharSequence)weworkMessage.getAppInfo())) {
            log.warn("appInfo is blank");
            return;
        }
        if (this.isSend(weworkMessage)) {
            return;
        }
        if (this.isExpired(weworkMessage)) {
            return;
        }
        if (this.isInternal(weworkMessage)) {
            return;
        }
        CachedWeworkAccount account = this.weworkAccountCacheService.get(weworkMessage.getWeworkId());
        if (account == null || account.getBizId() == null) {
            log.warn("\u673a\u5668\u4eba\u7684\u5546\u6237ID\u4e3a\u7a7a. wechatId={}", (Object)weworkMessage.getWeworkId());
            return;
        }
        ReplyContext ctx = ReplyContextUtil.get();
        ctx.setRequestId(weworkMessage.getRequestId());
        ctx.setWeworkId(weworkMessage.getWeworkId());
        ctx.setSenderId(weworkMessage.getSenderId());
        ctx.setConId(weworkMessage.getConId());
        ctx.setConType(weworkMessage.getConType());
        ctx.setAppInfo(weworkMessage.getAppInfo());
        ctx.setBizId(account.getBizId());
        ctx.setCorpId(account.getCorpId());
        ctx.setWeworkDigitId(account.getWeworkDigitId());
        ctx.setCorpDigitId(account.getCorpDigitId());
        ctx.setCorpIdStr(account.getCorpIdStr());
        ctx.setWeworkUserId(account.getWeworkUserId());
        ctx.setWeworkUserNum(account.getWeworkUserNum());
        switch (conType) {
            case 0: {
                this.friendMsgRecvHandler.dispatch(weworkMessage);
                break;
            }
            case 1: {
                this.groupMsgRecvHandler.dispatch(weworkMessage);
                break;
            }
            default: {
                log.warn("\u672a\u77e5\u4f1a\u8bdd\u7c7b\u578b, conType={}", (Object)conType);
            }
        }
    }

    private boolean isSend(WeworkMessage weworkMessage) {
        Preconditions.checkArgument((weworkMessage.getWeworkId() != null ? 1 : 0) != 0, (Object)"senderId is null");
        Preconditions.checkArgument((weworkMessage.getSenderId() != null ? 1 : 0) != 0, (Object)"weworkId is null");
        String senderId = weworkMessage.getSenderId();
        String weworkId = weworkMessage.getWeworkId();
        int contentType = weworkMessage.getContentType();
        switch (contentType) {
            case 1001: 
            case 1002: 
            case 1003: 
            case 1006: 
            case 1011: 
            case 1023: {
                return false;
            }
        }
        if (senderId.equals(weworkId)) {
            log.info("ignore msg send by bot, requestId={}", (Object)weworkMessage.getRequestId());
            return true;
        }
        return false;
    }

    private boolean isExpired(WeworkMessage weworkMessage) {
        Preconditions.checkArgument((weworkMessage.getSendTime() != null ? 1 : 0) != 0, (Object)"sendTime is null");
        int conType = weworkMessage.getConType();
        long expiredTime = conType == 0 ? this.friendMsgExpiredTime : this.groupMsgExpiredTime;
        Date createTime = weworkMessage.getSendTime();
        long time = createTime.getTime();
        long cur = System.currentTimeMillis();
        long last = (cur - time) / 1000L;
        if (last > expiredTime) {
            log.warn("Ignore expired message. requestId={}, expired={}", (Object)weworkMessage.getRequestId(), (Object)WeworkMessageDispatcher.formatExpireTime(last));
            return true;
        }
        return false;
    }

    private static String formatExpireTime(long sec) {
        StringBuilder sb = new StringBuilder();
        if (sec >= 86400L) {
            long days = sec / 86400L;
            sec -= days * 86400L;
            sb.append(days).append("day");
        }
        if (sec >= 3600L) {
            long hours = sec / 3600L;
            sec -= hours * 3600L;
            sb.append(hours).append("hour");
        }
        if (sec >= 60L) {
            long minutes = sec / 60L;
            sec -= minutes * 60L;
            sb.append(minutes).append("min");
        }
        if (sec > 0L) {
            sb.append(sec).append("sec");
        }
        return sb.toString();
    }

    private boolean isInternal(WeworkMessage weworkMessage) {
        Preconditions.checkArgument((weworkMessage.getExternalFlag() != null ? 1 : 0) != 0, (Object)"externalFlag is null");
        Integer externalFlag = weworkMessage.getExternalFlag();
        if (externalFlag == 1) {
            return false;
        }
        log.warn("\u4e0d\u5904\u7406\u5185\u90e8\u6d88\u606f, requestId={}", (Object)weworkMessage.getRequestId());
        return true;
    }
}

