/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.system.dto.request.RoleNodeReqDto;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class UserRoleReqDto
implements Serializable {
    private static final long serialVersionUID = 211804528472296510L;
    private Long userId;
    private List<RoleNodeReqDto> roles;

    public void validate() {
        Preconditions.checkArgument((this.userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.roles), (Object)"\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        for (RoleNodeReqDto dto : this.roles) {
            Preconditions.checkArgument((dto.getRoleId() != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public List<UserRole> to(CurrentUserInfo currentUserInfo) {
        ArrayList<UserRole> list = new ArrayList<UserRole>();
        if (CollectionUtils.isNotEmpty(this.roles)) {
            for (RoleNodeReqDto dto : this.roles) {
                if (CollectionUtils.isNotEmpty(dto.getNodeIds())) {
                    for (Long nodeId : dto.getNodeIds()) {
                        list.add(this.buildUserRoleObj(dto.getRoleId(), nodeId, currentUserInfo));
                    }
                    continue;
                }
                list.add(this.buildUserRoleObj(dto.getRoleId(), NumberUtils.LONG_ZERO, currentUserInfo));
            }
        }
        return list;
    }

    private UserRole buildUserRoleObj(Long roleId, Long nodeId, CurrentUserInfo currentUserInfo) {
        UserRole userRole = new UserRole();
        userRole.setUserId(this.userId);
        userRole.setRoleId(roleId);
        if (Objects.isNull(nodeId)) {
            userRole.setManageNodeId(NumberUtils.LONG_ZERO);
        }
        userRole.setManageNodeId(nodeId);
        userRole.setBizId(currentUserInfo.getBizId());
        userRole.setCreateBy(currentUserInfo.getId());
        userRole.setCreateTime(new Date());
        userRole.setUpdateBy(currentUserInfo.getId());
        userRole.setUpdateTime(new Date());
        userRole.setIsDeleted(NumberUtils.INTEGER_ZERO);
        userRole.setCorpId(currentUserInfo.getCorpId());
        return userRole;
    }

    public Long getUserId() {
        return this.userId;
    }

    public List<RoleNodeReqDto> getRoles() {
        return this.roles;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setRoles(List<RoleNodeReqDto> roles) {
        this.roles = roles;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserRoleReqDto)) {
            return false;
        }
        UserRoleReqDto other = (UserRoleReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<RoleNodeReqDto> this$roles = this.getRoles();
        List<RoleNodeReqDto> other$roles = other.getRoles();
        return !(this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserRoleReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<RoleNodeReqDto> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        return result;
    }

    public String toString() {
        return "UserRoleReqDto(userId=" + this.getUserId() + ", roles=" + this.getRoles() + ")";
    }
}

