/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.operatelog.dto.OperateLogQueryParams;
import com.kuaike.scrm.dal.operatelog.entity.OperateLog;
import com.kuaike.scrm.dal.operatelog.mapper.OperateLogMapper;
import com.kuaike.scrm.system.dto.request.OperateLogListReqDto;
import com.kuaike.scrm.system.dto.response.OperateLogListRespDto;
import com.kuaike.scrm.system.service.OperateLogService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OperateLogServiceImpl
implements OperateLogService {
    private static final Logger log = LoggerFactory.getLogger(OperateLogServiceImpl.class);
    @Autowired
    private OperateLogMapper operateLogMapper;

    @Override
    public List<OperateLogListRespDto> list(OperateLogListReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("list operateLog with params ={},operatorId={}", (Object)params, (Object)currentUserInfo.getId());
        ArrayList<OperateLogListRespDto> resultList = new ArrayList<OperateLogListRespDto>();
        OperateLogQueryParams queryParams = params.to(currentUserInfo.getBizId());
        List operateLogList = this.operateLogMapper.queryOperateLog(queryParams);
        if (CollectionUtils.isNotEmpty((Collection)operateLogList)) {
            for (OperateLog operateLog : operateLogList) {
                resultList.add(OperateLogListRespDto.from(operateLog));
            }
        }
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.operateLogMapper.queryCount(queryParams)));
            params.getPageDto().setCurPageCount(Integer.valueOf(resultList.size()));
        }
        return resultList;
    }
}

