/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.utils;

import com.kuaike.scrm.common.service.dto.NetSchoolGoodsDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetSchoolGoodsId {
    private static final Logger log = LoggerFactory.getLogger(NetSchoolGoodsId.class);
    private static final String FORMAT = "%06d%02d%08d%04d";
    private static final Integer DEFAULT_SCHOOL_ID = 2;

    private NetSchoolGoodsId() {
    }

    public static String getId(Long bizId, NetSchoolGoodsDto goodsDto) {
        return String.format(FORMAT, bizId, goodsDto.getGoodsType(), goodsDto.getId(), goodsDto.getSchoolId());
    }

    public static Long getOriginId(String productId) {
        return Long.parseLong(productId.substring(8, 16));
    }

    public static Integer getGoodsType(String productId) {
        return Integer.parseInt(productId.substring(6, 8));
    }

    public static Integer getSchoolId(String productId) {
        if (productId.length() == 16) {
            return DEFAULT_SCHOOL_ID;
        }
        try {
            return Integer.parseInt(productId.substring(16, 20));
        }
        catch (Exception e) {
            log.info("\u89e3\u6790productId:{}\u5931\u8d25", (Object)productId);
            return DEFAULT_SCHOOL_ID;
        }
    }
}

