/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.pay.business.dto.request.PayConfigAddReq;
import cn.kinyun.pay.business.dto.request.PayConfigBaseReq;
import cn.kinyun.pay.business.enums.PayChannelCode;
import cn.kinyun.pay.business.enums.PayChannelType;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.ApiResult;
import com.kuaike.common.utils.ApiResultUtils;
import com.kuaike.common.utils.BaseUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.app.center.service.AppCenterService;
import com.kuaike.scrm.common.dto.AppOpenBaseReqDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.UserRoleRespDto;
import com.kuaike.scrm.common.enums.AppCodeEnum;
import com.kuaike.scrm.common.enums.BizStatus;
import com.kuaike.scrm.common.enums.GoodsOrderSource;
import com.kuaike.scrm.common.enums.NetSchoolGoodsTypeEnum;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.OrgService;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.service.dto.resp.NetSchoolAppResp;
import com.kuaike.scrm.common.utils.AES256Util;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.app.entity.App;
import com.kuaike.scrm.dal.app.mapper.AppMapper;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.netschool.entity.NetSchoolSyncLog;
import com.kuaike.scrm.dal.netschool.mapper.NetSchoolSyncLogMapper;
import com.kuaike.scrm.dal.permission.dto.RoleQueryParams;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.entity.UserRole;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.shop.entity.ShopSku;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.system.dto.request.AddNetSchoolOrderReq;
import com.kuaike.scrm.system.dto.request.AddNetSchoolRefundOrderReq;
import com.kuaike.scrm.system.dto.request.CanBuyReq;
import com.kuaike.scrm.system.dto.request.NetSchoolCallbackDto;
import com.kuaike.scrm.system.dto.request.NetSchoolCourseListReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolEnableUserDto;
import com.kuaike.scrm.system.dto.request.NetSchoolGetTokenReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolGoodsCanBuyReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleAddReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleModParam;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleModReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolSetRoleMenuReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolSetUserRoleReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolTokenReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolUpdateUnionIdDto;
import com.kuaike.scrm.system.dto.request.NetSchoolUserAddReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolUserModReqDto;
import com.kuaike.scrm.system.dto.response.CourseResponse;
import com.kuaike.scrm.system.dto.response.GetNetSchoolTokenResp;
import com.kuaike.scrm.system.dto.response.NetSchoolDelResp;
import com.kuaike.scrm.system.dto.response.NetSchoolGetTokenRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolGoodsCanBuyRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolGoodsCanBuyResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolLearnDto;
import com.kuaike.scrm.system.dto.response.NetSchoolMenuRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolMenuResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolOrderResp;
import com.kuaike.scrm.system.dto.response.NetSchoolRefundOrderResp;
import com.kuaike.scrm.system.dto.response.NetSchoolResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolRoleAddResult;
import com.kuaike.scrm.system.dto.response.NetSchoolRoleDetailRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolRoleDetailResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolRoleModResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolSetRoleMenuResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolSetUserRoleResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolUser;
import com.kuaike.scrm.system.dto.response.NetSchoolUserAddResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolUserDetailRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolUserDetailResultRespDto;
import com.kuaike.scrm.system.dto.response.NetSchoolUserListResultDto;
import com.kuaike.scrm.system.dto.response.NetSchoolUserModResultDto;
import com.kuaike.scrm.system.dto.response.PackageMenuRespDto;
import com.kuaike.scrm.system.dto.response.SchoolInfoRespDto;
import com.kuaike.scrm.system.dto.response.SchoolListRespDto;
import com.kuaike.scrm.system.service.PackageService;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import com.kuaike.scrm.system.utils.NetSchoolGoodsId;
import com.kuaike.scrm.system.utils.ResultCode;
import com.kuaike.trace.utils.TraceExecutorWrapUtil;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpSession;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ScrmNetSchoolServiceImpl
implements ScrmNetSchoolService {
    private static final Logger log = LoggerFactory.getLogger(ScrmNetSchoolServiceImpl.class);
    public static final Integer DEFAULT_OPERATOR_ID = 2;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private UserMapper userMapper;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Resource
    private RoleMenuMapper roleMenuMapper;
    @Resource
    private UserRoleMapper userRoleMapper;
    @Resource
    private RoleMapper roleMapper;
    @Resource
    private WeworkContactMapper weworkContactMapper;
    @Resource
    private NodeService nodeService;
    @Resource
    private OrgService orgService;
    @Resource
    private PackageService packageService;
    @Resource
    private ScrmBizService scrmBizService;
    @Resource
    private AppCenterService appCenterService;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private AppMapper appMapper;
    @Resource
    private NetSchoolSyncLogMapper netSchoolPullLogMapper;
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private ShopSkuMapper shopSkuMapper;
    @Autowired(required=false)
    private ScrmPayConfigService scrmPayConfigService;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;
    @Value(value="${net.school.secret.key:}")
    public String secretKey;
    @Value(value="${spring.redis.externalRedisKey:%s:external:token:%s}")
    private String externalRedisKey;
    private static final String SCRM_TOKEN = "Scrm-Token";
    private static final int NET_SCHOOL_SUCCESS_CODE = 200;
    private static final String GET_NET_SCHOOL_TOKEN_URL = "/api/scrm/login/getToken";
    private static final String PERMISSION_MENU_URL = "/api/scrm/prmList";
    private static final String GET_NET_SCHOOL_SCHOOL_LIST_URL = "/api/scrm/schoolInfoList?org_name={0}";
    private static final String ROLE_ADD_URL = "/api/scrm/role";
    private static final String ROLE_DETAIL_URL = "/api/scrm/role/{0}";
    private static final String ROLE_UPDATE_URL = "/api/scrm/role/{0}";
    private static final String DELETE_ROLE_URL = "/api/scrm/role/{0}";
    private static final String SET_ROLE_MENU_URL = "/api/scrm/role/menu/{0}";
    private static final String USER_ADD_MOD = "/api/scrm/adminUser";
    private static final String USER_DETAIL = "/api/scrm/adminUser/{0}";
    private static final String DELETE_USER_URL = "/api/scrm/adminUser/{0}";
    private static final String ENABLE_DISABLE_USER_URL = "/api/scrm/adminUser/on/{0}";
    private static final String SET_USER_ROLE_URL = "/api/scrm/adminUser/role/{0}";
    private static final String USER_LIST_URL = "/api/scrm/adminUser?page=1&limit={0}&ids={1}";
    private static final String USER_MENU_URL = "/api/scrm/adminUser/menu/getMenuInfo";
    private static final String UPDATE_UNION_ID_URL = "/api/scrm/user/unionId";
    private static final String ADD_ORDER = "/api/scrm/order/create";
    private static final String ADD_REFUND = "/api/scrm/order/refund";
    private static final String GOODS_IS_CAN_BUY_URL = "/api/scrm/shop/isBuy";
    private static final String SCHOOL_DETAIL_URL = "/api/scrm/schoolInfoDetail?id={0}";
    private static final String COURSE_LIST_URL = "/api/scrm/courseList?title={0}&start_time={1}&end_time={2}&page={3}&limit={4}";
    private static final String PAY_ACCOUNT_URL = "/api/scrm/payAccount";

    @Override
    public ApiResult getToken(String param) {
        NetSchoolGetTokenReqDto netSchoolGetTokenDto;
        String decodeParam;
        log.info("getToken,param:{}", (Object)param);
        ApiResult apiResult = ApiResultUtils.buildApiResult();
        if (StringUtils.isBlank((CharSequence)param)) {
            log.info("getToken,param\u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        try {
            decodeParam = AES256Util.decode((String)param, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u89e3\u7801param:{}\u53d1\u751f\u5f02\u5e38:", (Object)param, (Object)e);
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        try {
            netSchoolGetTokenDto = (NetSchoolGetTokenReqDto)JacksonUtil.str2Obj((String)decodeParam, NetSchoolGetTokenReqDto.class);
        }
        catch (Exception e) {
            log.error("decodeParam:{}\u8f6c\u6210NetSchoolGetTokenDto\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38:", (Object)decodeParam, (Object)e);
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        Long bizId = netSchoolGetTokenDto.getBizId();
        Integer userId = netSchoolGetTokenDto.getUserId();
        if (Objects.isNull(bizId)) {
            log.info("\u5546\u6237id\u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        if (Objects.isNull(userId)) {
            log.info("\u7528\u6237id\u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null) {
            log.info("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230\u5546\u6237", (Object)bizId);
            apiResult.setCode((long)ResultCode.BIZ_NOT_EXIST.getValue());
            apiResult.setMsg(ResultCode.BIZ_NOT_EXIST.getDesc());
            return apiResult;
        }
        if (businessCustomer.getStatus().intValue() != BizStatus.NORMAL.getValue()) {
            log.info("\u5546\u6237bizId:{}\u7684status:{}\u4e0d\u4e3a\u6b63\u5e38", (Object)bizId, (Object)businessCustomer.getStatus());
            apiResult.setCode((long)ResultCode.BIZ_DISABLED.getValue());
            apiResult.setMsg(ResultCode.BIZ_DISABLED.getDesc());
            return apiResult;
        }
        User user = this.userMapper.selectByBizIdAndNetSchoolUserId(bizId, userId);
        if (user == null) {
            log.info("\u6839\u636euserId:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)userId);
            apiResult.setCode((long)ResultCode.USER_NOT_EXIST.getValue());
            apiResult.setMsg(ResultCode.USER_NOT_EXIST.getDesc());
            return apiResult;
        }
        if (NumberUtils.INTEGER_ONE.equals(user.getIsDeleted()) || NumberUtils.INTEGER_ZERO.equals(user.getEnabled())) {
            log.info("userId:{}\u5df2\u5220\u9664/\u5df2\u7981\u7528", (Object)userId);
            apiResult.setCode((long)ResultCode.USER_DISABLED.getValue());
            apiResult.setMsg(ResultCode.USER_DISABLED.getDesc());
            return apiResult;
        }
        NetSchoolGetTokenRespDto respDto = new NetSchoolGetTokenRespDto();
        if (StringUtils.isNotBlank((CharSequence)user.getScrmToken())) {
            respDto.setToken(user.getScrmToken());
            apiResult.setData((Object)respDto);
            return apiResult;
        }
        StringBuilder sb = new StringBuilder();
        long currTimeMillis = System.currentTimeMillis();
        sb.append(bizId).append("_").append(user.getId()).append("_").append(currTimeMillis);
        String token = null;
        try {
            token = AES256Util.encode((String)sb.toString(), (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("encode {}\u53d1\u751f\u5f02\u5e38:", (Object)sb.toString(), (Object)e);
        }
        if (token != null) {
            this.userMapper.updateScrmTokenInfoByUserId(token, user.getId());
        }
        respDto.setToken(token);
        apiResult.setData((Object)respDto);
        return apiResult;
    }

    @Override
    public ApiResult login(HttpSession session, String token) {
        String decodeToken;
        log.info("login,token:{}", (Object)token);
        ApiResult apiResult = ApiResultUtils.buildApiResult();
        if (StringUtils.isBlank((CharSequence)token)) {
            log.info("param \u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.TOKEN_IS_BLANK.getValue());
            apiResult.setMsg(ResultCode.TOKEN_IS_BLANK.getDesc());
            return apiResult;
        }
        try {
            decodeToken = AES256Util.decode((String)token, (String)this.secretKey);
        }
        catch (Exception ex) {
            log.error("decode token:{}\u53d1\u751f\u5f02\u5e38\uff1a", (Object)token, (Object)ex);
            apiResult.setCode((long)ResultCode.TOKEN_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.TOKEN_NOT_VALID.getDesc());
            return apiResult;
        }
        String[] strArr = decodeToken.split("_");
        if (strArr.length != 3) {
            log.info("token:{}\u89e3\u6790\u51fa\u6765\u7684decodeToken:{}\u4e0d\u5408\u6cd5", (Object)token, (Object)decodeToken);
            apiResult.setCode((long)ResultCode.TOKEN_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.TOKEN_NOT_VALID.getDesc());
            return apiResult;
        }
        User user = this.userMapper.selectByBizIdAndScrmToken(Long.valueOf(Long.parseLong(strArr[0])), token);
        if (user == null) {
            log.info("\u6839\u636ebizId:{}, scrmToken:{}\u672a\u67e5\u8be2\u5230\u7528\u6237", (Object)strArr[0], (Object)decodeToken);
            apiResult.setCode((long)ResultCode.TOKEN_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.TOKEN_NOT_VALID.getDesc());
            return apiResult;
        }
        if (Long.parseLong(strArr[1]) != user.getId()) {
            log.info("\u89e3\u6790\u51fa\u6765\u7684userId:{}\u4e0e\u4ece\u8868\u4e2d\u67e5\u8be2\u5230\u7684userId:{}\u4e0d\u4e00\u81f4", (Object)strArr[1], (Object)user.getId());
            apiResult.setCode((long)ResultCode.TOKEN_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.TOKEN_NOT_VALID.getDesc());
            return apiResult;
        }
        LoginUtils.setSession((HttpSession)session);
        LoginUtils.setLoginAccountId((Long)user.getId());
        Object currentUserInfoInRedis = this.getRedisValue(user.getId());
        if (currentUserInfoInRedis == null) {
            this.cacheCurrentUserInfo(user);
        }
        return apiResult;
    }

    @Override
    public GetNetSchoolTokenResp getNetSchoolToken() {
        ResponseEntity forEntity;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getNetSchoolToken,operatorId:{},bizId:{}", (Object)userInfo.getId(), (Object)userInfo.getBizId());
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(userInfo.getBizId());
        if (netSchoolAppResp == null || NumberUtils.INTEGER_ZERO.equals(netSchoolAppResp.getIsOpen()) || StringUtils.isBlank((CharSequence)netSchoolAppResp.getNetSchoolDomain()) || StringUtils.isBlank((CharSequence)netSchoolAppResp.getNetSchoolPartnerId())) {
            log.info("getNetSchoolToken,netSchoolAppResp:{}", (Object)netSchoolAppResp);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u673a\u6784\u672a\u5f00\u901a\u7f51\u6821\u7cfb\u7edf\uff0c\u5982\u9700\u8bd5\u7528\u6216\u5f00\u901a\uff0c\u8bf7\u4e0e\u60a8\u7684\u5ba2\u6237\u7ecf\u7406\u8054\u7cfb");
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userInfo.getId());
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("\u5f53\u524d\u7528\u6237\u8fd8\u672a\u540c\u6b65\u5230\u7f51\u6821userId:{}", (Object)user.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u5e10\u53f7\u672a\u5f00\u901a\u7f51\u6821\u6743\u9650\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        String url = netSchoolAppResp.getNetSchoolDomain() + GET_NET_SCHOOL_TOKEN_URL;
        NetSchoolTokenReqDto reqDto = new NetSchoolTokenReqDto();
        reqDto.setUserId(user.getNetSchoolUserId());
        reqDto.setPartnerId(netSchoolAppResp.getNetSchoolPartnerId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        log.info("getNetSchoolToken,url:{}", (Object)url);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821token\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u83b7\u53d6\u7f51\u6821token\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolResultDto result = (NetSchoolResultDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821token result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            String tipMsg = result == null ? "\u83b7\u53d6\u7f51\u6821token\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5" : result.getMsg();
            log.info(tipMsg);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, tipMsg);
        }
        this.userMapper.updateNetSchoolTokenByUserId(result.getData().getToken(), userInfo.getId());
        return result.getData();
    }

    @Override
    public List<NetSchoolMenuRespDto> permissionMenus(Long operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("permissionMenus,operatorId:{},bizId:{}", (Object)operatorId, (Object)bizId);
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            return Collections.emptyList();
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (user == null || Objects.isNull(user.getNetSchoolUserId())) {
            log.info("user\u4e3a\u7a7a/user\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return Collections.emptyList();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + PERMISSION_MENU_URL;
        log.info("permissionMenus,url:{}", (Object)url);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, NetSchoolMenuResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821\u6743\u9650\u83dc\u5355\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return Collections.emptyList();
        }
        NetSchoolMenuResultDto result = (NetSchoolMenuResultDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821\u6743\u9650\u83dc\u5355result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            String tipMsg = result == null ? "\u83b7\u53d6\u7f51\u6821\u6821\u533a\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5" : result.getMsg();
            log.info(tipMsg);
            return Collections.emptyList();
        }
        return result.getData();
    }

    @Override
    public SchoolListRespDto getSchoolList(String orgName) {
        ResponseEntity forEntity;
        String scrmToken;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long userId = userInfo.getId();
        Long bizId = userInfo.getBizId();
        log.info("getSchoolList,orgName:{}, operatorId:{}", (Object)orgName, (Object)userId);
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)userId);
        if (user == null || Objects.isNull(user.getNetSchoolUserId())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u5e10\u53f7\u672a\u5f00\u901a\u7f51\u6821\u6743\u9650\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        if (StringUtils.isBlank((CharSequence)orgName)) {
            orgName = "";
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + GET_NET_SCHOOL_SCHOOL_LIST_URL;
        url = MessageFormat.format(url, orgName);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, SchoolInfoRespDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821\u6821\u533a\u5217\u8868\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
        SchoolInfoRespDto result = (SchoolInfoRespDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821\u6821\u533a\u5217\u8868result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            String tipMsg = result == null ? "\u83b7\u53d6\u7f51\u6821\u6821\u533a\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5" : result.getMsg();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, tipMsg);
        }
        return result.getData();
    }

    @Override
    public Integer addRole(NetSchoolRoleAddReqDto reqDto, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("adding role,reqDto:{},bizId:{}", (Object)reqDto, (Object)bizId);
        reqDto.validateParams();
        String roleAddReqJson = JacksonUtil.obj2Str((Object)reqDto);
        log.info("roleAddReqJson:{}", (Object)roleAddReqJson);
        try {
            scrmToken = AES256Util.encode((String)roleAddReqJson, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)roleAddReqJson, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u589e\u52a0\u7528\u6237\u7684\u63a5\u53e3", (Object)netSchoolAppResp);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + ROLE_ADD_URL;
        log.info("addRole,url:{}", (Object)url);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolRoleAddResult.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolRoleAddResult result = (NetSchoolRoleAddResult)forEntity.getBody();
        log.info("\u65b0\u5efa\u89d2\u8272result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return result.getData().getId();
    }

    @Override
    public NetSchoolRoleDetailRespDto roleDetail(Integer netSchoolRoleId, Integer operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("roleDetail,netSchoolRoleId:{}, operatorId:{}, bizId:{}", new Object[]{netSchoolRoleId, operatorId, bizId});
        if (Objects.isNull(netSchoolRoleId)) {
            log.info("netSchoolRoleId is null");
            return null;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            return null;
        }
        String userIdJsonStr = "{\"userId\":" + operatorId + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + "/api/scrm/role/{0}";
        url = MessageFormat.format(url, String.valueOf(netSchoolRoleId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, NetSchoolRoleDetailResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821\u89d2\u8272\u8be6\u60c5\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
        NetSchoolRoleDetailResultDto result = (NetSchoolRoleDetailResultDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821\u89d2\u8272\u8be6\u60c5result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            String tipMsg = result == null ? "\u83b7\u53d6\u7f51\u6821\u89d2\u8272\u8be6\u60c5\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5" : result.getMsg();
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, tipMsg);
        }
        return result.getData();
    }

    @Override
    public void modRole(NetSchoolRoleModReqDto reqDto, Integer netSchoolRoleId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("modRole,reqDto:{},netSchoolRoleId:{},bizId:{}", new Object[]{reqDto, netSchoolRoleId, bizId});
        reqDto.validateParams();
        if (Objects.isNull(netSchoolRoleId)) {
            log.info("modRole, netSchoolRoleId is null");
            return;
        }
        String roleModReqJson = JacksonUtil.obj2Str((Object)reqDto);
        log.info("roleModReqJson:{}", (Object)roleModReqJson);
        try {
            scrmToken = AES256Util.encode((String)roleModReqJson, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)roleModReqJson, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u589e\u52a0\u7528\u6237\u7684\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        NetSchoolRoleModParam roleModParam = new NetSchoolRoleModParam();
        roleModParam.setRoleName(reqDto.getRoleName());
        roleModParam.setDescription(reqDto.getDescription());
        HttpEntity httpEntity = new HttpEntity((Object)roleModParam, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + "/api/scrm/role/{0}";
        url = MessageFormat.format(url, String.valueOf(netSchoolRoleId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, NetSchoolRoleModResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u66f4\u65b0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u66f4\u65b0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolRoleModResultDto result = (NetSchoolRoleModResultDto)forEntity.getBody();
        log.info("\u66f4\u65b0\u89d2\u8272result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u66f4\u65b0\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void deleteRole(Integer netSchoolRoleId, Integer operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("deleteRole,roleId:{},userId:{}, bizId:{}", new Object[]{netSchoolRoleId, operatorId, bizId});
        if (Objects.isNull(netSchoolRoleId)) {
            log.info("deleteRole, netSchoolRoleId is null");
            return;
        }
        String userIdJsonStr = "{\"userId\":" + operatorId + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u5220\u9664\u89d2\u8272\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + "/api/scrm/role/{0}";
        url = MessageFormat.format(url, String.valueOf(netSchoolRoleId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, NetSchoolDelResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("roleId:{}\u8c03\u7528\u7f51\u6821\u5220\u9664\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)netSchoolRoleId, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u5220\u9664\u89d2\u8272\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolDelResp result = (NetSchoolDelResp)forEntity.getBody();
        log.info("\u5220\u9664\u89d2\u8272result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || !result.getData().booleanValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u5220\u9664\u89d2\u8272\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void setRoleMenu(Integer netSchoolRoleId, Long operatorId, Set<String> menuIds, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("setRoleMenu,roleId:{},operatorId:{}, menuIds:{}", new Object[]{netSchoolRoleId, operatorId, menuIds});
        if (Objects.isNull(netSchoolRoleId)) {
            log.info("setRoleMenu, netSchoolRoleId is null");
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u8bbe\u7f6e\u89d2\u8272\u83dc\u5355\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return;
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        NetSchoolSetRoleMenuReqDto reqDto = new NetSchoolSetRoleMenuReqDto();
        String netSchoolMenuIds = "";
        if (CollectionUtils.isNotEmpty(menuIds)) {
            netSchoolMenuIds = String.join((CharSequence)"/", (CharSequence[])menuIds.stream().map(Object::toString).toArray(String[]::new));
            netSchoolMenuIds = "/" + netSchoolMenuIds + "/";
        }
        reqDto.setMenuIds(netSchoolMenuIds);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + SET_ROLE_MENU_URL;
        url = MessageFormat.format(url, String.valueOf(netSchoolRoleId));
        log.info("setRoleMenu,url: {},reqDto:{}", (Object)url, (Object)reqDto);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, NetSchoolSetRoleMenuResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u4e3a\u89d2\u8272\u8d4b\u4e88\u83dc\u5355\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7ed9\u89d2\u8272\u8bbe\u7f6e\u6743\u9650\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolSetRoleMenuResultDto result = (NetSchoolSetRoleMenuResultDto)forEntity.getBody();
        log.info("\u8c03\u7528\u7f51\u6821\u7ed9\u89d2\u8272\u8bbe\u7f6e\u6743\u9650\u63a5\u53e3result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7ed9\u89d2\u8272\u8bbe\u7f6e\u6743\u9650\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void deleteUser(Integer netSchoolUserId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("deleteUser,deletedUserId:{}, bizId:{}", (Object)netSchoolUserId, (Object)bizId);
        if (Objects.isNull(netSchoolUserId)) {
            log.info("netSchoolUserId is null");
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u5220\u9664\u89d2\u8272\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        String userIdJsonStr = "{\"userId\":" + DEFAULT_OPERATOR_ID + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + "/api/scrm/adminUser/{0}";
        url = MessageFormat.format(url, String.valueOf(netSchoolUserId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.DELETE, httpEntity, NetSchoolDelResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("deletedUserId:{}\u8c03\u7528\u7f51\u6821\u5220\u9664\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)netSchoolUserId, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u5220\u9664\u7528\u6237\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolDelResp result = (NetSchoolDelResp)forEntity.getBody();
        log.info("\u5220\u9664\u7528\u6237result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || !result.getData().booleanValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u5220\u9664\u7528\u6237\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public void enableDisableUser(Integer netSchoolUserId, Integer isEnabled, Long operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("enableDisableUser,userId:{}, isEnabled:{}, operatorId:{}, bizId:{}", new Object[]{netSchoolUserId, isEnabled, operatorId, bizId});
        if (Objects.isNull(netSchoolUserId)) {
            log.info("netSchoolUserId is null");
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u542f\u7528\u7981\u7528\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return;
        }
        String userIdJsonStr = "{\"userId\":" + operatorId + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        NetSchoolEnableUserDto enableUserDto = new NetSchoolEnableUserDto();
        enableUserDto.setStatus(isEnabled);
        HttpEntity httpEntity = new HttpEntity((Object)enableUserDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + ENABLE_DISABLE_USER_URL;
        url = MessageFormat.format(url, String.valueOf(netSchoolUserId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, NetSchoolDelResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("userId:{}\u8c03\u7528\u7f51\u6821\u542f\u7528\u7981\u7528\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)netSchoolUserId, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u542f\u7528\u7981\u7528\u7528\u6237\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolDelResp result = (NetSchoolDelResp)forEntity.getBody();
        log.info("\u542f\u7528\u7981\u7528\u7528\u6237result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || !result.getData().booleanValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u542f\u7528\u7981\u7528\u7528\u6237\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public NetSchoolUserDetailRespDto userDetail(Integer netSchoolUserId, Long operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("userDetail,userId:{},operatorId:{}, bizId:{}", new Object[]{netSchoolUserId, operatorId, bizId});
        if (Objects.isNull(netSchoolUserId)) {
            log.info("netSchoolUserId is null");
            return null;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u7528\u6237\u8be6\u60c5\u63a5\u53e3", (Object)netSchoolAppResp);
            return null;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return null;
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + "/api/scrm/adminUser/{0}";
        url = MessageFormat.format(url, String.valueOf(netSchoolUserId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, NetSchoolUserDetailResultRespDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("userId:{}\u8c03\u7528\u7f51\u6821\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)netSchoolUserId, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolUserDetailResultRespDto result = (NetSchoolUserDetailResultRespDto)forEntity.getBody();
        log.info("\u7528\u6237\u8be6\u60c5result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7528\u6237\u8be6\u60c5\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return result.getData();
    }

    @Override
    public void afterModScrmUser(User user) {
        if (Objects.isNull(user)) {
            return;
        }
        if (Objects.isNull(user.getId())) {
            log.error("\u7528\u6237id \u672a\u8bbe\u7f6e,\u65e0\u6cd5\u66f4\u65b0\u7f51\u6821\u7528\u6237");
            return;
        }
        if (StringUtils.isBlank((CharSequence)user.getMobile())) {
            log.info("userId:{}\u4f01\u5fae\u6210\u5458\u624b\u673a\u53f7\u4e3a\u7a7a", (Object)user.getId());
            return;
        }
        if (Objects.isNull(user.getNetSchoolUserId())) {
            this.afterAddScrmUser(user);
            return;
        }
        NetSchoolUserModReqDto modReqDto = new NetSchoolUserModReqDto();
        try {
            modReqDto.setMobile(user.getMobile());
            modReqDto.setUserId(DEFAULT_OPERATOR_ID);
            modReqDto.setNickname(user.getName());
            modReqDto.setId(user.getNetSchoolUserId());
            this.modUser(modReqDto, user.getBizId());
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7f51\u6821\u7528\u6237\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString((Object)modReqDto), (Object)e);
        }
    }

    @Override
    public void modUser(NetSchoolUserModReqDto reqDto, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("modUser,reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        String userModReqJson = JacksonUtil.obj2Str((Object)reqDto);
        log.info("userModReqJson:{}", (Object)userModReqJson);
        try {
            scrmToken = AES256Util.encode((String)userModReqJson, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userModReqJson, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u589e\u52a0\u7528\u6237\u7684\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + USER_ADD_MOD;
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, NetSchoolUserModResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u7f16\u8f91\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7f16\u8f91\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolUserModResultDto result = (NetSchoolUserModResultDto)forEntity.getBody();
        log.info("\u7528\u6237\u8be6\u60c5result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u7f16\u8f91\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public Integer addUser(NetSchoolUserAddReqDto reqDto, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("addUser,reqDto:{}", (Object)reqDto);
        reqDto.validateParams();
        String userAddReqJson = JacksonUtil.obj2Str((Object)reqDto);
        log.info("userAddReqJson:{},key:{}", (Object)userAddReqJson, (Object)this.secretKey);
        try {
            scrmToken = AES256Util.encode((String)userAddReqJson, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userAddReqJson, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u589e\u52a0\u7528\u6237\u7684\u63a5\u53e3", (Object)netSchoolAppResp);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + USER_ADD_MOD;
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolUserAddResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolUserAddResultDto result = (NetSchoolUserAddResultDto)forEntity.getBody();
        log.info("\u7528\u6237\u8be6\u60c5result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u7528\u6237\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return result.getData().getUid();
    }

    @Override
    public void afterAddScrmUser(User user) {
        if (Objects.isNull(user)) {
            return;
        }
        if (Objects.nonNull(user.getNetSchoolUserId())) {
            log.error("\u7528\u6237:{}\u5df2\u540c\u6b65\u5230\u7f51\u6821", (Object)user.getId());
            return;
        }
        if (StringUtils.isBlank((CharSequence)user.getMobile())) {
            log.info("\u7528\u6237:{}\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u540c\u6b65\u5230\u7f51\u6821", (Object)user.getId());
            return;
        }
        NetSchoolUserAddReqDto addReqDto = new NetSchoolUserAddReqDto();
        try {
            addReqDto.setMobile(user.getMobile());
            addReqDto.setUserId(DEFAULT_OPERATOR_ID);
            addReqDto.setNickname(user.getName());
            Integer netSchoolId = this.addUser(addReqDto, user.getBizId());
            this.userMapper.updateNetSchoolUserIdById(netSchoolId, user.getId());
        }
        catch (Exception e) {
            log.error("\u65b0\u589e\u7f51\u6821\u7528\u6237\u5f02\u5e38\uff0cparam:{}", (Object)JSON.toJSONString((Object)addReqDto), (Object)e);
        }
    }

    @Override
    public void setUserRole(Integer netSchoolUserId, Long operatorId, String roles, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("setUserRole,userId:{},operatorId:{}, roles:{},bizId:{}", new Object[]{netSchoolUserId, operatorId, roles, bizId});
        if (Objects.isNull(netSchoolUserId)) {
            log.info("netSchoolUserId is null");
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return;
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        NetSchoolSetUserRoleReqDto reqDto = new NetSchoolSetUserRoleReqDto();
        reqDto.setRoles(roles);
        HttpEntity httpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + SET_USER_ROLE_URL;
        url = MessageFormat.format(url, String.valueOf(netSchoolUserId));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, NetSchoolSetUserRoleResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u4e3a\u7528\u6237\u8d4b\u4e88\u89d2\u8272\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u4e3a\u7528\u6237\u8d4b\u4e88\u89d2\u8272\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolSetUserRoleResultDto result = (NetSchoolSetUserRoleResultDto)forEntity.getBody();
        log.info("\u8c03\u7528\u7f51\u6821\u7ed9\u7528\u6237\u8d4b\u4e88\u89d2\u8272\u63a5\u53e3result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u4e3a\u7528\u6237\u8d4b\u4e88\u89d2\u8272\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public List<NetSchoolUser> getUserList(List<Integer> ids, Long operatorId, Long bizId) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("getUserList,ids:{},operatorId:{},bizId:{}", new Object[]{ids, operatorId, bizId});
        if (CollectionUtils.isEmpty(ids)) {
            log.info("getUserList,ids\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u8bbe\u7f6e\u7528\u6237\u89d2\u8272\u63a5\u53e3", (Object)netSchoolAppResp);
            return Collections.emptyList();
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return Collections.emptyList();
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return Collections.emptyList();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        String netSchoolUserIds = String.join((CharSequence)",", (CharSequence[])ids.stream().map(Object::toString).toArray(String[]::new));
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + USER_LIST_URL;
        url = MessageFormat.format(url, String.valueOf(ids.size()), netSchoolUserIds);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, NetSchoolUserListResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u7528\u6237\u5217\u8868\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return Collections.emptyList();
        }
        NetSchoolUserListResultDto result = (NetSchoolUserListResultDto)forEntity.getBody();
        log.info("\u8c03\u7528\u7f51\u6821\u7528\u6237\u5217\u8868\u63a5\u53e3result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            return Collections.emptyList();
        }
        return result.getData().getUserList();
    }

    @Override
    public ApiResult netSchoolCallback(String param) {
        NetSchoolCallbackDto callbackDto;
        String decodeParam;
        log.info("netSchoolCallback,param:{}", (Object)param);
        ApiResult apiResult = ApiResultUtils.buildApiResult();
        if (StringUtils.isBlank((CharSequence)param)) {
            log.info("netSchoolCallback,param\u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.PARAMS_NOT_EXIST.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_EXIST.getDesc());
            return apiResult;
        }
        try {
            decodeParam = AES256Util.decode((String)param, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u89e3\u7801netSchoolCallback param:{} \u53d1\u751f\u5f02\u5e38:", (Object)param, (Object)e);
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        try {
            callbackDto = (NetSchoolCallbackDto)JacksonUtil.str2Obj((String)decodeParam, NetSchoolCallbackDto.class);
        }
        catch (Exception e) {
            log.error("decodeParam:{}\u8f6c\u6210NetSchoolGetTokenDto\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38:", (Object)decodeParam, (Object)e);
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        Long bizId = callbackDto.getBizId();
        if (Objects.isNull(bizId)) {
            log.info("\u5546\u6237id\u4e3a\u7a7a");
            apiResult.setCode((long)ResultCode.PARAMS_NOT_VALID.getValue());
            apiResult.setMsg(ResultCode.PARAMS_NOT_VALID.getDesc());
            return apiResult;
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        if (businessCustomer == null) {
            log.info("\u6839\u636ebizId:{}\u672a\u67e5\u8be2\u5230\u5546\u6237", (Object)bizId);
            apiResult.setCode((long)ResultCode.BIZ_NOT_EXIST.getValue());
            apiResult.setMsg(ResultCode.BIZ_NOT_EXIST.getDesc());
            return apiResult;
        }
        if (businessCustomer.getStatus().intValue() != BizStatus.NORMAL.getValue()) {
            log.info("\u5546\u6237bizId:{}\u7684status:{}\u4e0d\u4e3a\u6b63\u5e38", (Object)bizId, (Object)businessCustomer.getStatus());
            apiResult.setCode((long)ResultCode.BIZ_DISABLED.getValue());
            apiResult.setMsg(ResultCode.BIZ_DISABLED.getDesc());
            return apiResult;
        }
        App app = this.appMapper.selectByCode(AppCodeEnum.BAI_JIA_YUN_WANG_XIAO.getCode());
        if (app == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "APP\u4e0d\u5b58\u5728");
        }
        AppOpenBaseReqDto reqDto = new AppOpenBaseReqDto();
        reqDto.setNetSchoolDomain(callbackDto.getNetSchoolDomain());
        reqDto.setNetSchoolPartnerId(callbackDto.getPartnerId());
        reqDto.setAppId(app.getNum());
        String configJson = JSON.toJSONString((Object)reqDto);
        this.appCenterService.updateBinding(app, bizId, businessCustomer.getCorpId(), callbackDto.getOpenNetSchool(), configJson, null);
        TraceExecutorWrapUtil.wrapCompletableFutureRunAsync(() -> {
            log.info("netSchoolCallback \u540c\u6b65\u7528\u6237\u6216\u89d2\u8272");
            Integer operatorUserId = 2;
            List users = this.userMapper.selectAllNetSchoolUnFetchUser(bizId);
            if (CollectionUtils.isNotEmpty((Collection)users)) {
                List batchParam = users.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getMobile()) && Objects.isNull(item.getNetSchoolUserId()) && !businessCustomer.getApplyWeworkUserId().equals(item.getWeworkUserId())).map(item -> {
                    NetSchoolUserAddReqDto addUserDto = new NetSchoolUserAddReqDto();
                    addUserDto.setUserId(operatorUserId);
                    addUserDto.setMobile(item.getMobile());
                    addUserDto.setNickname(item.getName());
                    addUserDto.setScrmUserId(item.getId());
                    return addUserDto;
                }).collect(Collectors.toList());
                log.info("addUser size:{}", (Object)CollectionUtils.size(batchParam));
                for (NetSchoolUserAddReqDto addReqDto : batchParam) {
                    try {
                        Integer netSchoolUserId = this.addUser(addReqDto, bizId);
                        this.userMapper.updateNetSchoolUserIdById(netSchoolUserId, addReqDto.getScrmUserId());
                    }
                    catch (Exception e) {
                        log.error("addUser error:", (Throwable)e);
                    }
                }
            }
            List roles = this.roleMapper.selectAllNetSchoolUnFetchRole(bizId);
            List addReqDtos = roles.stream().map(item -> {
                NetSchoolRoleAddReqDto roleReqDto = new NetSchoolRoleAddReqDto();
                roleReqDto.setRoleName(item.getName());
                roleReqDto.setRoleId(item.getId());
                roleReqDto.setUserId(operatorUserId);
                if (item.getType() == 1) {
                    roleReqDto.setType(1);
                }
                return roleReqDto;
            }).collect(Collectors.toList());
            log.info("addRole size:{}", (Object)CollectionUtils.size(addReqDtos));
            for (NetSchoolRoleAddReqDto addReqDto : addReqDtos) {
                try {
                    Integer netSchoolRoleId = this.addRole(addReqDto, bizId);
                    this.roleMapper.updateNetSchoolRoleIdById(netSchoolRoleId, addReqDto.getRoleId());
                }
                catch (Exception e) {
                    log.error("addRole:", (Throwable)e);
                }
            }
        });
        return apiResult;
    }

    @Override
    public List<String> getUserNetSchoolMenuUrls() {
        ResponseEntity forEntity;
        String scrmToken;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Long operatorId = userInfo.getId();
        log.info("getUserNetSchoolMenuUrls,operatorId:{},bizId:{}", (Object)operatorId, (Object)bizId);
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("bizId:{},netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u5217\u8868\u63a5\u53e3", (Object)bizId, (Object)netSchoolAppResp);
            return Collections.emptyList();
        }
        User operator = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (operator == null || Objects.isNull(operator.getNetSchoolUserId())) {
            log.info("\u7528\u6237operatorId:{}\u8fd8\u672a\u8bbe\u7f6e\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return Collections.emptyList();
        }
        String userIdJsonStr = "{\"userId\":" + operator.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return Collections.emptyList();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + USER_MENU_URL;
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, NetSchoolMenuResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u5217\u8868\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return Collections.emptyList();
        }
        NetSchoolMenuResultDto result = (NetSchoolMenuResultDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u5217\u8868\u63a5\u53e3result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || CollectionUtils.isEmpty(result.getData())) {
            return Collections.emptyList();
        }
        ArrayList menuUrls = Lists.newArrayList();
        this.getMenuUrls(menuUrls, result.getData());
        return menuUrls;
    }

    @Override
    public String getLearningParams(String customerNum) {
        String encodeParam;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getLearningParams, bizId:{},operatorId:{}, customerNum:{}", new Object[]{userInfo.getBizId(), userInfo.getId(), customerNum});
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("customerNum is null");
            return null;
        }
        Set mobiles = this.ccCustomerNumService.getMobilesByCustomerNum(userInfo.getBizId(), customerNum);
        String unionId = this.weworkContactMapper.queryUnionIdByBizIdAndCustomerNum(userInfo.getBizId(), customerNum);
        if (CollectionUtils.isEmpty((Collection)mobiles) && StringUtils.isBlank((CharSequence)unionId)) {
            log.info("mobiles and unionId is null");
            return null;
        }
        NetSchoolLearnDto dto = new NetSchoolLearnDto();
        if (CollectionUtils.isNotEmpty((Collection)mobiles)) {
            dto.setMobiles(mobiles);
        }
        if (StringUtils.isNotBlank((CharSequence)unionId)) {
            dto.setUnionId(unionId);
        }
        try {
            encodeParam = AES256Util.encode((String)JacksonUtil.obj2Str((Object)dto), (String)this.secretKey);
        }
        catch (Exception e) {
            log.info("\u52a0\u5bc6\u53c2\u6570:{}\u53d1\u751f\u5f02\u5e38:", (Object)JacksonUtil.obj2Str((Object)dto), (Object)e);
            return null;
        }
        return encodeParam;
    }

    private void getMenuUrls(List<String> menuUrls, List<NetSchoolMenuRespDto> netSchoolMenuRespDtos) {
        if (CollectionUtils.isEmpty(netSchoolMenuRespDtos)) {
            return;
        }
        for (NetSchoolMenuRespDto dto : netSchoolMenuRespDtos) {
            menuUrls.add(dto.getMenuUrl());
            if (!CollectionUtils.isNotEmpty(dto.getChildren())) continue;
            this.getMenuUrls(menuUrls, dto.getChildren());
        }
    }

    private Object getRedisValue(Long userId) {
        String key = LoginUtils.getUserInfoKey((String)this.redisKeyPrefix, (Long)userId);
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        return valueOperations.get((Object)key);
    }

    private void cacheCurrentUserInfo(User user) {
        WeworkUser weworkUser;
        CurrentUserInfo currentUserInfo = new CurrentUserInfo();
        currentUserInfo.setName(user.getName());
        currentUserInfo.setMobile(user.getMobile());
        currentUserInfo.setAvatar(user.getAvatar());
        if (StringUtils.isNotBlank((CharSequence)user.getWeworkUserId()) && Objects.nonNull(weworkUser = this.weworkUserMapper.queryWeworkUserInfo(user.getCorpId(), user.getWeworkUserId()))) {
            currentUserInfo.setWeworkUserNum(weworkUser.getNum());
            if (StringUtils.isNotBlank((CharSequence)weworkUser.getName())) {
                currentUserInfo.setName(weworkUser.getName());
            }
            if (StringUtils.isNotBlank((CharSequence)weworkUser.getAvatar())) {
                currentUserInfo.setAvatar(weworkUser.getAvatar());
            }
        }
        currentUserInfo.setWeworkUserId(user.getWeworkUserId());
        currentUserInfo.setId(user.getId());
        currentUserInfo.setNum(user.getNum());
        currentUserInfo.setIdentifier(user.getIdentifier());
        currentUserInfo.setUserNodeId(user.getNodeId());
        currentUserInfo.setCorpId(user.getCorpId());
        currentUserInfo.setBizId(user.getBizId());
        currentUserInfo.setEnabled(user.getEnabled());
        List<UserRoleRespDto> userRoles = this.getUserRoles(user.getId(), user.getBizId());
        if (CollectionUtils.isNotEmpty(userRoles)) {
            userRoles.sort((o1, o2) -> {
                if (Objects.nonNull(o1.getLatestUseTime()) && Objects.nonNull(o2.getLatestUseTime())) {
                    return o2.getLatestUseTime().compareTo(o1.getLatestUseTime());
                }
                return Objects.isNull(o1.getLatestUseTime()) ? 1 : -1;
            });
            UserRoleRespDto userRole = userRoles.get(0);
            currentUserInfo.setCurRole(userRole);
            currentUserInfo.setRoles(userRoles);
            Set menuCodes = this.roleMenuMapper.queryMenuCodesByRoleIdAndBizId(userRole.getRoleId(), user.getBizId());
            Set<String> bizMenuCodes = this.getBizMenuCode(user.getBizId());
            if (CollectionUtils.isNotEmpty((Collection)menuCodes)) {
                menuCodes.retainAll(bizMenuCodes);
                currentUserInfo.setMenuCodes(menuCodes);
            }
            Set manageNodeIds = currentUserInfo.getCurRole().getManageNodeIds();
            HashSet nodeIds = Sets.newHashSet();
            HashSet nodes = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
                for (Long nodeId : manageNodeIds) {
                    if (nodeId == null) continue;
                    nodeIds.add(nodeId);
                    nodeIds.addAll(this.nodeService.getPosterityIds((Collection)Sets.newHashSet((Object[])new Long[]{nodeId}), user.getBizId()));
                    Node node = this.nodeService.getNode(nodeId, user.getBizId());
                    if (!Objects.nonNull(node)) continue;
                    nodes.add(node);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)nodeIds)) {
                currentUserInfo.setNodeIds((List)Lists.newArrayList((Iterable)nodeIds));
            } else {
                currentUserInfo.setNodeIds(new ArrayList());
            }
            if (CollectionUtils.isNotEmpty((Collection)nodes)) {
                currentUserInfo.setNodes((List)Lists.newArrayList((Iterable)nodes));
            } else {
                currentUserInfo.setNodes(new ArrayList());
            }
        }
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)currentUserInfo.getBizId());
        Date date = businessCustomer.getExpireDate();
        currentUserInfo.setExpireDate(DateUtil.getTheDateBegin((Date)date));
        currentUserInfo.setBizStatus(businessCustomer.getStatus());
        currentUserInfo.setBizName(businessCustomer.getName());
        currentUserInfo.setOpenNetSchool(businessCustomer.getOpenNetSchool());
        this.setRedisValue(user.getId(), currentUserInfo);
    }

    private List<UserRoleRespDto> getUserRoles(Long userId, Long bizId) {
        UserRole userRole = new UserRole();
        userRole.setUserId(userId);
        List userRoles = this.userRoleMapper.select((Object)userRole);
        if (CollectionUtils.isEmpty((Collection)userRoles)) {
            return Lists.newArrayList();
        }
        Map<Long, List<UserRole>> roleId2UserRolesMap = userRoles.stream().collect(Collectors.groupingBy(UserRole::getRoleId));
        Map roleNodeMap = userRoles.stream().filter(a -> a.getManageNodeId() != null).collect(Collectors.groupingBy(UserRole::getRoleId, Collectors.mapping(UserRole::getManageNodeId, Collectors.toSet())));
        List roleIds = userRoles.stream().map(UserRole::getRoleId).collect(Collectors.toList());
        RoleQueryParams queryParam = new RoleQueryParams();
        queryParam.setIds(roleIds);
        queryParam.setBizId(bizId);
        queryParam.setCorpId(((UserRole)userRoles.get(0)).getCorpId());
        Map roleMap = this.roleMapper.queryList(queryParam).stream().collect(Collectors.toMap(Role::getId, Function.identity()));
        ArrayList result = Lists.newArrayList();
        if (!roleMap.isEmpty()) {
            for (Map.Entry entry : roleMap.entrySet()) {
                Role role = (Role)entry.getValue();
                if (role == null) continue;
                UserRoleRespDto dto = new UserRoleRespDto();
                dto.setRoleId(role.getId());
                dto.setRoleName(role.getName());
                Set manageNodeIds = (Set)MapUtils.getObject(roleNodeMap, (Object)role.getId());
                ArrayList manageNodes = new ArrayList();
                if (CollectionUtils.isNotEmpty((Collection)manageNodeIds)) {
                    manageNodes.addAll(this.orgService.getNodeWithoutChildren(bizId, (Collection)manageNodeIds));
                }
                dto.setManageNodes(manageNodes);
                dto.setManageNodeIds(manageNodeIds);
                if (MapUtils.isNotEmpty(roleId2UserRolesMap) && roleId2UserRolesMap.containsKey(role.getId())) {
                    dto.setLatestUseTime(roleId2UserRolesMap.get(role.getId()).get(0).getLatestUseTime());
                }
                result.add(dto);
            }
        }
        return result;
    }

    private Set<String> getBizMenuCode(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        String pkgIds = businessCustomer.getPkgIds();
        log.info("getBizMenuCode pkgIds: {}", (Object)pkgIds);
        Set<String> menuCodes = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)pkgIds)) {
            ArrayList<Long> pkgIdList = new ArrayList<Long>();
            if (pkgIds.contains(",")) {
                for (String s : pkgIds.split(",")) {
                    Long parseLong = Long.parseLong(s);
                    pkgIdList.add(parseLong);
                }
            } else {
                pkgIdList.add(Long.parseLong(pkgIds));
            }
            log.info("treeList pkgIdList: {}", pkgIdList);
            PackageMenuRespDto respDto = this.packageService.packageMenuInfo(pkgIdList);
            if (respDto != null) {
                menuCodes = respDto.getMenuCodes();
            }
        }
        return menuCodes;
    }

    private void setRedisValue(Long userId, Object value) {
        if (Objects.isNull(userId)) {
            return;
        }
        String key = LoginUtils.getUserInfoKey((String)this.redisKeyPrefix, (Long)userId);
        ValueOperations valueOperations = this.redisTemplate.opsForValue();
        valueOperations.set((Object)key, value, 2592000L, TimeUnit.SECONDS);
        String token = LoginUtils.getExternalToken();
        if (token == null) {
            String uuid = UUID.randomUUID().toString();
            token = Base64.getEncoder().encodeToString(uuid.getBytes(StandardCharsets.UTF_8));
            LoginUtils.setExternalToken((String)token);
            String redisKey = this.getExternalTokenKey(token);
            HashOperations hash = this.redisTemplate.opsForHash();
            hash.put((Object)redisKey, (Object)"sessionId", (Object)LoginUtils.getSessionId());
            hash.put((Object)redisKey, (Object)"userId", (Object)userId);
            this.redisTemplate.expire((Object)redisKey, 2592000L, TimeUnit.SECONDS);
        }
    }

    private String getExternalTokenKey(String externalToken) {
        return String.format(this.externalRedisKey, this.redisKeyPrefix, externalToken);
    }

    @Override
    public void updateNetSchoolUserUnionId(Long bizId, String userId, String unionId, NetSchoolSyncLog syncLog) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("bizId: {}, userId: {}, unionId: {}", new Object[]{bizId, userId, unionId});
        if (StringUtils.isBlank((CharSequence)userId) || StringUtils.isBlank((CharSequence)unionId)) {
            return;
        }
        NetSchoolUpdateUnionIdDto unionIdDto = new NetSchoolUpdateUnionIdDto();
        unionIdDto.setUserId(userId);
        unionIdDto.setUnionId(unionId);
        String jsonStr = JacksonUtil.obj2Str((Object)unionIdDto);
        try {
            scrmToken = AES256Util.encode((String)jsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)jsonStr, (Object)e);
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)unionIdDto, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + UPDATE_UNION_ID_URL;
        if (syncLog == null) {
            syncLog = this.insertPullLog(bizId, "updateUnionId", jsonStr);
        }
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.PUT, httpEntity, ApiResult.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("unionIdDto:{}\u8c03\u7528\u7f51\u6821\u66f4\u65b0unionid\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)unionIdDto, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u66f4\u65b0\u5b66\u5458unionid\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        ApiResult result = (ApiResult)forEntity.getBody();
        log.info("result: {}, syncLogId: {}", (Object)result, (Object)syncLog.getId());
        if (result == null || 200L != result.getCode()) {
            String errorMsg;
            Integer errorCode = null;
            if (result == null) {
                errorMsg = "\u8bf7\u7f51\u6821\u63a5\u53e3\u62a5\u9519";
            } else {
                errorCode = (int)result.getCode();
                errorMsg = result.getMsg();
            }
            this.setPullLogFail(syncLog, errorCode, errorMsg);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u66f4\u65b0\u5b66\u5458unionid\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.setPullLogSuccess(syncLog);
    }

    @Override
    public void addNetSchoolOrder(Long bizId, AddNetSchoolOrderReq req, NetSchoolSyncLog syncLog) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("add net school order req: {}", (Object)req);
        String jsonStr = JacksonUtil.obj2Str((Object)req);
        try {
            scrmToken = AES256Util.encode((String)jsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)jsonStr, (Object)e);
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        try {
            BizSimpleDto bizSimpleDto = this.scrmBizService.getById(bizId);
            PayConfigBaseReq payConfigBaseReq = new PayConfigBaseReq();
            payConfigBaseReq.setCorpId(bizSimpleDto.getCorpId());
            String defaultPayGroupKey = this.scrmPayConfigService.getDefaultGroupKey(payConfigBaseReq);
            req.setPayGroupKey(defaultPayGroupKey);
        }
        catch (Exception e) {
            log.info("\u83b7\u53d6\u9ed8\u8ba4\u652f\u4ed8\u4e3b\u4f53\u5931\u8d25: ", (Throwable)e);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + ADD_ORDER;
        if (syncLog == null) {
            syncLog = this.insertPullLog(bizId, "addOrder", jsonStr);
        }
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolOrderResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("addNetSchoolOrder req:{}\u8c03\u7528\u7f51\u6821\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)req, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolOrderResp result = (NetSchoolOrderResp)forEntity.getBody();
        log.info("result: {}, syncLogId: {}", (Object)result, (Object)syncLog.getId());
        if (result == null || 200 != result.getCode()) {
            String errorMsg;
            Integer errorCode = null;
            if (result == null) {
                errorMsg = "\u8bf7\u7f51\u6821\u63a5\u53e3\u62a5\u9519";
            } else {
                errorCode = result.getCode();
                errorMsg = result.getMsg();
            }
            this.setPullLogFail(syncLog, errorCode, errorMsg);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u8ba2\u5355\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.setPullLogSuccess(syncLog);
    }

    @Override
    public void addNetSchoolRefundOrder(Long bizId, AddNetSchoolRefundOrderReq req, NetSchoolSyncLog syncLog) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("add net school refund order req: {}", (Object)req);
        String jsonStr = JacksonUtil.obj2Str((Object)req);
        try {
            scrmToken = AES256Util.encode((String)jsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)jsonStr, (Object)e);
            return;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)req, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + ADD_REFUND;
        if (syncLog == null) {
            syncLog = this.insertPullLog(bizId, "addRefundOrder", jsonStr);
        }
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolRefundOrderResp.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("addNetSchoolRefundOrder req:{}\u8c03\u7528\u7f51\u6821\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Object)req, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u8ba2\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        NetSchoolRefundOrderResp result = (NetSchoolRefundOrderResp)forEntity.getBody();
        log.info("result: {}, syncLogId: {}", (Object)result, (Object)syncLog.getId());
        if (result == null || 200 != result.getCode()) {
            String errorMsg;
            Integer errorCode = null;
            if (result == null) {
                errorMsg = "\u8bf7\u7f51\u6821\u63a5\u53e3\u62a5\u9519";
            } else {
                errorCode = result.getCode();
                errorMsg = result.getMsg();
            }
            this.setPullLogFail(syncLog, errorCode, errorMsg);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u7f51\u6821\u6dfb\u52a0\u8ba2\u5355\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.setPullLogSuccess(syncLog);
    }

    @Override
    public NetSchoolGoodsCanBuyRespDto goodsIsCanBuy(NetSchoolGoodsCanBuyReqDto req) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("goodsIsCanBuy,req:{}", (Object)req);
        req.validateParams();
        ShopSku sku = this.shopSkuMapper.selectByProductId(req.getSkuNo());
        if (sku == null) {
            log.info("\u6839\u636eskuNo:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)req.getSkuNo());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        NetSchoolGoodsCanBuyRespDto resp = new NetSchoolGoodsCanBuyRespDto();
        if (GoodsOrderSource.NET_SCHOOL.getSource() != sku.getSource().intValue()) {
            log.info("\u5546\u54c1skuNo:{}\u4e0d\u662f\u7f51\u6821\u5546\u54c1", (Object)req.getSkuNo());
            resp.setIsCanBuy(1);
            return resp;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(sku.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("bizId:{},netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u83b7\u53d6\u7528\u6237\u83dc\u5355\u6743\u9650\u5217\u8868\u63a5\u53e3", (Object)sku.getBizId(), (Object)netSchoolAppResp);
            resp.setIsCanBuy(2);
            resp.setMessage("\u672a\u5f00\u901a\u7f51\u6821\uff0c\u6682\u4e0d\u652f\u6301\u5bf9\u7f51\u6821\u5546\u54c1\u4e0b\u5355");
            return resp;
        }
        int goodsType = NetSchoolGoodsId.getGoodsType(req.getSkuNo());
        CanBuyReq canBuyReq = new CanBuyReq();
        canBuyReq.setMobile(req.getMobile());
        canBuyReq.setShopId(String.valueOf(NetSchoolGoodsId.getOriginId(req.getSkuNo())));
        canBuyReq.setSchoolId(String.valueOf(NetSchoolGoodsId.getSchoolId(req.getSkuNo())));
        if (NetSchoolGoodsTypeEnum.COURSE.getValue() == goodsType) {
            canBuyReq.setShopType("1");
        } else if (NetSchoolGoodsTypeEnum.CLASS.getValue() == goodsType) {
            canBuyReq.setShopType("19");
        }
        try {
            scrmToken = AES256Util.encode((String)JacksonUtil.obj2Str((Object)canBuyReq), (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u8bf7\u6c42\u53c2\u6570:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)JacksonUtil.obj2Str((Object)canBuyReq), (Object)e);
            resp.setIsCanBuy(2);
            return resp;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((Object)canBuyReq, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + GOODS_IS_CAN_BUY_URL;
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, NetSchoolGoodsCanBuyResultDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u7f51\u6821\u83b7\u53d6\u5546\u54c1\u662f\u5426\u80fd\u8d2d\u4e70\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            resp.setIsCanBuy(2);
            resp.setMessage("\u8c03\u7528\u7f51\u6821\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            return resp;
        }
        NetSchoolGoodsCanBuyResultDto result = (NetSchoolGoodsCanBuyResultDto)forEntity.getBody();
        log.info("\u8c03\u7528\u7f51\u6821\u83b7\u53d6\u5546\u54c1\u662f\u5426\u80fd\u8d2d\u4e70result:{}", (Object)result);
        if (result == null || 200 != result.getCode() || Objects.isNull(result.getData())) {
            resp.setIsCanBuy(2);
            if (result == null || StringUtils.isBlank((CharSequence)result.getMsg())) {
                resp.setMessage("\u8c03\u7528\u7f51\u6821\u63a5\u53e3\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            } else {
                resp.setMessage(result.getMsg());
            }
            return resp;
        }
        return result.getData();
    }

    @Override
    public SchoolListRespDto schoolSimpleInfo(Long bizId, Set<Long> schoolIds) {
        ResponseEntity forEntity;
        String scrmToken;
        log.info("schoolSimpleInfo,bizId:{},schoolIds:{}", (Object)bizId, schoolIds);
        if (CollectionUtils.isEmpty(schoolIds) || bizId == null || bizId <= 0L) {
            return null;
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(bizId);
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u672a\u4e0e\u7f51\u6821\u6253\u901a", (Object)netSchoolAppResp);
            return null;
        }
        String userIdJsonStr = "{\"userId\":" + DEFAULT_OPERATOR_ID + "}";
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return null;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + SCHOOL_DETAIL_URL;
        url = MessageFormat.format(url, BaseUtils.listToStr(schoolIds, (String)","));
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, SchoolInfoRespDto.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821\u6821\u533a\u8be6\u60c5\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return null;
        }
        SchoolInfoRespDto result = (SchoolInfoRespDto)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821\u6821\u533a\u8be6\u60c5result:{}", (Object)result);
        if (result == null || 200 != result.getCode()) {
            return null;
        }
        return result.getData();
    }

    @Override
    public List<CourseResponse.CourseData.Course> getNetSchoolCourseList(NetSchoolCourseListReqDto req) {
        ResponseEntity forEntity;
        String scrmToken;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("getNetSchoolCourseList,req:{},operatorId:{}", (Object)req, (Object)userInfo.getId());
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(userInfo.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u672a\u4e0e\u7f51\u6821\u6253\u901a", (Object)netSchoolAppResp);
            return null;
        }
        String userIdJsonStr = "{\"userId\":" + DEFAULT_OPERATOR_ID + "}";
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            return null;
        }
        req.convertParams();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        headers.set(SCRM_TOKEN, scrmToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + COURSE_LIST_URL;
        url = MessageFormat.format(url, req.getTitle(), req.getUpdateStartTimeStr(), req.getUpdateEndTimeStr(), req.getPage(), req.getLimit());
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, CourseResponse.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u7f51\u6821\u8bfe\u7a0b\u5217\u8868\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            return Collections.emptyList();
        }
        CourseResponse result = (CourseResponse)forEntity.getBody();
        log.info("\u83b7\u53d6\u7f51\u6821\u8bfe\u7a0b\u8be6\u60c5,url:{}, result:{}", (Object)url, (Object)result);
        if (result == null || 200 != result.getCode()) {
            return Collections.emptyList();
        }
        req.getPageDto().setCount(result.getData().getTotal());
        if (CollectionUtils.isNotEmpty(result.getData().getList())) {
            for (CourseResponse.CourseData.Course courseData : result.getData().getList()) {
                courseData.setPrice(courseData.getPrice() * 100);
                if (!Objects.nonNull(courseData.getUnderlinedPrice())) continue;
                courseData.setUnderlinedPrice(courseData.getUnderlinedPrice() * 100);
            }
        }
        return result.getData().getList();
    }

    private NetSchoolSyncLog insertPullLog(Long bizId, String action, String reqBody) {
        Date curTime = new Date();
        NetSchoolSyncLog syncLog = new NetSchoolSyncLog();
        syncLog.setBizId(bizId);
        syncLog.setAction(action);
        syncLog.setReqBody(reqBody);
        syncLog.setSyncTime(curTime);
        syncLog.setStatus(Integer.valueOf(0));
        syncLog.setCreateTime(curTime);
        syncLog.setUpdateTime(curTime);
        syncLog.setFailCount(Integer.valueOf(0));
        syncLog.setCreateBy(Long.valueOf(-1L));
        syncLog.setUpdateBy(Long.valueOf(-1L));
        this.netSchoolPullLogMapper.insertSelective((Object)syncLog);
        return syncLog;
    }

    private void setPullLogFail(NetSchoolSyncLog syncLog, Integer errorCode, String errorMsg) {
        syncLog.setStatus(Integer.valueOf(2));
        syncLog.setErrorCode(errorCode);
        syncLog.setErrorMsg(errorMsg);
        syncLog.setUpdateTime(new Date());
        syncLog.setFailCount(Integer.valueOf(syncLog.getFailCount() + 1));
        this.netSchoolPullLogMapper.updateByPrimaryKeySelective((Object)syncLog);
    }

    private void setPullLogSuccess(NetSchoolSyncLog syncLog) {
        syncLog.setUpdateTime(new Date());
        syncLog.setFailCount(Integer.valueOf(0));
        syncLog.setStatus(Integer.valueOf(1));
        this.netSchoolPullLogMapper.updateByPrimaryKeySelective((Object)syncLog);
    }

    @Override
    public void syncPayConfig(PayConfigAddReq req) {
        ResponseEntity forEntity;
        String scrmToken;
        String rsaFile;
        String publicKeyFile;
        String certFile;
        String privateKey;
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        req.setCorpId(currentUser.getCorpId());
        req.setBusinessName(currentUser.getBizName());
        req.setOperatorId(currentUser.getId());
        Long operatorId = currentUser.getId();
        req.validate();
        Integer payType = null;
        String mpAppId = null;
        String mchId = req.getMchId();
        String appId = req.getAppId();
        switch (PayChannelType.get((Integer)req.getPayChannelType())) {
            case WEIXIN_NATIVE: {
                payType = 4;
                break;
            }
            case WEIXIN_APP: {
                payType = 3;
                break;
            }
            case WEIXIN_H5: {
                payType = 6;
                break;
            }
            case WEIXIN_JSAPI: {
                payType = 5;
                appId = req.getAppId();
                mpAppId = req.getAppId();
                break;
            }
            case ALIPAY_APP: {
                payType = 1;
                break;
            }
            case ALIPAY_PRE_CREATE: {
                payType = 2;
                break;
            }
            case ALIPAY_WAP: {
                payType = 7;
                break;
            }
            default: {
                return;
            }
        }
        switch (PayChannelCode.get((String)PayChannelType.get((Integer)req.getPayChannelType()).getServiceCode())) {
            case PAY_CHANNEL_CODE_ALIPAY: {
                privateKey = req.getAlipayAppPrivateKey();
                certFile = req.getPayCerts().stream().filter(a -> StringUtils.equals((CharSequence)a.getCertName(), (CharSequence)"alipayRootCert.crt")).map(a -> a.getCertBase64()).findFirst().get();
                publicKeyFile = req.getPayCerts().stream().filter(a -> a.getCertName().matches("appCertPublicKey_\\d+\\.crt")).map(a -> a.getCertBase64()).findFirst().get();
                rsaFile = req.getPayCerts().stream().filter(a -> StringUtils.equals((CharSequence)a.getCertName(), (CharSequence)"alipayCertPublicKey_RSA2.crt")).map(a -> a.getCertBase64()).findFirst().get();
                break;
            }
            case PAY_CHANNEL_CODE_WEIXIN: {
                privateKey = req.getSecret();
                certFile = req.getPayCerts().stream().filter(a -> StringUtils.equals((CharSequence)a.getCertName(), (CharSequence)"apiclient_cert.p12")).map(a -> a.getCertBase64()).findFirst().get();
                publicKeyFile = req.getPayCerts().stream().filter(a -> StringUtils.equals((CharSequence)a.getCertName(), (CharSequence)"apiclient_cert.pem")).map(a -> a.getCertBase64()).findFirst().get();
                rsaFile = req.getPayCerts().stream().filter(a -> StringUtils.equals((CharSequence)a.getCertName(), (CharSequence)"apiclient_key.pem")).map(a -> a.getCertBase64()).findFirst().get();
                break;
            }
            default: {
                return;
            }
        }
        JSONObject map = new JSONObject();
        map.put("pay_type", (Object)payType);
        map.put("mch_id", (Object)mchId);
        map.put("app_id", (Object)appId);
        map.put("mp_app_id", (Object)mpAppId);
        map.put("private_key", (Object)privateKey);
        map.put("cert_file", (Object)certFile);
        map.put("public_key_file", (Object)publicKeyFile);
        map.put("rsa_file", (Object)rsaFile);
        String paramJson = map.toJSONString();
        log.info("syncPayConfig paramJson={}", (Object)paramJson);
        String params = null;
        try {
            params = AES256Util.encode((String)paramJson, (String)this.secretKey);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6\u53c2\u6570\u53d1\u751f\u5f02\u5e38,params={}", (Object)params, (Object)e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("params", (Object)params);
        String json = jsonObject.toJSONString();
        log.info("syncPayConfig json:{},key:{}", (Object)json, (Object)this.secretKey);
        User user = (User)this.userMapper.selectByPrimaryKey((Object)operatorId);
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("operatorId:{}\u4e3a\u8bbe\u7f6e\u5bf9\u5e94\u7684\u7f51\u6821\u7528\u6237id", (Object)operatorId);
            return;
        }
        String userIdJsonStr = "{\"userId\":" + user.getNetSchoolUserId() + "}";
        log.info("userIdJsonStr:{}", (Object)userIdJsonStr);
        try {
            scrmToken = AES256Util.encode((String)userIdJsonStr, (String)this.secretKey);
            log.info("scrmToken:{}", (Object)scrmToken);
        }
        catch (Exception e) {
            log.error("\u52a0\u5bc6userIdJsonStr:{}\u751f\u6210\u8bf7\u6c42\u5934\u4e2d\u7684Scrm-Token\u53c2\u6570\u53d1\u751f\u5f02\u5e38:", (Object)userIdJsonStr, (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u751f\u6210\u52a0\u5bc6Scrm-Token\u5931\u8d25");
        }
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(currentUser.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("netSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u7684\u63a5\u53e3", (Object)netSchoolAppResp);
            return;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set(SCRM_TOKEN, scrmToken);
        LinkedMultiValueMap paramMap = new LinkedMultiValueMap();
        paramMap.add((Object)"params", (Object)params);
        HttpEntity httpEntity = new HttpEntity((Object)paramMap, (MultiValueMap)headers);
        String url = netSchoolAppResp.getNetSchoolDomain() + PAY_ACCOUNT_URL;
        log.info("syncPayConfig,url:{}", (Object)url);
        try {
            forEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, Object.class, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u540c\u6b65\u652f\u4ed8\u914d\u7f6e\u63a5\u53e3\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8c03\u7528\u540c\u6b65\u652f\u4ed8\u914d\u7f6e\u63a5\u53e3\u53d1\u751f\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (forEntity.getStatusCode().is2xxSuccessful()) {
            log.info("syncPayConfig success,result={}", forEntity.getBody());
        } else {
            log.info("syncPayConfig fail, result={}", forEntity.getBody());
        }
    }
}

