/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.dto.resp.NetSchoolAppResp;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.permission.dto.RoleQueryParams;
import com.kuaike.scrm.dal.permission.entity.Role;
import com.kuaike.scrm.dal.permission.entity.RoleMenu;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.RoleMapper;
import com.kuaike.scrm.dal.permission.mapper.RoleMenuMapper;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.permission.mapper.UserRoleMapper;
import com.kuaike.scrm.dal.system.mapper.SystemRoleMenuMapper;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleAddReqDto;
import com.kuaike.scrm.system.dto.request.NetSchoolRoleModReqDto;
import com.kuaike.scrm.system.dto.request.RoleAddReqDto;
import com.kuaike.scrm.system.dto.request.RoleListReqDto;
import com.kuaike.scrm.system.dto.request.RoleModReqDto;
import com.kuaike.scrm.system.dto.request.RoleReqDto;
import com.kuaike.scrm.system.dto.request.SystemRoleMenuReqDto;
import com.kuaike.scrm.system.dto.response.NetSchoolRoleDetailRespDto;
import com.kuaike.scrm.system.dto.response.RoleDetailRespDto;
import com.kuaike.scrm.system.dto.response.RoleOrgTypeRespDto;
import com.kuaike.scrm.system.dto.response.RoleRespDto;
import com.kuaike.scrm.system.dto.response.SystemRoleMenuRespDto;
import com.kuaike.scrm.system.service.RoleService;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import com.kuaike.scrm.system.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleMapper roleMapper;
    @Autowired
    private UserRoleMapper userRoleMapper;
    @Autowired
    private RoleMenuMapper roleMenuMapper;
    @Autowired
    private SystemRoleMenuMapper systemRoleMenuMapper;
    @Autowired
    private BusinessCustomerMapper businessCustomerMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private ScrmNetSchoolService scrmNetSchoolService;

    @Override
    public List<RoleRespDto> list(RoleListReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("list role with params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validateParams();
        RoleQueryParams roleQueryParams = params.to();
        roleQueryParams.setBizId(currentUserInfo.getBizId());
        roleQueryParams.setCorpId(currentUserInfo.getCorpId());
        List roles = this.roleMapper.queryList(roleQueryParams);
        if (params.getPageDto() != null) {
            params.getPageDto().setCount(Integer.valueOf(this.roleMapper.queryCount(roleQueryParams)));
            params.getPageDto().setCurPageCount(Integer.valueOf(roles.size()));
        }
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty((Collection)roles)) {
            return result;
        }
        Set<Long> creatorIds = roles.stream().map(Role::getCreateBy).collect(Collectors.toSet());
        Map<Long, String> creatorId2NameMap = this.userService.getUserIdAndNameByUserIds(creatorIds);
        for (Role role : roles) {
            result.add(RoleRespDto.from(role, creatorId2NameMap));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addRole(RoleAddReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("add role with params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validate();
        this.checkRoleName(currentUserInfo.getBizId(), params.getName(), null);
        Role role = params.to();
        role.setCreateBy(currentUserInfo.getId());
        role.setUpdateBy(currentUserInfo.getId());
        role.setBizId(currentUserInfo.getBizId());
        role.setCorpId(currentUserInfo.getCorpId());
        role.setOrgType(params.getOrgType());
        this.roleMapper.insertSelective((Object)role);
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(currentUserInfo.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("bizId:{}\uff0cnetSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)currentUserInfo.getBizId(), (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("user userId:{} \u5bf9\u5e94\u7684\u7f51\u6821userId\u4e0d\u5b58\u5728", (Object)currentUserInfo.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u5e10\u53f7\u672a\u5f00\u901a\u7f51\u6821\u6743\u9650\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        NetSchoolRoleAddReqDto netSchoolRoleAddReqDto = params.convertToNetSchoolRoleAddReq(user.getNetSchoolUserId());
        try {
            Integer netSchoolRoleId = this.scrmNetSchoolService.addRole(netSchoolRoleAddReqDto, currentUserInfo.getBizId());
            this.roleMapper.updateNetSchoolRoleIdById(netSchoolRoleId, role.getId());
        }
        catch (Exception e) {
            log.info("add role netSchoolRoleAddReqDto:{}\u540c\u6b65\u597d\u53cb\u5230\u7f51\u6821\u5931\u8d25:", (Object)netSchoolRoleAddReqDto);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u5efa\u89d2\u8272\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modRole(RoleModReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("mod role with params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validate();
        this.checkRoleName(currentUserInfo.getBizId(), params.getName(), params.getId());
        Role role = this.roleMapper.selectRoleById(params.getId(), currentUserInfo.getBizId());
        if (Objects.isNull(role)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8981\u4fee\u6539\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        role.setName(params.getName());
        role.setRemark(params.getRemark());
        role.setUpdateTime(new Date());
        role.setUpdateBy(currentUserInfo.getId());
        role.setOrgType(params.getOrgType());
        this.roleMapper.updateByPrimaryKeySelective((Object)role);
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(currentUserInfo.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("bizId:{}\uff0cnetSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)currentUserInfo.getBizId(), (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("user userId:{} \u5bf9\u5e94\u7684\u7f51\u6821userId\u4e0d\u5b58\u5728", (Object)currentUserInfo.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u5e10\u53f7\u672a\u5f00\u901a\u7f51\u6821\u6743\u9650\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        if (Objects.nonNull(role.getNetSchoolRoleId())) {
            NetSchoolRoleModReqDto reqDto = params.convertToRoleModReqDto(user.getNetSchoolUserId());
            try {
                this.scrmNetSchoolService.modRole(reqDto, role.getNetSchoolRoleId(), currentUserInfo.getBizId());
            }
            catch (Exception e) {
                log.info("reqDto:{}\u8c03\u7528\u7f51\u6821\u7f16\u8f91\u89d2\u8272\u63a5\u53e3\u5931\u8d25:", (Object)reqDto);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f16\u8f91\u89d2\u8272\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
        }
        NetSchoolRoleAddReqDto netSchoolRoleAddReqDto = new NetSchoolRoleAddReqDto();
        netSchoolRoleAddReqDto.setRoleName(role.getName());
        netSchoolRoleAddReqDto.setDescription(role.getRemark());
        netSchoolRoleAddReqDto.setUserId(user.getNetSchoolUserId());
        try {
            Integer netSchoolRoleId = this.scrmNetSchoolService.addRole(netSchoolRoleAddReqDto, currentUserInfo.getBizId());
            this.roleMapper.updateNetSchoolRoleIdById(netSchoolRoleId, role.getId());
        }
        catch (Exception e) {
            log.info("modRole netSchoolRoleAddReqDto:{}\u540c\u6b65\u597d\u53cb\u5230\u7f51\u6821\u5931\u8d25:", (Object)netSchoolRoleAddReqDto);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f16\u8f91\u89d2\u8272\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delRole(RoleReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("del role with params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        Preconditions.checkArgument((params.getId() != null ? 1 : 0) != 0, (Object)"\u89d2\u8272id\u4e3a\u7a7a");
        Role role = this.roleMapper.selectRoleById(params.getId(), currentUserInfo.getBizId());
        if (Objects.isNull(role)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8981\u5220\u9664\u7684\u89d2\u8272\u4e0d\u5b58\u5728");
        }
        if (role.getIsSystem() > 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u7cfb\u7edf\u5185\u7f6e\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        Set<Long> roleIdSet = Collections.singleton(params.getId());
        Map roleUserNumMap = this.userRoleMapper.queryRoleUserNum(currentUserInfo.getBizId(), roleIdSet);
        Set userIds = this.userRoleMapper.selectUserIdsByRoleIdAndBizId(params.getId(), currentUserInfo.getBizId());
        int relAccessUserCount = this.userMapper.selectAccessUserCount((Collection)userIds);
        Integer userNum = MapUtils.getInteger((Map)roleUserNumMap, (Object)params.getId(), (Integer)0);
        if (userNum != 0 && relAccessUserCount != 0) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6709\u7528\u6237\u5173\u8054\u8be5\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u5220\u9664");
        }
        this.roleMapper.deleteOwnRoleById(params.getId(), currentUserInfo.getBizId());
        this.roleMenuMapper.delRoleMenus(params.getId(), currentUserInfo.getBizId());
        NetSchoolAppResp netSchoolAppResp = this.scrmBizService.getNetSchoolAppResp(currentUserInfo.getBizId());
        if (!netSchoolAppResp.getIsCanInvokeNetSchoolInterface().booleanValue()) {
            log.info("bizId:{}\uff0cnetSchoolAppResp:{}\u6682\u4e0d\u652f\u6301\u8c03\u7528\u7f51\u6821\u63a5\u53e3", (Object)currentUserInfo.getBizId(), (Object)netSchoolAppResp);
            return;
        }
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        if (Objects.isNull(user.getNetSchoolUserId())) {
            log.info("user userId:{} \u5bf9\u5e94\u7684\u7f51\u6821userId\u4e0d\u5b58\u5728", (Object)currentUserInfo.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u7684\u5e10\u53f7\u672a\u5f00\u901a\u7f51\u6821\u6743\u9650\uff0c\u5982\u6709\u7591\u95ee\uff0c\u8bf7\u4e0e\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4");
        }
        try {
            this.scrmNetSchoolService.deleteRole(role.getNetSchoolRoleId(), user.getNetSchoolUserId(), currentUserInfo.getBizId());
        }
        catch (Exception e) {
            log.error("roleId:{}\u8c03\u7528\u7f51\u6821\u5220\u9664\u89d2\u8272\u63a5\u53e3\u5931\u8d25:", (Object)role.getId(), (Object)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5220\u9664\u89d2\u8272\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public RoleDetailRespDto detail(RoleReqDto params) {
        NetSchoolRoleDetailRespDto netSchoolRoleDetailRespDto;
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("role detail with params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validate();
        Role role = this.validateRoleId(params.getId(), currentUserInfo.getBizId());
        Set menuCodes = this.roleMenuMapper.getMenuCodesByRoleId(params.getId(), currentUserInfo.getBizId());
        RoleDetailRespDto roleDetailRespDto = new RoleDetailRespDto();
        roleDetailRespDto.setId(role.getId());
        roleDetailRespDto.setName(role.getName());
        roleDetailRespDto.setRemark(role.getRemark());
        roleDetailRespDto.setOrgType(role.getOrgType());
        roleDetailRespDto.setMenuCodes(menuCodes);
        User user = (User)this.userMapper.selectByPrimaryKey((Object)currentUserInfo.getId());
        if (Objects.isNull(user.getNetSchoolUserId())) {
            return roleDetailRespDto;
        }
        HashSet netSchoolUserIds = Sets.newHashSet();
        try {
            netSchoolRoleDetailRespDto = this.scrmNetSchoolService.roleDetail(role.getNetSchoolRoleId(), user.getNetSchoolUserId(), currentUserInfo.getBizId());
        }
        catch (Exception e) {
            log.error("roleId:{}\u8c03\u7528\u7f51\u6821\u83b7\u53d6\u89d2\u8272\u8be6\u60c5\u63a5\u53e3\u5931\u8d25:", (Object)role.getId(), (Object)e);
            return roleDetailRespDto;
        }
        log.info("role detail netSchoolRoleDetailRespDto:{}", (Object)roleDetailRespDto);
        if (netSchoolRoleDetailRespDto != null && StringUtils.isNotBlank((CharSequence)netSchoolRoleDetailRespDto.getMenuIds())) {
            String[] netSchoolMenuIds;
            for (String menuId : netSchoolMenuIds = netSchoolRoleDetailRespDto.getMenuIds().split("/")) {
                if (!StringUtils.isNotBlank((CharSequence)menuId)) continue;
                netSchoolUserIds.add(menuId);
            }
        }
        roleDetailRespDto.setNetSchoolMenuCodes(netSchoolUserIds);
        return roleDetailRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setMenu(RoleReqDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        log.info("setMenu,params:{},operatorId:{}", (Object)params, (Object)currentUserInfo.getId());
        params.validateSetMenuParams();
        Role role = this.validateRoleId(params.getId(), currentUserInfo.getBizId());
        Collection<String> needAddMenuCodes = null;
        Collection needDelMenuCodes = null;
        HashSet netSchoolMenuCodes = params.getNetSchoolMenuCodes();
        Set oldMenuCodes = this.roleMenuMapper.getMenuCodesByRoleId(params.getId(), currentUserInfo.getBizId());
        if (CollectionUtils.isEmpty(params.getMenuCodes())) {
            if (CollectionUtils.isNotEmpty((Collection)oldMenuCodes)) {
                this.roleMenuMapper.delByRoleIdAndMenuCodes(role.getId(), (Collection)oldMenuCodes, currentUserInfo.getBizId());
            }
            if (CollectionUtils.isNotEmpty(netSchoolMenuCodes) && netSchoolMenuCodes.contains("470")) {
                HashSet newMenuCodes = Sets.newHashSet((Object[])new String[]{"010701"});
                this.addSaveRoleMenu(newMenuCodes, role.getId(), currentUserInfo);
            }
        } else {
            if (CollectionUtils.isEmpty((Collection)oldMenuCodes)) {
                needAddMenuCodes = params.getMenuCodes();
            } else {
                needAddMenuCodes = CollectionUtils.removeAll(params.getMenuCodes(), (Collection)oldMenuCodes);
                needDelMenuCodes = CollectionUtils.removeAll((Collection)oldMenuCodes, params.getMenuCodes());
            }
            log.info("setMenu,needAddMenuCodes:{}, needDelMenuCodes:{}", needAddMenuCodes, needDelMenuCodes);
            if (CollectionUtils.isNotEmpty((Collection)needDelMenuCodes)) {
                this.roleMenuMapper.delByRoleIdAndMenuCodes(role.getId(), needDelMenuCodes, currentUserInfo.getBizId());
            }
            if (CollectionUtils.isNotEmpty(params.getNetSchoolMenuCodes()) && params.getNetSchoolMenuCodes().contains("470") && CollectionUtils.isEmpty(needAddMenuCodes)) {
                needAddMenuCodes = Sets.newHashSet();
            }
            if (CollectionUtils.isNotEmpty(needAddMenuCodes)) {
                this.addSaveRoleMenu(needAddMenuCodes, role.getId(), currentUserInfo);
            }
        }
        try {
            if (CollectionUtils.isNotEmpty(needAddMenuCodes) && needAddMenuCodes.contains("010701")) {
                if (CollectionUtils.isEmpty(netSchoolMenuCodes)) {
                    netSchoolMenuCodes = Sets.newHashSet();
                }
                netSchoolMenuCodes.add("470");
            }
            if (oldMenuCodes.contains("010701") && CollectionUtils.isNotEmpty((Collection)needDelMenuCodes) && !needDelMenuCodes.contains("010701")) {
                netSchoolMenuCodes.add("470");
            }
            this.scrmNetSchoolService.setRoleMenu(role.getNetSchoolRoleId(), currentUserInfo.getId(), params.getNetSchoolMenuCodes(), currentUserInfo.getBizId());
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u7f51\u6821\u8bbe\u7f6e\u89d2\u8272\u6743\u9650\u63a5\u53e3\u5931\u8d25:", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7ed9\u89d2\u8272\u8bbe\u7f6e\u6743\u9650\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    public SystemRoleMenuRespDto systemRoleDetail(SystemRoleMenuReqDto params) {
        log.info("systemRoleDetail,params:{}", (Object)params);
        params.baseValidate();
        Set menuCodes = this.systemRoleMenuMapper.selectByType(params.getType());
        SystemRoleMenuRespDto systemRoleMenuRespDto = new SystemRoleMenuRespDto();
        systemRoleMenuRespDto.setType(params.getType());
        systemRoleMenuRespDto.setMenuCodes(menuCodes);
        return systemRoleMenuRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void setSystemRoleMenu(SystemRoleMenuReqDto params) {
        Collection<String> needAddMenuCodes;
        log.info("setSystemRoleMenu,params:{}", (Object)params);
        params.validateParams();
        Set oldMenuCodes = this.systemRoleMenuMapper.selectByType(params.getType());
        Collection needDelMenuCodes = null;
        if (CollectionUtils.isEmpty((Collection)oldMenuCodes)) {
            needAddMenuCodes = params.getMenuCodes();
        } else {
            needAddMenuCodes = CollectionUtils.removeAll(params.getMenuCodes(), (Collection)oldMenuCodes);
            needDelMenuCodes = CollectionUtils.removeAll((Collection)oldMenuCodes, params.getMenuCodes());
        }
        List businessCustomers = this.businessCustomerMapper.selectAll();
        Map businessCustomerMap = null;
        if (CollectionUtils.isNotEmpty((Collection)businessCustomers)) {
            businessCustomerMap = businessCustomers.stream().collect(Collectors.toMap(BusinessCustomer::getCorpId, Functions.identity()));
        }
        if (CollectionUtils.isNotEmpty(needAddMenuCodes)) {
            this.systemRoleMenuMapper.batchInsert(params.getType(), needAddMenuCodes);
            if (MapUtils.isNotEmpty(businessCustomerMap)) {
                Set corpIds = businessCustomers.stream().map(BusinessCustomer::getCorpId).collect(Collectors.toSet());
                Map corpId2RoleIdMap = this.roleMapper.selectByCorpIdsAndSystemRoleType(corpIds, params.getType());
                ArrayList roleMenus = Lists.newArrayList();
                for (Map.Entry entry : corpId2RoleIdMap.entrySet()) {
                    BusinessCustomer businessCustomer = (BusinessCustomer)businessCustomerMap.get(entry.getKey());
                    if (Objects.isNull(businessCustomer)) continue;
                    for (String menuCode : needAddMenuCodes) {
                        RoleMenu roleMenu = new RoleMenu();
                        roleMenus.add(roleMenu);
                        roleMenu.setRoleId((Long)entry.getValue());
                        roleMenu.setMenuCode(menuCode);
                        roleMenu.setBizId(businessCustomer.getId());
                        roleMenu.setCreateBy(NumberUtils.LONG_MINUS_ONE);
                        roleMenu.setCreateTime(new Date());
                        roleMenu.setUpdateBy(NumberUtils.LONG_MINUS_ONE);
                        roleMenu.setUpdateTime(new Date());
                        roleMenu.setIsDeleted(NumberUtils.INTEGER_ZERO);
                        roleMenu.setCorpId((String)entry.getKey());
                    }
                }
                Lists.partition((List)roleMenus, (int)100).forEach(partitionRoleMenus -> this.roleMenuMapper.batchInsert(partitionRoleMenus));
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)needDelMenuCodes)) {
            this.systemRoleMenuMapper.delByTypeAndMenuCodes(params.getType(), needDelMenuCodes);
            if (MapUtils.isNotEmpty(businessCustomerMap)) {
                for (Map.Entry entry : businessCustomerMap.entrySet()) {
                    Set roleIds = this.roleMapper.selectSystemRoleIdsByCorpId(entry.getKey(), params.getType());
                    if (CollectionUtils.isEmpty((Collection)roleIds)) continue;
                    this.roleMenuMapper.delByRoleIdsAndMenuCodes((Collection)roleIds, needDelMenuCodes);
                }
            }
        }
    }

    @Override
    public RoleOrgTypeRespDto getRoleOrgType() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long userId = currentUserInfo.getId();
        Long roleId = currentUserInfo.getCurRole().getRoleId();
        RoleOrgTypeRespDto roleOrgTypeRespDto = new RoleOrgTypeRespDto();
        if (Objects.isNull(roleId)) {
            log.info("getRoleOrgType, operatorId:{}\u672a\u914d\u7f6e\u89d2\u8272", (Object)userId);
            return roleOrgTypeRespDto;
        }
        Integer orgType = this.roleMapper.selectOrgTypeByRoleId(roleId);
        roleOrgTypeRespDto.setOrgType(orgType);
        return roleOrgTypeRespDto;
    }

    private void checkRoleName(Long bizId, String roleName, Long oldRoleId) {
        List roleList = this.roleMapper.selectOwnRoleByName(roleName, bizId);
        if (CollectionUtils.isNotEmpty((Collection)roleList)) {
            for (Role role : roleList) {
                if (!(oldRoleId == null ? role.getName().equals(roleName) : role.getName().equals(roleName) && !role.getId().equals(oldRoleId))) continue;
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89d2\u8272\u540d\u79f0\u91cd\u590d");
            }
        }
    }

    private Role validateRoleId(Long roleId, Long bizId) {
        Role role = (Role)this.roleMapper.selectByPrimaryKey((Object)roleId);
        if (Objects.isNull(role)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89d2\u8272id\u4e0d\u5408\u6cd5");
        }
        if (!role.getBizId().equals(bizId)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u89d2\u8272id\u4e0d\u5408\u6cd5");
        }
        return role;
    }

    private void addSaveRoleMenu(Collection<String> menuCodes, Long roleId, CurrentUserInfo currentUserInfo) {
        if (CollectionUtils.isNotEmpty(menuCodes)) {
            ArrayList roleMenus = Lists.newArrayListWithCapacity((int)menuCodes.size());
            for (String menuCode : menuCodes) {
                RoleMenu roleMenu = new RoleMenu();
                roleMenus.add(roleMenu);
                roleMenu.setRoleId(roleId);
                roleMenu.setMenuCode(menuCode);
                roleMenu.setBizId(currentUserInfo.getBizId());
                roleMenu.setCreateBy(currentUserInfo.getId());
                roleMenu.setUpdateBy(currentUserInfo.getId());
                roleMenu.setCreateTime(new Date());
                roleMenu.setUpdateTime(new Date());
                roleMenu.setIsDeleted(NumberUtils.INTEGER_ZERO);
                roleMenu.setCorpId(currentUserInfo.getCorpId());
            }
            this.roleMenuMapper.batchInsert((List)roleMenus);
        }
    }
}

