/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.service.impl;

import cn.kinyun.pay.business.dto.request.PayConfigGroupQuery;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDto;
import cn.kinyun.pay.business.dto.response.PayConfigGroupDtoResp;
import cn.kinyun.pay.business.service.ScrmPayConfigService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.GroupTypeEnum;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.CommonGroupService;
import com.kuaike.scrm.common.service.dto.GroupDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.channel.dto.ChannelQueryParams;
import com.kuaike.scrm.dal.channel.entity.Channel;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.group.entity.CommonGroupRel;
import com.kuaike.scrm.dal.group.mapper.CommonGroupRelMapper;
import com.kuaike.scrm.system.dto.request.ChannelEnableDto;
import com.kuaike.scrm.system.dto.request.ChannelReqDto;
import com.kuaike.scrm.system.dto.response.ChannelGroupRespDto;
import com.kuaike.scrm.system.dto.response.ChannelRespDto;
import com.kuaike.scrm.system.service.ChannelService;
import com.kuaike.scrm.system.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChannelServiceImpl
implements ChannelService {
    private static final Logger log = LoggerFactory.getLogger(ChannelServiceImpl.class);
    @Autowired
    private UserService userService;
    @Resource
    private ScrmPayConfigService scrmPayConfigService;
    @Resource
    private ChannelMapper channelMapper;
    @Autowired
    private IdGen idGen;
    @Autowired
    private CommonGroupService commonGroupService;
    @Autowired
    private CommonGroupRelMapper groupRelMapper;

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long userId = LoginUtils.getCurrentUserId();
        log.info("query channel list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        List list = this.channelMapper.queryList(bizId, query, pageDto);
        if (pageDto != null) {
            int count = this.channelMapper.queryCount(bizId, query);
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Channel it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(it.getNum());
                dto.setLabel(it.getName());
                result.add(dto);
            }
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query channel list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet nums = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            nums.add(it.trim());
        }
        Map map = this.channelMapper.selectNameByNums(bizId, (Collection)nums);
        if (map != null && map.size() > 0) {
            map.forEach((num, name) -> {
                BDataValueDto dto = new BDataValueDto();
                dto.setValue(num);
                dto.setLabel(name);
                result.add(dto);
            });
        }
        return result;
    }

    @Override
    public List<ChannelRespDto> list(ChannelReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateListParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        ChannelQueryParams channelQueryParams = reqDto.convert2QueryCondition(bizId, corpId);
        channelQueryParams.setName(reqDto.getName());
        List channels = this.channelMapper.getListByCondition(channelQueryParams);
        if (CollectionUtils.isEmpty((Collection)channels)) {
            log.warn("\u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)channelQueryParams);
            return Collections.emptyList();
        }
        int count = this.channelMapper.getCountByCondition(channelQueryParams);
        reqDto.getPageDto().setCount(Integer.valueOf(count));
        Set<Long> creatorIds = channels.stream().map(Channel::getCreateBy).collect(Collectors.toSet());
        Set updateIds = channels.stream().map(Channel::getUpdateBy).collect(Collectors.toSet());
        creatorIds.addAll(updateIds);
        Map<Long, String> userId2NameMap = this.userService.getUserIdAndNameByUserIds(creatorIds);
        List channelNums = channels.stream().map(Channel::getNum).collect(Collectors.toList());
        List groupRels = this.groupRelMapper.queryGroupNumByFkKeys(bizId, channelNums);
        Map<String, String> groupId2NumMap = null;
        if (CollectionUtils.isNotEmpty((Collection)groupRels)) {
            groupId2NumMap = groupRels.stream().collect(Collectors.toMap(CommonGroupRel::getFkKey, CommonGroupRel::getGroupNum));
        }
        List filteredChannels = channels.stream().filter(c -> StringUtils.isNotBlank((CharSequence)c.getPayGroupKey())).collect(Collectors.toList());
        Map<String, String> payGroupKey2NameMap = null;
        if (CollectionUtils.isNotEmpty(filteredChannels)) {
            PayConfigGroupQuery payConfigGroupQuery = new PayConfigGroupQuery();
            payConfigGroupQuery.setCorpId(corpId);
            payConfigGroupQuery.setGroupKeys((Collection)filteredChannels.stream().map(Channel::getPayGroupKey).collect(Collectors.toList()));
            PayConfigGroupDtoResp payConfigGroupDtoResp = this.scrmPayConfigService.queryConfigGroup(payConfigGroupQuery);
            if (Objects.nonNull(payConfigGroupDtoResp) && CollectionUtils.isNotEmpty((Collection)payConfigGroupDtoResp.getList())) {
                payGroupKey2NameMap = payConfigGroupDtoResp.getList().stream().collect(Collectors.toMap(PayConfigGroupDto::getGroupKey, PayConfigGroupDto::getGroupName));
            }
        }
        return this.buildChannelList(channels, userId2NameMap, reqDto.getShowInner(), groupId2NumMap, payGroupKey2NameMap);
    }

    @Override
    public void add(ChannelReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateAddParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("addChannel,reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        boolean isExist = this.channelMapper.checkNameIsExist(reqDto.getName(), bizId, corpId);
        Preconditions.checkArgument((!isExist ? 1 : 0) != 0, (Object)"\u6e20\u9053\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        Channel channel = this.buildChannelObj(reqDto, currentUserInfo);
        try {
            this.channelMapper.insert((Object)channel);
        }
        catch (Exception ex) {
            log.error("\u65b0\u589e\u6e20\u9053\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u589e\u6e20\u9053\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        this.commonGroupService.relGroup(currentUserInfo.getBizId(), currentUserInfo.getId(), reqDto.getGroupId(), channel.getNum());
    }

    @Override
    public void mod(ChannelReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateModeParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("modChannel,reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        Channel channel = this.channelMapper.selectByNum(reqDto.getId(), bizId, corpId);
        Preconditions.checkArgument((boolean)Objects.nonNull(channel), (Object)"\u6e20\u9053id\u4e0d\u5408\u6cd5");
        Channel oldChannel = this.channelMapper.selectByName(reqDto.getName(), bizId, corpId);
        if (Objects.nonNull(oldChannel) && !reqDto.getId().equals(oldChannel.getNum())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u6e20\u9053\u540d\u79f0\u91cd\u590d");
        }
        channel.setName(reqDto.getName());
        channel.setDescription(reqDto.getDesc());
        channel.setLevel(reqDto.getLevel());
        channel.setUpdateBy(currentUserInfo.getId());
        channel.setUpdateTime(new Date());
        channel.setPayGroupKey(reqDto.getPayGroupKey());
        this.channelMapper.updateByPrimaryKey((Object)channel);
        this.commonGroupService.relGroup(currentUserInfo.getBizId(), currentUserInfo.getId(), reqDto.getGroupId(), channel.getNum());
    }

    @Override
    public void del(ChannelReqDto reqDto) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        reqDto.validateDelParams(currentUserInfo);
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("delChannel,reqDto:{}, bizId:{}, corpId:{}", new Object[]{reqDto, bizId, corpId});
        this.channelMapper.delByNum(reqDto.getId(), bizId, corpId);
        this.commonGroupService.delRelGroup(bizId, reqDto.getId());
    }

    @Override
    public void enable(ChannelEnableDto params) {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        log.info("modChannel,reqDto:{}, bizId:{}, corpId:{}", new Object[]{params, bizId, corpId});
        Preconditions.checkArgument((StringUtils.isNotEmpty((CharSequence)params.getId()) && params.getIsEnabled() != null && (params.getIsEnabled() == 0 || params.getIsEnabled() == 1) ? 1 : 0) != 0, (Object)"\u53c2\u6570\u4e0d\u5408\u6cd5");
        Channel channel = this.channelMapper.selectByNum(params.getId(), bizId, corpId);
        Preconditions.checkArgument((boolean)Objects.nonNull(channel), (Object)"\u6e20\u9053id\u4e0d\u5408\u6cd5");
        channel.setIsEnabled(params.getIsEnabled());
        channel.setUpdateBy(currentUserInfo.getId());
        channel.setUpdateTime(new Date());
        this.channelMapper.updateByPrimaryKey((Object)channel);
    }

    @Override
    public List<Long> getChannelIdByNum(List<String> numList) {
        if (CollectionUtils.isEmpty(numList)) {
            return Lists.newArrayList();
        }
        return this.channelMapper.queryChannelIdByNum(numList);
    }

    private List<ChannelRespDto> buildChannelList(List<Channel> channels, Map<Long, String> userId2NameMap, Integer showInner, Map<String, String> groupId2NumMap, Map<String, String> payGroupKey2NameMap) {
        ArrayList channelRespDtos = Lists.newArrayList();
        for (Channel channel : channels) {
            SysChannelEnum innerChannel = SysChannelEnum.getInnerChannelByCode((String)channel.getNum());
            if ((Objects.isNull(showInner) || !YnEnum.YES.getValue().equals(showInner)) && Objects.nonNull(innerChannel)) continue;
            ChannelRespDto channelRespDto = new ChannelRespDto();
            channelRespDtos.add(channelRespDto);
            channelRespDto.setId(channel.getNum());
            channelRespDto.setName(channel.getName());
            channelRespDto.setCreateTime(channel.getCreateTime());
            channelRespDto.setUpdateTime(channel.getUpdateTime());
            if (Objects.nonNull(innerChannel)) {
                channelRespDto.setDesc("\u7cfb\u7edf\u5185\u7f6e\u6e20\u9053");
                channelRespDto.setIsInner(YnEnum.YES.getValue());
            } else {
                channelRespDto.setDesc(channel.getDescription());
            }
            channelRespDto.setIsEnabled(channel.getIsEnabled());
            channelRespDto.setLevel(channel.getLevel());
            if (groupId2NumMap != null) {
                String groupId = groupId2NumMap.get(channel.getNum());
                channelRespDto.setGroupId(groupId);
            }
            if (MapUtils.isNotEmpty(userId2NameMap) && userId2NameMap.containsKey(channel.getCreateBy())) {
                channelRespDto.setCreatorName(userId2NameMap.get(channel.getCreateBy()));
            }
            if (MapUtils.isNotEmpty(userId2NameMap) && userId2NameMap.containsKey(channel.getUpdateBy())) {
                channelRespDto.setUpdateName(userId2NameMap.get(channel.getUpdateBy()));
            }
            if (channel.getBizId() == 0L) {
                channelRespDto.setType(1);
                channelRespDto.setIsInner(1);
            } else {
                channelRespDto.setType(0);
                channelRespDto.setIsInner(0);
            }
            if (!MapUtils.isNotEmpty(payGroupKey2NameMap) || !StringUtils.isNotBlank((CharSequence)channel.getPayGroupKey())) continue;
            channelRespDto.setPayGroupKey(channel.getPayGroupKey());
            channelRespDto.setPayGroupName(payGroupKey2NameMap.get(channel.getPayGroupKey()));
        }
        return channelRespDtos;
    }

    private Channel buildChannelObj(ChannelReqDto reqDto, CurrentUserInfo currentUserInfo) {
        Channel channel = new Channel();
        channel.setName(reqDto.getName());
        channel.setBizId(currentUserInfo.getBizId());
        channel.setCorpId(currentUserInfo.getCorpId());
        channel.setCreateBy(currentUserInfo.getId());
        channel.setCreateTime(new Date());
        channel.setUpdateBy(currentUserInfo.getId());
        channel.setUpdateTime(new Date());
        channel.setIsDeleted(NumberUtils.INTEGER_ZERO);
        channel.setNum(this.idGen.getNum());
        channel.setDescription(reqDto.getDesc());
        channel.setLevel(reqDto.getLevel());
        channel.setIsEnabled(NumberUtils.INTEGER_ONE);
        channel.setPayGroupKey(reqDto.getPayGroupKey());
        return channel;
    }

    @Override
    public List<ChannelGroupRespDto> groupChannelList() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Long bizId = currentUserInfo.getBizId();
        log.info("groupChannelList bizId:{}", (Object)bizId);
        List channels = this.channelMapper.getBizChannelList(bizId);
        List fkKeys = this.groupRelMapper.queryFkIdByBizid(bizId);
        List channelNums = channels.stream().map(Channel::getNum).collect(Collectors.toList());
        channelNums.removeAll(fkKeys);
        log.info("groupChannelList channelNums: {}", channelNums);
        if (CollectionUtils.isNotEmpty(channelNums)) {
            for (String channelNum : channelNums) {
                this.commonGroupService.relGroup(currentUserInfo.getBizId(), currentUserInfo.getId(), "", channelNum);
            }
        }
        GroupDto dto = new GroupDto();
        dto.setType(GroupTypeEnum.CAHNNEL_MANAGER.getCode());
        List groupDtos = this.commonGroupService.list(dto);
        List groupNums = groupDtos.stream().map(GroupDto::getId).collect(Collectors.toList());
        log.info("groupChannelList get groupNums: {}", groupNums);
        Map<String, String> groupMap = groupDtos.stream().collect(Collectors.toMap(GroupDto::getId, GroupDto::getName));
        log.info("groupChannelList get groupMap: {}", groupMap);
        List groupRels = this.groupRelMapper.queryCommonGroupRel(bizId, groupNums);
        if (CollectionUtils.isEmpty((Collection)groupRels)) {
            return null;
        }
        Map groupNum2FkidMaps = groupRels.stream().collect(Collectors.groupingBy(CommonGroupRel::getGroupNum, Collectors.mapping(CommonGroupRel::getFkKey, Collectors.toList())));
        log.info("groupChannelList, get groupNum2FkidMaps: {}", groupNum2FkidMaps);
        Map<String, Channel> channelMap = channels.stream().collect(Collectors.toMap(Channel::getNum, a -> a));
        log.info("groupChannelList, get channelMap: {}", channelMap);
        ArrayList groupRespDtos = Lists.newArrayList();
        for (Map.Entry entry : groupNum2FkidMaps.entrySet()) {
            String groupNum = entry.getKey();
            List fkIds = entry.getValue();
            ChannelGroupRespDto respDto = new ChannelGroupRespDto();
            String name = groupMap.get(groupNum);
            if (groupNum.equals("default")) {
                name = "\u9ed8\u8ba4\u5206\u7ec4";
            }
            respDto.setGroupId(groupNum);
            respDto.setGroupName(name);
            ArrayList channelRespDtos = Lists.newArrayList();
            for (String fkId : fkIds) {
                Channel channel = channelMap.get(fkId);
                if (channel == null) continue;
                ChannelRespDto channelRespDto = new ChannelRespDto();
                channelRespDto.setId(fkId);
                channelRespDto.setName(channel.getName());
                channelRespDto.setDesc(channel.getDescription());
                channelRespDto.setIsEnabled(channel.getIsEnabled());
                channelRespDto.setLevel(channel.getLevel());
                channelRespDto.setIsInner(NumberUtils.INTEGER_ZERO);
                if (NumberUtils.LONG_ZERO.equals(channel.getBizId())) {
                    channelRespDto.setIsInner(NumberUtils.INTEGER_ONE);
                }
                channelRespDtos.add(channelRespDto);
            }
            respDto.setChannelRespDtos(channelRespDtos);
            groupRespDtos.add(respDto);
        }
        return groupRespDtos;
    }
}

