/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.system.dto.response;

import com.kuaike.scrm.common.enums.OrgTypeEnum;
import com.kuaike.scrm.dal.permission.entity.Role;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;

public class RoleRespDto
implements Serializable {
    private static final long serialVersionUID = -2505037495593967532L;
    private Long id;
    private String name;
    private String remark;
    private Integer isSystem;
    private Long creatorId;
    private String creatorName;
    private Date createTime;
    private Integer type;
    private Integer orgType;
    private String orgTypeDesc;

    public static RoleRespDto from(Role role, Map<Long, String> creatorId2NameMap) {
        RoleRespDto dto = new RoleRespDto();
        dto.setId(role.getId());
        dto.setName(role.getName());
        dto.setRemark(role.getRemark());
        dto.setIsSystem(role.getIsSystem());
        dto.setCreateTime(role.getCreateTime());
        dto.setCreatorId(role.getCreateBy());
        dto.setType(role.getType());
        if (MapUtils.isNotEmpty(creatorId2NameMap) && creatorId2NameMap.containsKey(role.getCreateBy())) {
            dto.setCreatorName(creatorId2NameMap.get(role.getCreateBy()));
        }
        if (Objects.nonNull(role.getOrgType())) {
            dto.setOrgType(role.getOrgType());
            dto.setOrgTypeDesc(OrgTypeEnum.get((int)role.getOrgType()).getDesc());
        }
        return dto;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getRemark() {
        return this.remark;
    }

    public Integer getIsSystem() {
        return this.isSystem;
    }

    public Long getCreatorId() {
        return this.creatorId;
    }

    public String getCreatorName() {
        return this.creatorName;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getOrgType() {
        return this.orgType;
    }

    public String getOrgTypeDesc() {
        return this.orgTypeDesc;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setIsSystem(Integer isSystem) {
        this.isSystem = isSystem;
    }

    public void setCreatorId(Long creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreatorName(String creatorName) {
        this.creatorName = creatorName;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setOrgType(Integer orgType) {
        this.orgType = orgType;
    }

    public void setOrgTypeDesc(String orgTypeDesc) {
        this.orgTypeDesc = orgTypeDesc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RoleRespDto)) {
            return false;
        }
        RoleRespDto other = (RoleRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$isSystem = this.getIsSystem();
        Integer other$isSystem = other.getIsSystem();
        if (this$isSystem == null ? other$isSystem != null : !((Object)this$isSystem).equals(other$isSystem)) {
            return false;
        }
        Long this$creatorId = this.getCreatorId();
        Long other$creatorId = other.getCreatorId();
        if (this$creatorId == null ? other$creatorId != null : !((Object)this$creatorId).equals(other$creatorId)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$orgType = this.getOrgType();
        Integer other$orgType = other.getOrgType();
        if (this$orgType == null ? other$orgType != null : !((Object)this$orgType).equals(other$orgType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$remark = this.getRemark();
        String other$remark = other.getRemark();
        if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
            return false;
        }
        String this$creatorName = this.getCreatorName();
        String other$creatorName = other.getCreatorName();
        if (this$creatorName == null ? other$creatorName != null : !this$creatorName.equals(other$creatorName)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        String this$orgTypeDesc = this.getOrgTypeDesc();
        String other$orgTypeDesc = other.getOrgTypeDesc();
        return !(this$orgTypeDesc == null ? other$orgTypeDesc != null : !this$orgTypeDesc.equals(other$orgTypeDesc));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RoleRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $isSystem = this.getIsSystem();
        result = result * 59 + ($isSystem == null ? 43 : ((Object)$isSystem).hashCode());
        Long $creatorId = this.getCreatorId();
        result = result * 59 + ($creatorId == null ? 43 : ((Object)$creatorId).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $orgType = this.getOrgType();
        result = result * 59 + ($orgType == null ? 43 : ((Object)$orgType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $remark = this.getRemark();
        result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
        String $creatorName = this.getCreatorName();
        result = result * 59 + ($creatorName == null ? 43 : $creatorName.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        String $orgTypeDesc = this.getOrgTypeDesc();
        result = result * 59 + ($orgTypeDesc == null ? 43 : $orgTypeDesc.hashCode());
        return result;
    }

    public String toString() {
        return "RoleRespDto(id=" + this.getId() + ", name=" + this.getName() + ", remark=" + this.getRemark() + ", isSystem=" + this.getIsSystem() + ", creatorId=" + this.getCreatorId() + ", creatorName=" + this.getCreatorName() + ", createTime=" + this.getCreateTime() + ", type=" + this.getType() + ", orgType=" + this.getOrgType() + ", orgTypeDesc=" + this.getOrgTypeDesc() + ")";
    }
}

