/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopFundAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.fund.OrderFlowDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetOrderFlowReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetOrderFlowResp;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.ThreadTools;
import com.kuaike.scrm.dal.shop.entity.ShopOrderFlow;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderFlowMapper;
import com.kuaike.scrm.shop.enums.OrderFlowStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FundFlowUpdateService {
    private static final Logger log = LoggerFactory.getLogger(FundFlowUpdateService.class);
    @Autowired
    private ShopOrderFlowMapper shopOrderFlowMapper;
    @Autowired
    private AppletAccessTokenService accessTokenService;
    @Autowired
    private WxShopFundAPI fundAPI;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    private Set<Integer> needUpdateStatusList = Sets.newHashSet((Object[])new Integer[]{OrderFlowStatus.ORDER_FLOW_STATUS_TRANSACTION_PENDING_SETTLED.getStatus()});

    public Set<Integer> getNeedUpdateStatus() {
        return this.needUpdateStatusList;
    }

    public void doRun() {
        List appIds = this.appletInfoMapper.queryAllAuthShopAppId();
        if (CollectionUtils.isNotEmpty((Collection)appIds)) {
            for (String appId : appIds) {
                ThreadTools.getMixTaskThreadPool().submit(() -> {
                    try {
                        this.run(appId);
                    }
                    catch (Exception e) {
                        log.info("run with error", (Throwable)e);
                    }
                });
            }
        }
    }

    public void run(String appId) {
        Date fromDate = DateUtils.addDays((Date)new Date(), (int)-90);
        AtomicInteger count = new AtomicInteger(0);
        AtomicInteger updateCount = new AtomicInteger(0);
        int start = 0;
        int pageSize = 40;
        boolean ifContinue = false;
        do {
            List orderFlows;
            if (CollectionUtils.isNotEmpty((Collection)(orderFlows = this.shopOrderFlowMapper.queryNotFinishedWithStatus(appId, fromDate, this.getNeedUpdateStatus(), start, pageSize)))) {
                count.getAndAdd(orderFlows.size());
                String accessToken = this.accessTokenService.getAccessToken(appId);
                ArrayList needUpdateOrderFlows = Lists.newArrayList();
                for (ShopOrderFlow orderFlow : orderFlows) {
                    this.collectNeedUpdate(appId, accessToken, needUpdateOrderFlows, orderFlow);
                }
                if (CollectionUtils.isNotEmpty((Collection)needUpdateOrderFlows)) {
                    updateCount.getAndAdd(needUpdateOrderFlows.size());
                    this.shopOrderFlowMapper.batchUpdate((Collection)needUpdateOrderFlows);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)orderFlows) && orderFlows.size() == pageSize) {
                ifContinue = true;
                start += pageSize;
                continue;
            }
            ifContinue = false;
        } while (ifContinue);
        log.info("finish renew orderFlow with appId={}, total check size={}, update size={}", new Object[]{appId, count.get(), updateCount.get()});
    }

    private void collectNeedUpdate(String appId, String accessToken, List<ShopOrderFlow> needUpdateOrderFlows, ShopOrderFlow orderFlow) {
        FundGetOrderFlowReq req = new FundGetOrderFlowReq();
        req.setOrderId(Long.valueOf(orderFlow.getOrderId()));
        for (int i = 0; i < 3; ++i) {
            try {
                FundGetOrderFlowResp orderFlowResp = this.fundAPI.getOrderFlow(accessToken, req);
                OrderFlowDto dto = orderFlowResp.getOrderFlow();
                ShopOrderFlow shopOrderFlow = this.buildOrderFlow(appId, dto, orderFlow);
                if (this.isEquals(orderFlow, shopOrderFlow)) break;
                needUpdateOrderFlows.add(shopOrderFlow);
                break;
            }
            catch (Exception e) {
                log.error("getOrderFlow error, req={}", (Object)e, (Object)req);
                continue;
            }
        }
    }

    private ShopOrderFlow buildOrderFlow(String appId, OrderFlowDto dto, ShopOrderFlow oldFlow) {
        ShopOrderFlow newOrderFlow = new ShopOrderFlow();
        newOrderFlow.setStatus(Integer.valueOf(OrderFlowStatus.getByName(dto.getStatus()).getStatus()));
        newOrderFlow.setSettledTime(dto.getSettledTime() > 0L ? new Date(dto.getSettledTime() * 1000L) : null);
        newOrderFlow.setRefundingType(dto.getRefundingType());
        newOrderFlow.setServiceFee(dto.getServiceFee());
        newOrderFlow.setOrderTime(new Date(dto.getOrderTime() * 1000L));
        newOrderFlow.setOrderPrice(dto.getOrderPrice());
        newOrderFlow.setPrice(dto.getPrice());
        newOrderFlow.setOrderId(String.valueOf(dto.getOrderId()));
        newOrderFlow.setRefundFee(dto.getRefundFee());
        newOrderFlow.setHandlingFee(dto.getHandlingFee());
        newOrderFlow.setDiscountFee(dto.getDiscountFee());
        newOrderFlow.setAppId(appId);
        newOrderFlow.setId(oldFlow.getId());
        return newOrderFlow;
    }

    private boolean isEquals(ShopOrderFlow oldItem, ShopOrderFlow newItem) {
        if (!Objects.equals(oldItem.getDiscountFee(), newItem.getDiscountFee())) {
            return false;
        }
        if (!Objects.equals(oldItem.getHandlingFee(), newItem.getHandlingFee())) {
            return false;
        }
        if (!Objects.equals(oldItem.getRefundFee(), newItem.getRefundFee())) {
            return false;
        }
        if (!Objects.equals(oldItem.getPrice(), newItem.getPrice())) {
            return false;
        }
        if (!Objects.equals(oldItem.getOrderPrice(), newItem.getOrderPrice())) {
            return false;
        }
        if (!Objects.equals(oldItem.getOrderTime(), newItem.getOrderTime())) {
            return false;
        }
        if (!Objects.equals(oldItem.getServiceFee(), newItem.getServiceFee())) {
            return false;
        }
        if (!Objects.equals(oldItem.getRefundingType(), newItem.getRefundingType())) {
            return false;
        }
        if (!Objects.equals(oldItem.getSettledTime(), newItem.getSettledTime())) {
            return false;
        }
        return Objects.equals(oldItem.getStatus(), newItem.getStatus());
    }
}

