/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.datasync;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopFundAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.fund.OrderFlowDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.FundGetOrderFlowListReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.FundGetOrderFlowListResp;
import com.google.common.collect.Lists;
import com.kuaike.scrm.applet.dto.PullResult;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.applet.service.shopdatasync.AbstractPullService;
import com.kuaike.scrm.dal.shop.entity.ShopOrderFlow;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderFlowMapper;
import com.kuaike.scrm.shop.enums.OrderFlowStatus;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class FundFlowPullService
extends AbstractPullService {
    private static final Logger log = LoggerFactory.getLogger(FundFlowPullService.class);
    private static final String ORDER_FLOW_TOTAL_NUM_KEY = "orderFlowCreateTotalNum";
    private static final String ORDER_FLOW_LAST_TIME_KEY = "orderFlowLastTimeKey";
    @Autowired
    WxShopFundAPI wxShopFundAPI;
    @Autowired
    AppletAccessTokenService appletAccessTokenService;
    @Resource
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private ShopOrderFlowMapper orderFlowMapper;

    public String getKey() {
        return "orderFlowCreate";
    }

    public String getStartTime(String appId) {
        return null;
    }

    public int getTotalNum(String appId) {
        String value = (String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)ORDER_FLOW_TOTAL_NUM_KEY);
        return StringUtils.isNotBlank((CharSequence)value) ? Integer.valueOf(value) : 0;
    }

    public void saveTotalNum(String appId, int newTotalNum) {
        this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)ORDER_FLOW_TOTAL_NUM_KEY, (Object)String.valueOf(newTotalNum));
    }

    public int getPageSize() {
        return 50;
    }

    public PullResult doPull(String appId, String startTime, String endTime, int page, int pageSize) {
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        FundGetOrderFlowListReq req = this.buildReq(page, pageSize);
        FundGetOrderFlowListResp fundGetOrderFlowListResp = this.wxShopFundAPI.getOrderFlowList(accessToken, req);
        PullResult pullResult = new PullResult();
        pullResult.setResultList(fundGetOrderFlowListResp.getOrderFlow());
        pullResult.setTotalNum(Integer.valueOf(fundGetOrderFlowListResp.getTotalNum().intValue()));
        this.saveLastPullTime(appId);
        return pullResult;
    }

    private void saveLastPullTime(String appId) {
        this.stringRedisTemplate.opsForHash().put((Object)appId, (Object)ORDER_FLOW_LAST_TIME_KEY, (Object)String.valueOf(System.currentTimeMillis()));
    }

    public Long getLastPullTime(String appId) {
        return Long.valueOf((String)this.stringRedisTemplate.opsForHash().get((Object)appId, (Object)ORDER_FLOW_LAST_TIME_KEY));
    }

    private FundGetOrderFlowListReq buildReq(int page, int pageSize) {
        FundGetOrderFlowListReq req = new FundGetOrderFlowListReq();
        req.setPageNum(Integer.valueOf(page));
        req.setPageSize(Integer.valueOf(pageSize));
        return req;
    }

    protected void save(String appId, PullResult result) {
        super.save(appId, result);
        ArrayList orderIds = Lists.newArrayList();
        ArrayList orderFlowDtos = Lists.newArrayList();
        for (Object item : result.getResultList()) {
            OrderFlowDto dto = (OrderFlowDto)item;
            orderIds.add(dto.getOrderId());
            orderFlowDtos.add(dto);
        }
        this.checkExistInDbAndInsert(appId, orderIds, orderFlowDtos);
    }

    private List<OrderFlowDto> checkExistInDbAndInsert(String appId, List<Long> orderIds, List<OrderFlowDto> orderFlowDtos) {
        Set existsOrderIds = this.orderFlowMapper.existsOrderIds(appId, orderIds);
        List<OrderFlowDto> newOrderFlowList = orderFlowDtos.stream().filter(a -> !existsOrderIds.contains(a.getOrderId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(newOrderFlowList)) {
            List<ShopOrderFlow> list = this.convertToShopOrderFlow(appId, newOrderFlowList);
            this.orderFlowMapper.batchInsert(list);
        }
        return newOrderFlowList;
    }

    private List<ShopOrderFlow> convertToShopOrderFlow(String appId, List<OrderFlowDto> spuItemDtos) {
        ArrayList list = Lists.newArrayList();
        for (OrderFlowDto dto : spuItemDtos) {
            ShopOrderFlow item = new ShopOrderFlow();
            item.setCreateBy(Long.valueOf(-1L));
            item.setCreateTime(new Date());
            item.setOrderId(String.valueOf(dto.getOrderId()));
            item.setAppId(appId);
            item.setUpdateBy(Long.valueOf(-1L));
            item.setIsDeleted(Integer.valueOf(0));
            item.setOrderPrice(dto.getOrderPrice());
            item.setOrderTime(new Date(dto.getOrderTime() * 1000L));
            item.setServiceFee(dto.getServiceFee());
            item.setDiscountFee(dto.getDiscountFee());
            item.setHandlingFee(dto.getHandlingFee());
            item.setPrice(dto.getPrice());
            item.setRefundFee(dto.getRefundFee());
            item.setRefundingType(dto.getRefundingType());
            item.setSettledTime(dto.getSettledTime() <= 0L ? null : new Date(dto.getSettledTime() * 1000L));
            item.setStatus(Integer.valueOf(OrderFlowStatus.valueOf(dto.getStatus()).getStatus()));
            item.setUpdateBy(Long.valueOf(-1L));
            list.add(item);
        }
        return list;
    }
}

