/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WxShopAfterSaleReason {
    INCORRECT_SELECTION(1, "\u62cd\u9519/\u591a\u62cd", "INCORRECT_SELECTION"),
    NO_LONGER_WANT(2, "\u4e0d\u60f3\u8981\u4e86", "NO_LONGER_WANT"),
    NO_EXPRESS_INFO(3, "\u65e0\u5feb\u9012\u4fe1\u606f", "NO_EXPRESS_INFO"),
    EMPTY_PACKAGE(4, "\u5305\u88f9\u4e3a\u7a7a", "EMPTY_PACKAGE"),
    REJECT_RECEIVE_PACKAGE(5, "\u5df2\u62d2\u7b7e\u5305\u88f9", "REJECT_RECEIVE_PACKAGE"),
    NOT_DELIVERED_TOO_LONG(6, "\u5feb\u9012\u957f\u65f6\u95f4\u672a\u9001\u8fbe", "NOT_DELIVERED_TOO_LONG"),
    NOT_MATCH_PRODUCT_DESC(7, "\u4e0e\u5546\u54c1\u63cf\u8ff0\u4e0d\u7b26", "NOT_MATCH_PRODUCT_DESC"),
    QUALITY_ISSUE(8, "\u8d28\u91cf\u95ee\u9898", "QUALITY_ISSUE"),
    SEND_WRONG_GOODS(9, "\u5356\u5bb6\u53d1\u9519\u8d27", "SEND_WRONG_GOODS"),
    THREE_NO_PRODUCT(10, "\u4e09\u65e0\u4ea7\u54c1", "THREE_NO_PRODUCT"),
    FAKE_PRODUCT(11, "\u5047\u5192\u4ea7\u54c1", "FAKE_PRODUCT"),
    OTHERS(12, "\u5176\u5b83", "OTHERS");

    private Integer type;
    private String reason;
    private String enReason;
    private static Map<Integer, WxShopAfterSaleReason> map;
    private static Map<String, WxShopAfterSaleReason> enReasonMap;

    private WxShopAfterSaleReason(Integer type, String reason, String enReason) {
        this.type = type;
        this.reason = reason;
        this.enReason = enReason;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public static String getReasonByType(int type) {
        return map.containsKey(type) ? map.get(type).getReason() : null;
    }

    public static WxShopAfterSaleReason getByEnReason(String enReason) {
        return enReasonMap.getOrDefault(enReason, null);
    }

    public Integer getType() {
        return this.type;
    }

    public String getReason() {
        return this.reason;
    }

    public String getEnReason() {
        return this.enReason;
    }

    static {
        map = Maps.newHashMap();
        enReasonMap = Maps.newHashMap();
        for (WxShopAfterSaleReason reason : WxShopAfterSaleReason.values()) {
            map.put(reason.type, reason);
            enReasonMap.put(reason.getEnReason(), reason);
        }
    }
}

