/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopUtilAPI;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CategoryItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PicFile;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.CategoryResp;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.UploadImgResp;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.dal.shop.entity.ShopUploadImg;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopUploadImgMapper;
import com.kuaike.scrm.shop.service.ShopCommonService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ShopCommonServiceImpl
implements ShopCommonService {
    private static final Logger log = LoggerFactory.getLogger(ShopCommonServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private ShopUploadImgMapper shopUploadImgMapper;
    @Autowired
    private WxShopUtilAPI wxShopUtilAPI;
    @Autowired
    private AppletAccessTokenService appletAccessTokenService;
    @Autowired
    private ComponentTokenService componentTokenService;
    @Autowired
    private AppletInfoMapper appletInfoMapper;
    @Value(value="${wx.component.appid}")
    private String componentAppId;

    @Override
    public void scanAndUpload() {
        log.info("scanAndUpload start");
        long startTime = System.currentTimeMillis();
        List shopUploadImgList = this.shopUploadImgMapper.queryNotConvert();
        int convertCount = 0;
        for (ShopUploadImg shopUploadImg : shopUploadImgList) {
            try {
                this.saveUploadImg(shopUploadImg.getAppId(), shopUploadImg.getImgUrl(), shopUploadImg.getCreateBy(), true, true);
                ++convertCount;
            }
            catch (Exception e) {
                log.error("saveUploadImg with error", (Throwable)e);
            }
        }
        long wasteTime = System.currentTimeMillis() - startTime;
        log.info("scanAndUpload end, scan count={},convert count={},waste time={}", new Object[]{shopUploadImgList.size(), convertCount, wasteTime});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadImgResp saveUploadImg(String appId, String imgUrl, Long operatorId, boolean forever, boolean generateMediaId) throws IOException {
        log.info("saveUploadImg with appId={}, imgUrl={}, operatorId={}, forever={}, generateMediaId={}", new Object[]{appId, imgUrl, operatorId, forever, generateMediaId});
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)imgUrl), (Object)"imgUrl\u4e0d\u80fd\u4e3a\u7a7a");
        ShopUploadImg shopUploadImg = null;
        if (forever) {
            String key;
            String fileKey = this.calFileKey(imgUrl);
            String string = key = appId + "$$" + fileKey;
            synchronized (string) {
                shopUploadImg = this.shopUploadImgMapper.queryByAppIdAndFileKey(appId, fileKey);
                if (Objects.nonNull(shopUploadImg)) {
                    UploadImgResp resp = new UploadImgResp();
                    if (StringUtils.isNotBlank((CharSequence)shopUploadImg.getMediaId())) {
                        PicFile picFile = new PicFile();
                        picFile.setMediaId(shopUploadImg.getMediaId());
                        picFile.setPayMediaId(shopUploadImg.getPayMediaId());
                        resp.setPicFile(picFile);
                    } else {
                        PicFile picFile = new PicFile();
                        picFile.setTempImgUrl(shopUploadImg.getTempImgUrl());
                        resp.setPicFile(picFile);
                    }
                    return resp;
                }
                shopUploadImg = this.insertIntoShopUploadImg(appId, imgUrl, operatorId, fileKey);
            }
        }
        if (generateMediaId) {
            String accessToken = this.componentAppId.equals(appId) ? this.componentTokenService.getComponentAccessToken() : this.appletAccessTokenService.getAccessToken(appId);
            int respType = forever ? 0 : 1;
            UploadImgResp uploadImg = this.wxShopUtilAPI.uploadImg(accessToken, Integer.valueOf(1), Integer.valueOf(respType), imgUrl, null);
            if (Objects.nonNull(uploadImg) && forever) {
                shopUploadImg.setMediaId(uploadImg.getPicFile().getMediaId().toString());
                shopUploadImg.setPayMediaId(uploadImg.getPicFile().getPayMediaId());
                shopUploadImg.setIsSuccess(Integer.valueOf(1));
                this.shopUploadImgMapper.updateByPrimaryKey((Object)shopUploadImg);
            }
            return uploadImg;
        }
        return null;
    }

    private ShopUploadImg insertIntoShopUploadImg(String appId, String imgUrl, Long operatorId, String fileKey) {
        ShopUploadImg shopUploadImg = new ShopUploadImg();
        shopUploadImg.setFileKey(fileKey);
        shopUploadImg.setImgUrl(imgUrl);
        shopUploadImg.setAppId(appId);
        shopUploadImg.setIsDeleted(Integer.valueOf(0));
        shopUploadImg.setNum(this.idGen.getNum());
        shopUploadImg.setCreateBy(operatorId);
        shopUploadImg.setCreateTime(new Date());
        this.shopUploadImgMapper.insertSelective((Object)shopUploadImg);
        return shopUploadImg;
    }

    private String calFileKey(String imgUrl) throws IOException {
        String fileKey;
        File tempFile = null;
        try {
            URL url = new URL(imgUrl);
            String tempFilePath = FileUtils.getTempDirectoryPath() + UUID.randomUUID();
            tempFile = new File(tempFilePath);
            FileUtils.copyURLToFile((URL)url, (File)new File(tempFilePath));
            try (FileInputStream inputStream = new FileInputStream(tempFile);){
                fileKey = DigestUtils.sha512Hex((InputStream)inputStream);
            }
        }
        catch (Exception e) {
            log.error("read file from url={} with error", (Object)imgUrl, (Object)e);
            throw e;
        }
        finally {
            if (tempFile != null && tempFile.exists()) {
                FileUtils.deleteQuietly((File)tempFile);
            }
        }
        return fileKey;
    }

    @Override
    public List<CategoryItem> category(String appId, Long catId) {
        Preconditions.checkArgument((boolean)Objects.nonNull(appId), (Object)"appId \u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((Objects.nonNull(catId) && catId >= 0L ? 1 : 0) != 0, (Object)"catId \u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u53d6\u503c\u5927\u4e8e\u7b49\u4e8e0");
        String accessToken = this.appletAccessTokenService.getAccessToken(appId);
        CategoryResp categoryResp = this.wxShopUtilAPI.getCategory(accessToken, catId);
        return categoryResp.getCatList();
    }
}

