/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopAddressAPI;
import cn.kinyun.scrm.weixin.sdk.api.shop.WxShopAfterSaleAPI;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.AttrItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderDetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PriceInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ProductInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressItemDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AddressGetReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleAcceptApplyReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.req.AfterSaleRejectRefundReq;
import cn.kinyun.scrm.weixin.sdk.entity.shop.resp.AddressGetResp;
import com.alibaba.excel.EasyExcel;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.applet.service.AppletAccessTokenService;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.shop.dto.aftersale.AfterSaleListQueryParams;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.entity.ShopOrderAftersale;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderAftersaleMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.dal.shop.mapper.ShopSkuMapper;
import com.kuaike.scrm.shop.dto.OrderEsModel;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleChangeApplyDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleDetailReqDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleDetailRespDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleExportRespDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleInfoDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleListReqDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleListRespDto;
import com.kuaike.scrm.shop.dto.aftersale.AfterSaleOrderInfoDto;
import com.kuaike.scrm.shop.dto.aftersale.StatisticsCountByStatusRespDto;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleReason;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleStatus;
import com.kuaike.scrm.shop.enums.WxShopAfterSaleType;
import com.kuaike.scrm.shop.service.OrderEsService;
import com.kuaike.scrm.shop.service.ShopAfterSaleService;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ShopAfterSaleServiceImpl
implements ShopAfterSaleService {
    private static final Logger log = LoggerFactory.getLogger(ShopAfterSaleServiceImpl.class);
    @Resource
    private ShopOrderAftersaleMapper shopOrderAfterSaleMapper;
    @Resource
    private ShopOrderMapper shopOrderMapper;
    @Resource
    private ShopSkuMapper shopSkuMapper;
    @Resource
    private WxShopAfterSaleAPI wxShopAfterSaleAPI;
    @Resource
    private WxShopAddressAPI wxShopAddressAPI;
    @Resource
    private AppletAccessTokenService appletAccessTokenService;
    @Resource
    private OrderEsService orderEsService;

    @Override
    public StatisticsCountByStatusRespDto statisticsCountByStatus() {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        StatisticsCountByStatusRespDto respDto = new StatisticsCountByStatusRespDto();
        int waitCount = this.shopOrderAfterSaleMapper.selectCountByBizIdInStatus(userInfo.getBizId(), Collections.singletonList(WxShopAfterSaleStatus.MERCHANT_PROCESSING.getStatus()));
        respDto.setWaitCount(waitCount);
        int waitReceiveCount = this.shopOrderAfterSaleMapper.selectCountByBizIdInStatus(userInfo.getBizId(), Collections.singletonList(WxShopAfterSaleStatus.MERCHANT_WAIT_RECEIPT.getStatus()));
        respDto.setWaitReceiveCount(waitReceiveCount);
        int refundFailCount = this.shopOrderAfterSaleMapper.selectCountByBizIdInStatus(userInfo.getBizId(), Collections.singletonList(WxShopAfterSaleStatus.PLATFORM_REFUND_FAIL.getStatus()));
        respDto.setRefundFailCount(refundFailCount);
        int overdueRefundCount = this.shopOrderAfterSaleMapper.selectCountByBizIdInStatus(userInfo.getBizId(), Collections.singletonList(WxShopAfterSaleStatus.MERCHANT_OVERDUE_REFUND.getStatus()));
        respDto.setOverdueRefundCount(overdueRefundCount);
        return respDto;
    }

    @Override
    public List<AfterSaleListRespDto> list(AfterSaleListReqDto dto) {
        List orderAfterSales;
        log.info("list,dto:{}", (Object)dto);
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        if (dto == null) {
            return Lists.newArrayList();
        }
        dto.validate();
        int afterSaleType = dto.getAfterSaleType() != null ? dto.getAfterSaleType() : 0;
        int afterSaleReason = dto.getAfterSaleReason() != null ? dto.getAfterSaleReason() : 0;
        int afterSaleStatus = dto.getAfterSaleStatus() != null ? dto.getAfterSaleStatus() : 0;
        AfterSaleListQueryParams params = new AfterSaleListQueryParams();
        params.setBizId(userInfo.getBizId());
        params.setPageDto(dto.getPageDto());
        params.setAfterSaleType(Integer.valueOf(afterSaleType));
        params.setAfterSaleReason(Integer.valueOf(afterSaleReason));
        params.setAfterSaleStatus(Integer.valueOf(afterSaleStatus));
        if (dto.getPageDto() != null) {
            int total = this.shopOrderAfterSaleMapper.selectListTotalByParams(params);
            dto.getPageDto().setCount(Integer.valueOf(total));
        }
        if (CollectionUtils.isEmpty((Collection)(orderAfterSales = this.shopOrderAfterSaleMapper.selectListByParams(params)))) {
            return Lists.newArrayList();
        }
        HashMap<String, OrderEsModel> orderIdAndEsModelMap = new HashMap<String, OrderEsModel>(orderAfterSales.size());
        int size = 20;
        List orderIds = orderAfterSales.stream().map(ShopOrderAftersale::getOriginalOrderId).collect(Collectors.toList());
        List partition = Lists.partition(orderIds, (int)size);
        for (int i = 0; i < partition.size(); ++i) {
            List partOrderIds = (List)partition.get(i);
            orderIdAndEsModelMap.putAll(this.orderEsService.queryOrderByOrderIds(partOrderIds, i * size, size));
        }
        ArrayList<AfterSaleListRespDto> list = new ArrayList<AfterSaleListRespDto>(orderAfterSales.size());
        HashMap<String, Map> orderIdAndProductInfoMap = new HashMap<String, Map>();
        for (ShopOrderAftersale afterSale : orderAfterSales) {
            ProductInfo productInfo;
            Map skuIdAndProductInfoMap;
            AfterSaleListRespDto respDto = new AfterSaleListRespDto();
            respDto.setAfterSaleOrderId(afterSale.getAftersaleOrderId());
            respDto.setAfterSaleStatus(afterSale.getStatus());
            respDto.setProductCount(afterSale.getSkuCount());
            respDto.setAfterSaleType(afterSale.getType());
            respDto.setAfterSaleReason(afterSale.getReason());
            respDto.setRefundAmount(afterSale.getRefundAmount());
            OrderEsModel orderEsModel = (OrderEsModel)orderIdAndEsModelMap.get(afterSale.getOriginalOrderId());
            if (orderEsModel == null) continue;
            if (orderIdAndProductInfoMap.containsKey(afterSale.getOriginalOrderId())) {
                skuIdAndProductInfoMap = (Map)orderIdAndProductInfoMap.get(afterSale.getOriginalOrderId());
            } else {
                skuIdAndProductInfoMap = this.buildSkuIdAndProductInfo(orderEsModel);
                orderIdAndProductInfoMap.put(afterSale.getOriginalOrderId(), skuIdAndProductInfoMap);
            }
            if (skuIdAndProductInfoMap.size() > 0 && (productInfo = (ProductInfo)skuIdAndProductInfoMap.get(afterSale.getSkuId())) != null) {
                respDto.setProductName(productInfo.getTitle());
                respDto.setProductAttrs(productInfo.getSkuAttrs());
                respDto.setProductFirstImg(productInfo.getThumbImg());
            }
            OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
            List productInfos = orderDetail.getProductInfos();
            for (ProductInfo productInfo2 : productInfos) {
                if (!afterSale.getProductId().equals(productInfo2.getProductId())) continue;
                respDto.setProductPrice(productInfo2.getSalePrice());
            }
            PriceInfoDto priceInfoDto = orderDetail.getPriceInfo();
            if (priceInfoDto != null) {
                respDto.setChangeDownPrice(priceInfoDto.getChangeDownPrice());
                respDto.setDiscountedPrice(priceInfoDto.getDiscountedPrice());
            }
            list.add(respDto);
        }
        return list;
    }

    @Override
    public AfterSaleDetailRespDto detail(AfterSaleDetailReqDto dto) {
        ProductInfo productInfo;
        log.info("detail,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopOrderAftersale detail = new ShopOrderAftersale();
        detail.setAftersaleOrderId(dto.getAfterSaleOrderId());
        ShopOrderAftersale shopOrderAftersale = (ShopOrderAftersale)this.shopOrderAfterSaleMapper.selectOne((Object)detail);
        Preconditions.checkArgument((shopOrderAftersale != null ? 1 : 0) != 0, (Object)"\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        AfterSaleDetailRespDto respDto = new AfterSaleDetailRespDto();
        AfterSaleInfoDto afterSaleInfo = new AfterSaleInfoDto();
        afterSaleInfo.setAfterSaleOrderId(shopOrderAftersale.getAftersaleOrderId());
        afterSaleInfo.setAfterSaleStatus(shopOrderAftersale.getStatus());
        afterSaleInfo.setRefundAmount(shopOrderAftersale.getRefundAmount());
        OrderEsModel esModel = this.getOrderEsModelByOrderId(String.valueOf(shopOrderAftersale.getOriginalOrderId()));
        Map<String, ProductInfo> productInfoMap = this.buildSkuIdAndProductInfo(esModel);
        if (productInfoMap.size() > 0 && (productInfo = productInfoMap.get(shopOrderAftersale.getSkuId())) != null) {
            afterSaleInfo.setProductName(productInfo.getTitle());
            afterSaleInfo.setProductAttrs(productInfo.getSkuAttrs());
            afterSaleInfo.setProductFirstImg(productInfo.getThumbImg());
        }
        afterSaleInfo.setAfterSaleReason(shopOrderAftersale.getReason());
        afterSaleInfo.setCreateTime(com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)shopOrderAftersale.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        respDto.setAfterSaleInfo(afterSaleInfo);
        AfterSaleOrderInfoDto afterSaleOrderInfoDto = new AfterSaleOrderInfoDto();
        ShopOrder select = new ShopOrder();
        select.setOrderId(shopOrderAftersale.getOriginalOrderId());
        ShopOrder shopOrder = (ShopOrder)this.shopOrderMapper.selectOne((Object)select);
        if (shopOrder != null) {
            afterSaleInfo.setOrderAmount(shopOrder.getOrderPrice());
            AddressInfo addressInfo = (AddressInfo)JSON.parseObject((String)shopOrder.getAddressinfo(), AddressInfo.class);
            afterSaleInfo.setAddressUserName(addressInfo.getUserName());
            afterSaleInfo.setAddressTelNumber(shopOrderAftersale.getTelNumber());
            afterSaleOrderInfoDto.setOrderStatus(shopOrder.getStatus());
            afterSaleOrderInfoDto.setOrderId(shopOrder.getOrderId());
            afterSaleOrderInfoDto.setPayMethod(shopOrder.getPayMethod());
            afterSaleOrderInfoDto.setPayTime(com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)shopOrder.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            afterSaleOrderInfoDto.setCreateTime(com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)shopOrder.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            afterSaleOrderInfoDto.setTransactionId(shopOrder.getTransactionId());
        }
        respDto.setOrderInfo(afterSaleOrderInfoDto);
        return respDto;
    }

    private Map<String, ProductInfo> buildSkuIdAndProductInfo(OrderEsModel orderEsModel) {
        HashMap<String, ProductInfo> map = new HashMap<String, ProductInfo>();
        if (orderEsModel == null) {
            return map;
        }
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        List productInfos = orderDetail.getProductInfos();
        for (ProductInfo productInfo : productInfos) {
            map.put(String.valueOf(productInfo.getSkuId()), productInfo);
        }
        return map;
    }

    private OrderEsModel getOrderEsModelByOrderId(String orderId) {
        return this.orderEsService.queryOrderByOrderId(orderId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeApply(AfterSaleChangeApplyDto dto) {
        log.info("changeApply,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ShopOrderAftersale detail = new ShopOrderAftersale();
        detail.setAftersaleOrderId(dto.getAfterSaleOrderId());
        ShopOrderAftersale shopOrderAftersale = (ShopOrderAftersale)this.shopOrderAfterSaleMapper.selectOne((Object)detail);
        Preconditions.checkArgument((shopOrderAftersale != null ? 1 : 0) != 0, (Object)"\u552e\u540e\u5355\u4e0d\u5b58\u5728");
        ShopOrderAftersale updateStatus = new ShopOrderAftersale();
        updateStatus.setId(shopOrderAftersale.getId());
        if (dto.getType() == 1) {
            ErrorCode errorCode;
            AddressGetResp address;
            try {
                address = this.wxShopAddressAPI.getAddress(this.appletAccessTokenService.getAccessToken(shopOrderAftersale.getAppId()), new AddressGetReq());
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u5fae\u4fe1\u83b7\u53d6\u5546\u5bb6\u5730\u5740\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6536\u8d27\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            Preconditions.checkArgument((address != null && CollectionUtils.isNotEmpty((Collection)address.getAddressList()) ? 1 : 0) != 0, (Object)"\u6536\u8d27\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            AfterSaleAcceptApplyReq req = new AfterSaleAcceptApplyReq();
            req.setOrderId(Long.valueOf(shopOrderAftersale.getAftersaleOrderId()));
            req.setAddressId(((AddressItemDto)address.getAddressList().get(0)).getAddressId());
            try {
                errorCode = this.wxShopAfterSaleAPI.acceptApply(this.appletAccessTokenService.getAccessToken(shopOrderAftersale.getAppId()), req);
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u5fae\u4fe1\u540c\u610f\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38,req={}", (Object)req, (Object)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            if (errorCode.getErrCode() != 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
            }
            if (WxShopAfterSaleType.REFUND.getType().equals(shopOrderAftersale.getType())) {
                updateStatus.setStatus(WxShopAfterSaleStatus.PLATFORM_REFUNDING.getStatus());
            } else if (WxShopAfterSaleType.RETURN.getType().equals(shopOrderAftersale.getType())) {
                updateStatus.setStatus(WxShopAfterSaleStatus.USER_WAIT_RETURN.getStatus());
            }
        } else {
            AfterSaleRejectRefundReq req = new AfterSaleRejectRefundReq();
            req.setOrderId(Long.valueOf(dto.getAfterSaleOrderId()));
            req.setRejectReason(dto.getRejectReason());
            ErrorCode errorCode = null;
            try {
                errorCode = this.wxShopAfterSaleAPI.rejectRefund(this.appletAccessTokenService.getAccessToken(shopOrderAftersale.getAppId()), req);
            }
            catch (Exception e) {
                log.error("\u8bf7\u6c42\u5fae\u4fe1\u62d2\u7edd\u9000\u6b3e\u63a5\u53e3\u5f02\u5e38,req={}", (Object)req, (Object)e);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
            }
            if (errorCode.getErrCode() != 0) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, errorCode.getErrMsg());
            }
            if (WxShopAfterSaleType.REFUND.getType().equals(shopOrderAftersale.getType())) {
                updateStatus.setStatus(WxShopAfterSaleStatus.MERCHANT_REJECT_REFUND.getStatus());
            } else if (WxShopAfterSaleType.RETURN.getType().equals(shopOrderAftersale.getType())) {
                updateStatus.setStatus(WxShopAfterSaleStatus.MERCHANT_REJECT_RETURN.getStatus());
            }
        }
        updateStatus.setUpdateBy(userInfo.getId());
        log.info("\u66f4\u65b0\u552e\u540e\u5355\u72b6\u6001,shopOrderAftersaleId:{},status:{}", (Object)updateStatus.getId(), (Object)updateStatus.getStatus());
        this.shopOrderAfterSaleMapper.updateByPrimaryKeySelective((Object)updateStatus);
    }

    @Override
    public void export(HttpServletResponse response, AfterSaleListReqDto dto) {
        log.info("export,dto:{}", (Object)dto);
        dto.validate();
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((userInfo != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        int afterSaleType = dto.getAfterSaleType() != null ? dto.getAfterSaleType() : 0;
        int afterSaleReason = dto.getAfterSaleReason() != null ? dto.getAfterSaleReason() : 0;
        int afterSaleStatus = dto.getAfterSaleStatus() != null ? dto.getAfterSaleStatus() : 0;
        AfterSaleListQueryParams params = new AfterSaleListQueryParams();
        params.setPageDto(dto.getPageDto());
        params.setAfterSaleType(Integer.valueOf(afterSaleType));
        params.setAfterSaleReason(Integer.valueOf(afterSaleReason));
        params.setAfterSaleStatus(Integer.valueOf(afterSaleStatus));
        params.setBizId(userInfo.getBizId());
        DateTime now = DateUtil.date();
        DateTime farDate = DateUtil.offsetDay((Date)now, (int)-365);
        params.setStartCreateTime(DateUtil.formatDateTime((Date)farDate));
        params.setEndCreateTime(DateUtil.formatDateTime((Date)now));
        List orderAfterSales = this.shopOrderAfterSaleMapper.selectListByParams(params);
        ArrayList<AfterSaleExportRespDto> respDtoList = new ArrayList<AfterSaleExportRespDto>(orderAfterSales.size());
        if (CollectionUtils.isNotEmpty((Collection)orderAfterSales)) {
            HashMap<String, OrderEsModel> orderIdAndEsModelMap = new HashMap<String, OrderEsModel>(orderAfterSales.size());
            int size = 20;
            List orderIds = orderAfterSales.stream().map(ShopOrderAftersale::getOriginalOrderId).collect(Collectors.toList());
            List partition = Lists.partition(orderIds, (int)size);
            for (int i = 0; i < partition.size(); ++i) {
                List partOrderIds = (List)partition.get(i);
                orderIdAndEsModelMap.putAll(this.orderEsService.queryOrderByOrderIds(partOrderIds, i * size, size));
            }
            for (ShopOrderAftersale afterSale : orderAfterSales) {
                AfterSaleExportRespDto respDto = new AfterSaleExportRespDto();
                respDto.setAfterSaleOrderId(String.valueOf(afterSale.getAftersaleOrderId()));
                respDto.setCreateTime(com.kuaike.scrm.common.utils.DateUtil.dateToDateString((Date)afterSale.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                respDto.setSkuCount(afterSale.getSkuCount());
                respDto.setRefundType(WxShopAfterSaleType.getDescByType(afterSale.getType()));
                respDto.setRefundReason(WxShopAfterSaleReason.getReasonByType(afterSale.getReason()));
                respDto.setRefundAmount(String.valueOf(afterSale.getRefundAmount().doubleValue() / 100.0));
                respDto.setRefundStatus(WxShopAfterSaleStatus.getDescByStatus(afterSale.getStatus()));
                OrderEsModel orderEsModel = (OrderEsModel)orderIdAndEsModelMap.get(afterSale.getOriginalOrderId());
                if (orderEsModel != null) {
                    respDto.setOrderId(String.valueOf(orderEsModel.getOrderId()));
                    OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
                    PriceInfoDto priceInfo = orderDetail.getPriceInfo();
                    respDto.setProductAmount(String.valueOf(priceInfo.getProductPrice().doubleValue() / 100.0));
                    respDto.setPaidAmount(String.valueOf(priceInfo.getOrderPrice().doubleValue() / 100.0));
                    List productInfos = orderDetail.getProductInfos();
                    for (ProductInfo productInfo : productInfos) {
                        if (!afterSale.getSkuId().equals(productInfo.getSkuId())) continue;
                        respDto.setProductName(productInfo.getTitle());
                        respDto.setProductAttrs(productInfo.getSkuAttrs().stream().map(AttrItem::getAttrValue).collect(Collectors.joining()));
                    }
                }
                respDtoList.add(respDto);
            }
        }
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode("\u552e\u540e\u5bfc\u51fa_" + System.currentTimeMillis() + ".xlsx", "UTF-8");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), AfterSaleExportRespDto.class).sheet("\u552e\u540e\u6570\u636e").doWrite(respDtoList);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u5c0f\u5546\u5e97\u552e\u540e\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
    }
}

