/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.kinyun.crm.common.enums.SourceType;
import cn.kinyun.crm.common.service.CrmLeadsService;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsInfoReq;
import cn.kinyun.crm.common.service.dto.req.CrmLeadsReq;
import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.order.OrderReq;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.enums.OrderSource;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.CouponCodeInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.DeliveryInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ExtInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderDetailDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.OrderItem;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PayInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.PriceInfoDto;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.ProductInfo;
import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.address.AddressInfo;
import cn.kinyun.wework.sdk.utils.JacksonUtils;
import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.scrm.common.enums.SysChannelEnum;
import com.kuaike.scrm.common.enums.SystemTypeEnum;
import com.kuaike.scrm.common.utils.NamedThreadFactory;
import com.kuaike.scrm.common.utils.ThreadPoolMonitorUtils;
import com.kuaike.scrm.dal.biz.entity.BusinessCustomer;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.shop.entity.AppletInfo;
import com.kuaike.scrm.dal.shop.mapper.AppletInfoMapper;
import com.kuaike.scrm.dal.system.mapper.PackageMapper;
import com.kuaike.scrm.shop.dto.OrderEsModel;
import com.kuaike.scrm.shop.dto.SaleStatisticDto;
import com.kuaike.scrm.shop.dto.order.OrderLisQueryParam;
import com.kuaike.scrm.shop.enums.WxShopOrderStatus;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.Header;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetRequestBuilder;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderEsService {
    private static final Logger log = LoggerFactory.getLogger(OrderEsService.class);
    @Value(value="${scrm.elasticsearch.shopOrderIndex}")
    private String shopOrderIndex;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private Client client;
    @Resource
    private AppletInfoMapper appletInfoMapper;
    @Resource
    private CcCustomerNumService ccCustomerNumService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private PackageMapper packageMapper;
    @Resource
    private CrmLeadsService crmLeadsService;
    @Resource
    private CcCustomerDetailService ccCustomerDetailService;
    @Resource
    private CcCustomerOrderService ccCustomerOrderService;
    @Resource
    private CcCustomerEventService ccCustomerEventService;
    @Autowired
    private ChannelMapper channelMapper;
    private static final String TYPE = "doc";
    private static final String SOURCE = "scrm";
    private final ExecutorService orderSaveExecutorService = new ThreadPoolExecutor(2, 4, 10L, TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(1000), (ThreadFactory)new NamedThreadFactory("orderSaveExecutorService"), new ThreadPoolExecutor.CallerRunsPolicy());

    @PostConstruct
    public void init() {
        ThreadPoolMonitorUtils.addToMonitor((ExecutorService)this.orderSaveExecutorService);
    }

    public void updateMerchantNoteByOrderId(String orderId, String merchantNotes) {
        OrderEsModel orderEsModel = this.queryOrderByOrderId(orderId);
        ExtInfo extInfo = orderEsModel.getExtInfo();
        extInfo.setMerchantNotes(merchantNotes);
        UpdateRequest request = new UpdateRequest(this.shopOrderIndex, TYPE, String.valueOf(orderEsModel.getOrderId())).doc(JSON.toJSONString((Object)orderEsModel), XContentType.JSON);
        try {
            this.restHighLevelClient.update(request, new Header[0]);
        }
        catch (IOException e) {
            log.error("es\u4fee\u6539\u5546\u5bb6\u5907\u6ce8\u5f02\u5e38,orderId:{},merchantNotes:{}", new Object[]{orderId, merchantNotes, e});
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
        }
    }

    public Map<String, OrderEsModel> queryOrderByOrderIds(List<String> orderIds, int from, int size) {
        if (CollectionUtils.isEmpty(orderIds)) {
            return null;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"orderId.keyword", orderIds));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.from(from);
        searchSourceBuilder.size(size);
        SearchResponse searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder);
        if (searchResponse == null) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        HashMap<String, OrderEsModel> map = new HashMap<String, OrderEsModel>();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
            map.put(orderEsModel.getOrderId(), orderEsModel);
        });
        return map;
    }

    private SearchResponse queryByQueryBuilder(BoolQueryBuilder queryBuilder, SearchSourceBuilder searchSourceBuilder) {
        SearchResponse searchResponse;
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        return searchResponse;
    }

    public OrderEsModel queryOrderByOrderId(String orderId) {
        SearchSourceBuilder searchSourceBuilder;
        if (StringUtils.isBlank((CharSequence)orderId)) {
            return null;
        }
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"orderId.keyword", (String)orderId));
        SearchResponse searchResponse = this.queryByQueryBuilder(queryBuilder, searchSourceBuilder = new SearchSourceBuilder());
        if (searchResponse == null) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits.length > 0) {
            SearchHit searchHit = searchHits[0];
            String sourceAsString = searchHit.getSourceAsString();
            return (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
        }
        return null;
    }

    public Set<OrderEsModel> existsOrderIds(List<OrderItem> orderList) {
        HashSet<OrderEsModel> result = new HashSet<OrderEsModel>();
        if (CollectionUtils.isEmpty(orderList)) {
            return result;
        }
        MultiGetRequestBuilder multiGetRequestBuilder = this.client.prepareMultiGet();
        for (OrderItem item : orderList) {
            multiGetRequestBuilder.add(new MultiGetRequest.Item(this.shopOrderIndex, TYPE, String.valueOf(item.getOrderId())));
        }
        try {
            MultiGetResponse multiGetResponse = (MultiGetResponse)multiGetRequestBuilder.get();
            for (MultiGetItemResponse response : multiGetResponse) {
                GetResponse itemResponse = response.getResponse();
                if (!Objects.nonNull(itemResponse) || !itemResponse.isExists()) continue;
                String sourceAsString = itemResponse.getSourceAsString();
                try {
                    OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
                    result.add(orderEsModel);
                }
                catch (Exception e) {
                    log.error("\u89e3\u6790json\u5931\u8d25, value={}", (Object)sourceAsString, (Object)e);
                }
            }
        }
        catch (Exception e) {
            log.error("existsOrderIds with error", (Throwable)e);
        }
        return result;
    }

    public void batchInsertOrders(List<OrderItem> orderList, String appId) {
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        AppletInfo appletInfo = this.appletInfoMapper.getByAppId(appId);
        if (appletInfo == null) {
            log.error("\u540c\u6b65\u5c0f\u5546\u5e97\u8ba2\u5355\u5f02\u5e38\uff0c\u901a\u8fc7appId\u83b7\u53d6appletInfo\u4e3a\u7a7a\uff0cappId:{}", (Object)appId);
            return;
        }
        boolean openCrm = this.openCrm(appletInfo.getBizId());
        ArrayList<OrderEsModel> orderEsModels = new ArrayList<OrderEsModel>();
        for (OrderItem orderItem : orderList) {
            log.info("batchInsertOrders current orderItem:{}", (Object)orderItem);
            OrderEsModel orderEsModel = this.orderItemToOrderEsModel(orderItem, appId);
            String customerNum = null;
            try {
                customerNum = this.syncCustomerToCustomerCenter(orderEsModel, appletInfo, openCrm);
                orderEsModel.setCustomerNum(customerNum);
            }
            catch (Exception e) {
                log.error("\u5c0f\u5546\u5e97\u8ba2\u5355 \u5ba2\u6237\u4fe1\u606f \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)orderEsModel.getOrderId(), (Object)e);
            }
            if (customerNum != null) {
                try {
                    this.syncToCustomerByAddOrder(orderItem, customerNum, appletInfo.getBizId());
                }
                catch (Exception e) {
                    log.error("\u5c0f\u5546\u5e97\u8ba2\u5355 \u8ba2\u5355\u4fe1\u606f \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)orderEsModel.getOrderId(), (Object)e);
                }
                try {
                    this.syncToCustomerEvent(orderItem, customerNum, appletInfo.getBizId(), ModuleType.SHOP);
                }
                catch (Exception e) {
                    log.error("\u5c0f\u5546\u5e97\u8ba2\u5355 \u4e0b\u8ba2\u5355\u4e8b\u4ef6 \u540c\u6b65\u5230\u5ba2\u6237\u4e2d\u5fc3\u5f02\u5e38\uff0corderId:{}", (Object)orderEsModel.getOrderId(), (Object)e);
                }
            }
            orderEsModels.add(orderEsModel);
        }
        this.batchWriteOrderAsync(orderEsModels);
    }

    public void syncToCustomerEvent(OrderItem orderItem, String customerNum, Long bizId, ModuleType moduleType) {
        CustomerEventReq req = new CustomerEventReq();
        req.setEventType(EventType.PURCHASE_ORDER.getCode());
        EventData eventData = new EventData();
        EventModule module = new EventModule();
        eventData.setModule(module);
        eventData.setOrderNo(String.valueOf(orderItem.getOrderId()));
        eventData.setOrderType(moduleType.getCode());
        OrderDetailDto orderDetail = orderItem.getOrderDetail();
        if (orderDetail != null) {
            PayInfoDto payInfo;
            ProductInfo productInfo;
            List productInfos;
            PriceInfoDto priceInfo = orderDetail.getPriceInfo();
            if (priceInfo != null) {
                eventData.setOrderAmount(Long.valueOf(priceInfo.getProductPrice() * 100L));
            }
            if (CollectionUtils.isNotEmpty((Collection)(productInfos = orderDetail.getProductInfos())) && (productInfo = (ProductInfo)productInfos.get(0)) != null) {
                module.setProductId(String.valueOf(productInfo.getSkuId()));
                module.setProductName(productInfo.getTitle());
            }
            if ((payInfo = orderDetail.getPayInfo()) != null && StringUtils.isNotBlank((CharSequence)payInfo.getPayTime())) {
                req.setEventType(EventType.PAY_ORDER.getCode());
            }
            String mobile = "";
            CouponCodeInfo couponCodeInfo = orderDetail.getCouponCodeInfo();
            if (couponCodeInfo != null) {
                mobile = couponCodeInfo.getPhoneNumber();
            } else {
                AddressInfo addressInfo;
                DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
                if (deliveryInfoDto != null && (addressInfo = deliveryInfoDto.getAddressInfo()) != null) {
                    mobile = addressInfo.getTelNumber();
                }
            }
            eventData.setMobile(mobile);
        }
        Date now = new Date();
        eventData.setCreateTime(now);
        req.setEventTime(now);
        String createTime = orderItem.getCreateTime();
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            try {
                DateTime orderCreateTime = DateUtil.parse((CharSequence)createTime, (String)"yyyy-MM-dd HH:mm:ss");
                eventData.setCreateTime((Date)orderCreateTime);
                req.setEventTime((Date)orderCreateTime);
            }
            catch (Exception e) {
                log.error("\u5c0f\u5546\u5e97 \u8ba2\u5355\u521b\u5efa\u65f6\u95f4 \u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        module.setType(moduleType.getCode());
        module.setName(moduleType.getDesc());
        req.setBizId(bizId);
        req.setProductLineId("");
        req.setSource(SOURCE);
        req.setUserId(Long.valueOf(-1L));
        req.setWeworkUserNum("");
        req.setCustomerNum(customerNum);
        req.setEventData(eventData);
        log.info("\u5c0f\u5546\u5e97\u8ba2\u5355 \u540c\u6b65\u8ba2\u5355\u4e8b\u4ef6 req:{}", (Object)req);
        this.ccCustomerEventService.add(req);
    }

    private void syncToCustomerByAddOrder(OrderItem orderItem, String customerNum, Long bizId) {
        OrderReq customerOrderReq = new OrderReq();
        customerOrderReq.setBizId(bizId);
        customerOrderReq.setProductLineId("");
        customerOrderReq.setSource(OrderSource.SHOP_ORDER.getValue());
        customerOrderReq.setOrderNo(String.valueOf(orderItem.getOrderId()));
        OrderDetailDto orderDetail = orderItem.getOrderDetail();
        if (orderDetail != null) {
            PayInfoDto payInfo;
            PriceInfoDto priceInfo;
            ProductInfo productInfo;
            List productInfos = orderDetail.getProductInfos();
            if (CollectionUtils.isNotEmpty((Collection)productInfos) && (productInfo = (ProductInfo)productInfos.get(0)) != null) {
                customerOrderReq.setSkuNo(String.valueOf(productInfo.getSkuId()));
                customerOrderReq.setSkuName(productInfo.getTitle());
                customerOrderReq.setSkuImgUrl(productInfo.getThumbImg());
            }
            if ((priceInfo = orderDetail.getPriceInfo()) != null) {
                customerOrderReq.setOrderAmount(Long.valueOf(priceInfo.getProductPrice() * 100L));
            }
            if ((payInfo = orderDetail.getPayInfo()) != null) {
                customerOrderReq.setPayStatus(Integer.valueOf(StringUtils.isNotBlank((CharSequence)payInfo.getPayTime()) ? PayStatusEnum.PAID.getValue() : PayStatusEnum.UNPAID.getValue()));
            }
            customerOrderReq.setPaidAmount(Long.valueOf(0L));
            if (priceInfo != null && priceInfo.getOrderPrice() != null) {
                customerOrderReq.setPaidAmount(Long.valueOf(priceInfo.getOrderPrice() * 100L));
            }
        }
        customerOrderReq.setRefundNo("");
        customerOrderReq.setRefundStatus(Integer.valueOf(RefundStatusEnum.NONE.getValue()));
        customerOrderReq.setRefundAmount(Long.valueOf(0L));
        customerOrderReq.setCreateTime(new Date());
        String createTime = orderItem.getCreateTime();
        if (StringUtils.isNotBlank((CharSequence)createTime)) {
            try {
                DateTime orderCreateTime = DateUtil.parse((CharSequence)createTime, (String)"yyyy-MM-dd HH:mm:ss");
                customerOrderReq.setCreateTime((Date)orderCreateTime);
            }
            catch (Exception e) {
                log.error("\u5c0f\u5546\u5e97 \u8ba2\u5355\u521b\u5efa\u65f6\u95f4 \u683c\u5f0f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            }
        }
        customerOrderReq.setIsDeleted(Integer.valueOf(0));
        customerOrderReq.setCustomerNum(customerNum);
        customerOrderReq.setCustomerNum(customerNum);
        log.info("\u5c0f\u5546\u5e97\u8ba2\u5355\u63d2\u5165es \u540c\u6b65addOrder\u4fe1\u606f\u7ed9\u5ba2\u6237\u4e2d\u5fc3 req:{}", (Object)customerOrderReq);
        this.ccCustomerOrderService.addOrder(customerOrderReq);
    }

    public void batchUpdateByOrderId(List<OrderItem> orderList, String appId) {
        if (CollectionUtils.isEmpty(orderList)) {
            return;
        }
        ArrayList<OrderEsModel> orderEsModels = new ArrayList<OrderEsModel>();
        for (OrderItem orderItem : orderList) {
            OrderEsModel orderEsModel = this.orderItemToOrderEsModel(orderItem, appId);
            orderEsModels.add(orderEsModel);
        }
        this.batchUpdateOrderAsync(orderEsModels);
    }

    public OrderEsModel orderItemToOrderEsModel(OrderItem orderItem, String appId) {
        OrderEsModel orderEsModel = new OrderEsModel();
        orderEsModel.setOrderId(orderItem.getOrderId().toString());
        orderEsModel.setStatus(orderItem.getStatus());
        DateTime createTime = DateUtil.parse((CharSequence)orderItem.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        orderEsModel.setCreateTime(createTime.getTime());
        DateTime updateTime = DateUtil.parse((CharSequence)orderItem.getUpdateTime(), (String)"yyyy-MM-dd HH:mm:ss");
        orderEsModel.setUpdateTime(updateTime.getTime());
        orderEsModel.setOpenId(orderItem.getOpenId());
        orderEsModel.setAppId(appId);
        orderEsModel.setOrderDetail(orderItem.getOrderDetail());
        orderEsModel.setAfterSaleDetail(orderItem.getAfterSaleDetail());
        orderEsModel.setExtInfo(orderItem.getExtInfo());
        log.info("orderItemToOrderEsModel orderEsModel:{}", (Object)orderEsModel);
        return orderEsModel;
    }

    private String syncCustomerToCustomerCenter(OrderEsModel orderEsModel, AppletInfo appletInfo, boolean openCrm) {
        AddressInfo addressInfo;
        Long bizId = appletInfo.getBizId();
        String customerNum = "";
        OrderDetailDto orderDetail = orderEsModel.getOrderDetail();
        String addressMobile = null;
        DeliveryInfoDto deliveryInfoDto = orderDetail.getDeliveryInfoDto();
        if (deliveryInfoDto != null && StringUtils.isNotBlank((CharSequence)(addressMobile = (addressInfo = deliveryInfoDto.getAddressInfo()).getTelNumber()))) {
            log.info("syncToCustomerCenter sync addressMobile,bizId:{},orderId:{},addressMobile:{}", new Object[]{bizId, orderEsModel.getOrderId(), addressMobile});
            customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, addressMobile);
        }
        String rserveMobile = null;
        CouponCodeInfo couponCodeInfo = orderDetail.getCouponCodeInfo();
        if (couponCodeInfo != null && StringUtils.isNotBlank((CharSequence)(rserveMobile = couponCodeInfo.getPhoneNumber()))) {
            log.info("syncToCustomerCenter sync rserveMobile,bizId:{},orderId:{},rserveMobile:{}", new Object[]{bizId, orderEsModel.getOrderId(), rserveMobile});
            customerNum = this.ccCustomerNumService.getCustomerNumByMobile(bizId, rserveMobile);
        }
        log.info("syncToCustomerCenter sync appId and openId,bizId:{},orderId:{},appId:{},openId:{}", new Object[]{bizId, orderEsModel.getOrderId(), orderEsModel.getAppId(), orderEsModel.getOpenId()});
        String customerNumByType = this.ccCustomerNumService.getCustomerNumByType(bizId, 3, orderEsModel.getAppId(), orderEsModel.getOpenId(), null);
        log.info("syncToCustomerCenter sync appId and openId res:{}", (Object)customerNumByType);
        CustomerDetailReq customerDetailReq = new CustomerDetailReq();
        customerDetailReq.setBizId(appletInfo.getBizId());
        customerDetailReq.setCustomerNum(customerNum);
        log.info("syncToCustomerCenter sync customerDetail,orderId:{},customerDetailReq:{}", (Object)orderEsModel.getOrderId(), (Object)customerDetailReq);
        this.ccCustomerDetailService.add(customerDetailReq);
        if (openCrm && (StringUtils.isNotBlank((CharSequence)rserveMobile) || StringUtils.isNotBlank((CharSequence)addressMobile))) {
            CrmLeadsInfoReq crmLeadsInfoReq = new CrmLeadsInfoReq();
            crmLeadsInfoReq.setMobile(StringUtils.isNotBlank((CharSequence)rserveMobile) ? rserveMobile : addressMobile);
            crmLeadsInfoReq.setCorpId(appletInfo.getCorpId());
            boolean exists = this.crmLeadsService.exists(crmLeadsInfoReq);
            if (exists) {
                return customerNum;
            }
            CrmLeadsReq crmLeadsReq = new CrmLeadsReq();
            crmLeadsReq.setCorpId(appletInfo.getCorpId());
            crmLeadsReq.setMobile(StringUtils.isNotBlank((CharSequence)rserveMobile) ? rserveMobile : addressMobile);
            crmLeadsReq.setSourceType(Integer.valueOf(SourceType.SCRM_SYNC.getValue()));
            Long channelId = this.channelMapper.getIdByNum(bizId, SysChannelEnum.ORDER_CENTER.getCode());
            crmLeadsReq.setChannelId(channelId);
            log.info("syncToCustomerCenter sync crm,orderId:{},crmLeadsReq:{}", (Object)orderEsModel.getOrderId(), (Object)crmLeadsReq);
            this.crmLeadsService.addLeads(crmLeadsReq);
        }
        return customerNum;
    }

    private boolean openCrm(Long bizId) {
        BusinessCustomer businessCustomer = (BusinessCustomer)this.businessCustomerMapper.selectByPrimaryKey((Object)bizId);
        log.info("isOpenCrm businessCustomer: {}", (Object)businessCustomer);
        String pkgIdsStr = businessCustomer.getPkgIds();
        if (StringUtils.isBlank((CharSequence)pkgIdsStr)) {
            return false;
        }
        ArrayList pkgIds = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)pkgIdsStr)) {
            for (String s : StringUtils.split((String)pkgIdsStr, (String)",")) {
                try {
                    Long parseLong = Long.parseLong(s);
                    pkgIds.add(parseLong);
                }
                catch (NumberFormatException e) {
                    log.error("unknown package, bizId={}, packageId:{}", (Object)businessCustomer.getId(), (Object)s);
                }
            }
        }
        if (!CollectionUtils.isEmpty((Collection)pkgIds)) {
            List systemIds = this.packageMapper.querySystemIds((List)pkgIds);
            for (Long id : systemIds) {
                if (id.intValue() != SystemTypeEnum.CRM.getValue()) continue;
                return true;
            }
        }
        return false;
    }

    private void batchUpdateOrderAsync(List<OrderEsModel> orderEsModels) {
        if (CollectionUtils.isEmpty(orderEsModels)) {
            return;
        }
        List partition = Lists.partition(orderEsModels, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchUpdateOrder(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.orderSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[0])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("update order error", t);
            }
        })).join();
    }

    public void batchWriteOrderAsync(List<OrderEsModel> orderEsModels) {
        if (CollectionUtils.isEmpty(orderEsModels)) {
            return;
        }
        List partition = Lists.partition(orderEsModels, (int)100);
        ArrayList resultFutureList = Lists.newArrayListWithExpectedSize((int)partition.size());
        for (List list : partition) {
            CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(() -> {
                try {
                    this.batchWriteOrder(list);
                }
                catch (IOException e) {
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR);
                }
            }, this.orderSaveExecutorService);
            resultFutureList.add(completableFuture);
        }
        ((CompletableFuture)CompletableFuture.allOf(resultFutureList.toArray(new CompletableFuture[0])).whenComplete((r, t) -> {
            if (t != null) {
                log.error("store order error", t);
            }
        })).join();
    }

    private void batchUpdateOrder(List<OrderEsModel> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (OrderEsModel model : list) {
            UpdateRequest request = new UpdateRequest(this.shopOrderIndex, TYPE, String.valueOf(model.getOrderId())).doc(JSON.toJSONString((Object)model), XContentType.JSON);
            bulkRequest.add(request);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("update order id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    private void batchWriteOrder(List<OrderEsModel> list) throws IOException {
        BulkRequest bulkRequest = new BulkRequest();
        for (OrderEsModel model : list) {
            IndexRequest indexRequest = new IndexRequest(this.shopOrderIndex, TYPE, String.valueOf(model.getOrderId()));
            try {
                indexRequest.source(JacksonUtils.writeValueAsString((Object)model), XContentType.JSON);
            }
            catch (JsonProcessingException e) {
                log.error("json error:{}", (Object)JSON.toJSONString((Object)model));
                continue;
            }
            bulkRequest.add(indexRequest);
        }
        BulkResponse bulkResponse = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
        log.info("bulk response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            log.info("write order id:{}, error:{}", (Object)response.getId(), (Object)response.getFailureMessage());
        }
    }

    public Map<String, SaleStatisticDto> countStockNumByProductIds(List<String> productIds) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"orderDetail.productInfos.productId", productIds));
        queryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"status", (Collection)Lists.newArrayList((Object[])new Integer[]{WxShopOrderStatus.WAIT_GROUP.getStatus(), WxShopOrderStatus.PAID_WAIT_MERCHANT_TAKE_ORDER.getStatus(), WxShopOrderStatus.PAID_WAIT_WRITE_OFF.getStatus(), WxShopOrderStatus.WAIT_DELIVERY.getStatus(), WxShopOrderStatus.PARTIAL_DELIVERY.getStatus(), WxShopOrderStatus.WAIT_RECEIPT.getStatus(), WxShopOrderStatus.FINISHED.getStatus(), WxShopOrderStatus.AFTER_SALE_CANCEL.getStatus(), WxShopOrderStatus.USER_CANCEL_OR_PAY_TIMEOUT.getStatus()})));
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.terms((String)"c1").field("orderDetail.productInfos.productId");
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"s1").field("orderDetail.productInfos.skuCnt"));
        aggregationBuilder.subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)"uv").field("openId.keyword"));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchSourceBuilder.size(0);
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("es search error:", (Throwable)e);
        }
        HashMap productIdSaleCount = Maps.newHashMap();
        if (Objects.isNull(searchResponse) || Objects.isNull(searchResponse.getAggregations())) {
            return productIdSaleCount;
        }
        Terms terms = (Terms)searchResponse.getAggregations().get("c1");
        if (Objects.isNull(terms)) {
            return productIdSaleCount;
        }
        List buckets = terms.getBuckets();
        if (CollectionUtils.isNotEmpty((Collection)buckets)) {
            for (Terms.Bucket bucket : buckets) {
                String productId = bucket.getKeyAsString();
                SaleStatisticDto dto = new SaleStatisticDto();
                dto.setOrderCount(bucket.getDocCount());
                dto.setTotalSaleCount(new Double(((ParsedSum)bucket.getAggregations().get("s1")).getValue()).longValue());
                dto.setDistinctOpenIdCount(((ParsedCardinality)bucket.getAggregations().get("uv")).getValue());
                productIdSaleCount.put(productId, dto);
            }
        }
        return productIdSaleCount;
    }

    public Long getOrderCountByStatus(Integer status, String appId) {
        SearchResponse searchResponse;
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)status)).must((QueryBuilder)QueryBuilders.matchQuery((String)"appId.keyword", (Object)appId));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("orderId");
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (Exception e) {
            log.error("Search ES failed index:{},searchRequest:{}", new Object[]{this.shopOrderIndex, searchRequest, e});
            return 0L;
        }
        ValueCount valueCount = (ValueCount)searchResponse.getAggregations().get("count");
        return valueCount.getValue();
    }

    public Pair<List<OrderEsModel>, Long> queryOrderList(OrderLisQueryParam param, boolean direction, boolean isExport, String appId) {
        log.info("queryOrderList param:{},direction:{}", (Object)param, (Object)direction);
        param.validate();
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"appId.keyword", (Object)appId));
        if (param.getStatus() != null && param.getStatus() != 0) {
            BoolQueryBuilder statusQueryBuilder;
            if (WxShopOrderStatus.WAIT_RECEIPT.getStatus().equals(param.getStatus())) {
                statusQueryBuilder = new BoolQueryBuilder();
                statusQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)WxShopOrderStatus.WAIT_RECEIPT.getStatus()));
                statusQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)WxShopOrderStatus.PAID_WAIT_WRITE_OFF.getStatus()));
                statusQueryBuilder.minimumShouldMatch(1);
                queryBuilder.must((QueryBuilder)statusQueryBuilder);
            } else if (WxShopOrderStatus.USER_CANCEL_OR_PAY_TIMEOUT.getStatus().equals(param.getStatus())) {
                statusQueryBuilder = new BoolQueryBuilder();
                statusQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)WxShopOrderStatus.USER_CANCEL_OR_PAY_TIMEOUT.getStatus()));
                statusQueryBuilder.should((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)WxShopOrderStatus.AFTER_SALE_CANCEL.getStatus()));
                statusQueryBuilder.minimumShouldMatch(1);
                queryBuilder.must((QueryBuilder)statusQueryBuilder);
            } else {
                queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)param.getStatus()));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getProductName())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDetail.productInfos.title.keyword", (String)("*" + param.getProductName() + "*")));
        }
        if (StringUtils.isNotBlank((CharSequence)param.getMobile())) {
            BoolQueryBuilder mobileQueryBuilder = new BoolQueryBuilder();
            mobileQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDetail.deliveryInfoDto.addressInfo.telNumber", (String)param.getMobile()));
            mobileQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"orderDetail.couponCodeInfo.phoneNumber", (String)param.getMobile()));
            mobileQueryBuilder.minimumShouldMatch(1);
            queryBuilder.must((QueryBuilder)mobileQueryBuilder);
        }
        if (StringUtils.isNotBlank((CharSequence)param.getOrderId())) {
            queryBuilder.must((QueryBuilder)QueryBuilders.matchQuery((String)"orderId", (Object)param.getOrderId()));
        }
        if (isExport) {
            DateTime dateTime;
            DateTime startTime;
            Date now = new Date();
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)param.getOrderStartTime()) && StringUtils.isNotBlank((CharSequence)param.getOrderEndTime())) {
                DateTime endTime;
                startTime = DateUtil.parse((CharSequence)param.getOrderStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
                long betweenDay = DateUtil.between((Date)startTime, (Date)(endTime = DateUtil.parse((CharSequence)param.getOrderEndTime(), (String)"yyyy-MM-dd HH:mm:ss")), (DateUnit)DateUnit.DAY);
                if (betweenDay > 365L) {
                    DateTime newStartTime = DateUtil.offsetMonth((Date)endTime, (int)-12);
                    rangeQueryBuilder.gte((Object)newStartTime.getTime());
                } else {
                    rangeQueryBuilder.gte((Object)startTime.getTime());
                }
                rangeQueryBuilder.lte((Object)endTime.getTime());
            } else if (StringUtils.isNotBlank((CharSequence)param.getOrderStartTime()) && StringUtils.isBlank((CharSequence)param.getOrderEndTime())) {
                dateTime = DateUtil.parse((CharSequence)param.getOrderStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
                rangeQueryBuilder.gte((Object)dateTime.getTime());
                DateTime endTime = DateUtil.offsetMonth((Date)dateTime, (int)12);
                rangeQueryBuilder.lte((Object)endTime.getTime());
            } else if (StringUtils.isBlank((CharSequence)param.getOrderStartTime()) && StringUtils.isNotBlank((CharSequence)param.getOrderEndTime())) {
                dateTime = DateUtil.parse((CharSequence)param.getOrderEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
                DateTime startTime2 = DateUtil.offsetMonth((Date)now, (int)-12);
                rangeQueryBuilder.gte((Object)startTime2.getTime());
                rangeQueryBuilder.lte((Object)dateTime.getTime());
            } else {
                startTime = DateUtil.offsetMonth((Date)now, (int)-12);
                rangeQueryBuilder.gte((Object)startTime.getTime());
                rangeQueryBuilder.lte((Object)now.getTime());
            }
            queryBuilder.must((QueryBuilder)rangeQueryBuilder);
        } else if (StringUtils.isNotBlank((CharSequence)param.getOrderStartTime()) || StringUtils.isNotBlank((CharSequence)param.getOrderEndTime())) {
            DateTime dateTime;
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"createTime");
            if (StringUtils.isNotBlank((CharSequence)param.getOrderStartTime())) {
                dateTime = DateUtil.parse((CharSequence)param.getOrderStartTime(), (String)"yyyy-MM-dd HH:mm:ss");
                rangeQueryBuilder.gte((Object)dateTime.getTime());
            }
            if (StringUtils.isNotBlank((CharSequence)param.getOrderEndTime())) {
                dateTime = DateUtil.parse((CharSequence)param.getOrderEndTime(), (String)"yyyy-MM-dd HH:mm:ss");
                rangeQueryBuilder.lte((Object)dateTime.getTime());
            }
            queryBuilder.must((QueryBuilder)rangeQueryBuilder);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        if (direction) {
            searchSourceBuilder.sort("createTime.keyword", SortOrder.ASC);
        } else {
            searchSourceBuilder.sort("createTime.keyword", SortOrder.DESC);
        }
        if (Objects.isNull(param.getPageDto())) {
            searchSourceBuilder.size(20);
            searchSourceBuilder.from(0);
        } else {
            searchSourceBuilder.size(param.getPageDto().getPageSize().intValue());
            searchSourceBuilder.from(param.getPageDto().getOffset());
        }
        ValuesSourceAggregationBuilder aggregationBuilder = AggregationBuilders.count((String)"count").field("orderId.keyword");
        searchSourceBuilder.aggregation((AggregationBuilder)aggregationBuilder);
        return this.executeQueryAndDealResult(searchRequest, searchSourceBuilder);
    }

    private Pair<List<OrderEsModel>, Long> executeQueryAndDealResult(SearchRequest searchRequest, SearchSourceBuilder searchSourceBuilder) {
        searchRequest.source(searchSourceBuilder);
        SearchResponse searchResponse = null;
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
        }
        ArrayList orderList = new ArrayList();
        if (Objects.isNull(searchResponse)) {
            return new ImmutablePair(orderList, (Object)0L);
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        long totalHits = hits.getTotalHits();
        Stream.of(searchHits).forEach(searchHit -> {
            String sourceAsString = searchHit.getSourceAsString();
            OrderEsModel orderEsModel = (OrderEsModel)JSON.parseObject((String)sourceAsString, OrderEsModel.class);
            orderList.add(orderEsModel);
        });
        return new ImmutablePair(orderList, (Object)totalHits);
    }

    public OrderEsModel getOneById(String orderId) {
        SearchResponse searchResponse;
        log.info("getOneById orderId:{}", (Object)orderId);
        BoolQueryBuilder queryBuilder = new BoolQueryBuilder();
        queryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"orderId.keyword", (String)orderId));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.shopOrderIndex});
        searchRequest.types(new String[]{TYPE});
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queryBuilder);
        searchRequest.source(searchSourceBuilder);
        try {
            searchResponse = this.restHighLevelClient.search(searchRequest, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search es failed, searchRequest={}", (Object)searchRequest, (Object)e);
            searchResponse = null;
        }
        if (Objects.isNull(searchResponse)) {
            return null;
        }
        SearchHits hits = searchResponse.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits == null || searchHits.length <= 0) {
            return null;
        }
        return (OrderEsModel)JSON.parseObject((String)searchHits[0].getSourceAsString(), OrderEsModel.class);
    }
}

