/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WxShopPromoteType {
    PROMOTE_TYPE_SHOP(1, "\u5e97\u94fa\u5185\u63a8\u5e7f", "PROMOTE_TYPE_SHOP"),
    PROMOTE_TYPE_CUSTOMIZE(2, "\u81ea\u5b9a\u4e49\u63a8\u5e7f\u6e20\u9053", "PROMOTE_TYPE_CUSTOMIZE"),
    PROMOTE_TYPE_TARGET(3, "\u5b9a\u5411\u4f18\u60e0", "PROMOTE_TYPE_TARGET");

    private Integer type;
    private String desc;
    private String enDesc;
    private static Map<Integer, WxShopPromoteType> map;
    private static Map<String, WxShopPromoteType> enMap;

    private WxShopPromoteType(Integer type, String desc, String enDesc) {
        this.type = type;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    public static boolean isExistByType(int type) {
        return map.containsKey(type);
    }

    public static String getDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public static Integer getTypeByEnDesc(String enDesc) {
        return enMap.containsKey(enDesc) ? enMap.get(enDesc).getType() : -1;
    }

    public static String getEnDescByType(int type) {
        return map.containsKey(type) ? map.get(type).getEnDesc() : null;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    static {
        map = Maps.newHashMap();
        enMap = Maps.newHashMap();
        for (WxShopPromoteType type : WxShopPromoteType.values()) {
            map.put(type.type, type);
            enMap.put(type.enDesc, type);
        }
    }
}

