/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.enums;

import com.google.common.collect.Maps;
import java.util.Map;

public enum WxShopAfterSaleStatus {
    USER_CANCELD(1, "\u7528\u6237\u53d6\u6d88\u7533\u8bf7", "USER_CANCELD"),
    MERCHANT_PROCESSING(2, "\u5546\u5bb6\u53d7\u7406\u4e2d", "MERCHANT_PROCESSING"),
    MERCHANT_REJECT_REFUND(4, "\u5546\u5bb6\u62d2\u7edd\u9000\u6b3e", "MERCHANT_REJECT_REFUND"),
    MERCHANT_REJECT_RETURN(5, "\u5546\u5bb6\u62d2\u7edd\u9000\u8d27\u9000\u6b3e", "MERCHANT_REJECT_RETURN"),
    USER_WAIT_RETURN(6, "\u5f85\u4e70\u5bb6\u9000\u8d27", "USER_WAIT_RETURN"),
    RETURN_CLOSED(7, "\u9000\u8d27\u9000\u6b3e\u5173\u95ed", "RETURN_CLOSED"),
    MERCHANT_WAIT_RECEIPT(8, "\u5f85\u5546\u5bb6\u6536\u8d27", "MERCHANT_WAIT_RECEIPT"),
    MERCHANT_OVERDUE_REFUND(12, "\u5546\u5bb6\u903e\u671f\u672a\u9000\u6b3e", "MERCHANT_OVERDUE_REFUND"),
    MERCHANT_REFUND_SUCCESS(13, "\u9000\u6b3e\u5b8c\u6210", "MERCHANT_REFUND_SUCCESS"),
    MERCHANT_RETURN_SUCCESS(14, "\u9000\u8d27\u9000\u6b3e\u5b8c\u6210", "MERCHANT_RETURN_SUCCESS"),
    PLATFORM_REFUNDING(15, "\u5e73\u53f0\u9000\u6b3e\u4e2d", "PLATFORM_REFUNDING"),
    PLATFORM_REFUND_FAIL(16, "\u5e73\u53f0\u9000\u6b3e\u5931\u8d25", "PLATFORM_REFUND_FAIL"),
    USER_WAIT_CONFIRM(17, "\u5f85\u7528\u6237\u786e\u8ba4", "USER_WAIT_CONFIRM"),
    MERCHANT_REFUND_RETRY_FAIL(18, "\u5546\u5bb6\u6253\u6b3e\u5931\u8d25\uff0c\u5ba2\u670d\u5173\u95ed\u552e\u540e", "MERCHANT_REFUND_RETRY_FAIL"),
    MERCHANT_FAIL(19, "\u552e\u540e\u5173\u95ed", "MERCHANT_FAIL");

    private Integer status;
    private String desc;
    private String enDesc;
    private static Map<Integer, WxShopAfterSaleStatus> map;
    private static Map<String, WxShopAfterSaleStatus> enDescMap;

    private WxShopAfterSaleStatus(Integer status, String desc, String enDesc) {
        this.status = status;
        this.desc = desc;
        this.enDesc = enDesc;
    }

    public static boolean isExistByStatus(int type) {
        return map.containsKey(type);
    }

    public static String getDescByStatus(int type) {
        return map.containsKey(type) ? map.get(type).getDesc() : null;
    }

    public static WxShopAfterSaleStatus getByEnDesc(String enDesc) {
        return enDescMap.getOrDefault(enDesc, null);
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getEnDesc() {
        return this.enDesc;
    }

    static {
        map = Maps.newHashMap();
        enDescMap = Maps.newHashMap();
        for (WxShopAfterSaleStatus status : WxShopAfterSaleStatus.values()) {
            map.put(status.status, status);
            enDescMap.put(status.getEnDesc(), status);
        }
    }
}

