/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.shop.dto.spu.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.shop.dto.AttrItem;
import com.kuaike.scrm.shop.dto.spu.dto.CategoryLevelDto;
import com.kuaike.scrm.shop.dto.spu.dto.CouponCodeInfo;
import com.kuaike.scrm.shop.dto.spu.dto.ExpressInfo;
import com.kuaike.scrm.shop.dto.spu.dto.SkuItemDto;
import com.kuaike.scrm.shop.dto.spu.dto.SpuDescInfo;
import com.kuaike.scrm.utils.HttpHeadUtils;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpuAddReq {
    protected String outProductId;
    protected String title;
    protected String subTitle;
    protected List<String> headImg;
    protected SpuDescInfo descInfo;
    protected String brandId;
    protected List<CategoryLevelDto> cats;
    protected List<AttrItem> attrs;
    protected String model;
    protected ExpressInfo expressInfo;
    protected List<SkuItemDto> skus;
    protected CouponCodeInfo couponcodeInfo;
    protected Integer productType;
    protected Integer status;
    protected Integer editStatus;

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.brandId) || "0".equals(this.brandId)) {
            this.brandId = "2100000000";
        }
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)this.title) && StringUtils.length((CharSequence)this.title) <= 60 ? 1 : 0) != 0, (Object)"\u6807\u9898\u5fc5\u586b,\u4e14\u6700\u591a60\u4e2a\u5b57\u7b26");
        if (StringUtils.isNotBlank((CharSequence)this.subTitle)) {
            Preconditions.checkArgument((StringUtils.length((CharSequence)this.subTitle) <= 18 ? 1 : 0) != 0, (Object)"subTitle,\u526f\u6807\u9898\u6700\u591a18\u4e2a\u5b57\u7b26");
        }
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(this.headImg) && CollectionUtils.size(this.headImg) <= 9 ? 1 : 0) != 0, (Object)"headImg,\u4e3b\u56fe\u4e0d\u80fd\u4e3a\u7a7a,\u6700\u591a9\u5f20");
        for (String img : this.headImg) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)img), (Object)"headImg\u4e2d\u4e0d\u80fd\u5b58\u5728\u7a7a\u7684\u56fe\u7247");
            if (HttpHeadUtils.isWxResource((String)img)) continue;
            HttpHeadUtils.checkImgAndSize((String)img, (String)"\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e", (int)10, (String)"\u5546\u54c1\u56fe\u7247\u6700\u592710MB");
        }
        if (Objects.nonNull(this.descInfo) && CollectionUtils.isNotEmpty(this.descInfo.getImgs())) {
            Preconditions.checkArgument((CollectionUtils.size(this.descInfo.getImgs()) <= 20 ? 1 : 0) != 0, (Object)"\u5546\u54c1\u8be6\u60c5,\u76ee\u524d\u53ea\u652f\u6301\u56fe\u7247, \u6700\u591a20\u5f20");
            for (String img : this.descInfo.getImgs()) {
                if (HttpHeadUtils.isWxResource((String)img)) continue;
                HttpHeadUtils.checkImgAndSize((String)img, (String)"\u56fe\u7247\u683c\u5f0f\u4e0d\u6b63\u786e", (int)10, (String)"\u5546\u54c1\u8be6\u60c5\u56fe\u7247\u6700\u592710MB");
            }
        }
        Preconditions.checkArgument((CollectionUtils.isNotEmpty(this.cats) && this.cats.size() == 3 ? 1 : 0) != 0, (Object)"\u5546\u54c1\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u7c7b\u76ee\u5fc5\u987b\u4e3a\u4e09\u7ea7\u7ed3\u6784");
        for (int i = 0; i < this.cats.size(); ++i) {
            CategoryLevelDto cat = this.cats.get(i);
            Preconditions.checkArgument((boolean)Objects.nonNull(cat), (Object)"cats\u5143\u7d20\u4e0d\u80fd\u4e3a\u7a7a");
            if (Objects.isNull(cat.getLevel())) {
                cat.setLevel(i + 1);
            }
            cat.validate();
        }
        if (CollectionUtils.isNotEmpty(this.attrs)) {
            for (AttrItem attr : this.attrs) {
                Preconditions.checkArgument((boolean)Objects.nonNull(attr), (Object)"attrs\u5143\u7d20\u4e0d\u80fd\u4e3a\u7a7a");
                attr.validate();
            }
        }
        Preconditions.checkArgument((Objects.nonNull(this.productType) && this.productType == 2 ? 1 : 0) != 0, (Object)"productType\u76ee\u524d\u5fc5\u987b\u662f\u5238\u7801\u5546\u54c1,\u8bbe\u7f6e\u4e3a2");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.couponcodeInfo), (Object)"couponcodeInfo \u4e0d\u80fd\u4e3a\u7a7a");
        this.couponcodeInfo.validate();
        if (CollectionUtils.isNotEmpty(this.skus)) {
            for (SkuItemDto dto : this.skus) {
                dto.validate();
            }
        }
    }

    public String getOutProductId() {
        return this.outProductId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubTitle() {
        return this.subTitle;
    }

    public List<String> getHeadImg() {
        return this.headImg;
    }

    public SpuDescInfo getDescInfo() {
        return this.descInfo;
    }

    public String getBrandId() {
        return this.brandId;
    }

    public List<CategoryLevelDto> getCats() {
        return this.cats;
    }

    public List<AttrItem> getAttrs() {
        return this.attrs;
    }

    public String getModel() {
        return this.model;
    }

    public ExpressInfo getExpressInfo() {
        return this.expressInfo;
    }

    public List<SkuItemDto> getSkus() {
        return this.skus;
    }

    public CouponCodeInfo getCouponcodeInfo() {
        return this.couponcodeInfo;
    }

    public Integer getProductType() {
        return this.productType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getEditStatus() {
        return this.editStatus;
    }

    public void setOutProductId(String outProductId) {
        this.outProductId = outProductId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubTitle(String subTitle) {
        this.subTitle = subTitle;
    }

    public void setHeadImg(List<String> headImg) {
        this.headImg = headImg;
    }

    public void setDescInfo(SpuDescInfo descInfo) {
        this.descInfo = descInfo;
    }

    public void setBrandId(String brandId) {
        this.brandId = brandId;
    }

    public void setCats(List<CategoryLevelDto> cats) {
        this.cats = cats;
    }

    public void setAttrs(List<AttrItem> attrs) {
        this.attrs = attrs;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public void setExpressInfo(ExpressInfo expressInfo) {
        this.expressInfo = expressInfo;
    }

    public void setSkus(List<SkuItemDto> skus) {
        this.skus = skus;
    }

    public void setCouponcodeInfo(CouponCodeInfo couponcodeInfo) {
        this.couponcodeInfo = couponcodeInfo;
    }

    public void setProductType(Integer productType) {
        this.productType = productType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setEditStatus(Integer editStatus) {
        this.editStatus = editStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpuAddReq)) {
            return false;
        }
        SpuAddReq other = (SpuAddReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$productType = this.getProductType();
        Integer other$productType = other.getProductType();
        if (this$productType == null ? other$productType != null : !((Object)this$productType).equals(other$productType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$editStatus = this.getEditStatus();
        Integer other$editStatus = other.getEditStatus();
        if (this$editStatus == null ? other$editStatus != null : !((Object)this$editStatus).equals(other$editStatus)) {
            return false;
        }
        String this$outProductId = this.getOutProductId();
        String other$outProductId = other.getOutProductId();
        if (this$outProductId == null ? other$outProductId != null : !this$outProductId.equals(other$outProductId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$subTitle = this.getSubTitle();
        String other$subTitle = other.getSubTitle();
        if (this$subTitle == null ? other$subTitle != null : !this$subTitle.equals(other$subTitle)) {
            return false;
        }
        List<String> this$headImg = this.getHeadImg();
        List<String> other$headImg = other.getHeadImg();
        if (this$headImg == null ? other$headImg != null : !((Object)this$headImg).equals(other$headImg)) {
            return false;
        }
        SpuDescInfo this$descInfo = this.getDescInfo();
        SpuDescInfo other$descInfo = other.getDescInfo();
        if (this$descInfo == null ? other$descInfo != null : !((Object)this$descInfo).equals(other$descInfo)) {
            return false;
        }
        String this$brandId = this.getBrandId();
        String other$brandId = other.getBrandId();
        if (this$brandId == null ? other$brandId != null : !this$brandId.equals(other$brandId)) {
            return false;
        }
        List<CategoryLevelDto> this$cats = this.getCats();
        List<CategoryLevelDto> other$cats = other.getCats();
        if (this$cats == null ? other$cats != null : !((Object)this$cats).equals(other$cats)) {
            return false;
        }
        List<AttrItem> this$attrs = this.getAttrs();
        List<AttrItem> other$attrs = other.getAttrs();
        if (this$attrs == null ? other$attrs != null : !((Object)this$attrs).equals(other$attrs)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        ExpressInfo this$expressInfo = this.getExpressInfo();
        ExpressInfo other$expressInfo = other.getExpressInfo();
        if (this$expressInfo == null ? other$expressInfo != null : !((Object)this$expressInfo).equals(other$expressInfo)) {
            return false;
        }
        List<SkuItemDto> this$skus = this.getSkus();
        List<SkuItemDto> other$skus = other.getSkus();
        if (this$skus == null ? other$skus != null : !((Object)this$skus).equals(other$skus)) {
            return false;
        }
        CouponCodeInfo this$couponcodeInfo = this.getCouponcodeInfo();
        CouponCodeInfo other$couponcodeInfo = other.getCouponcodeInfo();
        return !(this$couponcodeInfo == null ? other$couponcodeInfo != null : !((Object)this$couponcodeInfo).equals(other$couponcodeInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpuAddReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $productType = this.getProductType();
        result = result * 59 + ($productType == null ? 43 : ((Object)$productType).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $editStatus = this.getEditStatus();
        result = result * 59 + ($editStatus == null ? 43 : ((Object)$editStatus).hashCode());
        String $outProductId = this.getOutProductId();
        result = result * 59 + ($outProductId == null ? 43 : $outProductId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $subTitle = this.getSubTitle();
        result = result * 59 + ($subTitle == null ? 43 : $subTitle.hashCode());
        List<String> $headImg = this.getHeadImg();
        result = result * 59 + ($headImg == null ? 43 : ((Object)$headImg).hashCode());
        SpuDescInfo $descInfo = this.getDescInfo();
        result = result * 59 + ($descInfo == null ? 43 : ((Object)$descInfo).hashCode());
        String $brandId = this.getBrandId();
        result = result * 59 + ($brandId == null ? 43 : $brandId.hashCode());
        List<CategoryLevelDto> $cats = this.getCats();
        result = result * 59 + ($cats == null ? 43 : ((Object)$cats).hashCode());
        List<AttrItem> $attrs = this.getAttrs();
        result = result * 59 + ($attrs == null ? 43 : ((Object)$attrs).hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        ExpressInfo $expressInfo = this.getExpressInfo();
        result = result * 59 + ($expressInfo == null ? 43 : ((Object)$expressInfo).hashCode());
        List<SkuItemDto> $skus = this.getSkus();
        result = result * 59 + ($skus == null ? 43 : ((Object)$skus).hashCode());
        CouponCodeInfo $couponcodeInfo = this.getCouponcodeInfo();
        result = result * 59 + ($couponcodeInfo == null ? 43 : ((Object)$couponcodeInfo).hashCode());
        return result;
    }

    public String toString() {
        return "SpuAddReq(outProductId=" + this.getOutProductId() + ", title=" + this.getTitle() + ", subTitle=" + this.getSubTitle() + ", headImg=" + this.getHeadImg() + ", descInfo=" + this.getDescInfo() + ", brandId=" + this.getBrandId() + ", cats=" + this.getCats() + ", attrs=" + this.getAttrs() + ", model=" + this.getModel() + ", expressInfo=" + this.getExpressInfo() + ", skus=" + this.getSkus() + ", couponcodeInfo=" + this.getCouponcodeInfo() + ", productType=" + this.getProductType() + ", status=" + this.getStatus() + ", editStatus=" + this.getEditStatus() + ")";
    }
}

