/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class ReplyModReqDto {
    private String id;
    private String groupId;
    private List<String> keywords;
    private List<UniformMsgDto> contentList;
    private String title;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.id), (Object)"\u8bdd\u672fID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.groupId), (Object)"\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"\u8bdd\u672f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        for (UniformMsgDto msgDto : this.contentList) {
            msgDto.validate();
        }
        if (Objects.nonNull(this.title)) {
            Preconditions.checkArgument((this.title.length() <= 50 ? 1 : 0) != 0, (Object)"\u6807\u9898\u9650\u523650\u4e2a\u5b57\u4ee5\u5185");
        }
        if (CollectionUtils.isNotEmpty(this.keywords)) {
            for (String keyword : this.keywords) {
                Preconditions.checkArgument((keyword.length() <= 50 ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u9650\u523650\u4e2a\u5b57\u4ee5\u5185");
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public String getTitle() {
        return this.title;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplyModReqDto)) {
            return false;
        }
        ReplyModReqDto other = (ReplyModReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        return !(this$title == null ? other$title != null : !this$title.equals(other$title));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplyModReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        return result;
    }

    public String toString() {
        return "ReplyModReqDto(id=" + this.getId() + ", groupId=" + this.getGroupId() + ", keywords=" + this.getKeywords() + ", contentList=" + this.getContentList() + ", title=" + this.getTitle() + ")";
    }
}

