/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.service.impl;

import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.quickreply.entity.QuickTag;
import com.kuaike.scrm.dal.quickreply.entity.QuickTagGroup;
import com.kuaike.scrm.dal.quickreply.mapper.QuickTagGroupMapper;
import com.kuaike.scrm.dal.quickreply.mapper.QuickTagMapper;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.reply.dto.request.QuickTagAddOrModReqDto;
import com.kuaike.scrm.reply.dto.request.QuickTagDto;
import com.kuaike.scrm.reply.dto.request.QuickTagListReqDto;
import com.kuaike.scrm.reply.dto.response.QuickTagGroupRespDto;
import com.kuaike.scrm.reply.dto.response.QuickTagRespDto;
import com.kuaike.scrm.reply.service.QuickTagService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class QuickTagServiceImpl
implements QuickTagService {
    private static final Logger log = LoggerFactory.getLogger(QuickTagServiceImpl.class);
    @Resource
    private QuickTagMapper quickTagMapper;
    @Resource
    private QuickTagGroupMapper quickTagGroupMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private IdGen idGen;

    @Override
    public void add(QuickTagAddOrModReqDto req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("quick tag add req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateAddParams();
        int count = this.quickTagGroupMapper.queryCountByGroupName(userInfo.getBizId(), userInfo.getId(), req.getGroupName());
        if (count > 0) {
            log.info("quick tag add groupName:{}\u5df2\u5b58\u5728", (Object)req.getGroupName());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5feb\u6377\u6807\u7b7e\u7ec4\u540d\u5df2\u5b58\u5728");
        }
        Date curTime = new Date();
        QuickTagGroup quickTagGroup = this.buildQuickTagGroup(userInfo, req.getGroupName(), curTime);
        this.quickTagGroupMapper.insertSelective((Object)quickTagGroup);
        if (CollectionUtils.isEmpty(req.getTags())) {
            log.info("quick tag add tags is empty");
            return;
        }
        List<QuickTag> quickTags = this.buildQuickTags(userInfo, quickTagGroup.getId(), req.getTags(), curTime);
        this.quickTagMapper.batchInsert(quickTags);
    }

    @Override
    public void mod(QuickTagAddOrModReqDto req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("quick tag mod req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        req.validateModParams();
        QuickTagGroup quickTagGroup = this.quickTagGroupMapper.selectByNum(req.getId());
        if (quickTagGroup == null) {
            log.info("\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230\u5feb\u6377\u6807\u7b7e\u7ec4", (Object)req.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        if (!req.getGroupName().equals(quickTagGroup.getGroupName())) {
            int count = this.quickTagGroupMapper.queryCountByGroupName(userInfo.getBizId(), userInfo.getId(), req.getGroupName());
            if (count > 0) {
                log.info("groupName:{}\u5df2\u5b58\u5728", (Object)req.getGroupName());
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5feb\u6377\u6807\u7b7e\u7ec4\u540d\u5df2\u5b58\u5728");
            }
            quickTagGroup.setGroupName(req.getGroupName());
            quickTagGroup.setUpdateBy(userInfo.getId());
            quickTagGroup.setUpdateTime(new Date());
            this.quickTagGroupMapper.updateByPrimaryKey((Object)quickTagGroup);
        }
        this.quickTagMapper.deleteByQuickTagGroupId(quickTagGroup.getId());
        if (CollectionUtils.isEmpty(req.getTags())) {
            return;
        }
        List<QuickTag> quickTags = this.buildQuickTags(userInfo, quickTagGroup.getId(), req.getTags(), new Date());
        this.quickTagMapper.batchInsert(quickTags);
    }

    @Override
    public void del(String id) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("quick tag del id:{}, operatorId:{}", (Object)id, (Object)userInfo.getId());
        QuickTagGroup quickTagGroup = this.quickTagGroupMapper.selectByNum(id);
        if (quickTagGroup == null) {
            log.info("\u6839\u636enum:{}\u672a\u67e5\u8be2\u5230\u5feb\u6377\u6807\u7b7e\u7ec4", (Object)id);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bf7\u6c42\u53c2\u6570\u4e0d\u5408\u6cd5");
        }
        quickTagGroup.setIsDeleted(NumberUtils.INTEGER_ONE);
        quickTagGroup.setUpdateBy(userInfo.getId());
        quickTagGroup.setUpdateTime(new Date());
        this.quickTagGroupMapper.updateByPrimaryKey((Object)quickTagGroup);
        this.quickTagMapper.deleteByQuickTagGroupId(quickTagGroup.getId());
    }

    @Override
    public List<QuickTagRespDto> list(QuickTagListReqDto req) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("quick tag list req:{}, operatorId:{}", (Object)req, (Object)userInfo.getId());
        List<QuickTagGroup> quickTagGroups = this.getQuickTagGroupList(req.getPageDto(), req.getGroupName(), userInfo.getId());
        if (CollectionUtils.isEmpty(quickTagGroups)) {
            return Collections.emptyList();
        }
        List quickTagGroupIds = quickTagGroups.stream().map(QuickTagGroup::getId).collect(Collectors.toList());
        List quickTags = this.quickTagMapper.selectByQuickTagGroupIds(quickTagGroupIds);
        Map<Long, List<QuickTag>> quickTagGroupId2TagsMap = null;
        Map weworkTagId2NameMap = null;
        if (CollectionUtils.isNotEmpty((Collection)quickTags)) {
            quickTagGroupId2TagsMap = quickTags.stream().collect(Collectors.groupingBy(QuickTag::getQuickTagGroupId));
            List weworkTagIds = quickTags.stream().map(QuickTag::getWeworkTagId).collect(Collectors.toList());
            weworkTagId2NameMap = this.weworkTagMapper.queryTagIdAndName(userInfo.getCorpId(), weworkTagIds);
        }
        ArrayList respDtos = Lists.newArrayList();
        for (QuickTagGroup quickTagGroup : quickTagGroups) {
            QuickTagRespDto quickTagResp = new QuickTagRespDto();
            respDtos.add(quickTagResp);
            quickTagResp.setId(quickTagGroup.getNum());
            quickTagResp.setGroupName(quickTagGroup.getGroupName());
            quickTagResp.setCreateTime(quickTagGroup.getCreateTime());
            if (MapUtils.isEmpty(quickTagGroupId2TagsMap) || !quickTagGroupId2TagsMap.containsKey(quickTagGroup.getId())) continue;
            ArrayList tags = Lists.newArrayList();
            quickTagResp.setTags(tags);
            for (QuickTag quickTag : quickTagGroupId2TagsMap.get(quickTagGroup.getId())) {
                if (weworkTagId2NameMap == null || !weworkTagId2NameMap.containsKey(quickTag.getWeworkTagId())) continue;
                QuickTagDto quickTagDto = new QuickTagDto();
                tags.add(quickTagDto);
                quickTagDto.setId(quickTag.getNum());
                quickTagDto.setWeworkTagId(quickTag.getWeworkTagId());
                quickTagDto.setWeworkTagGroupId(quickTag.getWeworkTagGroupId());
                quickTagDto.setWeworkTagName((String)weworkTagId2NameMap.get(quickTag.getWeworkTagId()));
            }
        }
        return respDtos;
    }

    @Override
    public List<QuickTagGroupRespDto> getTagGroups(PageDto pageDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        List<QuickTagGroup> quickTagGroups = this.getQuickTagGroupList(pageDto, null, userInfo.getId());
        if (CollectionUtils.isEmpty(quickTagGroups)) {
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (QuickTagGroup quickTagGroup : quickTagGroups) {
            QuickTagGroupRespDto respDto = new QuickTagGroupRespDto();
            respDtos.add(respDto);
            respDto.setId(quickTagGroup.getNum());
            respDto.setGroupName(quickTagGroup.getGroupName());
        }
        return respDtos;
    }

    private QuickTagGroup buildQuickTagGroup(CurrentUserInfo userInfo, String groupName, Date curTime) {
        QuickTagGroup quickTagGroup = new QuickTagGroup();
        quickTagGroup.setNum(this.idGen.getNum());
        quickTagGroup.setBizId(userInfo.getBizId());
        quickTagGroup.setGroupName(groupName);
        quickTagGroup.setCreateBy(userInfo.getId());
        quickTagGroup.setCreateTime(curTime);
        quickTagGroup.setUpdateBy(userInfo.getId());
        quickTagGroup.setUpdateTime(curTime);
        quickTagGroup.setIsDeleted(NumberUtils.INTEGER_ZERO);
        return quickTagGroup;
    }

    private List<QuickTag> buildQuickTags(CurrentUserInfo userInfo, Long quickTagGroupId, List<QuickTagDto> tags, Date curTime) {
        ArrayList quickTags = Lists.newArrayList();
        for (QuickTagDto tagDto : tags) {
            QuickTag quickTag = new QuickTag();
            quickTags.add(quickTag);
            quickTag.setNum(this.idGen.getNum());
            quickTag.setBizId(userInfo.getBizId());
            quickTag.setQuickTagGroupId(quickTagGroupId);
            quickTag.setWeworkTagGroupId(tagDto.getWeworkTagGroupId());
            quickTag.setWeworkTagId(tagDto.getWeworkTagId());
            quickTag.setCreateBy(userInfo.getId());
            quickTag.setCreateTime(curTime);
            quickTag.setUpdateBy(userInfo.getId());
            quickTag.setUpdateTime(curTime);
            quickTag.setIsDeleted(NumberUtils.INTEGER_ZERO);
        }
        return quickTags;
    }

    private List<QuickTagGroup> getQuickTagGroupList(PageDto pageDto, String groupName, Long createBy) {
        Integer offset = null;
        Integer pageSize = null;
        if (pageDto != null) {
            int count = this.quickTagGroupMapper.queryCountByCreateBy(createBy, groupName);
            pageDto.setCount(Integer.valueOf(count));
            pageSize = pageDto.getPageSize();
            offset = (pageDto.getPageNum() - 1) * pageSize;
        }
        return this.quickTagGroupMapper.queryList(offset, pageSize, createBy, groupName);
    }
}

