/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.service.impl;

import com.alibaba.fastjson.JSON;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.JacksonUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.quickreply.dto.QuickReplyModDto;
import com.kuaike.scrm.dal.quickreply.entity.QuickReply;
import com.kuaike.scrm.dal.quickreply.entity.QuickReplyRelation;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyMapper;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyRelationMapper;
import com.kuaike.scrm.reply.dto.entity.ReplyContentEntity;
import com.kuaike.scrm.reply.dto.request.GroupListReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyAddReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyDelReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyListReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyModReqDto;
import com.kuaike.scrm.reply.dto.request.ReplyMvListReqDto;
import com.kuaike.scrm.reply.dto.response.GroupListRespDto;
import com.kuaike.scrm.reply.dto.response.ReplyListRespDto;
import com.kuaike.scrm.reply.service.QuickReplyService;
import com.kuaike.scrm.reply.service.ReplyContentHandleService;
import com.kuaike.scrm.reply.service.ReplyGroupService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class QuickReplyServiceImpl
implements QuickReplyService {
    private static final Logger log = LoggerFactory.getLogger(QuickReplyServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private QuickReplyMapper mapper;
    @Autowired
    private QuickReplyRelationMapper relationMapper;
    @Autowired
    private RestHighLevelClient restHighLevelClient;
    @Autowired
    private ReplyContentHandleService replyContentHandleService;
    @Autowired
    private ReplyGroupService replyGroupService;
    @Value(value="${scrm.elasticsearch.replyIndex}")
    private String replyIndex;
    private static final String TYPE = "doc";

    @Override
    public List<ReplyListRespDto> getReplyList(ReplyListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("groupList reqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        GroupListReqDto groupListReqDto = new GroupListReqDto();
        List<GroupListRespDto> groupList = this.replyGroupService.groupList(groupListReqDto);
        if (CollectionUtils.isEmpty(groupList)) {
            return Lists.newArrayList();
        }
        HashSet groupIds = groupList.stream().map(GroupListRespDto::getId).collect(Collectors.toSet());
        String selectGroupId = reqDto.getGroupId();
        if (StringUtils.isNotEmpty((CharSequence)selectGroupId)) {
            groupIds = groupIds.contains(selectGroupId) ? Sets.newHashSet((Object[])new String[]{selectGroupId}) : Sets.newHashSet();
        }
        List list = null;
        if (Objects.isNull(reqDto.getQuery()) || reqDto.getQuery().equals("")) {
            list = this.mapper.getReplyList(reqDto.getPageDto(), userInfo.getBizId(), (Collection)groupIds);
            Integer count = this.mapper.getCountByReplyList(userInfo.getBizId(), (Collection)groupIds);
            reqDto.getPageDto().setCount(count);
        } else {
            BoolQueryBuilder queries = QueryBuilders.boolQuery();
            if (StringUtils.isNotBlank((CharSequence)reqDto.getGroupId())) {
                queries.must((QueryBuilder)QueryBuilders.termQuery((String)"groupId.keyword", (String)reqDto.getGroupId()));
            }
            queries.must((QueryBuilder)QueryBuilders.termQuery((String)"corpId.keyword", (String)userInfo.getCorpId()));
            queries.must((QueryBuilder)QueryBuilders.termQuery((String)"isDelete", (int)0));
            String wildQuery = "*" + reqDto.getQuery() + "*";
            queries.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"content.keyword", (String)wildQuery)).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"keyword.keyword", (String)wildQuery)).should((QueryBuilder)QueryBuilders.wildcardQuery((String)"title.keyword", (String)wildQuery));
            queries.minimumShouldMatch(1);
            SearchSourceBuilder builder = new SearchSourceBuilder();
            builder.query((QueryBuilder)queries);
            builder.from(reqDto.getPageDto().getOffset());
            builder.size(reqDto.getPageDto().getPageSize().intValue());
            SearchRequest request = new SearchRequest(new String[]{this.replyIndex});
            request.types(new String[]{TYPE});
            request.source(builder);
            SearchResponse response = null;
            try {
                log.info("search request : {}", (Object)request);
                response = this.restHighLevelClient.search(request, new Header[0]);
            }
            catch (IOException e) {
                log.error("Search query quick reply failed, searchRequest={}", (Object)request, (Object)e);
            }
            if (Objects.isNull(response)) {
                return null;
            }
            SearchHits hits = response.getHits();
            if (hits.getTotalHits() <= 0L) {
                return null;
            }
            ArrayList replyIdsList = Lists.newArrayListWithExpectedSize((int)Long.valueOf(hits.getTotalHits()).intValue());
            Stream.of(hits.getHits()).forEach(hit -> {
                String sourceAsString = hit.getSourceAsString();
                ReplyContentEntity replyContentEntity = (ReplyContentEntity)JSON.parseObject((String)sourceAsString, ReplyContentEntity.class);
                replyIdsList.add(replyContentEntity.getId());
            });
            if (CollectionUtils.isNotEmpty((Collection)replyIdsList)) {
                list = this.mapper.getReplyListByIds((List)replyIdsList, userInfo.getBizId(), (Collection)groupIds);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            List replyNums = list.stream().map(QuickReply::getNum).collect(Collectors.toList());
            List relations = this.relationMapper.getRelationsByUserIdAndNums(replyNums, userInfo.getId(), userInfo.getCorpId());
            log.info("get relations size: {}", (Object)relations.size());
            HashSet replyRelationSet = new HashSet(relations);
            Set relationNums = replyRelationSet.stream().map(QuickReplyRelation::getCorpReplyNum).collect(Collectors.toSet());
            log.info("get favorite  reply nums : {}", relationNums);
            ArrayList respDtos = Lists.newArrayList();
            for (QuickReply replyCorp : list) {
                ReplyListRespDto respDto = new ReplyListRespDto();
                respDto.setId(replyCorp.getNum());
                respDto.setGroupId(replyCorp.getQuickReplyGroupId());
                List<UniformMsgDto> contentList = this.replyContentHandleService.getMsgList(replyCorp.getContent());
                this.replyContentHandleService.handleMsgMediaId(userInfo.getBizId(), userInfo.getCorpId(), contentList);
                respDto.setContentList(contentList);
                respDto.setTitle(replyCorp.getTitle());
                String keyword = replyCorp.getKeyword();
                if (StringUtils.isNotEmpty((CharSequence)keyword)) {
                    List<String> keywords = Arrays.asList(keyword.split(","));
                    respDto.setKeywords(keywords);
                }
                respDto.setCreatorName(replyCorp.getCreator());
                Integer favorite = relationNums.contains(replyCorp.getNum()) ? 1 : 0;
                respDto.setIsFavorite(favorite);
                respDtos.add(respDto);
            }
            return respDtos;
        }
        return null;
    }

    @Override
    public void add(ReplyAddReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("add ReplyAddReqDto: {}, operateId: {}", (Object)reqDto, (Object)userInfo.getId());
        reqDto.validate();
        final ReplyContentEntity entity = new ReplyContentEntity();
        QuickReply reply = new QuickReply();
        reply.setNum(this.idGen.getNum());
        reply.setQuickReplyGroupId(reqDto.getGroupId());
        if (Objects.nonNull(reqDto.getKeywords()) && reqDto.getKeywords().size() > 0) {
            String keywordsStr = Joiner.on((String)",").join(reqDto.getKeywords());
            reply.setKeyword(keywordsStr);
            entity.setKeyword(keywordsStr);
        }
        if (Objects.nonNull(reqDto.getTitle())) {
            reply.setTitle(reqDto.getTitle());
            entity.setTitle(reqDto.getTitle());
        }
        String content = JacksonUtil.obj2Str(reqDto.getContentList());
        reply.setContent(content);
        reply.setBizId(userInfo.getBizId());
        reply.setCreateBy(userInfo.getId());
        reply.setCreateTime(new Date());
        reply.setUpdateTime(new Date());
        reply.setCorpId(userInfo.getCorpId());
        reply.setCreator(userInfo.getName());
        this.mapper.insertSelective((Object)reply);
        entity.setId(reply.getId());
        entity.setGroupId(reqDto.getGroupId());
        entity.setContentList(reqDto.getContentList());
        entity.setIsDelete(0);
        entity.setBizId(userInfo.getBizId());
        entity.setCorpId(userInfo.getCorpId());
        IndexRequest indexRequest = new IndexRequest(this.replyIndex, TYPE, String.valueOf(entity.getId()));
        try {
            indexRequest.source(JacksonUtils.getInstance().writeValueAsString((Object)entity), XContentType.JSON);
        }
        catch (JsonProcessingException e) {
            log.error("\u751f\u6210json\u5931\u8d25", (Throwable)e);
        }
        this.restHighLevelClient.indexAsync(indexRequest, (ActionListener)new ActionListener<IndexResponse>(){

            public void onResponse(IndexResponse indexResponse) {
                log.info("insert success:{}", (Object)entity.getId());
            }

            public void onFailure(Exception e) {
                log.info("insert fail:{}", (Object)entity.getId(), (Object)e);
            }
        }, new Header[0]);
        this.replyContentHandleService.handleMsgMediaId(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getContentList());
    }

    @Override
    public void mod(ReplyModReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mod ReplyModReqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        String keywordsStr = "";
        if (Objects.nonNull(reqDto.getKeywords()) && reqDto.getKeywords().size() > 0) {
            keywordsStr = Joiner.on((String)",").join(reqDto.getKeywords());
        }
        String title = "";
        if (Objects.nonNull(reqDto.getTitle())) {
            title = reqDto.getTitle();
        }
        StopWatchDto timer = new StopWatchDto("quick reply mod", true, log);
        timer.start("mod quick reply");
        String content = JacksonUtil.obj2Str(reqDto.getContentList());
        QuickReplyModDto modDto = new QuickReplyModDto();
        modDto.setNum(reqDto.getId());
        modDto.setGroupId(reqDto.getGroupId());
        modDto.setKeyword(keywordsStr);
        modDto.setContent(content);
        modDto.setUpdateBy(userInfo.getId());
        modDto.setUpdater(userInfo.getName());
        modDto.setTitle(title);
        modDto.setBizId(userInfo.getBizId());
        this.mapper.updateQuickReply(modDto);
        timer.stop();
        QuickReply reply = this.mapper.getIdByNum(reqDto.getId(), userInfo.getBizId());
        if (Objects.nonNull(reply)) {
            Long id = reply.getId();
            timer.start("query reply from es by id");
            ReplyContentEntity entity = this.getReplyFromEsById(id);
            if (Objects.isNull(entity)) {
                entity = new ReplyContentEntity();
                entity.setId(id);
                entity.setBizId(userInfo.getBizId());
                entity.setCorpId(userInfo.getCorpId());
            }
            timer.stop();
            entity.setTitle(title);
            entity.setContentList(reqDto.getContentList());
            entity.setKeyword(keywordsStr);
            entity.setGroupId(reqDto.getGroupId());
            String entityJson = JSON.toJSONString((Object)entity);
            timer.start("update reply of es");
            UpdateRequest request = new UpdateRequest(this.replyIndex, TYPE, String.valueOf(id)).doc(entityJson, XContentType.JSON);
            timer.stop();
            try {
                UpdateResponse response = this.restHighLevelClient.update(request, new Header[0]);
                if (response.getResult() == DocWriteResponse.Result.UPDATED) {
                    log.info("update reply success id: {}", (Object)id);
                } else {
                    log.info("update reply failure id: {}", (Object)id);
                }
            }
            catch (Exception e) {
                log.error("sync ex error: " + e);
            }
        }
        timer.start("get mediaId");
        this.replyContentHandleService.handleMsgMediaId(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getContentList());
        timer.stop();
        timer.print();
    }

    @Override
    public void del(ReplyDelReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("del ReplyDelReqDto: {}, operateId: {},bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        this.mapper.delQuickReply(reqDto.getNums(), userInfo.getId(), userInfo.getName(), userInfo.getBizId());
        BulkRequest bulkRequest = new BulkRequest();
        List replyCorpIds = this.mapper.getReplyListByNums(reqDto.getNums(), userInfo.getBizId());
        if (CollectionUtils.isNotEmpty((Collection)replyCorpIds)) {
            for (Long id : replyCorpIds) {
                ReplyContentEntity entity = this.getReplyFromEsById(id);
                if (!Objects.nonNull(entity)) continue;
                entity.setIsDelete(1);
                String entityJson = JSON.toJSONString((Object)entity);
                UpdateRequest request = new UpdateRequest(this.replyIndex, TYPE, String.valueOf(id)).doc(entityJson, XContentType.JSON);
                bulkRequest.add(request);
            }
        }
        if (bulkRequest.requests().size() > 0) {
            try {
                BulkResponse response = this.restHighLevelClient.bulk(bulkRequest, new Header[0]);
                for (BulkItemResponse itemResponse : response) {
                    if (itemResponse.isFailed()) {
                        log.error("del quickReply to es error:{}", (Object)itemResponse.getId(), (Object)itemResponse.getFailure().getCause());
                        continue;
                    }
                    log.info("del quickReply to es success:{}", (Object)itemResponse.getId());
                }
            }
            catch (IOException e) {
                log.error("del quickReply ex error: " + e);
            }
        }
    }

    @Override
    public void mvList(ReplyMvListReqDto reqDto) {
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        log.info("mvList ReplyMvListReqDto: {}, operateId: {}, bizId: {}", new Object[]{reqDto, userInfo.getId(), userInfo.getBizId()});
        reqDto.validate();
        this.mapper.mvGroup(reqDto.getNums(), reqDto.getGroupId(), userInfo.getId(), userInfo.getName(), userInfo.getBizId());
    }

    private ReplyContentEntity getReplyFromEsById(Long id) {
        BoolQueryBuilder queries = QueryBuilders.boolQuery();
        queries.must((QueryBuilder)QueryBuilders.termQuery((String)"id", (Object)id));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query((QueryBuilder)queries);
        SearchRequest request = new SearchRequest(new String[]{this.replyIndex});
        request.types(new String[]{TYPE});
        request.source(searchSourceBuilder);
        SearchResponse response = null;
        try {
            response = this.restHighLevelClient.search(request, new Header[0]);
        }
        catch (IOException e) {
            log.error("Search query reply failed, searchRequest={}", (Object)request, (Object)e);
        }
        if (Objects.isNull(response)) {
            return null;
        }
        SearchHits hits = response.getHits();
        SearchHit[] searchHits = hits.getHits();
        if (searchHits.length > 0) {
            SearchHit hit = searchHits[0];
            String sourceStr = hit.getSourceAsString();
            return (ReplyContentEntity)JSON.parseObject((String)sourceStr, ReplyContentEntity.class);
        }
        return null;
    }
}

