/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.service.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.quickreply.dto.PersonReplyQueryParams;
import com.kuaike.scrm.dal.quickreply.entity.PersonQuickReply;
import com.kuaike.scrm.dal.quickreply.entity.PersonQuickReplyKeywordRelation;
import com.kuaike.scrm.dal.quickreply.entity.PersonQuickReplyOrg;
import com.kuaike.scrm.dal.quickreply.entity.QuickReplyRelation;
import com.kuaike.scrm.dal.quickreply.mapper.PersonQuickReplyKeywordRelationMapper;
import com.kuaike.scrm.dal.quickreply.mapper.PersonQuickReplyMapper;
import com.kuaike.scrm.dal.quickreply.mapper.PersonQuickReplyOrgMapper;
import com.kuaike.scrm.dal.quickreply.mapper.QuickReplyRelationMapper;
import com.kuaike.scrm.reply.dto.request.PersonAddReqDto;
import com.kuaike.scrm.reply.dto.request.PersonDelReqDto;
import com.kuaike.scrm.reply.dto.request.PersonGroupModReqDto;
import com.kuaike.scrm.reply.dto.request.PersonListReqDto;
import com.kuaike.scrm.reply.dto.request.PersonModReqDto;
import com.kuaike.scrm.reply.dto.response.PersonGroupListRespDto;
import com.kuaike.scrm.reply.dto.response.PersonListRespDto;
import com.kuaike.scrm.reply.service.PersonReplyService;
import com.kuaike.scrm.reply.service.ReplyContentHandleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PersonReplyServiceImpl
implements PersonReplyService {
    private static final Logger log = LoggerFactory.getLogger(PersonReplyServiceImpl.class);
    @Autowired
    private IdGen idGen;
    @Autowired
    private PersonQuickReplyMapper personQuickReplyMapper;
    @Autowired
    private PersonQuickReplyOrgMapper personQuickReplyOrgMapper;
    @Autowired
    private PersonQuickReplyKeywordRelationMapper relationMapper;
    @Autowired
    private QuickReplyRelationMapper quickReplyRelationMapper;
    @Autowired
    private ReplyContentHandleService replyContentHandleService;

    @Override
    public List<PersonGroupListRespDto> listGroup() {
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("listGroup: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        List personQuickReplyOrgs = this.personQuickReplyOrgMapper.queryByUserId(userInfo.getCorpId(), userInfo.getId());
        if (CollectionUtils.isEmpty((Collection)personQuickReplyOrgs)) {
            log.info("listGroup: \u67e5\u8be2\u65e0\u5206\u7ec4\uff0cuserId:{}", (Object)userInfo.getId());
            return Collections.emptyList();
        }
        ArrayList respDtos = Lists.newArrayList();
        for (PersonQuickReplyOrg org : personQuickReplyOrgs) {
            PersonGroupListRespDto respDto = new PersonGroupListRespDto();
            respDto.setGroupName(org.getGroupName());
            respDto.setOrder(org.getOrder());
            respDto.setGroupId(org.getId());
            respDto.setIsDefault(org.getIsDefault());
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrModGroup(List<PersonGroupModReqDto> reqDtoList) {
        log.info("addOrModGroup reqDtoList:{}", (Object)JSON.toJSONString(reqDtoList));
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("addOrModGroup: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        this.validate(reqDtoList);
        Map<Long, PersonGroupModReqDto> dtoMap = reqDtoList.stream().collect(Collectors.toMap(PersonGroupModReqDto::getGroupId, a -> a, (k1, k2) -> k2));
        List personQuickReplyOrgs = this.personQuickReplyOrgMapper.queryByUserId(userInfo.getCorpId(), userInfo.getId());
        Map<Long, PersonQuickReplyOrg> replyOrgMap = personQuickReplyOrgs.stream().collect(Collectors.toMap(PersonQuickReplyOrg::getId, a -> a, (k1, k2) -> k2));
        Map<String, PersonQuickReplyOrg> replyOrgNameMap = personQuickReplyOrgs.stream().collect(Collectors.toMap(PersonQuickReplyOrg::getGroupName, a -> a, (k1, k2) -> k2));
        ArrayList insertList = Lists.newArrayList();
        ArrayList updateList = Lists.newArrayList();
        HashSet<Long> deleteList = new HashSet<Long>();
        for (PersonQuickReplyOrg org : personQuickReplyOrgs) {
            if (dtoMap.containsKey(org.getId())) continue;
            deleteList.add(org.getId());
        }
        for (PersonGroupModReqDto dto : reqDtoList) {
            if (replyOrgMap.containsKey(dto.getGroupId())) {
                updateList.add(this.buildReplyOrg(dto, userInfo));
                continue;
            }
            if (!replyOrgNameMap.containsKey(dto.getGroupName())) {
                insertList.add(this.buildReplyOrg(dto, userInfo));
                continue;
            }
            log.warn("addOrModGroup: \u5206\u7ec4\u540d\u5df2\u5b58\u5728\uff0cgroupName:{},userId:{}", (Object)dto.getGroupName(), (Object)userInfo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)insertList)) {
            this.personQuickReplyOrgMapper.batchInsert((List)insertList);
        }
        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
            this.personQuickReplyOrgMapper.batchUpdate((List)updateList);
        }
        if (CollectionUtils.isNotEmpty(deleteList)) {
            this.personQuickReplyOrgMapper.batchDelete(userInfo.getId(), userInfo.getId(), userInfo.getCorpId(), deleteList);
        }
    }

    @Override
    public List<PersonListRespDto> list(PersonListReqDto reqDto) {
        List relations;
        log.info("list: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("list: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        PersonReplyQueryParams params = reqDto.convertToQueryCondition(userInfo.getId(), userInfo.getCorpId(), reqDto.getGroupId(), reqDto.getQuery());
        List personQuickReplys = this.personQuickReplyMapper.queryListByCondition(params);
        int count = this.personQuickReplyMapper.getCountByCondition(params);
        if (CollectionUtils.isEmpty((Collection)personQuickReplys) && CollectionUtils.isNotEmpty((Collection)(relations = this.relationMapper.queryListByCondition(params)))) {
            count = this.relationMapper.getCountByKeyword(params);
            log.info("list: \u5173\u952e\u8bcd\u641c\u7d22 count :{}", (Object)count);
            Set replyIds = relations.stream().map(PersonQuickReplyKeywordRelation::getPersonReplyId).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(replyIds)) {
                log.info("list: \u5173\u952e\u8bcd\u641c\u7d22 replyIds.size :{} ", (Object)replyIds.size());
                personQuickReplys = this.personQuickReplyMapper.getListByIds(replyIds, userInfo.getId(), userInfo.getCorpId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)personQuickReplys)) {
            log.warn("list: \u6839\u636e\u67e5\u8be2\u6761\u4ef6:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)params);
            return Collections.emptyList();
        }
        if (Objects.nonNull(reqDto.getPageDto())) {
            reqDto.getPageDto().setCount(Integer.valueOf(count));
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(personQuickReplys.size()));
        }
        ArrayList respDtos = Lists.newArrayList();
        for (PersonQuickReply reply : personQuickReplys) {
            PersonListRespDto respDto = new PersonListRespDto();
            respDto.setCount(reply.getCount());
            List<UniformMsgDto> contentList = this.replyContentHandleService.getMsgList(reply.getContent());
            this.replyContentHandleService.handleMsgMediaId(userInfo.getBizId(), userInfo.getCorpId(), contentList);
            respDto.setContentList(contentList);
            respDto.setTitle(reply.getTitle());
            respDto.setLastTime(reply.getLastTime());
            respDto.setNum(reply.getNum());
            respDto.setGroupId(reply.getGroupId());
            respDto.setIsTop(reply.getIsTop());
            List relations2 = this.relationMapper.queryByReplyId(reply.getId(), userInfo.getCorpId(), userInfo.getId());
            if (CollectionUtils.isNotEmpty((Collection)relations2)) {
                HashSet keywords = Sets.newHashSet();
                for (PersonQuickReplyKeywordRelation relation : relations2) {
                    keywords.add(relation.getKeyword());
                }
                respDto.setKeywords(keywords);
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(PersonAddReqDto reqDto) {
        log.info("add: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("add: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        String content = JacksonUtil.obj2Str(reqDto.getContentList());
        boolean isExist = this.personQuickReplyMapper.checkContentIsExist(content, reqDto.getGroupId(), userInfo.getId(), userInfo.getCorpId());
        Preconditions.checkArgument((!isExist ? 1 : 0) != 0, (Object)"\u8be5\u5206\u7ec4\u4e0b\u8bdd\u672f\u5185\u5bb9\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        PersonQuickReply reply = this.buildReply(reqDto, userInfo);
        try {
            this.personQuickReplyMapper.insertReply(reply);
            log.info("add: \u63d2\u5165\u540e id:{}", (Object)reply.getId());
            if (StringUtils.isNotBlank((CharSequence)reqDto.getCorpReplyNum())) {
                boolean isCorpReplyNumExist = this.quickReplyRelationMapper.checkCorpReplyNumExist(userInfo.getCorpId(), userInfo.getId(), reqDto.getCorpReplyNum());
                log.info("add: isCorpReplyNumExist{} corpReplyNum:{}", (Object)isCorpReplyNumExist, (Object)reqDto.getCorpReplyNum());
                if (!isCorpReplyNumExist) {
                    QuickReplyRelation replyRelation = this.buildReplyRelation(reqDto.getCorpReplyNum(), reply.getNum(), userInfo);
                    this.quickReplyRelationMapper.insertSelective((Object)replyRelation);
                }
            }
            if (CollectionUtils.isNotEmpty(reqDto.getKeywords())) {
                Map<String, PersonQuickReplyKeywordRelation> relationMap = this.relationMapper.queryByReplyId(reply.getId(), userInfo.getCorpId(), userInfo.getId()).stream().collect(Collectors.toMap(PersonQuickReplyKeywordRelation::getKeyword, a -> a, (k1, k2) -> k2));
                ArrayList insertList = Lists.newArrayList();
                for (String keyword : reqDto.getKeywords()) {
                    if (relationMap.containsKey(keyword)) continue;
                    PersonQuickReplyKeywordRelation relation = this.buildKeyword(keyword, reply.getId(), userInfo);
                    insertList.add(relation);
                }
                if (CollectionUtils.isNotEmpty((Collection)insertList)) {
                    this.relationMapper.batchInsert((List)insertList);
                }
            }
        }
        catch (Exception ex) {
            log.error("add:\u65b0\u589e\u4e2a\u4eba\u8bdd\u672f\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u589e\u4e2a\u4eba\u8bdd\u672f\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mod(PersonModReqDto reqDto) {
        log.info("mod: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("mod: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        PersonQuickReply reply = this.personQuickReplyMapper.queryByNum(reqDto.getNum(), userInfo.getId(), userInfo.getCorpId());
        Preconditions.checkArgument((boolean)Objects.nonNull(reply), (Object)"\u552f\u4e00\u6807\u8bc6\u4e0d\u5408\u6cd5");
        log.info("mod: reply:{}", (Object)reply);
        reply.setUpdateBy(userInfo.getId());
        reply.setUpdateTime(new Date());
        if (reqDto.getGroupId().equals(reply.getGroupId())) {
            reply.setCount(Integer.valueOf(reply.getCount() + 1));
            reply.setLastTime(new Date());
        }
        String content = JacksonUtil.obj2Str(reqDto.getContentList());
        reply.setGroupId(reqDto.getGroupId());
        reply.setContent(content);
        reply.setTitle(reqDto.getTitle());
        reply.setIsTop(reqDto.getIsTop());
        reply.setIsDeleted(NumberUtils.INTEGER_ZERO);
        int rowId = this.personQuickReplyMapper.updateByPrimaryKey((Object)reply);
        log.info("mod: rowId:{}", (Object)rowId);
        List relations = this.relationMapper.queryByReplyId(reply.getId(), userInfo.getCorpId(), userInfo.getId());
        if (CollectionUtils.isEmpty(reqDto.getKeywords())) {
            this.relationMapper.updateKeywordByReplyId(reply.getId(), userInfo.getCorpId(), userInfo.getId());
        } else {
            HashSet insertKeywords = Sets.newHashSet();
            HashSet deleteKeywords = Sets.newHashSet();
            for (Object relation : relations) {
                if (reqDto.getKeywords().contains(relation.getKeyword())) continue;
                deleteKeywords.add(relation.getKeyword());
            }
            Map<String, PersonQuickReplyKeywordRelation> replyMap = relations.stream().collect(Collectors.toMap(PersonQuickReplyKeywordRelation::getKeyword, a -> a, (u, v) -> v));
            for (String keyword : reqDto.getKeywords()) {
                if (replyMap.containsKey(keyword)) continue;
                insertKeywords.add(keyword);
            }
            if (CollectionUtils.isNotEmpty((Collection)insertKeywords)) {
                ArrayList insertRelations = Lists.newArrayList();
                for (String keyword : insertKeywords) {
                    PersonQuickReplyKeywordRelation relation = this.buildKeyword(keyword, reply.getId(), userInfo);
                    insertRelations.add(relation);
                }
                if (CollectionUtils.isNotEmpty((Collection)insertRelations)) {
                    this.relationMapper.batchInsert((List)insertRelations);
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)deleteKeywords)) {
                this.relationMapper.batchDelete(reply.getId(), userInfo.getCorpId(), userInfo.getId(), userInfo.getId(), (Set)deleteKeywords);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void del(PersonDelReqDto reqDto) {
        log.info("del: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("del: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        HashSet deletePersonNums = Sets.newHashSet();
        if (StringUtils.isNotBlank((CharSequence)reqDto.getCorpReplyNum())) {
            List personReplyNums = this.quickReplyRelationMapper.queryPersonNumsByCorpNum(userInfo.getCorpId(), userInfo.getId(), reqDto.getCorpReplyNum());
            deletePersonNums.addAll(personReplyNums);
            this.quickReplyRelationMapper.delByCorpReplyNum(userInfo.getCorpId(), userInfo.getId(), userInfo.getId(), reqDto.getCorpReplyNum());
        }
        if (CollectionUtils.isNotEmpty(reqDto.getNums())) {
            deletePersonNums.addAll(reqDto.getNums());
        }
        if (CollectionUtils.isNotEmpty((Collection)deletePersonNums)) {
            Set replyIds;
            List personQuickReplies = this.personQuickReplyMapper.queryByNums((Set)deletePersonNums, userInfo.getId(), userInfo.getCorpId());
            if (CollectionUtils.isNotEmpty((Collection)personQuickReplies) && CollectionUtils.isNotEmpty(replyIds = personQuickReplies.stream().map(PersonQuickReply::getId).collect(Collectors.toSet()))) {
                this.relationMapper.delByReplyIds(replyIds, userInfo.getCorpId(), userInfo.getId(), userInfo.getId());
            }
            this.personQuickReplyMapper.delByNum((Set)deletePersonNums, userInfo.getId(), userInfo.getCorpId(), userInfo.getId());
        }
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private PersonQuickReplyOrg buildReplyOrg(PersonGroupModReqDto reqDto, CurrentUserInfo userInfo) {
        PersonQuickReplyOrg org = new PersonQuickReplyOrg();
        if (Objects.nonNull(reqDto.getGroupId())) {
            org.setId(reqDto.getGroupId());
        }
        org.setUserId(userInfo.getId());
        org.setGroupName(reqDto.getGroupName());
        org.setOrder(reqDto.getOrder());
        org.setCreateBy(userInfo.getId());
        org.setCreateTime(new Date());
        org.setUpdateBy(userInfo.getId());
        org.setUpdateTime(new Date());
        org.setCorpId(userInfo.getCorpId());
        org.setBizId(userInfo.getBizId());
        org.setIsDeleted(NumberUtils.INTEGER_ZERO);
        org.setNum(this.idGen.getNum());
        org.setIsDefault(NumberUtils.INTEGER_ZERO);
        return org;
    }

    private PersonQuickReply buildReply(PersonAddReqDto reqDto, CurrentUserInfo userInfo) {
        PersonQuickReply reply = new PersonQuickReply();
        String content = JacksonUtil.obj2Str(reqDto.getContentList());
        reply.setGroupId(reqDto.getGroupId());
        reply.setContent(content);
        reply.setTitle(reqDto.getTitle());
        reply.setCount(NumberUtils.INTEGER_ZERO);
        reply.setLastTime(new Date());
        reply.setIsTop(NumberUtils.INTEGER_ZERO);
        reply.setUserId(userInfo.getId());
        reply.setCreateBy(userInfo.getId());
        reply.setCreateTime(new Date());
        reply.setUpdateBy(userInfo.getId());
        reply.setUpdateTime(new Date());
        reply.setCorpId(userInfo.getCorpId());
        reply.setBizId(userInfo.getBizId());
        reply.setIsDeleted(NumberUtils.INTEGER_ZERO);
        reply.setNum(this.idGen.getNum());
        return reply;
    }

    private QuickReplyRelation buildReplyRelation(String corpReplyNum, String personReplyNum, CurrentUserInfo userInfo) {
        QuickReplyRelation reply = new QuickReplyRelation();
        reply.setPersonReplyNum(personReplyNum);
        reply.setCorpReplyNum(corpReplyNum);
        reply.setUserId(userInfo.getId());
        reply.setCreateBy(userInfo.getId());
        reply.setCreateTime(new Date());
        reply.setUpdateBy(userInfo.getId());
        reply.setUpdateTime(new Date());
        reply.setCorpId(userInfo.getCorpId());
        reply.setBizId(userInfo.getBizId());
        reply.setIsDeleted(NumberUtils.INTEGER_ZERO);
        reply.setNum(this.idGen.getNum());
        return reply;
    }

    private PersonQuickReplyKeywordRelation buildKeyword(String keyword, Long quickReplyId, CurrentUserInfo userInfo) {
        PersonQuickReplyKeywordRelation relation = new PersonQuickReplyKeywordRelation();
        relation.setKeyword(keyword);
        relation.setPersonReplyId(quickReplyId);
        relation.setUserId(userInfo.getId());
        relation.setCreateBy(userInfo.getId());
        relation.setCreateTime(new Date());
        relation.setUpdateBy(userInfo.getId());
        relation.setUpdateTime(new Date());
        relation.setCorpId(userInfo.getCorpId());
        relation.setBizId(userInfo.getBizId());
        relation.setIsDeleted(NumberUtils.INTEGER_ZERO);
        relation.setNum(this.idGen.getNum());
        return relation;
    }

    private void validate(List<PersonGroupModReqDto> reqDtoList) {
        Preconditions.checkArgument((boolean)Objects.nonNull(reqDtoList), (Object)"\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        if (CollectionUtils.isNotEmpty(reqDtoList)) {
            for (PersonGroupModReqDto dto : reqDtoList) {
                dto.validate();
            }
            Preconditions.checkArgument((reqDtoList.stream().map(PersonGroupModReqDto::getGroupName).collect(Collectors.toSet()).size() >= reqDtoList.size() ? 1 : 0) != 0, (Object)"\u5206\u7ec4\u540d\u4e0d\u80fd\u91cd\u590d");
        }
    }
}

