/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.reply.dto.request;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class PersonAddReqDto {
    private List<String> keywords;
    private Long groupId;
    private List<UniformMsgDto> contentList;
    private String title;
    private String corpReplyNum;

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.groupId), (Object)"\u5206\u7ec4id\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.title), (Object)"\u8bdd\u672f\u6807\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.title.length() <= 50 ? 1 : 0) != 0, (Object)"\u8bdd\u672f\u6807\u9898\u4e0d\u80fd\u5927\u4e8e50\u4e2a\u5b57\u7b26");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"\u8bdd\u672f\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        for (UniformMsgDto msgDto : this.contentList) {
            msgDto.validate();
        }
        if (CollectionUtils.isNotEmpty(this.keywords)) {
            Preconditions.checkArgument((this.keywords.size() <= 10 ? 1 : 0) != 0, (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u8d85\u8fc710\u4e2a");
            for (String keyword : this.keywords) {
                Preconditions.checkArgument((boolean)Objects.nonNull(keyword), (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u4e3anull");
                Preconditions.checkArgument((keyword.length() <= 50 ? 1 : 0) != 0, (Object)"\u5173\u952e\u5b57\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
            }
            HashSet<String> keySet = new HashSet<String>(this.keywords);
            Preconditions.checkArgument((keySet.size() == this.keywords.size() ? 1 : 0) != 0, (Object)"\u5173\u952e\u8bcd\u4e0d\u80fd\u91cd\u590d");
        }
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public Long getGroupId() {
        return this.groupId;
    }

    public List<UniformMsgDto> getContentList() {
        return this.contentList;
    }

    public String getTitle() {
        return this.title;
    }

    public String getCorpReplyNum() {
        return this.corpReplyNum;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public void setGroupId(Long groupId) {
        this.groupId = groupId;
    }

    public void setContentList(List<UniformMsgDto> contentList) {
        this.contentList = contentList;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setCorpReplyNum(String corpReplyNum) {
        this.corpReplyNum = corpReplyNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PersonAddReqDto)) {
            return false;
        }
        PersonAddReqDto other = (PersonAddReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$groupId = this.getGroupId();
        Long other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !((Object)this$groupId).equals(other$groupId)) {
            return false;
        }
        List<String> this$keywords = this.getKeywords();
        List<String> other$keywords = other.getKeywords();
        if (this$keywords == null ? other$keywords != null : !((Object)this$keywords).equals(other$keywords)) {
            return false;
        }
        List<UniformMsgDto> this$contentList = this.getContentList();
        List<UniformMsgDto> other$contentList = other.getContentList();
        if (this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$corpReplyNum = this.getCorpReplyNum();
        String other$corpReplyNum = other.getCorpReplyNum();
        return !(this$corpReplyNum == null ? other$corpReplyNum != null : !this$corpReplyNum.equals(other$corpReplyNum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PersonAddReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : ((Object)$groupId).hashCode());
        List<String> $keywords = this.getKeywords();
        result = result * 59 + ($keywords == null ? 43 : ((Object)$keywords).hashCode());
        List<UniformMsgDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $corpReplyNum = this.getCorpReplyNum();
        result = result * 59 + ($corpReplyNum == null ? 43 : $corpReplyNum.hashCode());
        return result;
    }

    public String toString() {
        return "PersonAddReqDto(keywords=" + this.getKeywords() + ", groupId=" + this.getGroupId() + ", contentList=" + this.getContentList() + ", title=" + this.getTitle() + ", corpReplyNum=" + this.getCorpReplyNum() + ")";
    }
}

