/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class AddRemindReqDto {
    private Integer bizType;
    private Integer remindType;
    private String content;
    private Long fkId;
    private String fkIdStr;
    private Long fkCreateBy;
    private Integer meetingType;
    private List<RemindDetailReqDto> remindDetailReqDtos;
    private Long operatorId;
    private Long bizId;
    private String corpId;

    public AddRemindReqDto() {
    }

    public AddRemindReqDto(Long operatorId, Long bizId, String corpId, Integer bizType, Integer remindType, String content, Long fkId, Long fkCreateBy, Integer meetingType, List<RemindDetailReqDto> remindDetailReqDtos) {
        this.operatorId = operatorId;
        this.bizId = bizId;
        this.corpId = corpId;
        this.bizType = bizType;
        this.remindType = remindType;
        this.content = content;
        this.fkId = fkId;
        this.fkIdStr = "";
        this.fkCreateBy = fkCreateBy;
        this.meetingType = meetingType;
        this.remindDetailReqDtos = remindDetailReqDtos;
    }

    public AddRemindReqDto(Long operatorId, Long bizId, String corpId, Integer bizType, Integer remindType, String content, String fkIdStr, Long fkCreateBy, Integer meetingType, List<RemindDetailReqDto> remindDetailReqDtos) {
        this.operatorId = operatorId;
        this.bizId = bizId;
        this.corpId = corpId;
        this.bizType = bizType;
        this.remindType = remindType;
        this.content = content;
        this.fkId = -1L;
        this.fkIdStr = fkIdStr;
        this.fkId = -1L;
        this.fkCreateBy = fkCreateBy;
        this.meetingType = meetingType;
        this.remindDetailReqDtos = remindDetailReqDtos;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)Objects.nonNull(this.bizType), (Object)"\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.remindType), (Object)"\u63d0\u9192\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.content), (Object)"\u63d0\u9192\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((Objects.nonNull(this.fkId) || StringUtils.isNotBlank((CharSequence)this.fkIdStr) ? 1 : 0) != 0, (Object)"\u4e1a\u52a1\u6570\u636eID\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(this.fkCreateBy), (Object)"\u4e1a\u52a1\u5173\u8054\u8868\u521b\u5efa\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.bizType == 1) {
            Preconditions.checkArgument((boolean)Objects.nonNull(this.meetingType), (Object)"\u4f1a\u8bae\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Preconditions.checkArgument((Objects.nonNull(this.remindDetailReqDtos) && this.remindDetailReqDtos.size() > 0 ? 1 : 0) != 0, (Object)"\u63d0\u9192\u8be6\u60c5\u4e0d\u80fd\u4e3a\u7a7a");
        for (RemindDetailReqDto reqDto : this.remindDetailReqDtos) {
            reqDto.validateParam();
        }
    }

    public Integer getBizType() {
        return this.bizType;
    }

    public Integer getRemindType() {
        return this.remindType;
    }

    public String getContent() {
        return this.content;
    }

    public Long getFkId() {
        return this.fkId;
    }

    public String getFkIdStr() {
        return this.fkIdStr;
    }

    public Long getFkCreateBy() {
        return this.fkCreateBy;
    }

    public Integer getMeetingType() {
        return this.meetingType;
    }

    public List<RemindDetailReqDto> getRemindDetailReqDtos() {
        return this.remindDetailReqDtos;
    }

    public Long getOperatorId() {
        return this.operatorId;
    }

    public Long getBizId() {
        return this.bizId;
    }

    public String getCorpId() {
        return this.corpId;
    }

    public void setBizType(Integer bizType) {
        this.bizType = bizType;
    }

    public void setRemindType(Integer remindType) {
        this.remindType = remindType;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setFkId(Long fkId) {
        this.fkId = fkId;
    }

    public void setFkIdStr(String fkIdStr) {
        this.fkIdStr = fkIdStr;
    }

    public void setFkCreateBy(Long fkCreateBy) {
        this.fkCreateBy = fkCreateBy;
    }

    public void setMeetingType(Integer meetingType) {
        this.meetingType = meetingType;
    }

    public void setRemindDetailReqDtos(List<RemindDetailReqDto> remindDetailReqDtos) {
        this.remindDetailReqDtos = remindDetailReqDtos;
    }

    public void setOperatorId(Long operatorId) {
        this.operatorId = operatorId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public void setCorpId(String corpId) {
        this.corpId = corpId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRemindReqDto)) {
            return false;
        }
        AddRemindReqDto other = (AddRemindReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$bizType = this.getBizType();
        Integer other$bizType = other.getBizType();
        if (this$bizType == null ? other$bizType != null : !((Object)this$bizType).equals(other$bizType)) {
            return false;
        }
        Integer this$remindType = this.getRemindType();
        Integer other$remindType = other.getRemindType();
        if (this$remindType == null ? other$remindType != null : !((Object)this$remindType).equals(other$remindType)) {
            return false;
        }
        Long this$fkId = this.getFkId();
        Long other$fkId = other.getFkId();
        if (this$fkId == null ? other$fkId != null : !((Object)this$fkId).equals(other$fkId)) {
            return false;
        }
        Long this$fkCreateBy = this.getFkCreateBy();
        Long other$fkCreateBy = other.getFkCreateBy();
        if (this$fkCreateBy == null ? other$fkCreateBy != null : !((Object)this$fkCreateBy).equals(other$fkCreateBy)) {
            return false;
        }
        Integer this$meetingType = this.getMeetingType();
        Integer other$meetingType = other.getMeetingType();
        if (this$meetingType == null ? other$meetingType != null : !((Object)this$meetingType).equals(other$meetingType)) {
            return false;
        }
        Long this$operatorId = this.getOperatorId();
        Long other$operatorId = other.getOperatorId();
        if (this$operatorId == null ? other$operatorId != null : !((Object)this$operatorId).equals(other$operatorId)) {
            return false;
        }
        Long this$bizId = this.getBizId();
        Long other$bizId = other.getBizId();
        if (this$bizId == null ? other$bizId != null : !((Object)this$bizId).equals(other$bizId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$fkIdStr = this.getFkIdStr();
        String other$fkIdStr = other.getFkIdStr();
        if (this$fkIdStr == null ? other$fkIdStr != null : !this$fkIdStr.equals(other$fkIdStr)) {
            return false;
        }
        List<RemindDetailReqDto> this$remindDetailReqDtos = this.getRemindDetailReqDtos();
        List<RemindDetailReqDto> other$remindDetailReqDtos = other.getRemindDetailReqDtos();
        if (this$remindDetailReqDtos == null ? other$remindDetailReqDtos != null : !((Object)this$remindDetailReqDtos).equals(other$remindDetailReqDtos)) {
            return false;
        }
        String this$corpId = this.getCorpId();
        String other$corpId = other.getCorpId();
        return !(this$corpId == null ? other$corpId != null : !this$corpId.equals(other$corpId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddRemindReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $bizType = this.getBizType();
        result = result * 59 + ($bizType == null ? 43 : ((Object)$bizType).hashCode());
        Integer $remindType = this.getRemindType();
        result = result * 59 + ($remindType == null ? 43 : ((Object)$remindType).hashCode());
        Long $fkId = this.getFkId();
        result = result * 59 + ($fkId == null ? 43 : ((Object)$fkId).hashCode());
        Long $fkCreateBy = this.getFkCreateBy();
        result = result * 59 + ($fkCreateBy == null ? 43 : ((Object)$fkCreateBy).hashCode());
        Integer $meetingType = this.getMeetingType();
        result = result * 59 + ($meetingType == null ? 43 : ((Object)$meetingType).hashCode());
        Long $operatorId = this.getOperatorId();
        result = result * 59 + ($operatorId == null ? 43 : ((Object)$operatorId).hashCode());
        Long $bizId = this.getBizId();
        result = result * 59 + ($bizId == null ? 43 : ((Object)$bizId).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $fkIdStr = this.getFkIdStr();
        result = result * 59 + ($fkIdStr == null ? 43 : $fkIdStr.hashCode());
        List<RemindDetailReqDto> $remindDetailReqDtos = this.getRemindDetailReqDtos();
        result = result * 59 + ($remindDetailReqDtos == null ? 43 : ((Object)$remindDetailReqDtos).hashCode());
        String $corpId = this.getCorpId();
        result = result * 59 + ($corpId == null ? 43 : $corpId.hashCode());
        return result;
    }

    public String toString() {
        return "AddRemindReqDto(bizType=" + this.getBizType() + ", remindType=" + this.getRemindType() + ", content=" + this.getContent() + ", fkId=" + this.getFkId() + ", fkIdStr=" + this.getFkIdStr() + ", fkCreateBy=" + this.getFkCreateBy() + ", meetingType=" + this.getMeetingType() + ", remindDetailReqDtos=" + this.getRemindDetailReqDtos() + ", operatorId=" + this.getOperatorId() + ", bizId=" + this.getBizId() + ", corpId=" + this.getCorpId() + ")";
    }
}

