/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.service.impl;

import cn.kinyun.wework.sdk.entity.msg.Article;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.enums.WeworkNotifyTypeEnums;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.ScrmRemindService;
import com.kuaike.scrm.common.service.dto.LeadsAllocRemindReq;
import com.kuaike.scrm.common.service.dto.RemindMsgDto;
import com.kuaike.scrm.common.service.dto.req.ScrmAddRemindReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmModRemindReqDto;
import com.kuaike.scrm.common.service.dto.req.ScrmRemindDetailReqDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.system.mapper.OrganizationMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkDepartmentUser;
import com.kuaike.scrm.dal.wework.entity.WeworkNotify;
import com.kuaike.scrm.dal.wework.mapper.WeworkDepartmentUserMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkNotifyMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkNotifyWeekDetailMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.remind.dto.LeadsRemindDto;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.ModRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScrmRemindServiceImpl
implements ScrmRemindService {
    private static final Logger log = LoggerFactory.getLogger(ScrmRemindServiceImpl.class);
    @Autowired
    private RemindService remindService;
    @Resource
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private WeworkNotifyMapper weworkNotifyMapper;
    @Autowired
    private WeworkNotifyWeekDetailMapper weworkNotifyWeekDetailMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private OrganizationMapper organizationMapper;
    @Autowired
    private WeworkDepartmentUserMapper weworkDepartmentUserMapper;
    @Value(value="${leads.alloc.remind.picUrl:https://cdn.kinyun.cn/tool/bind-notice-bg.png}")
    private String allocPicUrl;
    @Value(value="${leads.release.remind.picUrl:https://cdn.kinyun.cn/tool/unbind-notice-bg.png}")
    private String releasePicUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String root;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${leads.alloc.remind.link:/bindNotice}")
    private String url;

    public void sendMsg(String corpId, List<String> weworkUserNums, String sendContent) {
        log.info("send remind msg corpId: {}, weworkUserNums: {}, sendContent: {}", new Object[]{corpId, weworkUserNums, sendContent});
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserNums) || StringUtils.isEmpty((CharSequence)sendContent)) {
            return;
        }
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        String target = Joiner.on((String)"|").join((Iterable)weworkUserIds);
        try {
            this.remindService.sendMsg(corpId, target, sendContent);
        }
        catch (Exception e) {
            log.error("send remind msg error: ", (Throwable)e);
        }
    }

    public void sendMsg(String corpId, String target, String sendContent) {
        try {
            this.remindService.sendMsg(corpId, target, sendContent);
        }
        catch (Exception e) {
            log.error("sendMsg: corpId:{}, target:{}, error:{} ", new Object[]{corpId, target, e});
        }
    }

    public void sendNewMsg(String corpId, List<String> weworkUserNums, List<RemindMsgDto> msgDtos) {
        log.info("send remind new msg corpId: {}, weworkUserNums: {}, sendContent: {}", new Object[]{corpId, weworkUserNums, msgDtos});
        if (StringUtils.isEmpty((CharSequence)corpId) || CollectionUtils.isEmpty(weworkUserNums) || CollectionUtils.isEmpty(msgDtos)) {
            return;
        }
        List weworkUserIds = this.weworkUserMapper.queryWeworkUserIdByNums(weworkUserNums);
        String target = Joiner.on((String)"|").join((Iterable)weworkUserIds);
        ArrayList articles = Lists.newArrayListWithCapacity((int)msgDtos.size());
        for (RemindMsgDto msgDto : msgDtos) {
            Article article = new Article();
            article.setUrl(msgDto.getUrl());
            article.setDescription(msgDto.getDescription());
            article.setPicUrl(msgDto.getPicUrl());
            article.setTitle(msgDto.getTitle());
            articles.add(article);
        }
        try {
            this.remindService.sendNewMsg(corpId, target, articles);
        }
        catch (Exception e) {
            log.error("send remind new msg error: ", (Throwable)e);
        }
    }

    public void addRemind(ScrmAddRemindReqDto reqDto) {
        try {
            AddRemindReqDto addRemindReqDto = new AddRemindReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)addRemindReqDto);
            ArrayList targetList = Lists.newArrayList();
            for (ScrmRemindDetailReqDto dto : reqDto.getRemindDetailReqDtos()) {
                RemindDetailReqDto targetDto = new RemindDetailReqDto();
                BeanUtils.copyProperties((Object)dto, (Object)targetDto);
                targetList.add(targetDto);
            }
            addRemindReqDto.setRemindDetailReqDtos(targetList);
            this.remindService.addRemind(addRemindReqDto);
        }
        catch (Exception e) {
            log.error("addRemind: reqDto:{}, error:{} ", (Object)reqDto, (Object)e);
        }
    }

    public void modRemind(ScrmModRemindReqDto reqDto) {
        try {
            ModRemindReqDto modRemindReqDto = new ModRemindReqDto();
            BeanUtils.copyProperties((Object)reqDto, (Object)modRemindReqDto);
            ArrayList targetList = Lists.newArrayList();
            for (ScrmRemindDetailReqDto dto : reqDto.getRemindDetailReqDtos()) {
                RemindDetailReqDto targetDto = new RemindDetailReqDto();
                BeanUtils.copyProperties((Object)dto, (Object)targetDto);
                targetList.add(targetDto);
            }
            modRemindReqDto.setRemindDetailReqDtos(targetList);
            this.remindService.modRemind(modRemindReqDto);
        }
        catch (Exception e) {
            log.error("modRemind: reqDto:{}, error:{} ", (Object)reqDto, (Object)e);
        }
    }

    public void leadsAllocRemind(LeadsAllocRemindReq req) {
        log.info("leads alloc remind req: {}", (Object)req);
        if (req == null) {
            return;
        }
        req.validate();
        if (this.needNotify(req)) {
            LeadsRemindDto leadsRemindDto = new LeadsRemindDto();
            leadsRemindDto.setNotifyType(req.getNotifyType());
            leadsRemindDto.setLeadsCount(req.getLeadsCount());
            String content = leadsRemindDto.buildRemindMsg();
            String pageUrl = this.url + "?notifyType=" + req.getNotifyType() + "&weworkUserNum=" + req.getWeworkUserNum() + "&batchNo=" + req.getBatchNo() + "&corpId=" + req.getCorpId();
            pageUrl = this.wrapCrmLeadsRemindUrl(this.root, req.getCorpId(), pageUrl);
            String picUrl = this.allocPicUrl;
            String title = "\u7ebf\u7d22\u5206\u914d\u901a\u77e5";
            if (leadsRemindDto.getNotifyType().intValue() == WeworkNotifyTypeEnums.LEADS_UNBIND_NOTIFY.getValue()) {
                picUrl = this.releasePicUrl;
                title = "\u7ebf\u7d22\u89e3\u7ed1\u901a\u77e5";
            }
            Article article = this.remindService.setArticleNews(title, content, pageUrl, picUrl);
            log.info("weworkUserId: {}, article: {}", (Object)req.getWeworkUserId(), (Object)article);
            this.remindService.sendNewMsg(req.getCorpId(), req.getWeworkUserId(), Lists.newArrayList((Object[])new Article[]{article}));
        } else {
            log.info("not match config");
        }
    }

    private String wrapCrmLeadsRemindUrl(String root, String corpId, String redirectUri) {
        log.info("corpId:{}, redirectUri:{}", (Object)corpId, (Object)redirectUri);
        String uri = root + "/dkf/oauth.json";
        String state = redirectUri;
        try {
            uri = URLEncoder.encode(uri, "UTF-8");
            state = URLEncoder.encode(redirectUri, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("url encode failed: {}", (Object)uri, (Object)e);
        }
        return "https://open.weixin.qq.com/connect/oauth2/authorize?appid=" + corpId + "&redirect_uri=" + uri + "&response_type=code&scope=snsapi_base&state=" + state + "#wechat_redirect";
    }

    private boolean needNotify(LeadsAllocRemindReq req) {
        List weworkUserNums;
        int todayOfWeek = DateUtil.getTodayOfWeek();
        String weworkUserNum = req.getWeworkUserNum();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        req.setWeworkUserId(weworkUserId);
        if (StringUtils.isEmpty((CharSequence)weworkUserNum) || StringUtils.isEmpty((CharSequence)weworkUserId)) {
            log.info("send weworkUser is empty");
            return false;
        }
        List weworkNotifyList = this.weworkNotifyMapper.getByWhichWeekday(req.getBizId(), req.getNotifyType(), (Collection)Lists.newArrayList((Object[])new Integer[]{todayOfWeek}));
        if (CollectionUtils.isEmpty((Collection)weworkNotifyList)) {
            log.info("notify config is empty");
            return false;
        }
        WeworkNotify weworkNotify = (WeworkNotify)weworkNotifyList.get(0);
        req.setCorpId(weworkNotify.getCorpId());
        log.info("wework notify: {}", (Object)JacksonUtil.obj2Str((Object)weworkNotify));
        String times = weworkNotify.getNotifyTime();
        if (StringUtils.isBlank((CharSequence)times)) {
            log.info("notify times is empty ");
            return false;
        }
        List timeList = Splitter.on((String)",").splitToList((CharSequence)times);
        if (CollectionUtils.isEmpty((Collection)timeList) || timeList.size() != 2) {
            log.info("notify config times not valid");
            return false;
        }
        Date curTime = new Date();
        Date startTime = DateUtil.stringTimeToDate((String)((String)timeList.get(0)), (Date)curTime);
        Date endTime = DateUtil.stringTimeToDate((String)((String)timeList.get(1)), (Date)curTime);
        if (curTime.before(startTime) || curTime.after(endTime)) {
            log.info("curTime not match notify config times: {}", (Object)times);
            return false;
        }
        String userIds = weworkNotify.getUserIds();
        if (StringUtils.isNotBlank((CharSequence)userIds) && "all".equals(userIds)) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)userIds) && "-1".equals(userIds)) {
            List adminUsers = this.userMapper.getUserInfo(req.getBizId(), YnEnum.YES.getValue(), (Collection)Lists.newArrayList((Object[])new String[]{weworkUserNum}));
            if (CollectionUtils.isEmpty((Collection)adminUsers)) {
                log.info("user not match");
                return false;
            }
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)weworkNotify.getDepIds())) {
            List orgNums = Splitter.on((String)",").splitToList((CharSequence)weworkNotify.getDepIds());
            Map idByNums = this.nodeService.getIdByNums(req.getBizId(), (Collection)orgNums);
            HashSet nodeIds = Sets.newHashSet(idByNums.values());
            Set deptIds = this.organizationMapper.queryDepartmentIds((Collection)nodeIds);
            List weworkDepartmentUsers = this.weworkDepartmentUserMapper.selectExistDepartmentUser(weworkNotify.getCorpId(), weworkUserId);
            if (CollectionUtils.isEmpty((Collection)weworkDepartmentUsers)) {
                log.info("weworkUserNum dept is empty: {}", (Object)weworkUserNum);
                return false;
            }
            Set userDeptIds = weworkDepartmentUsers.stream().map(WeworkDepartmentUser::getDepartmentId).collect(Collectors.toSet());
            if (CollectionUtils.containsAny((Collection)deptIds, userDeptIds)) {
                return true;
            }
        }
        if (StringUtils.isNotBlank((CharSequence)weworkNotify.getUserIds()) && (weworkUserNums = Splitter.on((String)",").splitToList((CharSequence)weworkNotify.getUserIds())).contains(weworkUserNum)) {
            log.info("weworkUserNum match: {}", (Object)weworkUserNum);
            return true;
        }
        return false;
    }
}

