/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.service.impl;

import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.remind.dto.req.ApprovalRemindDto;
import com.kuaike.scrm.remind.dto.req.PaySuccessRemindDto;
import com.kuaike.scrm.remind.dto.req.PayTimeOutRemindDto;
import com.kuaike.scrm.remind.dto.req.RefundSuccessRemindDto;
import com.kuaike.scrm.remind.service.OrderRemindService;
import com.kuaike.scrm.remind.service.RemindService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OrderRemindServiceImpl
implements OrderRemindService {
    private static final Logger log = LoggerFactory.getLogger(OrderRemindServiceImpl.class);
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}")
    private String hostUrl;
    @Value(value="${scrm.approval-page.url}")
    private String approvalPageUrl;
    @Autowired
    private RemindService remindService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;

    @Override
    public void approvalRemind(ApprovalRemindDto req) {
        req.validate();
        req.buildContent();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(req.getWeworkUserNum());
        String url = this.hostUrl + this.approvalPageUrl + "?weworkUserNum=" + req.getWeworkUserNum() + "&refundOrderNum=" + req.getRefundOrderNum();
        String msgContent = req.getContent().replace("${approvalUrl}", url);
        log.info("approval remind msg corpId: {}, weworkUserId: {}, content: {}", new Object[]{req.getCorpId(), weworkUserId, msgContent});
        this.remindService.sendMsg(req.getCorpId(), weworkUserId, msgContent);
    }

    @Override
    public void payRemind(PayTimeOutRemindDto req) {
        req.validate();
        req.buildContent();
        String weworkUserNum = req.getWeworkUserNum();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        log.info("pay timeout remind msg corpId: {}, weworkUserId: {}, content: {}", new Object[]{req.getCorpId(), weworkUserId, req.getContent()});
        this.remindService.sendMsg(req.getCorpId(), weworkUserId, req.getContent());
    }

    @Override
    public void paySuccessRemind(PaySuccessRemindDto req) {
        req.validate();
        req.buildContent();
        String weworkUserNum = req.getWeworkUserNum();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        log.info("pay success remind msg corpId: {}, weworkUserId: {}, content: {}", new Object[]{req.getCorpId(), weworkUserId, req.getContent()});
        this.remindService.sendMsg(req.getCorpId(), weworkUserId, req.getContent());
    }

    @Override
    public void refundSuccessRemind(RefundSuccessRemindDto req) {
        req.validate();
        req.buildContent();
        String weworkUserNum = req.getWeworkUserNum();
        String weworkUserId = this.weworkUserMapper.queryWeworkUserIdByNum(weworkUserNum);
        log.info("refund success remind msg corpId: {}, weworkUserId: {}, content: {}", new Object[]{req.getCorpId(), weworkUserId, req.getContent()});
        this.remindService.sendMsg(req.getCorpId(), weworkUserId, req.getContent());
    }
}

