/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.remind.dto.req;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.MoneyConverterUtil;
import com.kuaike.scrm.common.utils.TemplateReplaceUtil;
import com.kuaike.scrm.remind.dto.OrderRemindBaseReq;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;

public class PayTimeOutRemindDto
extends OrderRemindBaseReq {
    private String template = "\u3010\u8ba2\u5355\u5f85\u652f\u4ed8\u63d0\u9192\u3011\u60a8\u53d1\u8d77\u7684\u8ba2\u535530\u5206\u949f\u5185\u672a\u5b8c\u6210\u652f\u4ed8\uff0c24\u5c0f\u65f6\u540e\u5c06\u4f1a\u4f5c\u5e9f\u3002\n\u8ba2\u5355\u7f16\u53f7\uff1a${orderNo} \n \u5f85\u652f\u4ed8\uff1a\u00a5${payAmount}\n\u5ba2\u6237\u540d\u79f0\uff1a${customerName}\n \u624b\u673a\u53f7\uff1a${mobile}\n\u4e0b\u5355\u65f6\u95f4\uff1a${orderTime}";
    private String content;
    private String orderNo;
    private Long payAmount;
    private String customerName;
    private String mobile;
    private Date orderTime;

    public void buildContent() {
        ConcurrentMap paramsMap = Maps.newConcurrentMap();
        paramsMap.put("${orderNo}", this.orderNo);
        String payAmountStr = MoneyConverterUtil.liToStr((Long)this.payAmount);
        paramsMap.put("${payAmount}", payAmountStr);
        paramsMap.put("${customerName}", StringUtils.isNotBlank((CharSequence)this.customerName) ? this.customerName : "");
        paramsMap.put("${mobile}", StringUtils.isNotBlank((CharSequence)this.mobile) ? this.mobile : "");
        paramsMap.put("${orderTime}", DateUtil.dateToDateString((Date)this.orderTime));
        this.content = TemplateReplaceUtil.render((String)this.template, (Map)paramsMap);
    }

    @Override
    public void validate() {
        super.validate();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.orderNo), (Object)"\u8ba2\u5355\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((this.payAmount != null ? 1 : 0) != 0, (Object)"\u4ed8\u6b3e\u91d1\u989d\u4e0d\u80fd\u4e3anull");
    }

    public String getTemplate() {
        return this.template;
    }

    public String getContent() {
        return this.content;
    }

    public String getOrderNo() {
        return this.orderNo;
    }

    public Long getPayAmount() {
        return this.payAmount;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public String getMobile() {
        return this.mobile;
    }

    public Date getOrderTime() {
        return this.orderTime;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public void setPayAmount(Long payAmount) {
        this.payAmount = payAmount;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PayTimeOutRemindDto)) {
            return false;
        }
        PayTimeOutRemindDto other = (PayTimeOutRemindDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$payAmount = this.getPayAmount();
        Long other$payAmount = other.getPayAmount();
        if (this$payAmount == null ? other$payAmount != null : !((Object)this$payAmount).equals(other$payAmount)) {
            return false;
        }
        String this$template = this.getTemplate();
        String other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$orderNo = this.getOrderNo();
        String other$orderNo = other.getOrderNo();
        if (this$orderNo == null ? other$orderNo != null : !this$orderNo.equals(other$orderNo)) {
            return false;
        }
        String this$customerName = this.getCustomerName();
        String other$customerName = other.getCustomerName();
        if (this$customerName == null ? other$customerName != null : !this$customerName.equals(other$customerName)) {
            return false;
        }
        String this$mobile = this.getMobile();
        String other$mobile = other.getMobile();
        if (this$mobile == null ? other$mobile != null : !this$mobile.equals(other$mobile)) {
            return false;
        }
        Date this$orderTime = this.getOrderTime();
        Date other$orderTime = other.getOrderTime();
        return !(this$orderTime == null ? other$orderTime != null : !((Object)this$orderTime).equals(other$orderTime));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof PayTimeOutRemindDto;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $payAmount = this.getPayAmount();
        result = result * 59 + ($payAmount == null ? 43 : ((Object)$payAmount).hashCode());
        String $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $orderNo = this.getOrderNo();
        result = result * 59 + ($orderNo == null ? 43 : $orderNo.hashCode());
        String $customerName = this.getCustomerName();
        result = result * 59 + ($customerName == null ? 43 : $customerName.hashCode());
        String $mobile = this.getMobile();
        result = result * 59 + ($mobile == null ? 43 : $mobile.hashCode());
        Date $orderTime = this.getOrderTime();
        result = result * 59 + ($orderTime == null ? 43 : ((Object)$orderTime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "PayTimeOutRemindDto(template=" + this.getTemplate() + ", content=" + this.getContent() + ", orderNo=" + this.getOrderNo() + ", payAmount=" + this.getPayAmount() + ", customerName=" + this.getCustomerName() + ", mobile=" + this.getMobile() + ", orderTime=" + this.getOrderTime() + ")";
    }
}

