/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.hutool.core.util.IdUtil;
import cn.kinyun.customer.center.dto.ApprovalMsgDto;
import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.req.order.RefundOrderReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderPayStatusReq;
import cn.kinyun.customer.center.dto.req.order.SetOrderRefundInfoReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.enums.electricity.PayOrderStatusEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.customer.center.service.CcCustomerRefundOrderService;
import cn.kinyun.pay.business.component.PayCertBackgroundService;
import cn.kinyun.pay.business.dto.request.OrderQuerySimpleRequest;
import cn.kinyun.pay.business.dto.request.RefundRequest;
import cn.kinyun.pay.business.dto.request.TransRequest;
import cn.kinyun.pay.business.dto.request.trans.AliPayAccount;
import cn.kinyun.pay.business.dto.request.trans.BaseAccountInfo;
import cn.kinyun.pay.business.dto.request.trans.TransTargetInfoReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.OrderQueryData;
import cn.kinyun.pay.business.dto.vo.PayMessageDto;
import cn.kinyun.pay.business.dto.vo.RefundDetailDto;
import cn.kinyun.pay.business.dto.vo.TransDetailDto;
import cn.kinyun.pay.business.enums.PayEventType;
import cn.kinyun.pay.business.enums.PayTransChannelType;
import cn.kinyun.pay.business.enums.SourceType;
import cn.kinyun.pay.business.event.PayEvent;
import cn.kinyun.pay.business.service.PayOrderService;
import cn.kinyun.pay.business.service.PayRefundService;
import cn.kinyun.pay.business.service.PayTransService;
import cn.kinyun.scrm.payconfig.dto.req.OrderRefundReq;
import cn.kinyun.scrm.payconfig.service.OrderPayService;
import cn.kinyun.scrm.payconfig.service.OrderRefundService;
import cn.kinyun.scrm.payconfig.service.impl.PayConfigServiceImpl;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.service.ScrmBizService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.resp.BizSimpleDto;
import com.kuaike.scrm.common.utils.MoneyConverterUtil;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import com.kuaike.scrm.remind.dto.req.ApprovalRemindDto;
import com.kuaike.scrm.remind.dto.req.RefundSuccessRemindDto;
import com.kuaike.scrm.remind.service.OrderRemindService;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderRefundServiceImpl
implements OrderRefundService {
    private static final Logger log = LoggerFactory.getLogger(OrderRefundServiceImpl.class);
    @Autowired
    private PayRefundService payRefundService;
    @Autowired
    private PayTransService payTransService;
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private PayCertBackgroundService payCertBackgroundService;
    @Autowired
    private PayConfigServiceImpl payConfigService;
    @Autowired
    private ScrmBizService scrmBizService;
    @Autowired
    private CcCustomerRefundOrderService ccCustomerRefundOrderService;
    @Autowired
    private OrderRemindService orderRemindService;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private PayOrderService payOrderService;
    @Autowired
    private PayRecordMapper payRecordMapper;
    @Autowired
    private OrderPayService orderPayService;

    @Override
    public void refundApprovalRemind(ApprovalMsgDto msgDto) {
        ApprovalRemindDto remindDto = new ApprovalRemindDto();
        remindDto.setBizId(msgDto.getBizId());
        String corpId = this.scrmBizService.getById(msgDto.getBizId()).getCorpId();
        remindDto.setCorpId(corpId);
        remindDto.setRefundOrderNum(msgDto.getRefundNum());
        String weworkUserNum = this.scrmUserService.getWeworkUserNumByUserId(msgDto.getApprovalUserId());
        remindDto.setWeworkUserNum(weworkUserNum);
        Map nameByIds = this.scrmUserService.getNameByIds((Collection)Lists.newArrayList((Object[])new Long[]{msgDto.getOpUserId()}));
        if (MapUtils.isNotEmpty((Map)nameByIds)) {
            remindDto.setUserName(nameByIds.getOrDefault(msgDto.getOpUserId(), ""));
        }
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        orderListReq.setBizId(msgDto.getBizId());
        orderListReq.setOrderNo(msgDto.getOrderNo());
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(orderListReq);
        OrderListResp orderResp = null;
        if (CollectionUtils.isNotEmpty((Collection)pageOrderListResp.getList())) {
            orderResp = (OrderListResp)pageOrderListResp.getList().get(0);
        }
        if (orderResp != null) {
            remindDto.setCustomerName(orderResp.getCustomerName());
            if (CollectionUtils.isNotEmpty((Collection)orderResp.getSkuNames())) {
                String skuNames = Joiner.on((String)",").join((Iterable)orderResp.getSkuNames());
                remindDto.setSkuNames(skuNames);
            }
        }
        remindDto.setRefundAmount(msgDto.getRefundAmount());
        this.orderRemindService.approvalRemind(remindDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse refund(OrderRefundReq req) {
        log.info("order refund  req={}", (Object)req);
        req.validate();
        BaseResponse response = null;
        if (req.getRefundType().intValue() == RefundTypeEnum.WAY_BACK.getValue()) {
            RefundRequest request = this.buildRefundRequest(req);
            boolean isSave = this.saveRefundRecord(req, request.getRequestId());
            if (!isSave) {
                log.info("refund record is exist refundNum: {}", (Object)req.getRefundNo());
                return response;
            }
            log.info("refund request: {}", (Object)JacksonUtil.obj2Str((Object)request));
            response = this.payRefundService.refund(request);
        } else if (req.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue()) {
            if (req.getUpdateTransferAccount().booleanValue()) {
                TransTargetInfoReq targetInfoReq = this.buildTransTargetRequest(req);
                log.info("update trans target info params: {}", (Object)targetInfoReq);
                response = this.payRefundService.updateTransTargetInfo(targetInfoReq);
                if (response != null && response.isSuccess()) {
                    RefundOrderReq refundOrderReq = new RefundOrderReq();
                    refundOrderReq.setBizId(req.getBizId());
                    refundOrderReq.setRefundNo(req.getRefundNo());
                    refundOrderReq.setRefundFailReason("");
                    this.ccCustomerRefundOrderService.setRefundRecord(refundOrderReq);
                }
            } else {
                TransRequest transRequest = this.buildTransferRequest(req);
                boolean isSave = this.saveRefundRecord(req, transRequest.getRequestId());
                if (!isSave) {
                    log.info("refund record is exist refundNum: {}", (Object)req.getRefundNo());
                    return response;
                }
                log.info("refund trans request: {}", (Object)JacksonUtil.obj2Str((Object)transRequest));
                response = this.payTransService.trans(transRequest);
            }
        }
        log.info("order refund response: {}", response);
        return response;
    }

    private String getPayAppId(OrderRefundReq req) {
        String appId = null;
        if (req.getRefundType().intValue() == RefundTypeEnum.WAY_BACK.getValue()) {
            String bizOrderNo = req.getOrderNo();
            PayRecord payRecord = this.payRecordMapper.queryLatestPayRecordByOrderNo(bizOrderNo);
            OrderQuerySimpleRequest orderRequest = new OrderQuerySimpleRequest();
            orderRequest.setOrderNum(payRecord.getPayTradeNum());
            BaseResponse orderQueryResp = this.payOrderService.queryOrderSimple(orderRequest);
            if (Objects.isNull(orderQueryResp)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
            }
            log.info("orderQueryResp={}", (Object)JSON.toJSONString((Object)orderQueryResp));
            if (!orderQueryResp.isSuccess()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, orderQueryResp.getMsg());
            }
            appId = ((OrderQueryData)orderQueryResp.getData()).getAppId();
        } else if (req.getRefundType().intValue() == RefundTypeEnum.TRANSFER.getValue()) {
            String corpId = this.scrmBizService.getById(req.getBizId()).getCorpId();
            BaseResponse appIdResp = this.payTransService.queryAvailableAppId(corpId);
            if (Objects.isNull(appIdResp)) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u4e0d\u5230\u8f6c\u8d26\u7684appId");
            }
            if (!appIdResp.isSuccess()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, appIdResp.getMsg());
            }
            log.info("orderQueryResp={}", (Object)JSON.toJSONString((Object)appIdResp));
            appId = (String)appIdResp.getData();
        }
        return appId;
    }

    private RefundRequest buildRefundRequest(OrderRefundReq req) {
        RefundRequest request = new RefundRequest();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(req.getBizId());
        request.setCorpId(bizSimpleDto.getCorpId());
        request.setRequestId(IdUtil.simpleUUID());
        request.setBizOrderNum(req.getOrderNo());
        request.setBizRefundNum(req.getRefundNo());
        request.setAmount(String.valueOf(MoneyConverterUtil.scrmToPayCenter((Long)req.getRefundAmount())));
        request.setRefundReason(req.getRefundReason());
        request.setSourceType(SourceType.SCRM_ORDER_CENTER.getType());
        String sign = this.payCertBackgroundService.getSign((Object)request);
        request.setSign(sign);
        request.validate();
        return request;
    }

    private TransTargetInfoReq buildTransTargetRequest(OrderRefundReq req) {
        TransTargetInfoReq request = new TransTargetInfoReq();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(req.getBizId());
        request.setCorpId(bizSimpleDto.getCorpId());
        request.setRequestId(IdUtil.simpleUUID());
        request.setBizTransNum(req.getRefundNo());
        request.setPayTransType(PayTransChannelType.PAY_TRANS_TYPE_ALILY_TO_ALILY.getValue());
        AliPayAccount aliPayAccount = new AliPayAccount();
        aliPayAccount.setIdentityType(1);
        aliPayAccount.setName(req.getAccountName());
        aliPayAccount.setRecAccNo(req.getAccount());
        request.setAccountInfo(aliPayAccount);
        String sign = this.payCertBackgroundService.getSign((Object)request);
        request.setSign(sign);
        request.validate();
        return request;
    }

    private TransRequest buildTransferRequest(OrderRefundReq req) {
        TransRequest request = new TransRequest();
        BizSimpleDto bizSimpleDto = this.scrmBizService.getById(req.getBizId());
        request.setCorpId(bizSimpleDto.getCorpId());
        request.setRequestId(IdUtil.simpleUUID());
        request.setBizOrderNum(req.getOrderNo());
        request.setBizTransNum(req.getRefundNo());
        request.setAmount(String.valueOf(MoneyConverterUtil.scrmToPayCenter((Long)req.getRefundAmount())));
        request.setRefundReason(req.getRefundReason());
        request.setPayTransType(PayTransChannelType.PAY_TRANS_TYPE_ALILY_TO_ALILY.getValue());
        request.setSourceType(SourceType.SCRM_ORDER_CENTER.getType());
        AliPayAccount aliPayAccount = new AliPayAccount();
        aliPayAccount.setIdentityType(1);
        aliPayAccount.setName(req.getAccountName());
        aliPayAccount.setRecAccNo(req.getAccount());
        request.setAccountInfo((BaseAccountInfo)aliPayAccount);
        String sign = this.payCertBackgroundService.getSign((Object)request);
        request.setSign(sign);
        request.validate();
        return request;
    }

    private boolean saveRefundRecord(OrderRefundReq req, String requestId) {
        Date curTime = new Date();
        PayRefundRecord payRefundRecord = this.payRefundRecordMapper.queryRefundRecords(req.getRefundNo());
        if (payRefundRecord != null) {
            return false;
        }
        PayRefundRecord refundRecord = new PayRefundRecord();
        refundRecord.setBizId(req.getBizId());
        String corpId = this.scrmBizService.getById(req.getBizId()).getCorpId();
        refundRecord.setCorpId(corpId);
        refundRecord.setOrderNum(req.getOrderNo());
        refundRecord.setRequestId(requestId);
        refundRecord.setRefundNum(req.getRefundNo());
        refundRecord.setBankName(req.getBankName());
        refundRecord.setAccountName(req.getAccountName());
        refundRecord.setTransferAccount(req.getAccount());
        refundRecord.setRefundType(Long.valueOf(req.getRefundType().intValue()));
        refundRecord.setRefundAmount(Long.valueOf(req.getRefundAmount() / 100L));
        refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.WAIT_REFUND.getValue()));
        refundRecord.setCreateBy(req.getOpUserId());
        refundRecord.setUpdateBy(req.getOpUserId());
        refundRecord.setCreateTime(curTime);
        refundRecord.setUpdateTime(curTime);
        this.payRefundRecordMapper.insertSelective((Object)refundRecord);
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(req.getOrderNo());
        payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.WAIT_REFUND.getValue()));
        payOrder.setUpdateTime(new Date());
        this.payOrderMapper.updateByPrimaryKey((Object)payOrder);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleRefundMsg(PayMessageDto payMessageDto) {
        String refundNo = payMessageDto.getBizRefundNum();
        PayRefundRecord refundRecord = this.getRefundRecord(refundNo);
        if (refundRecord == null) {
            log.warn("refund records is empty msgDto: {}", (Object)payMessageDto);
            return;
        }
        String refundSerialNos = "";
        String payRefundNum = null;
        try {
            List detailDtos = JacksonUtil.str2List((String)payMessageDto.getBody(), RefundDetailDto.class);
            if (CollectionUtils.isNotEmpty((Collection)detailDtos)) {
                payRefundNum = ((RefundDetailDto)detailDtos.get(0)).getRefundNum();
                refundSerialNos = Joiner.on((String)",").join((Iterable)detailDtos.stream().filter(it -> StringUtils.isNotBlank((CharSequence)it.getOutRefundNum())).map(it -> it.getOutRefundNum()).collect(Collectors.toList()));
            }
        }
        catch (IOException e) {
            log.error("parse payMsg body error: ", (Throwable)e);
            return;
        }
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(refundRecord.getOrderNum());
        String key = "order-center:" + refundRecord.getOrderNum();
        try {
            this.lock.lock(key, 10L, 15L, TimeUnit.SECONDS);
            refundRecord = this.getRefundRecord(refundNo);
            if (Objects.isNull(refundRecord)) {
                log.info("refundRecord is not found, refundNo={}", (Object)refundNo);
                return;
            }
            if (Objects.equals(refundRecord.getRefundStatus(), RefundStatusEnum.REFUNDED.getValue())) {
                log.info("refund msg handed");
                return;
            }
            this.updateRefundRecord(payRefundNum, refundRecord, payOrder, refundNo, refundSerialNos, null);
            this.sendRemindMsg(refundRecord);
        }
        catch (Exception e) {
            log.error("handleOrderPaid with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }

    private void updatePayRecord(PayOrder payOrder, Long orderRefundAmount) {
        PayOrderStatusEnum orderStatus = this.getOrderStatus(orderRefundAmount, payOrder);
        if (orderStatus != null) {
            if (orderStatus.getValue() == PayOrderStatusEnum.PARTIAL_REFUND.getValue()) {
                payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.PART_REFUND.getValue()));
            } else if (orderStatus.getValue() == PayOrderStatusEnum.REFUNDED.getValue()) {
                payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDED.getValue()));
            }
        }
        payOrder.setUpdateTime(new Date());
        payOrder.setPayRefundAmount(orderRefundAmount);
        this.payOrderMapper.updateByPrimaryKey((Object)payOrder);
        this.orderPayService.sendPayOrderChangeMsg(payOrder);
    }

    private void updateCustomerOrderPayStatus(PayOrder payOrder) {
        SetOrderPayStatusReq req = new SetOrderPayStatusReq();
        req.setBizId(payOrder.getBizId());
        req.setOrderNo(payOrder.getOrderNum());
        req.setPaidAmount(MoneyConverterUtil.payCenterToScrm((Long)payOrder.getPayAmount()));
        req.setPayStatus(payOrder.getPayStatus());
        if (payOrder.getRefundStatus().intValue() == RefundStatusEnum.REFUNDED.getValue()) {
            req.setPayStatus(Integer.valueOf(PayStatusEnum.REFUND.getValue()));
            req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.REFUNDED.getValue()));
        } else if (payOrder.getRefundStatus().intValue() == RefundStatusEnum.PART_REFUND.getValue()) {
            req.setOrderStatus(Integer.valueOf(PayOrderStatusEnum.PARTIAL_REFUND.getValue()));
        }
        try {
            log.info("setOrderPayStatus with req={}", (Object)JSON.toJSONString((Object)req));
            this.ccCustomerOrderService.setOrderPayStatus(req);
        }
        catch (Exception e) {
            log.error("setOrderPayStatus with error, req={}", (Object)JSON.toJSONString((Object)req), (Object)e);
        }
    }

    private void updateCustomerOrderRefundStatus(PayOrder payOrder, String refundNo) {
        String orderNo = payOrder.getOrderNum();
        SetOrderRefundInfoReq refundInfoReq = new SetOrderRefundInfoReq();
        refundInfoReq.setOrderNo(orderNo);
        refundInfoReq.setRefundNo(refundNo);
        refundInfoReq.setBizId(payOrder.getBizId());
        refundInfoReq.setRefundAmount(MoneyConverterUtil.payCenterToScrm((Long)payOrder.getPayRefundAmount()));
        refundInfoReq.setRefundStatus(payOrder.getRefundStatus());
        refundInfoReq.setRefundTime(new Date());
        try {
            log.info("setOrderRefundInfo with req={}", (Object)JSON.toJSONString((Object)refundInfoReq));
            this.ccCustomerOrderService.setOrderRefundInfo(refundInfoReq);
        }
        catch (Exception e) {
            log.error("setOrderRefundInfo with error, refundInfoReq={}", (Object)JSON.toJSONString((Object)refundInfoReq), (Object)e);
        }
    }

    private void updateCustomerRefundOrder(PayOrder payOrder, PayRefundRecord refundRecord, String refundSerialNos, String refundFailReason) {
        SetOrderRefundInfoReq setOrderRefundInfoReq = new SetOrderRefundInfoReq();
        try {
            setOrderRefundInfoReq.setRefundNo(refundRecord.getRefundNum());
            setOrderRefundInfoReq.setRefundTime(refundRecord.getUpdateTime());
            setOrderRefundInfoReq.setRefundType(Integer.valueOf(refundRecord.getRefundType().intValue()));
            setOrderRefundInfoReq.setRefundStatus(refundRecord.getRefundStatus());
            setOrderRefundInfoReq.setRefundFailReason(refundFailReason);
            setOrderRefundInfoReq.setOrderNo(payOrder.getOrderNum());
            setOrderRefundInfoReq.setBizId(payOrder.getBizId());
            setOrderRefundInfoReq.setRefundSerialNo(refundSerialNos);
            setOrderRefundInfoReq.setRefundAmount(MoneyConverterUtil.payCenterToScrm((Long)refundRecord.getRefundAmount()));
            log.info("refundOrder with req={}", (Object)JSON.toJSONString((Object)setOrderRefundInfoReq));
            this.ccCustomerOrderService.refundOrder(setOrderRefundInfoReq);
        }
        catch (Exception e) {
            log.error("add customer refund order with error, req={}", (Object)JSON.toJSONString((Object)setOrderRefundInfoReq), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void handTransMsg(PayMessageDto payMessageDto) {
        String refundNo = payMessageDto.getBizTransNum();
        PayRefundRecord refundRecord = this.getRefundRecord(refundNo);
        if (refundRecord == null) {
            log.warn("pay msg bizTransNum is empty, payMsgDto: {}", (Object)payMessageDto);
            return;
        }
        String refundSerialNos = "";
        String payRefundNum = null;
        try {
            TransDetailDto detailDto = (TransDetailDto)JacksonUtil.str2Obj((String)payMessageDto.getBody(), TransDetailDto.class);
            payRefundNum = detailDto.getTransNum();
            refundSerialNos = detailDto.getOutTransNum();
        }
        catch (IOException e) {
            log.error("parse payMsg body error: ", (Throwable)e);
        }
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(refundRecord.getOrderNum());
        String key = "order-center:" + payMessageDto.getBizOrderNum();
        try {
            this.lock.lock(key, 10L, 15L, TimeUnit.SECONDS);
            refundRecord = this.getRefundRecord(refundNo);
            if (Objects.isNull(refundRecord)) {
                log.warn("refundRecord not exist,refundNo:{}", (Object)refundNo);
                return;
            }
            this.updateRefundRecord(payRefundNum, refundRecord, payOrder, refundNo, refundSerialNos, "");
            this.sendRemindMsg(refundRecord);
        }
        catch (Exception e) {
            log.error("handleOrderPaid with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
    }

    private void updateRefundRecord(String payRefundNum, PayRefundRecord refundRecord, PayOrder payOrder, String refundNo, String refundSerialNos, String refundFailReason) {
        if (StringUtils.isNotBlank((CharSequence)payRefundNum)) {
            refundRecord.setPayRefundNum(payRefundNum);
        }
        refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.REFUNDED.getValue()));
        refundRecord.setUpdateTime(new Date());
        this.payRefundRecordMapper.updateByPrimaryKey((Object)refundRecord);
        Long orderRefundAmount = this.getOrderRefundAmount(refundRecord.getOrderNum());
        this.updatePayRecord(payOrder, orderRefundAmount);
        this.updateCustomerOrderPayStatus(payOrder);
        this.updateCustomerOrderRefundStatus(payOrder, refundNo);
        this.updateCustomerRefundOrder(payOrder, refundRecord, refundSerialNos, refundFailReason);
    }

    private Long getOrderRefundAmount(String orderNo) {
        Long orderRefundAmount = this.payRefundRecordMapper.sumOrderRefundAmount(orderNo);
        if (orderRefundAmount == null) {
            orderRefundAmount = 0L;
        }
        return orderRefundAmount;
    }

    private PayOrderStatusEnum getOrderStatus(Long refundAmount, PayOrder payOrder) {
        PayOrderStatusEnum orderStatus = null;
        Long offlineRefundAmount = Objects.isNull(payOrder.getOfflineRefundAmount()) ? 0L : payOrder.getOfflineRefundAmount();
        if (refundAmount + offlineRefundAmount > 0L && refundAmount + offlineRefundAmount < payOrder.getPayAmount()) {
            orderStatus = PayOrderStatusEnum.PARTIAL_REFUND;
        } else if (Objects.equals(refundAmount + offlineRefundAmount, payOrder.getPayAmount())) {
            orderStatus = PayOrderStatusEnum.REFUNDED;
        }
        return orderStatus;
    }

    private PayRefundRecord getRefundRecord(String refundNo) {
        if (StringUtils.isBlank((CharSequence)refundNo)) {
            log.warn("pay msg bizTransNum is empty");
            return null;
        }
        return this.payRefundRecordMapper.queryRefundRecords(refundNo);
    }

    private void sendRemindMsg(PayRefundRecord refundRecord) {
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        orderListReq.setBizId(refundRecord.getBizId());
        orderListReq.setOrderNo(refundRecord.getOrderNum());
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(orderListReq);
        OrderListResp orderResp = null;
        if (CollectionUtils.isNotEmpty((Collection)pageOrderListResp.getList())) {
            orderResp = (OrderListResp)pageOrderListResp.getList().get(0);
        }
        try {
            Long opUserId = refundRecord.getCreateBy();
            String weworkUserNum = this.scrmUserService.getWeworkUserNumByUserId(opUserId);
            if (StringUtils.isNotBlank((CharSequence)weworkUserNum)) {
                RefundSuccessRemindDto remindDto = new RefundSuccessRemindDto();
                remindDto.setBizId(refundRecord.getBizId());
                remindDto.setCorpId(refundRecord.getCorpId());
                remindDto.setWeworkUserNum(weworkUserNum);
                remindDto.setOrderNo(refundRecord.getOrderNum());
                remindDto.setRefundOrderNum(refundRecord.getRefundNum());
                remindDto.setRefundAmount(MoneyConverterUtil.payCenterToScrm((Long)refundRecord.getRefundAmount()));
                if (orderResp != null) {
                    remindDto.setCustomerName(orderResp.getCustomerName());
                    remindDto.setMobile(orderResp.getCustomerMobile());
                }
                remindDto.setRefundTime(new Date());
                this.orderRemindService.refundSuccessRemind(remindDto);
            } else {
                log.info("opUserId of weworkUserId is empty");
            }
        }
        catch (Exception e) {
            log.error("send refund qy msg error: ", (Throwable)e);
        }
    }

    @Override
    public void updateTransferStatus(PayEvent payEvent) {
        PayRefundRecord refundRecord = this.payRefundRecordMapper.queryRefundRecords(payEvent.getBizTransNum());
        if (Objects.isNull(refundRecord)) {
            log.warn("refundRecord is null, bizTransNum={}", (Object)payEvent.getBizTransNum());
            return;
        }
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(refundRecord.getOrderNum());
        if (payOrder == null) {
            log.warn("pay records is empty");
            return;
        }
        if (payEvent.getEventType().equals(PayEventType.TransWrongAccount.getType())) {
            payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.FAIL.getValue()));
            payOrder.setUpdateTime(new Date());
            refundRecord.setRefundStatus(Integer.valueOf(RefundStatusEnum.FAIL.getValue()));
            refundRecord.setFailReason(PayEventType.TransWrongAccount.getDesc());
            this.payOrderMapper.updateByPrimaryKey((Object)payOrder);
            this.payRefundRecordMapper.updateByPrimaryKey((Object)refundRecord);
            this.updateCustomerOrderRefundStatus(payOrder, payEvent.getBizTransNum());
            this.updateCustomerRefundOrder(payOrder, refundRecord, null, PayEventType.TransWrongAccount.getDesc());
        }
    }
}

