/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.dto.request.audit.refund.PayRefundCalReq;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundBatchQuery;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundBatchQueryResp;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundCalDto;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundDetailItem;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundDetailQuery;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundDetailQueryResp;
import cn.kinyun.pay.business.dto.request.audit.refund.RefundListResp;
import cn.kinyun.pay.business.service.PayRefundAuditService;
import cn.kinyun.scrm.payconfig.dto.req.refund.ManualRefundReq;
import cn.kinyun.scrm.payconfig.dto.req.refund.PayRefundDetail;
import cn.kinyun.scrm.payconfig.dto.req.refund.RefundBatchItem;
import cn.kinyun.scrm.payconfig.dto.req.refund.RefundListItem;
import cn.kinyun.scrm.payconfig.dto.req.refund.RefundListReq;
import cn.kinyun.scrm.payconfig.dto.req.refund.VerifyCodeReq;
import cn.kinyun.scrm.payconfig.service.PayRefundWrapService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.StopWatchDto;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayRefundWrapServiceImpl
implements PayRefundWrapService {
    private static final Logger log = LoggerFactory.getLogger(PayRefundWrapServiceImpl.class);
    @Autowired
    private PayRefundAuditService payRefundAuditService;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;

    @Override
    public List<RefundListItem> refundList(RefundListReq req) {
        log.info("refundList with req={}", (Object)req);
        req.validate();
        StopWatchDto timer = new StopWatchDto("refundList", true, log);
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        timer.start("buildRefundListReq");
        cn.kinyun.pay.business.dto.request.audit.refund.RefundListReq refundListReq = this.buildRefundListReq(req, corpId, bizId);
        timer.stop();
        if (Objects.isNull(refundListReq)) {
            timer.print();
            return Lists.newArrayList();
        }
        timer.start("refundList");
        RefundListResp refundListResp = this.payRefundAuditService.refundList(refundListReq);
        timer.stop();
        List bizRefundNums = refundListResp.getList().stream().map(a -> a.getBizRefundNum()).collect(Collectors.toList());
        timer.start("queryRefundRecordByRefundNums");
        List payRefundRecordList = this.payRefundRecordMapper.queryRefundRecordByRefundNums(bizRefundNums);
        timer.stop();
        List createBys = payRefundRecordList.stream().map(a -> a.getCreateBy()).collect(Collectors.toList());
        timer.start("getNameByIds");
        Map creatorId2Name = this.scrmUserService.getNameByIds(createBys);
        timer.stop();
        Map<String, PayRefundRecord> bizRefundNum2Record = payRefundRecordList.stream().collect(Collectors.toMap(a -> a.getRefundNum(), a -> a));
        List bizOrderNos = refundListResp.getList().stream().map(a -> a.getBizOrderNum()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bizOrderNos)) {
            return Lists.newArrayList();
        }
        timer.start("orderList");
        QueryOrderListReq params = new QueryOrderListReq();
        params.setBizId(bizId);
        params.setOrderNos(bizOrderNos);
        PageOrderListResp orderListResp = this.ccCustomerOrderService.orderList(params);
        timer.stop();
        List mobiles = orderListResp.getList().stream().map(a -> a.getCustomerMobile()).distinct().collect(Collectors.toList());
        Map mobile2CustomerNum = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(mobiles)) {
            timer.start("batchGetCustomerNumByMobile");
            mobile2CustomerNum = this.ccCustomerNumService.batchGetCustomerNumByMobile(bizId, mobiles);
            timer.stop();
        }
        Map<String, OrderListResp> bizOrderNo2Item = orderListResp.getList().stream().collect(Collectors.toMap(a -> a.getOrderNo(), a -> a));
        ArrayList list = Lists.newArrayList();
        for (cn.kinyun.pay.business.dto.request.audit.refund.RefundListItem item : refundListResp.getList()) {
            RefundListItem dto = new RefundListItem();
            dto.setBatchNum(item.getBatchNum());
            dto.setBizRefundNum(item.getBizRefundNum());
            dto.setRefundAmount(item.getTotalAmount().toString());
            dto.setRefundMethod(RefundTypeEnum.WAY_BACK.getDesc());
            dto.setAccountNo(item.getCardNo());
            dto.setRefundStatus(item.getStatus());
            dto.setRefundSeqs(item.getRefundSeqs());
            OrderListResp resp = bizOrderNo2Item.get(item.getBizOrderNum());
            if (Objects.nonNull(resp)) {
                dto.setCustomerName(resp.getCustomerName());
                dto.setCustomerPhone(resp.getCustomerMobile());
                dto.setCustomerNum(mobile2CustomerNum.getOrDefault(resp.getCustomerMobile(), ""));
            }
            dto.setRefundOperateTime(item.getCreateTime());
            dto.setCustomerOrderNum(item.getBizOrderNum());
            PayRefundRecord payRefundRecord = bizRefundNum2Record.get(item.getBizRefundNum());
            dto.setRefundOperatorName(creatorId2Name.getOrDefault(payRefundRecord.getCreateBy(), ""));
            dto.setRefundStatusDesc(item.getStatusDesc());
            list.add(dto);
        }
        if (Objects.nonNull(req.getPageDto())) {
            req.setPageDto(refundListResp.getPageDto());
        }
        timer.print();
        return list;
    }

    private cn.kinyun.pay.business.dto.request.audit.refund.RefundListReq buildRefundListReq(RefundListReq req, String corpId, Long bizId) {
        List<Object> productBizOrderNums = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)req.getProductNameQuery()) || StringUtils.isNotBlank((CharSequence)req.getCustomerQuery())) {
            QueryOrderListReq orderListReq = new QueryOrderListReq();
            orderListReq.setBizId(bizId);
            orderListReq.setSkuName(req.getProductNameQuery());
            orderListReq.setNameOrMobile(req.getCustomerQuery());
            PageOrderListResp orderListResp = this.ccCustomerOrderService.orderList(orderListReq);
            if (Objects.nonNull(orderListResp)) {
                productBizOrderNums = orderListResp.getList().stream().map(a -> a.getOrderNo()).collect(Collectors.toList());
            }
            if (CollectionUtils.isEmpty((Collection)productBizOrderNums)) {
                log.info("\u6839\u636e\u6761\u4ef6\u67e5\u65b0\u4e0d\u5230\u6570\u636e\uff0creq={}", (Object)req);
                return null;
            }
        }
        cn.kinyun.pay.business.dto.request.audit.refund.RefundListReq refundListReq = new cn.kinyun.pay.business.dto.request.audit.refund.RefundListReq();
        refundListReq.setRefundStatusList(req.getRefundStatusList());
        refundListReq.setPageDto(req.getPageDto());
        refundListReq.setBizRefundNums(req.getBizRefundNums());
        refundListReq.setBatchNumQuery(req.getBatchNumQuery());
        refundListReq.setBizOrderNumQuery(req.getBizOrderNumQuery());
        refundListReq.setBizRefundNumQuery(req.getBizRefundNumQuery());
        refundListReq.setBizOrderNums((List)productBizOrderNums);
        refundListReq.setCorpId(corpId);
        refundListReq.setPhoneQuery(req.getCustomerQuery());
        refundListReq.setStartTime(req.getStartTime());
        refundListReq.setEndTime(req.getEndTime());
        return refundListReq;
    }

    @Override
    public RefundCalDto calRefund(cn.kinyun.scrm.payconfig.dto.req.refund.PayRefundCalReq req) {
        log.info("calRefund with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        PayRefundCalReq payRefundCalReq = new PayRefundCalReq();
        payRefundCalReq.setCorpId(corpId);
        payRefundCalReq.setQuery(this.buildRefundListReq(req.getQuery(), corpId, bizId));
        payRefundCalReq.setSelectMode(req.getSelectMode());
        if (Objects.isNull(payRefundCalReq.getQuery())) {
            return null;
        }
        return this.payRefundAuditService.calRefund(payRefundCalReq);
    }

    @Override
    public void manualRefund(ManualRefundReq req) {
        log.info("manualRefund with req={}", (Object)req);
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long operatorId = LoginUtils.getCurrentUserId();
        cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq manualRefundReq = new cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq();
        manualRefundReq.setRemark(req.getRemark());
        manualRefundReq.setQuery(this.buildRefundListReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualRefundReq.getQuery())) {
            return;
        }
        manualRefundReq.setCorpId(corpId);
        manualRefundReq.setSmsVerify(req.getSmsVerify());
        this.payRefundAuditService.manualRefund(manualRefundReq, operatorId);
    }

    @Override
    public void rejectRefund(ManualRefundReq req) {
        log.info("rejectRefund with req={}", (Object)req);
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long operatorId = LoginUtils.getCurrentUserId();
        cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq manualRefundReq = new cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq();
        manualRefundReq.setRemark(req.getRemark());
        manualRefundReq.setQuery(this.buildRefundListReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualRefundReq.getQuery())) {
            return;
        }
        manualRefundReq.setCorpId(corpId);
        manualRefundReq.setSmsVerify(req.getSmsVerify());
        this.payRefundAuditService.rejectRefund(manualRefundReq, operatorId);
    }

    @Override
    public void markRefund(ManualRefundReq req) {
        log.info("markRefund with req={}", (Object)req);
        req.rejectValidate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        Long operatorId = LoginUtils.getCurrentUserId();
        cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq manualRefundReq = new cn.kinyun.pay.business.dto.request.audit.refund.ManualRefundReq();
        manualRefundReq.setRemark(req.getRemark());
        manualRefundReq.setQuery(this.buildRefundListReq(req.getQuery(), corpId, bizId));
        if (Objects.isNull(manualRefundReq.getQuery())) {
            return;
        }
        manualRefundReq.setCorpId(corpId);
        manualRefundReq.setSmsVerify(req.getSmsVerify());
        this.payRefundAuditService.markRefund(manualRefundReq, operatorId);
    }

    @Override
    public void sendVerifyCode(VerifyCodeReq req) {
        CurrentUserInfo currentUser = LoginUtils.getCurrentUser();
        log.info("sendVerifyCode userId={}, req={}", (Object)currentUser.getId(), (Object)req);
        req.validate();
        if (Objects.equals(req.getMsgType(), 0)) {
            this.payRefundAuditService.sendVerifyCode(currentUser.getCorpId(), currentUser.getId(), currentUser.getWeworkUserId(), null);
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUser.getMobile()), (Object)("\u7528\u6237:" + currentUser.getName() + ",\u6ca1\u6709\u8bbe\u7f6e\u624b\u673a\u53f7\uff0c\u8bf7\u5728\u7cfb\u7edf\u91cd\u914d\u7f6e\u624b\u673a\u53f7\u5728"));
            this.payRefundAuditService.sendVerifyCode(null, currentUser.getId(), null, currentUser.getMobile());
        }
    }

    @Override
    public List<RefundBatchItem> refundBatchList(cn.kinyun.scrm.payconfig.dto.req.refund.RefundBatchQuery req) {
        log.info("refundBatchList with req={}", (Object)req);
        String corpId = LoginUtils.getCurrentUserCorpId();
        RefundBatchQuery refundBatchQuery = new RefundBatchQuery();
        refundBatchQuery.setBatchNum(req.getBatchNum());
        refundBatchQuery.setBizRefundNumQuery(req.getBizRefundNumQuery());
        refundBatchQuery.setCorpId(corpId);
        refundBatchQuery.setPageDto(req.getPageDto());
        refundBatchQuery.setStartTime(req.getStartTime());
        refundBatchQuery.setEndTime(req.getEndTime());
        RefundBatchQueryResp refundBatchQueryResp = this.payRefundAuditService.refundBatchList(refundBatchQuery);
        ArrayList resultList = Lists.newArrayList();
        for (cn.kinyun.pay.business.dto.request.audit.refund.RefundBatchItem refundBatchItem : refundBatchQueryResp.getList()) {
            RefundBatchItem item = new RefundBatchItem();
            item.setBatchNum(refundBatchItem.getBatchNum());
            item.setRefundAmount(refundBatchItem.getRefundAmount().toString());
            item.setBizRefundCount(refundBatchItem.getBizRefundCount());
            item.setCreateTime(refundBatchItem.getCreateTime());
            item.setRemark(refundBatchItem.getRemark());
            item.setRealPayRefundCount(refundBatchItem.getRealPayRefundCount());
            item.setFailAmount(refundBatchItem.getFailAmount().toString());
            item.setFailCount(refundBatchItem.getFailCount());
            item.setSuccessAmount(refundBatchItem.getSuccessAmount().toString());
            item.setSuccessCount(refundBatchItem.getSuccessCount());
            item.setStatus(refundBatchItem.getStatus());
            item.setStatusDesc(refundBatchItem.getStatusDesc());
            item.setOperatorName(refundBatchItem.getOperatorName());
            resultList.add(item);
        }
        req.setPageDto(refundBatchQueryResp.getPageDto());
        return resultList;
    }

    @Override
    public List<cn.kinyun.scrm.payconfig.dto.req.refund.RefundDetailItem> refundBatchDetail(cn.kinyun.scrm.payconfig.dto.req.refund.RefundDetailQuery req) {
        log.info("refundBatchDetail with req={}", (Object)req);
        req.validate();
        String corpId = LoginUtils.getCurrentUserCorpId();
        RefundDetailQuery refundDetailQuery = new RefundDetailQuery();
        refundDetailQuery.setBizRefundNumQuery(req.getBizRefundNumQuery());
        refundDetailQuery.setRefundStatusList(req.getRefundStatusList());
        refundDetailQuery.setPageDto(req.getPageDto());
        refundDetailQuery.setRefundBatchNum(req.getRefundBatchNum());
        refundDetailQuery.setCropId(corpId);
        RefundDetailQueryResp refundDetailQueryResp = this.payRefundAuditService.refundBatchDetail(refundDetailQuery);
        ArrayList resultList = Lists.newArrayList();
        for (RefundDetailItem refundDetailItem : refundDetailQueryResp.getList()) {
            cn.kinyun.scrm.payconfig.dto.req.refund.RefundDetailItem item = new cn.kinyun.scrm.payconfig.dto.req.refund.RefundDetailItem();
            item.setRefundStatus(refundDetailItem.getRefundStatus());
            item.setRefundStatusDesc(refundDetailItem.getRefundStatusDesc());
            item.setRefundType(refundDetailItem.getRefundType());
            item.setBizRefundNum(refundDetailItem.getBizRefundNum());
            List<PayRefundDetail> payRefundDetailList = refundDetailItem.getPayRefundDetails().stream().map(a -> {
                PayRefundDetail payRefundDetail = new PayRefundDetail();
                payRefundDetail.setRefundAmount(a.getRefundAmount().toString());
                payRefundDetail.setRefundNum(a.getRefundNum());
                payRefundDetail.setOutRefundNum(a.getOutRefundNum());
                payRefundDetail.setStatus(a.getStatus());
                payRefundDetail.setThirdErrCode(a.getThirdErrCode());
                payRefundDetail.setThirdErrMsg(a.getThirdErrMsg());
                payRefundDetail.setUpdateTime(a.getUpdateTime());
                return payRefundDetail;
            }).collect(Collectors.toList());
            item.setPayRefundDetails(payRefundDetailList);
            item.setPhone(refundDetailItem.getPhone());
            item.setReason(refundDetailItem.getReason());
            item.setSuccessAmount(refundDetailItem.getSuccessAmount().toString());
            item.setTotalAmount(refundDetailItem.getTotalAmount().toString());
            item.setBizOrderNum(refundDetailItem.getBizOrderNum());
            resultList.add(item);
        }
        req.setPageDto(refundDetailQueryResp.getPageDto());
        return resultList;
    }
}

