/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.payconfig.service.impl;

import cn.kinyun.customer.center.dto.req.QueryOrderListReq;
import cn.kinyun.customer.center.dto.resp.OrderListResp;
import cn.kinyun.customer.center.dto.resp.OrderSkuResp;
import cn.kinyun.customer.center.dto.resp.PageOrderListResp;
import cn.kinyun.customer.center.enums.PayStatusEnum;
import cn.kinyun.customer.center.enums.RefundStatusEnum;
import cn.kinyun.customer.center.enums.RefundTypeEnum;
import cn.kinyun.customer.center.service.CcCustomerOrderService;
import cn.kinyun.pay.business.component.PayCertBackgroundService;
import cn.kinyun.pay.business.dto.request.OrderRequest;
import cn.kinyun.pay.business.dto.request.RefundQueryReq;
import cn.kinyun.pay.business.dto.response.BaseResponse;
import cn.kinyun.pay.business.dto.response.OrderData;
import cn.kinyun.pay.business.dto.response.RefundQueryResp;
import cn.kinyun.pay.business.dto.vo.OrderHeaderDto;
import cn.kinyun.pay.business.dto.vo.PayMessageDto;
import cn.kinyun.pay.business.enums.PayChannelType;
import cn.kinyun.pay.business.enums.PayMessageType;
import cn.kinyun.pay.business.service.PayOrderService;
import cn.kinyun.pay.business.service.PayRefundService;
import cn.kinyun.scrm.payconfig.dto.req.OrderPayReq;
import cn.kinyun.scrm.payconfig.dto.req.OrderStatusReq;
import cn.kinyun.scrm.payconfig.dto.resp.OrderPayResp;
import cn.kinyun.scrm.payconfig.dto.resp.OrderStatusResp;
import cn.kinyun.scrm.payconfig.service.OrderPayService;
import cn.kinyun.scrm.payconfig.service.OrderRefundService;
import cn.kinyun.scrm.payconfig.service.PayConfigService;
import cn.kinyun.scrm.payconfig.service.impl.UpdateCustomerOrderDelayManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.DistributedLock;
import com.kuaike.scrm.common.service.ScrmPayOrderService;
import com.kuaike.scrm.common.service.ScrmUserService;
import com.kuaike.scrm.common.service.dto.PayOrderReq;
import com.kuaike.scrm.common.utils.KafkaClientUtils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MoneyConverterUtil;
import com.kuaike.scrm.dal.payorder.entity.PayOrder;
import com.kuaike.scrm.dal.payorder.entity.PayRecord;
import com.kuaike.scrm.dal.payorder.entity.PayRefundRecord;
import com.kuaike.scrm.dal.payorder.mapper.PayOrderMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRecordMapper;
import com.kuaike.scrm.dal.payorder.mapper.PayRefundRecordMapper;
import com.kuaike.scrm.dal.shop.entity.ShopOrder;
import com.kuaike.scrm.dal.shop.mapper.ShopOrderMapper;
import com.kuaike.scrm.remind.dto.req.PaySuccessRemindDto;
import com.kuaike.scrm.remind.dto.req.PayTimeOutRemindDto;
import com.kuaike.scrm.remind.service.OrderRemindService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OrderPayServiceImpl
implements OrderPayService,
ScrmPayOrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderPayServiceImpl.class);
    @Autowired
    private PayOrderMapper payOrderMapper;
    @Autowired
    private PayOrderService payOrderService;
    @Autowired
    private PayRefundService payRefundService;
    @Autowired
    private PayCertBackgroundService payCertBackgroundService;
    @Autowired
    private PayConfigService payConfigService;
    @Autowired
    private PayRecordMapper payRecordMapper;
    @Autowired
    private OrderRefundService orderRefundService;
    @Autowired
    private OrderRemindService orderRemindService;
    @Autowired
    private ScrmUserService scrmUserService;
    @Autowired
    private CcCustomerOrderService ccCustomerOrderService;
    @Autowired
    private OrderPayService self;
    @Autowired
    private DistributedLock lock;
    @Autowired
    private PayRefundRecordMapper payRefundRecordMapper;
    @Autowired
    private ShopOrderMapper shopOrderMapper;
    @Value(value="${kafka.topic.pay_order_change}")
    private String payOrderChangeTopic;
    @Autowired
    private KafkaClientUtils kafkaClient;
    @Autowired
    private UpdateCustomerOrderDelayManager updateCustomerOrderDelayManager;
    private Set<Integer> holdStatus = Sets.newHashSet((Object[])new Integer[]{PayStatusEnum.PAID.getValue(), PayStatusEnum.UNPAID.getValue()});

    @Override
    public OrderStatusResp orderStatus(OrderStatusReq req) {
        log.info("orderStatus with req={}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(req.getOrderNo());
        if (Objects.isNull(payOrder)) {
            return this.getOrderStatusResp(req);
        }
        String bizOrderNo = req.getOrderNo();
        List bizTransNums = this.payRefundRecordMapper.queryRefundRecordsByBizOrderNums((Collection)Lists.newArrayList((Object[])new String[]{bizOrderNo}), Integer.valueOf(RefundTypeEnum.TRANSFER.getValue())).stream().map(PayRefundRecord::getRefundNum).collect(Collectors.toList());
        RefundQueryReq refundQueryReq = new RefundQueryReq();
        refundQueryReq.setBizOrderNum(bizOrderNo);
        refundQueryReq.setBizTransNums(bizTransNums);
        BaseResponse refundQueryResp = this.payRefundService.queryRefund(refundQueryReq);
        if (Objects.isNull(refundQueryResp)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u67e5\u8be2\u9000\u6b3e\u8ba2\u5355\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458");
        }
        log.info("refundQueryResp={}", (Object)JSON.toJSONString((Object)refundQueryResp));
        if (!refundQueryResp.isSuccess()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, refundQueryResp.getMsg());
        }
        String orderStatusStr = this.getOrderStatusStr(payOrder);
        RefundQueryResp refundResp = (RefundQueryResp)refundQueryResp.getData();
        String refundStatusStr = this.getRefundStatusStr(refundResp, payOrder);
        Long remainRefundAmount = refundResp.getRemainAmount() - (Objects.isNull(payOrder.getOfflineRefundAmount()) ? 0L : payOrder.getOfflineRefundAmount());
        List payRecords = this.payRecordMapper.queryPayRecordByOrderNo(bizId, req.getOrderNo());
        Long holdPayAmount = 0L;
        Boolean haveNotPayOrder = false;
        for (PayRecord payRecord : payRecords) {
            if (this.holdStatus.contains(payRecord.getStatus())) {
                holdPayAmount = holdPayAmount + payRecord.getAmount();
            }
            if (!Objects.equals(PayStatusEnum.UNPAID.getValue(), payRecord.getStatus())) continue;
            haveNotPayOrder = true;
        }
        Long remainPayAmount = payOrder.getTotalAmount() - holdPayAmount;
        return this.buildOrderStatusResp(req, orderStatusStr, refundResp, refundStatusStr, remainRefundAmount, remainPayAmount, haveNotPayOrder);
    }

    private OrderStatusResp getOrderStatusResp(OrderStatusReq req) {
        OrderStatusResp resp = new OrderStatusResp();
        resp.setOrderStatus("");
        resp.setOrderNo(req.getOrderNo());
        resp.setRefundStatus("NONE");
        resp.setCanRefund(false);
        resp.setTotalAmount(0L);
        resp.setRemainRefundAmount(0L);
        resp.setRemainPayAmount(0L);
        resp.setHaveNotPayOrder(false);
        return resp;
    }

    private OrderStatusResp buildOrderStatusResp(OrderStatusReq req, String orderStatusStr, RefundQueryResp refundResp, String refundStatusStr, Long remainRefundAmount, Long remainPayAmount, Boolean haveNotPayOrder) {
        OrderStatusResp resp = new OrderStatusResp();
        resp.setOrderNo(req.getOrderNo());
        resp.setOrderStatus(orderStatusStr);
        resp.setRefundStatus(refundStatusStr);
        resp.setCanRefund(refundResp.getCanBackRefund());
        resp.setRemainRefundAmount(remainRefundAmount);
        resp.setTotalAmount(refundResp.getTotalAmount());
        resp.setRemainPayAmount(remainPayAmount);
        resp.setHaveNotPayOrder(haveNotPayOrder);
        return resp;
    }

    private String getRefundStatusStr(RefundQueryResp refundResp, PayOrder payOrder) {
        String refundStatusStr = "NONE";
        Long offlineRefundAmount = Objects.isNull(payOrder.getOfflineRefundAmount()) ? 0L : payOrder.getOfflineRefundAmount();
        if (refundResp.getCanBackRefund().booleanValue()) {
            if (refundResp.getRefundingAmount() > 0L) {
                refundStatusStr = "REFUNDING";
            } else if (refundResp.getHaveRefundAmount() + offlineRefundAmount > 0L && refundResp.getHaveRefundAmount() + offlineRefundAmount < refundResp.getPayAmount()) {
                refundStatusStr = "PART_REFUND";
            } else if (Objects.equals(refundResp.getHaveRefundAmount() + offlineRefundAmount, refundResp.getPayAmount())) {
                refundStatusStr = "REFUND";
            }
        }
        return refundStatusStr;
    }

    private String getOrderStatusStr(PayOrder payOrder) {
        String orderStatusStr;
        switch (PayStatusEnum.get((int)payOrder.getPayStatus())) {
            case UNPAID: {
                orderStatusStr = "WAIT_PAY";
                break;
            }
            case PAID: {
                orderStatusStr = "PAID";
                break;
            }
            case CLOSED: {
                orderStatusStr = "CLOSED";
                break;
            }
            case PART_PAID: {
                orderStatusStr = "PART_PAID";
                break;
            }
            case REFUND: {
                orderStatusStr = "REFUND";
                break;
            }
            default: {
                orderStatusStr = "";
            }
        }
        return orderStatusStr;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public OrderPayResp pay(OrderPayReq req) {
        PayRecord payRecord;
        log.info("pay with req={}", (Object)req);
        req.validate();
        Long bizId = LoginUtils.getCurrentUserBizId();
        String corpId = LoginUtils.getCurrentUserCorpId();
        Long operatorId = LoginUtils.getCurrentUserId();
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(req.getOrderNo());
        OrderPayResp resp = new OrderPayResp();
        this.checkPayOrder(payOrder);
        PayRecord latestPayRecord = this.payRecordMapper.queryLatestPayRecordByOrderNo(req.getOrderNo());
        if (Objects.nonNull(latestPayRecord) && Objects.equals(PayStatusEnum.UNPAID.getValue(), latestPayRecord.getStatus())) {
            OrderData orderData = (OrderData)JSON.parseObject((String)latestPayRecord.getPayInfo(), OrderData.class);
            resp.setJumpUrl(orderData.getJumpUrl());
            resp.setOrderNum(orderData.getOrderNum());
            resp.setBizOrderNum(orderData.getBizOrderNum());
            resp.setOutOrderNum(orderData.getOutOrderNum());
            resp.setExtraData(orderData.getExtraData());
            resp.setPayChannelCode(PayChannelType.get((Integer)latestPayRecord.getPayChannelType()).getServiceCode());
            resp.setPayAmount(latestPayRecord.getAmount());
            return resp;
        }
        req.validateAll();
        if (Objects.nonNull(payOrder)) {
            Preconditions.checkArgument((boolean)Objects.equals(payOrder.getTotalAmount(), req.getTotalAmount()), (Object)"\u5df2\u751f\u6210\u7684\u8ba2\u5355\u603b\u91d1\u989d\u4e0d\u80fd\u4fee\u6539");
        }
        QueryOrderListReq queryOrderListReq = new QueryOrderListReq();
        queryOrderListReq.setBizId(bizId);
        queryOrderListReq.setOrderNo(req.getOrderNo());
        PageOrderListResp orderListPageResp = this.ccCustomerOrderService.orderList(queryOrderListReq);
        Preconditions.checkArgument((Objects.nonNull(orderListPageResp) && CollectionUtils.isNotEmpty((Collection)orderListPageResp.getList()) ? 1 : 0) != 0, (Object)"\u8ba2\u5355\u5728\u8ba2\u5355\u4e2d\u5fc3\u4e0d\u5b58\u5728");
        OrderListResp customerCenterOrder = (OrderListResp)orderListPageResp.getList().stream().findFirst().get();
        String skuNo = UUID.randomUUID().toString().replace("-", "");
        if (Objects.nonNull(customerCenterOrder) && CollectionUtils.isNotEmpty((Collection)customerCenterOrder.getSkuList())) {
            skuNo = ((OrderSkuResp)customerCenterOrder.getSkuList().stream().findFirst().get()).getSkuNo();
        }
        OrderRequest orderRequest = this.buildOrderRequest(corpId, req, skuNo);
        try {
            BaseResponse orderResponse = this.payOrderService.order(orderRequest);
            log.info("order req={}, resp={}", (Object)orderRequest, (Object)orderResponse);
            if (Objects.nonNull(orderResponse) && orderResponse.isSuccess()) {
                OrderData orderData = (OrderData)orderResponse.getData();
                resp.setBizOrderNum(orderData.getBizOrderNum());
                resp.setOrderNum(orderData.getOrderNum());
                resp.setOutOrderNum(orderData.getOutOrderNum());
                resp.setExtraData(orderData.getExtraData());
                resp.setJumpUrl(orderData.getJumpUrl());
                resp.setPayChannelCode(PayChannelType.get((Integer)req.getPayChannelType()).getServiceCode());
                resp.setPayAmount(req.getPayAmount());
            } else if (Objects.nonNull(orderResponse)) {
                log.warn("order pay fail with resp={}", (Object)resp);
                String msg = "";
                if (StringUtils.isNotBlank((CharSequence)orderResponse.getMsg())) {
                    msg = orderResponse.getMsg();
                }
                if (StringUtils.isNotBlank((CharSequence)orderResponse.getThirdPartMsg())) {
                    msg = orderResponse.getThirdPartMsg();
                }
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, msg);
            }
            if (Objects.isNull(payOrder)) {
                payOrder = this.insertPayOrder(req, bizId, corpId, operatorId);
            }
            payRecord = this.insertPayRecord(req, bizId, corpId, operatorId, orderRequest, (BaseResponse<OrderData>)orderResponse);
        }
        catch (Exception e) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, e.getMessage());
        }
        this.updateCustomerOrderDelayManager.dealPayOrder(payOrder, payRecord);
        return resp;
    }

    private OrderRequest buildOrderRequest(String corpId, OrderPayReq req, String skuNo) {
        OrderRequest orderRequest = new OrderRequest();
        OrderHeaderDto orderHeaderDto = new OrderHeaderDto();
        orderHeaderDto.setBizOrderNum(req.getOrderNo());
        orderHeaderDto.setBizOrderInfos("");
        orderHeaderDto.setAmount(String.valueOf(req.getTotalAmount()));
        orderRequest.setOrderHeaderDto(orderHeaderDto);
        orderRequest.setRequestId(UUID.randomUUID().toString().replace("-", ""));
        orderRequest.setCorpId(corpId);
        orderRequest.setTotalAmount(String.valueOf(req.getPayAmount()));
        orderRequest.setSubject("\u8ba2\u5355\u4e2d\u5fc3\u8ba2\u5355");
        orderRequest.setChannelType(req.getPayChannelType());
        switch (PayChannelType.get((Integer)req.getPayChannelType())) {
            case WEIXIN_NATIVE: {
                orderRequest.setParams("{\"productId\":\"" + skuNo + "\"}");
                break;
            }
            case ALIPAY_PRE_CREATE: {
                break;
            }
        }
        String sign = this.payCertBackgroundService.getSign((Object)orderRequest);
        orderRequest.setSign(sign);
        return orderRequest;
    }

    private PayRecord insertPayRecord(OrderPayReq req, Long bizId, String corpId, Long operatorId, OrderRequest orderRequest, BaseResponse<OrderData> orderResponse) {
        OrderData orderData = (OrderData)orderResponse.getData();
        PayRecord payRecord = new PayRecord();
        payRecord.setPayInfo(JSON.toJSONString((Object)orderResponse.getData()));
        payRecord.setStatus(Integer.valueOf(PayStatusEnum.UNPAID.getValue()));
        payRecord.setBizId(bizId);
        payRecord.setOrderNum(req.getOrderNo());
        payRecord.setAmount(req.getPayAmount());
        payRecord.setPayChannelType(orderRequest.getChannelType());
        payRecord.setCorpId(corpId);
        payRecord.setCreateBy(operatorId);
        payRecord.setCreateTime(new Date());
        payRecord.setPayTradeNum(orderData.getOrderNum());
        payRecord.setTotalAmount(req.getTotalAmount());
        payRecord.setRemark("");
        payRecord.setRequestId(orderRequest.getRequestId());
        payRecord.setTradeSeq(orderData.getOutOrderNum());
        payRecord.setUpdateBy(operatorId);
        payRecord.setUpdateTime(new Date());
        this.payRecordMapper.insert((Object)payRecord);
        return payRecord;
    }

    private PayOrder insertPayOrder(OrderPayReq req, Long bizId, String corpId, Long operatorId) {
        PayOrder payOrder = new PayOrder();
        payOrder.setPayAmount(Long.valueOf(0L));
        payOrder.setPayStatus(Integer.valueOf(PayStatusEnum.UNPAID.getValue()));
        payOrder.setOrderNum(req.getOrderNo());
        payOrder.setRefundStatus(Integer.valueOf(RefundStatusEnum.NONE.getValue()));
        payOrder.setPayRefundAmount(Long.valueOf(0L));
        payOrder.setBizId(bizId);
        payOrder.setCorpId(corpId);
        payOrder.setCreateBy(operatorId);
        payOrder.setOfflineRefundAmount(Long.valueOf(0L));
        payOrder.setTotalAmount(req.getTotalAmount());
        payOrder.setCreateTime(new Date());
        payOrder.setUpdateBy(operatorId);
        payOrder.setUpdateTime(new Date());
        this.payOrderMapper.insert((Object)payOrder);
        return payOrder;
    }

    private void checkPayOrder(PayOrder payOrder) {
        if (Objects.nonNull(payOrder)) {
            if (Objects.equals(PayStatusEnum.PAID.getValue(), payOrder.getPayStatus())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5df2\u4ed8\u6b3e\u5b8c\u6bd5");
            }
            if (Objects.equals(PayStatusEnum.REFUND.getValue(), payOrder.getPayStatus())) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8ba2\u5355\u5df2\u9000\u6b3e");
            }
            if (Objects.equals(PayStatusEnum.TIMEOUT.getValue(), payOrder.getPayStatus())) {
                return;
            }
            if (payOrder.getPayStatus() > PayStatusEnum.PART_PAID.getValue()) {
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, PayStatusEnum.get((int)payOrder.getPayStatus()).getDesc());
            }
        }
    }

    @Override
    public void handlePayMessage(PayMessageDto payMessageDto) {
        log.info("handlePayMessage with orderNum={}", (Object)payMessageDto.getOrderNum());
        PayMessageType msgType = PayMessageType.getType((Integer)payMessageDto.getMsgType());
        switch (msgType) {
            case ORDER: {
                PayRecord payRecord = this.handlePaidMessage(payMessageDto);
                if (payRecord == null) {
                    return;
                }
                this.sendPaySuccessRemind(payRecord);
                break;
            }
            case REFUND: {
                this.orderRefundService.handleRefundMsg(payMessageDto);
                break;
            }
            case TRANS: {
                this.orderRefundService.handTransMsg(payMessageDto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PayRecord handlePaidMessage(PayMessageDto payMessageDto) {
        PayRecord payRecord = this.checkPayRecord(payMessageDto.getOrderNum());
        if (payRecord == null) {
            return null;
        }
        PayOrder payOrder = this.checkPayOrder(payRecord.getOrderNum());
        if (payOrder == null) {
            return null;
        }
        String key = "order-center:" + payMessageDto.getBizOrderNum();
        try {
            this.lock.lock(key, 10L, 15L, TimeUnit.SECONDS);
            this.self.handleOrderPaid(payMessageDto);
        }
        catch (Exception e) {
            log.error("handleOrderPaid with error", (Throwable)e);
        }
        finally {
            this.lock.unlock(key);
        }
        return payRecord;
    }

    private PayOrder checkPayOrder(String orderNum) {
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(orderNum);
        if (Objects.isNull(payOrder)) {
            log.error("payOrder is not exist, bizOrderNum={}", (Object)orderNum);
            return null;
        }
        if (Objects.equals(PayStatusEnum.PAID.getValue(), payOrder.getPayStatus())) {
            log.warn("payOrder have been paid, bizOrderNum={}", (Object)orderNum);
            return null;
        }
        return payOrder;
    }

    private PayRecord checkPayRecord(String orderNum) {
        PayRecord payRecord = this.payRecordMapper.queryByPayTradeNo(orderNum);
        if (Objects.isNull(payRecord)) {
            log.warn("payRecord is null, payTradeNo={}", (Object)orderNum);
            return null;
        }
        if (Objects.equals(payRecord.getStatus(), PayStatusEnum.PAID.getValue())) {
            log.warn("payRecord have been pay, payTradeNo={}", (Object)orderNum);
            return null;
        }
        return payRecord;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void handleOrderPaid(PayMessageDto payMessageDto) {
        log.info("handleOrderPaid with payMessageDto={}", (Object)payMessageDto);
        PayRecord payRecord = this.checkPayRecord(payMessageDto.getOrderNum());
        if (payRecord == null) {
            return;
        }
        PayOrder payOrder = this.checkPayOrder(payRecord.getOrderNum());
        if (payOrder == null) {
            return;
        }
        payRecord.setStatus(Integer.valueOf(PayStatusEnum.PAID.getValue()));
        payRecord.setTradeSeq(JSONObject.parseObject((String)payMessageDto.getBody()).getString("outOrderNum"));
        payRecord.setUpdateTime(new Date());
        this.payRecordMapper.updateByPrimaryKey((Object)payRecord);
        List list = this.payRecordMapper.queryPayRecordByOrderNo(payRecord.getBizId(), payRecord.getOrderNum());
        Long successPayAmount = list.stream().filter(a -> Objects.equals(PayStatusEnum.PAID.getValue(), a.getStatus())).mapToLong(PayRecord::getAmount).sum();
        payOrder.setPayAmount(successPayAmount);
        if (Objects.equals(payOrder.getPayAmount(), payOrder.getTotalAmount())) {
            payOrder.setPayStatus(Integer.valueOf(PayStatusEnum.PAID.getValue()));
        } else if (payOrder.getPayAmount() > 0L && payOrder.getPayAmount() < payOrder.getTotalAmount()) {
            payOrder.setPayStatus(Integer.valueOf(PayStatusEnum.PART_PAID.getValue()));
        }
        log.info("final payOrder={}", (Object)payOrder);
        this.payOrderMapper.updateByPrimaryKey((Object)payOrder);
        this.sendPayOrderChangeMsg(payOrder);
        this.updateCustomerOrderDelayManager.dealPayOrder(payOrder, payRecord);
    }

    @Override
    public void sendPayOrderChangeMsg(PayOrder payOrder) {
        log.info("sendPayOrderChangeMsg with payOrder={}", (Object)payOrder);
        this.kafkaClient.sendMessage(this.payOrderChangeTopic, JacksonUtil.obj2Str((Object)payOrder));
    }

    private void sendPaySuccessRemind(PayRecord payRecord) {
        if (payRecord == null) {
            log.warn("pay record is null");
            return;
        }
        log.info("payRecord: {}", (Object)JSON.toJSONString((Object)payRecord));
        ShopOrder shopOrder = this.shopOrderMapper.queryByOrderId(payRecord.getOrderNum());
        if (shopOrder != null) {
            log.info("order is meeting order, orderNum: {}", (Object)payRecord.getOrderNum());
            return;
        }
        PaySuccessRemindDto remindDto = new PaySuccessRemindDto();
        remindDto.setBizId(payRecord.getBizId());
        remindDto.setCorpId(payRecord.getCorpId());
        QueryOrderListReq orderListReq = new QueryOrderListReq();
        orderListReq.setBizId(payRecord.getBizId());
        orderListReq.setOrderNo(payRecord.getOrderNum());
        PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(orderListReq);
        OrderListResp orderResp = null;
        if (CollectionUtils.isNotEmpty((Collection)pageOrderListResp.getList())) {
            orderResp = (OrderListResp)pageOrderListResp.getList().get(0);
        }
        remindDto.setOrderNo(payRecord.getOrderNum());
        remindDto.setPayAmount(Long.valueOf(payRecord.getAmount() * 100L));
        String weworkUserNum = null;
        if (orderResp != null) {
            remindDto.setCustomerName(orderResp.getCustomerName());
            remindDto.setMobile(orderResp.getCustomerMobile());
            weworkUserNum = this.scrmUserService.getWeworkUserNumByUserId(orderResp.getCreateBy());
            remindDto.setWeworkUserNum(weworkUserNum);
        }
        if (StringUtils.isNotBlank(weworkUserNum)) {
            remindDto.setPayTime(new Date());
            this.orderRemindService.paySuccessRemind(remindDto);
        } else {
            log.warn("create pay record userId no weworkUserNum: {}", (Object)payRecord.getCreateBy());
        }
    }

    @Override
    @Transactional
    public void handleOrderPayTimeout() {
        Date now = new Date();
        long startTime = now.getTime() - 1860000L;
        Date start = new Date(startTime);
        List payRecords = this.payRecordMapper.getBeforeTimeBatch(start, Integer.valueOf(PayStatusEnum.UNPAID.getValue()));
        if (CollectionUtils.isEmpty((Collection)payRecords)) {
            log.info("timeout pay order list is empty");
            return;
        }
        List orderNoList = payRecords.stream().map(PayRecord::getOrderNum).collect(Collectors.toList());
        List payRecordIds = payRecords.stream().map(PayRecord::getId).collect(Collectors.toList());
        log.info("update timeout status orderNosList: {}, payRecordIds: {}", orderNoList, payRecordIds);
        this.payRecordMapper.updateStatus(payRecordIds, Integer.valueOf(PayStatusEnum.TIMEOUT.getValue()));
        List payNos = payRecords.stream().map(PayRecord::getPayTradeNum).collect(Collectors.toList());
        try {
            this.ccCustomerOrderService.setOrderPayTimeoutStatus(orderNoList, payNos);
        }
        catch (Exception e) {
            log.error("update customer order pay record error: ", (Throwable)e);
        }
        for (PayRecord payRecord : payRecords) {
            this.sendTimeoutRemind(payRecord);
        }
    }

    private void sendTimeoutRemind(PayRecord payRecord) {
        try {
            ShopOrder shopOrder = this.shopOrderMapper.queryByOrderId(payRecord.getOrderNum());
            if (shopOrder != null) {
                log.info("order is shopOrder, not handle, orderNo: {}", (Object)payRecord.getOrderNum());
                return;
            }
            PayTimeOutRemindDto remindDto = new PayTimeOutRemindDto();
            remindDto.setBizId(payRecord.getBizId());
            remindDto.setCorpId(payRecord.getCorpId());
            remindDto.setOrderNo(payRecord.getOrderNum());
            remindDto.setPayAmount(Long.valueOf(payRecord.getAmount() * 100L));
            QueryOrderListReq orderListReq = new QueryOrderListReq();
            orderListReq.setBizId(payRecord.getBizId());
            orderListReq.setOrderNo(payRecord.getOrderNum());
            PageOrderListResp pageOrderListResp = this.ccCustomerOrderService.orderList(orderListReq);
            OrderListResp orderResp = null;
            if (CollectionUtils.isNotEmpty((Collection)pageOrderListResp.getList())) {
                orderResp = (OrderListResp)pageOrderListResp.getList().get(0);
            }
            if (orderResp != null) {
                remindDto.setCustomerName(orderResp.getCustomerName());
                remindDto.setMobile(orderResp.getCustomerMobile());
                remindDto.setOrderTime(orderResp.getOrderTime());
                String weworkUserNum = this.scrmUserService.getWeworkUserNumByUserId(orderResp.getCreateBy());
                remindDto.setWeworkUserNum(weworkUserNum);
            }
            this.orderRemindService.payRemind(remindDto);
        }
        catch (Exception e) {
            log.error("send pay time out remind error: ", (Throwable)e);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void savePayOrder(PayOrderReq req) {
        log.info("save pay order req: {}", (Object)req);
        req.validate();
        if (StringUtils.isBlank((CharSequence)req.getPayInfo())) {
            log.info("pay info is empty");
            return;
        }
        PayOrder payOrder = this.payOrderMapper.queryByOrderNo(req.getOrderNo());
        if (payOrder != null) {
            log.info("pay order is exists orderNo: {}", (Object)req.getOrderNo());
            return;
        }
        OrderPayReq orderPayReq = new OrderPayReq();
        orderPayReq.setOrderNo(req.getOrderNo());
        orderPayReq.setPayChannelType(req.getPayChannelType());
        orderPayReq.setTotalAmount(MoneyConverterUtil.scrmToPayCenter((Long)req.getTotalAmount()));
        orderPayReq.setPayAmount(MoneyConverterUtil.scrmToPayCenter((Long)req.getPayAmount()));
        payOrder = this.insertPayOrder(orderPayReq, req.getBizId(), req.getCorpId(), req.getOpUserId());
        OrderRequest orderRequest = new OrderRequest();
        orderRequest.setRequestId(req.getRequestId());
        orderRequest.setChannelType(req.getPayChannelType());
        BaseResponse orderResponse = new BaseResponse();
        OrderData orderData = new OrderData();
        try {
            orderData = (OrderData)JacksonUtil.str2Obj((String)req.getPayInfo(), OrderData.class);
        }
        catch (Exception e) {
            log.error("pay info json parse error: ", (Throwable)e);
        }
        orderResponse.setData((Object)orderData);
        PayRecord payRecord = this.insertPayRecord(orderPayReq, req.getBizId(), req.getCorpId(), req.getOpUserId(), orderRequest, (BaseResponse<OrderData>)orderResponse);
        this.updateCustomerOrderDelayManager.dealPayOrder(payOrder, payRecord);
    }
}

