/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.page.auth.service.impl;

import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.scrm.page.auth.dto.OAuthPageDto;
import cn.kinyun.scrm.page.auth.dto.SnsUserDto;
import cn.kinyun.scrm.page.auth.service.ShortUrlService;
import cn.kinyun.scrm.page.auth.service.WeworkOauthService;
import cn.kinyun.scrm.page.auth.utils.PageAuthRedisUtil;
import cn.kinyun.wework.sdk.api.WwOauth2Client;
import cn.kinyun.wework.sdk.entity.oauth2.UserDetail;
import cn.kinyun.wework.sdk.entity.oauth2.Userinfo;
import com.google.common.base.Preconditions;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.enums.OauthShortUrlTypeEnum;
import com.kuaike.scrm.common.enums.WxOAuthScope;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.marketing.entity.OauthShortUrl;
import com.kuaike.scrm.dal.marketing.mapper.OauthShortUrlMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkCorp;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkCorpMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.system.service.ScrmNetSchoolService;
import com.kuaike.scrm.token.service.AgentTokenService;
import com.kuaike.scrm.token.service.CustomizedTokenService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Base64;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.session.web.http.CookieSerializer;
import org.springframework.session.web.http.DefaultCookieSerializer;
import org.springframework.stereotype.Service;

@Service
public class WeworkOauthServiceImpl
implements WeworkOauthService {
    private static final Logger log = LoggerFactory.getLogger(WeworkOauthServiceImpl.class);
    @Value(value="${scrm.domain.root}")
    private String domain;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${woauth.callbackUrl}")
    private String callbackUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.shortUrl}")
    private String oauthShortUrl;
    @Value(value="${scrm.domain.protocol}${scrm.domain.scrm-manager}${oauth.defaultUrl}")
    private String defaultUrl;
    @Autowired
    private IdGen idGen;
    @Autowired
    private OauthShortUrlMapper oauthShortUrlMapper;
    @Autowired
    private WeworkCorpMapper weworkCorpMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private PageAuthRedisUtil pageAuthRedisUtil;
    @Autowired
    private ShortUrlService shortUrlService;
    @Autowired
    private AgentTokenService agentTokenService;
    @Autowired
    private CustomizedTokenService customizedTokenService;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private WwOauth2Client wwOauth2Client;
    @Autowired
    private ScrmNetSchoolService scrmNetSchoolService;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Value(value="${spring.redis.key.prefix}")
    private String redisKeyPrefix;

    @Override
    public String wrapUrl(Long bizId, String corpId, String url, String shortUrlId, Integer type) {
        log.info("wrap url with params={}", (Object)url);
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{url}), (Object)"\u8df3\u8f6curl\u4e3a\u7a7a");
        OauthShortUrl oauthShort = this.oauthShortUrlMapper.queryShortUrlByOriginUrl(url);
        if (oauthShort != null && StringUtils.isNotBlank((CharSequence)oauthShort.getShortUrl())) {
            return MessageFormat.format(this.oauthShortUrl, oauthShort.getShortUrl());
        }
        OAuthPageDto data = new OAuthPageDto();
        data.setUrl(url);
        data.setType(type);
        data.setBizId(bizId);
        data.setFrom(corpId);
        data.setTo("");
        return this.getShortUrl(corpId, shortUrlId, data);
    }

    @Override
    public String wrapUrl(Long bizId, String corpId, String url, String shortUrlId) {
        return this.wrapUrl(bizId, corpId, url, shortUrlId, OauthShortUrlTypeEnum.MERCHANT_WRAP_URL.getValue());
    }

    @Override
    public String callback(String value, String code, String state, HttpServletRequest request, HttpServletResponse response) {
        log.info("callback with code={}, state={}, param={}", new Object[]{code, state, value});
        OAuthPageDto dto = OAuthPageDto.decrypt(value);
        if (dto == null) {
            log.warn("Invalid param. value={}", (Object)value);
            return this.defaultUrl;
        }
        String url = dto.getUrl();
        log.info("redirectUrl={}", (Object)url);
        if (StringUtils.isBlank((CharSequence)code)) {
            log.warn("Matching failed: code is empty. params={}", (Object)dto);
            return url;
        }
        Long bizId = dto.getBizId();
        WeworkCorp corp = this.weworkCorpMapper.getByBizId(bizId);
        if (corp == null) {
            log.warn("\u4f01\u4e1a\u672a\u6388\u6743, corpId={}", (Object)bizId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u4f01\u4e1a\u672a\u6388\u6743");
        }
        String corpId = corp.getCorpId();
        if (this.codeExist(code)) {
            log.info("code is used, bizId: {}, code: {}", (Object)bizId, (Object)code);
            return url;
        }
        Userinfo userinfo = this.wwOauth2Client.getUserinfo(corpId, code);
        try {
            if (userinfo != null && StringUtils.isNotBlank((CharSequence)userinfo.getOpenId()) && StringUtils.isNotBlank((CharSequence)userinfo.getExternalUserId())) {
                String contactId = userinfo.getExternalUserId();
                if (contactId.startsWith("wm")) {
                    this.ccCustomerNumService.bindContactIdAndOpenId(bizId, userinfo.getExternalUserId(), userinfo.getOpenId(), ModuleType.WEWORK_AUTH.getCode());
                }
            } else if (userinfo != null && StringUtils.isNotBlank((CharSequence)userinfo.getUserId()) && StringUtils.isNotBlank((CharSequence)userinfo.getUserTicket())) {
                UserDetail userdetail = this.wwOauth2Client.getUserdetail(corpId, userinfo.getUserTicket());
                boolean getQrcode = this.saveWeworkUser(corpId, userdetail);
                url = getQrcode ? this.urlAddOauthStatus(url, 1) : this.urlAddOauthStatus(url, 0);
            } else if (userinfo != null && StringUtils.isNotBlank((CharSequence)userinfo.getUserId())) {
                url = this.urlAddOauthStatus(url, 0);
            }
        }
        catch (Exception e) {
            log.error("bind contactId and openId error: ", (Throwable)e);
        }
        this.cacheUser(request, response, bizId, corpId, userinfo);
        return url;
    }

    private String urlAddOauthStatus(String url, int oauthStatus) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        if (url.indexOf(63) > -1) {
            return url + "&oauthStatus=" + oauthStatus;
        }
        return url + "?oauthStatus=" + oauthStatus;
    }

    private boolean codeExist(String code) {
        String key = this.redisKeyPrefix + ":code:" + code;
        boolean result = this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)code, 5L, TimeUnit.MINUTES);
        return !result;
    }

    private boolean saveWeworkUser(String corpId, UserDetail userDetail) {
        boolean result = false;
        log.info("save user private info, corpId:{}, detail:{}", (Object)corpId, (Object)userDetail);
        if (userDetail == null) {
            log.warn("user detail is null");
            return result;
        }
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserInfo(corpId, userDetail.getUserId());
        if (weworkUser == null) {
            log.warn("unknown wework_user, corpId:{}, userId:{}", (Object)corpId, (Object)userDetail.getUserId());
            return result;
        }
        boolean update = false;
        if (StringUtils.isNotBlank((CharSequence)userDetail.getName()) && !Objects.equals(userDetail.getName(), weworkUser.getName())) {
            weworkUser.setName(userDetail.getName());
            update = true;
        }
        if (userDetail.getGender() != null && userDetail.getGender() != 0 && !Objects.equals(userDetail.getGender(), weworkUser.getGender())) {
            weworkUser.setGender(userDetail.getGender());
            update = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getMobile()) && !Objects.equals(userDetail.getMobile(), weworkUser.getMobile())) {
            weworkUser.setMobile(userDetail.getMobile());
            update = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getAvatar()) && !Objects.equals(userDetail.getAvatar(), weworkUser.getAvatar())) {
            weworkUser.setAvatar(userDetail.getAvatar());
            update = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getQrCode()) && !Objects.equals(userDetail.getQrCode(), weworkUser.getQrCode())) {
            weworkUser.setQrCode(userDetail.getQrCode());
            update = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getQrCode())) {
            String vcode = this.getVCode(userDetail.getQrCode());
            if (StringUtils.isNotBlank((CharSequence)vcode) && !Objects.equals(vcode, weworkUser.getVcode())) {
                weworkUser.setVcode(vcode);
                update = true;
            }
            result = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getEmail()) && !Objects.equals(userDetail.getEmail(), weworkUser.getEmail())) {
            weworkUser.setEmail(userDetail.getEmail());
            update = true;
        }
        if (StringUtils.isNotBlank((CharSequence)userDetail.getAddress()) && !Objects.equals(userDetail.getAddress(), weworkUser.getAddress())) {
            weworkUser.setAddress(userDetail.getAddress());
            update = true;
        }
        if (update) {
            this.weworkUserMapper.updateByPrimaryKeySelective((Object)weworkUser);
            boolean isUpdateUser = false;
            boolean updateNameOrTel = false;
            User existUser = this.userMapper.selectUserByWeworkUserIdAndCorpId(weworkUser.getWeworkUserId(), weworkUser.getCorpId());
            if (existUser == null) {
                log.warn("exist user is null, weworkUserId: {}", (Object)weworkUser.getWeworkUserId());
                return result;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getName()) || !existUser.getName().equals(weworkUser.getName())) {
                existUser.setName(weworkUser.getName());
                updateNameOrTel = true;
                isUpdateUser = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getMobile()) || !existUser.getMobile().equals(weworkUser.getMobile())) {
                existUser.setMobile(weworkUser.getMobile());
                updateNameOrTel = true;
                isUpdateUser = true;
            }
            if (StringUtils.isBlank((CharSequence)existUser.getAvatar()) || !existUser.getAvatar().equals(weworkUser.getAvatar())) {
                existUser.setAvatar(weworkUser.getAvatar());
                isUpdateUser = true;
            }
            if (isUpdateUser) {
                this.userMapper.updateByPrimaryKey((Object)existUser);
            }
            if (updateNameOrTel) {
                this.scrmNetSchoolService.afterModScrmUser(existUser);
            }
        }
        return result;
    }

    private String getVCode(String qrCode) {
        if (StringUtils.isBlank((CharSequence)qrCode)) {
            return null;
        }
        Pattern regex = Pattern.compile("vcode=([a-z0-9]+)");
        Matcher matcher = regex.matcher(qrCode);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getShortUrl(String corpId, String shortUrlId, OAuthPageDto params) {
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getType() != null ? 1 : 0) != 0, (Object)"type is null");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{params.getUrl()}), (Object)"url is empty");
        String oauthUrl = this.buildOAuthUrl(corpId, null, params);
        log.info("build oauth url, originUrl: {}, oauthUrl: {}", (Object)params.getUrl(), (Object)oauthUrl);
        String shortUrl = this.idGen.getNum();
        if (StringUtils.isNotBlank((CharSequence)shortUrlId)) {
            OauthShortUrl exist = this.oauthShortUrlMapper.getByShortUrl(shortUrlId);
            if (exist == null) {
                shortUrl = shortUrlId;
            } else {
                log.warn("\u77ed\u94fe\u63a5\u5df2\u5b58\u5728:{}", (Object)shortUrlId);
            }
        }
        this.shortUrlService.recordShortUrl(corpId, params.getType(), params.getUrl(), oauthUrl, shortUrl);
        String url = MessageFormat.format(this.oauthShortUrl, shortUrl);
        log.info("generate shortUrl: {}", (Object)url);
        return url;
    }

    private String buildOAuthUrl(String corpId, Integer agentId, OAuthPageDto params) {
        String redirectUrl = this.callbackUrl + "?v=" + params.encrypt();
        try {
            redirectUrl = URLEncoder.encode(redirectUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error("unsupported encoding", (Throwable)e);
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("https://open.weixin.qq.com/connect/oauth2/authorize?response_type=code&appid=").append(corpId).append("&redirect_uri=").append(redirectUrl);
        if (agentId == null) {
            sb.append("&scope=").append(WxOAuthScope.SNSAPI_USERINFO.getValue());
        } else {
            sb.append("&scope=").append(WxOAuthScope.SNSAPI_PRIVATEINFO.getValue()).append("&agentid=").append(agentId);
        }
        sb.append("&state=").append(corpId).append("#wechat_redirect");
        return sb.toString();
    }

    private void cacheUser(HttpServletRequest request, HttpServletResponse response, Long bizId, String corpId, Userinfo userinfo) {
        WeworkUser user;
        log.info("cache corpId:{}, userinfo:{}", (Object)corpId, (Object)userinfo);
        String userId = userinfo.getUserId();
        String openId = userinfo.getOpenId();
        String token = StringUtils.isNotBlank((CharSequence)userId) ? MD5Utils.MD5((String)(corpId + "," + userId)) : MD5Utils.MD5((String)(corpId + "," + openId));
        SnsUserDto dto = new SnsUserDto();
        dto.setType(1);
        dto.setBusinessCustomerId(bizId);
        dto.setAppId(corpId);
        dto.setOpenId(openId);
        dto.setUserId(userId);
        dto.setDeviceId(userinfo.getDeviceId());
        dto.setExternalUserId(userinfo.getExternalUserId());
        if (StringUtils.isNotBlank((CharSequence)userinfo.getExternalUserId())) {
            WeworkContact contact = this.weworkContactMapper.queryWeworkContact(bizId, corpId, userinfo.getExternalUserId());
            if (contact != null) {
                dto.setNickname(contact.getName());
                dto.setHeadImgUrl(contact.getAvatar());
                dto.setSex(contact.getGender());
            }
        } else if (StringUtils.isNotBlank((CharSequence)userId) && (user = this.weworkUserMapper.queryWeworkUserInfo(corpId, userId)) != null) {
            dto.setNickname(user.getName());
            dto.setHeadImgUrl(user.getAvatar());
            dto.setSex(user.getGender());
        }
        String data = JacksonUtil.obj2Str((Object)dto);
        this.pageAuthRedisUtil.setSnsUser(token, data, Duration.ofSeconds(3600L));
        log.info("domain:{}, token:{}", (Object)this.domain, (Object)token);
        DefaultCookieSerializer cookieSerializer = new DefaultCookieSerializer();
        cookieSerializer.setCookieName("SNS_USERINFO_TOKEN");
        cookieSerializer.setCookieMaxAge(3600);
        cookieSerializer.setCookiePath("/");
        cookieSerializer.setDomainName(this.domain);
        cookieSerializer.setUseHttpOnlyCookie(true);
        cookieSerializer.setUseBase64Encoding(true);
        CookieSerializer.CookieValue cookieValue = new CookieSerializer.CookieValue(request, response, token);
        cookieSerializer.writeCookieValue(cookieValue);
    }

    @Override
    public SnsUserDto user(String token) {
        log.info("query sns userinfo with token={}", (Object)token);
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        try {
            byte[] bytes = Base64.getDecoder().decode(token);
            token = new String(bytes);
        }
        catch (Exception e) {
            log.error("Decode token failed", (Throwable)e);
        }
        String data = this.pageAuthRedisUtil.getSnsUser(token);
        if (StringUtils.isBlank((CharSequence)data) || "null".equals(data)) {
            return null;
        }
        SnsUserDto dto = null;
        try {
            dto = (SnsUserDto)JacksonUtil.str2Obj((String)data, SnsUserDto.class);
        }
        catch (IOException e) {
            log.error("\u53cd\u5e8f\u5217\u5316\u5931\u8d25, data={}", (Object)data, (Object)e);
        }
        return dto;
    }

    @Override
    public String getOAuthUrl(String redirectUrl) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        String corpId = user.getCorpId();
        Long bizId = user.getBizId();
        Integer agentId = this.customizedTokenService.getAgentId(corpId);
        OAuthPageDto params = new OAuthPageDto();
        if (StringUtils.isNotBlank((CharSequence)redirectUrl)) {
            params.setUrl(redirectUrl);
        } else {
            params.setUrl(this.defaultUrl);
        }
        params.setBizId(bizId);
        return this.buildOAuthUrl(corpId, agentId, params);
    }
}

