/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.token.impl;

import cn.kinyun.scrm.weixin.sdk.api.account.WxShorturlAPI;
import cn.kinyun.scrm.weixin.sdk.entity.account.ShorturlResult;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import cn.kinyun.scrm.weixin.token.ShorturlService;
import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ShorturlServiceImpl
implements ShorturlService {
    private static final Logger log = LoggerFactory.getLogger(ShorturlServiceImpl.class);
    @Autowired
    private WxShorturlAPI shorturlApi;
    @Autowired
    private OfficialTokenService officialTokenService;

    @Override
    public String shorturl(String appId, String longUrl) {
        log.info("shorturl with appId={}, longUrl={}", (Object)appId, (Object)longUrl);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)appId), (Object)"appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{longUrl}), (Object)"longUrl\u4e3a\u7a7a");
        String accessToken = this.officialTokenService.getOfficialAccessToken(appId);
        ShorturlResult result = this.shorturlApi.shorturl(accessToken, longUrl);
        return result.getShortUrl();
    }
}

