/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.dto.req;

import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.recommend.dto.RecommendContentDto;
import com.google.common.base.Preconditions;
import com.kuaike.common.utils.DateUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class RecommendAddOrModReq {
    private Long id;
    private String appId;
    private String theme;
    private Integer behaviorType;
    private String condition;
    private Integer unlimitedTrigger;
    private Date beginTime;
    private Date endTime;
    private Integer repeatable;
    private Integer isPermanent;
    private Integer status = 1;
    private List<RecommendContentDto> contentList;

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.appId}), (Object)"appId\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.theme}), (Object)"\u4e3b\u9898\u4e3a\u7a7a");
        BehaviorType behaviorType = BehaviorType.getByValue(this.behaviorType);
        Preconditions.checkArgument((behaviorType != null ? 1 : 0) != 0, (Object)"\u4e0d\u652f\u6301\u7684\u884c\u4e3a\u7c7b\u578b");
        if (behaviorType == BehaviorType.ALL) {
            this.unlimitedTrigger = 1;
        }
        if (this.unlimitedTrigger == null || this.unlimitedTrigger == 0) {
            Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.condition}), (Object)"\u89e6\u53d1\u6761\u4ef6\u4e3a\u7a7a");
        }
        if (this.isPermanent == null || this.isPermanent == 0) {
            Preconditions.checkArgument((this.beginTime != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65f6\u95f4\u4e3a\u7a7a");
            Preconditions.checkArgument((this.endTime != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65f6\u95f4\u4e3a\u7a7a");
            this.beginTime = DateUtil.getBeginOfDay((Date)this.beginTime);
            this.endTime = new Date(DateUtil.getEndOfDay((Date)this.endTime).getTime() - 500L);
            Preconditions.checkArgument((boolean)this.beginTime.before(this.endTime), (Object)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5728\u7ed3\u675f\u65f6\u95f4\u4e4b\u524d");
        }
        Preconditions.checkArgument((this.repeatable != null ? 1 : 0) != 0, (Object)"\u662f\u5426\u53bb\u91cd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(this.contentList), (Object)"\u63a8\u9001\u5185\u5bb9\u4e3a\u7a7a");
        this.contentList.forEach(RecommendContentDto::validate);
    }

    public Long getId() {
        return this.id;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getTheme() {
        return this.theme;
    }

    public Integer getBehaviorType() {
        return this.behaviorType;
    }

    public String getCondition() {
        return this.condition;
    }

    public Integer getUnlimitedTrigger() {
        return this.unlimitedTrigger;
    }

    public Date getBeginTime() {
        return this.beginTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public Integer getRepeatable() {
        return this.repeatable;
    }

    public Integer getIsPermanent() {
        return this.isPermanent;
    }

    public Integer getStatus() {
        return this.status;
    }

    public List<RecommendContentDto> getContentList() {
        return this.contentList;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public void setBehaviorType(Integer behaviorType) {
        this.behaviorType = behaviorType;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setUnlimitedTrigger(Integer unlimitedTrigger) {
        this.unlimitedTrigger = unlimitedTrigger;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setRepeatable(Integer repeatable) {
        this.repeatable = repeatable;
    }

    public void setIsPermanent(Integer isPermanent) {
        this.isPermanent = isPermanent;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setContentList(List<RecommendContentDto> contentList) {
        this.contentList = contentList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecommendAddOrModReq)) {
            return false;
        }
        RecommendAddOrModReq other = (RecommendAddOrModReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$behaviorType = this.getBehaviorType();
        Integer other$behaviorType = other.getBehaviorType();
        if (this$behaviorType == null ? other$behaviorType != null : !((Object)this$behaviorType).equals(other$behaviorType)) {
            return false;
        }
        Integer this$unlimitedTrigger = this.getUnlimitedTrigger();
        Integer other$unlimitedTrigger = other.getUnlimitedTrigger();
        if (this$unlimitedTrigger == null ? other$unlimitedTrigger != null : !((Object)this$unlimitedTrigger).equals(other$unlimitedTrigger)) {
            return false;
        }
        Integer this$repeatable = this.getRepeatable();
        Integer other$repeatable = other.getRepeatable();
        if (this$repeatable == null ? other$repeatable != null : !((Object)this$repeatable).equals(other$repeatable)) {
            return false;
        }
        Integer this$isPermanent = this.getIsPermanent();
        Integer other$isPermanent = other.getIsPermanent();
        if (this$isPermanent == null ? other$isPermanent != null : !((Object)this$isPermanent).equals(other$isPermanent)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$theme = this.getTheme();
        String other$theme = other.getTheme();
        if (this$theme == null ? other$theme != null : !this$theme.equals(other$theme)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Date this$beginTime = this.getBeginTime();
        Date other$beginTime = other.getBeginTime();
        if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        List<RecommendContentDto> this$contentList = this.getContentList();
        List<RecommendContentDto> other$contentList = other.getContentList();
        return !(this$contentList == null ? other$contentList != null : !((Object)this$contentList).equals(other$contentList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RecommendAddOrModReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $behaviorType = this.getBehaviorType();
        result = result * 59 + ($behaviorType == null ? 43 : ((Object)$behaviorType).hashCode());
        Integer $unlimitedTrigger = this.getUnlimitedTrigger();
        result = result * 59 + ($unlimitedTrigger == null ? 43 : ((Object)$unlimitedTrigger).hashCode());
        Integer $repeatable = this.getRepeatable();
        result = result * 59 + ($repeatable == null ? 43 : ((Object)$repeatable).hashCode());
        Integer $isPermanent = this.getIsPermanent();
        result = result * 59 + ($isPermanent == null ? 43 : ((Object)$isPermanent).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $theme = this.getTheme();
        result = result * 59 + ($theme == null ? 43 : $theme.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Date $beginTime = this.getBeginTime();
        result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        List<RecommendContentDto> $contentList = this.getContentList();
        result = result * 59 + ($contentList == null ? 43 : ((Object)$contentList).hashCode());
        return result;
    }

    public String toString() {
        return "RecommendAddOrModReq(id=" + this.getId() + ", appId=" + this.getAppId() + ", theme=" + this.getTheme() + ", behaviorType=" + this.getBehaviorType() + ", condition=" + this.getCondition() + ", unlimitedTrigger=" + this.getUnlimitedTrigger() + ", beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ", repeatable=" + this.getRepeatable() + ", isPermanent=" + this.getIsPermanent() + ", status=" + this.getStatus() + ", contentList=" + this.getContentList() + ")";
    }
}

