/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.message.service.impl;

import cn.kinyun.scrm.weixin.message.service.OfficialAccountMessageService;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessageCriteria;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMessageMapper;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountMessageServiceImpl
implements OfficialAccountMessageService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountMessageServiceImpl.class);
    @Resource
    private OfficialAccountMessageMapper officialAccountMessageMapper;

    @Override
    public OfficialAccountMessage queryLatestByOpenIdAppId(String openId, String appId) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{openId, appId}), (Object)"openId,appId can not be null or empty");
        return this.officialAccountMessageMapper.queryLatestByOpenIdAppId(openId, appId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public int updateByServentSession(List<Long> ids, Long servantSessionId, Long userId) {
        log.info("updateByServentSession with ids={},servantSessionId={},userId={}", new Object[]{ids, servantSessionId, userId});
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(ids), (Object)"ids is empty");
        Preconditions.checkArgument((servantSessionId != null ? 1 : 0) != 0, (Object)"servantSessionId can not be null");
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"userId is null");
        OfficialAccountMessageCriteria condition = new OfficialAccountMessageCriteria();
        condition.createCriteria().andIdIn(ids);
        OfficialAccountMessage item = new OfficialAccountMessage();
        item.setUserId(userId);
        item.setServantSessionId(servantSessionId);
        return this.officialAccountMessageMapper.updateByExampleSelective((Object)item, (Object)condition);
    }

    @Override
    public List<OfficialAccountMessage> queryByServantSessionId(Long servantSessionId) {
        Preconditions.checkArgument((servantSessionId != null ? 1 : 0) != 0, (Object)"\u5ba2\u670d\u4f1a\u8bddid\u4e3a\u7a7a");
        OfficialAccountMessageCriteria condition = new OfficialAccountMessageCriteria();
        condition.createCriteria().andServantSessionIdEqualTo(servantSessionId);
        return this.officialAccountMessageMapper.selectByExample((Object)condition);
    }
}

