/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.event.dto;

import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickKeyPackDto {
    private static final Logger log = LoggerFactory.getLogger(ClickKeyPackDto.class);
    private String type;
    private String key;

    public static ClickKeyPackDto unpack(String eventKey) {
        if (StringUtils.isEmpty((CharSequence)eventKey)) {
            return null;
        }
        String[] arr = eventKey.split("::");
        if (arr == null || arr.length < 2) {
            return null;
        }
        String type = arr[0];
        String key = arr[1];
        if (ClickEventBizType.getType(type) == null) {
            log.warn("unknown type, type={}", (Object)type);
        }
        ClickKeyPackDto dto = new ClickKeyPackDto();
        dto.setKey(key);
        dto.setType(type);
        return dto;
    }

    public ClickKeyPackDto(String type, String key) {
        this.type = type;
        this.key = key;
    }

    public ClickKeyPackDto() {
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickKeyPackDto)) {
            return false;
        }
        ClickKeyPackDto other = (ClickKeyPackDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        return !(this$key == null ? other$key != null : !this$key.equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClickKeyPackDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        return result;
    }

    public String toString() {
        return "ClickKeyPackDto(type=" + this.getType() + ", key=" + this.getKey() + ")";
    }
}

