/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.common.service.impl;

import cn.kinyun.scrm.weixin.common.dto.IdAndNameDto;
import cn.kinyun.scrm.weixin.common.service.BlackReasonService;
import com.google.common.collect.Lists;
import com.kuaike.scrm.dal.official.base.mapper.BlackReasonMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlackReasonServiceImpl
implements BlackReasonService {
    private static final Logger log = LoggerFactory.getLogger(BlackReasonServiceImpl.class);
    @Autowired
    private BlackReasonMapper blackReasonMapper;

    @Override
    public List<IdAndNameDto> getByIds(Collection<Long> ids) {
        log.info("query black reason info with ids={}", ids);
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ids)) {
            return result;
        }
        List list = this.blackReasonMapper.getByIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(a -> result.add(new IdAndNameDto(a.getId(), a.getReason())));
        }
        return result;
    }

    @Override
    public List<Long> reasonLike(String reason) {
        if (StringUtils.isBlank((CharSequence)reason)) {
            return Collections.emptyList();
        }
        return this.blackReasonMapper.getIdsWithReasonLike(reason);
    }
}

