/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.utils;

import cn.kinyun.scrm.weixin.activity.dto.resp.OfficialActiTaskResp;
import cn.kinyun.scrm.weixin.common.functions.DynamicExport;
import cn.kinyun.scrm.weixin.common.functions.ListObjExportable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.annotation.FieldDesc;
import com.kuaike.common.dto.resp.GradeDto;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.enums.EnumConstant;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class PojoExport2Excel {
    private PojoExport2Excel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <T> void printByAnnotation(List<T> beanList, Class<T> clazz, HttpServletResponse response, String returnName, String sheetName, List<String> fieldList, boolean isAppendDate) throws IOException, IllegalAccessException {
        if (StringUtils.isBlank((CharSequence)returnName)) {
            returnName = UUID.randomUUID().toString().replace("-", "");
        }
        if (isAppendDate) {
            Class<PojoExport2Excel> clazz2 = PojoExport2Excel.class;
            // MONITORENTER : cn.kinyun.scrm.weixin.utils.PojoExport2Excel.class
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5", Locale.getDefault());
            Date now = new Date();
            String nowStr = sdf.format(now);
            // MONITOREXIT : clazz2
            returnName = returnName + "-" + nowStr;
        }
        returnName = returnName + ".xlsx";
        PojoExport2Excel.doPrint(beanList, clazz, response, returnName, sheetName, fieldList);
    }

    private static <T> void doPrint(List<T> beanList, Class<T> clazz, HttpServletResponse response, String returnName, String sheetName, List<String> fieldList) throws IOException, IllegalAccessException {
        Object os;
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFSheet sheet = wb.createSheet(sheetName);
        PojoExport2Excel.printHeaderAndValue(beanList, clazz, fieldList, wb, (Sheet)sheet);
        if (response != null) {
            response.reset();
            os = response.getOutputStream();
            returnName = new String(returnName.getBytes("gbk"), StandardCharsets.ISO_8859_1);
            response.setHeader("Content-Disposition", "attachment;filename=\"" + returnName + "\"");
            response.setContentType("application/msexcel");
        } else {
            os = new FileOutputStream("1.xlsx");
        }
        wb.write((OutputStream)os);
        wb.close();
        ((OutputStream)os).close();
    }

    /*
     * Unable to fully structure code
     */
    private static <T> void printHeaderAndValue(List<T> beanList, Class<T> clazz, List<String> fieldList, XSSFWorkbook wb, Sheet sheet) throws IllegalAccessException {
        rowNo = 0;
        cellNo = 0;
        nRow = sheet.createRow(rowNo++);
        nRow.setHeightInPoints(20.0f);
        percentMap = Maps.newHashMap();
        percentLengthMap = Maps.newHashMap();
        dateFormatMap = Maps.newHashMap();
        fields = clazz.getDeclaredFields();
        hasFieldInfo = true;
        if (CollectionUtils.isEmpty(fieldList)) {
            hasFieldInfo = false;
            fieldList = Lists.newArrayList();
        }
        PojoExport2Excel.recurveGetFieldList(beanList.get(0), fields, fieldList, new HashSet<Class<?>>(), percentMap, percentLengthMap, dateFormatMap, hasFieldInfo);
        if (CollectionUtils.isEmpty((Collection)fieldList)) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b57\u6bb5\u4fe1\u606f");
        }
        if (beanList.get(0) instanceof OfficialActiTaskResp && !(taskResp = (OfficialActiTaskResp)beanList.get(0)).getHasPhysicsPhase().booleanValue()) {
            fieldList.remove("\u5feb\u9012\u5355\u53f7");
        }
        headerStyle = PojoExport2Excel.getCellStyle(wb, true);
        contentStyle = PojoExport2Excel.getCellStyle(wb, false);
        lengthMap = Maps.newHashMap();
        for (String fieldName : fieldList) {
            length = fieldName.length() * 4 * 256;
            sheet.setColumnWidth(cellNo, length);
            lengthMap.put(fieldName, length);
            nCell = nRow.createCell(cellNo++);
            nCell.setCellValue(fieldName);
            nCell.setCellStyle(headerStyle);
        }
        cellNo = 0;
        for (Object t : beanList) {
            nRow = sheet.createRow(rowNo++);
            valueMap = Maps.newHashMap();
            PojoExport2Excel.recurveFillValueMap(t, fields, valueMap, new HashSet<Class<?>>());
            for (String showName : fieldList) {
                nRow.setHeightInPoints(20.0f);
                nCell = nRow.createCell(cellNo++);
                obj = valueMap.get(showName);
                if (obj != null) {
                    percent = (Boolean)percentMap.get(showName);
                    if (percent) {
                        percentLength = (Integer)percentLengthMap.get(showName);
                        try {
                            number = (Number)obj;
                            if (percentLength == 100) {
                                b = BigDecimal.valueOf(number.doubleValue()).divide(BigDecimal.valueOf(100L), RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                                nCell.setCellValue(b.doubleValue());
                            }
                            if (percentLength != 10000) ** GOTO lbl81
                            b = BigDecimal.valueOf(number.doubleValue()).divide(BigDecimal.valueOf(10000L), RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
                            nCell.setCellValue(b.doubleValue());
                        }
                        catch (ClassCastException e) {
                            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u9700\u8981\u6253\u5370\u7684\u5b57\u6bb5\u4e0d\u4e3a\u6570\u503c\uff0c\u63cf\u8ff0\u4fe1\u606f\u9519\u8bef");
                        }
                    } else if (obj instanceof IdAndNameDto) {
                        nCell.setCellValue(((IdAndNameDto)obj).getName());
                    } else if (obj instanceof EnumConstant) {
                        nCell.setCellValue(((EnumConstant)obj).getDesc());
                    } else if (obj instanceof Node) {
                        nCell.setCellValue(((Node)obj).getName());
                    } else if (obj instanceof GradeDto) {
                        grade = (GradeDto)obj;
                        if (grade.getGradeId() != -1L) {
                            nCell.setCellValue(grade.getGradeLevelStr() + "(" + grade.getGradeLevelName() + ")");
                        } else {
                            nCell.setCellValue("\u672a\u5b9a\u7ea7");
                        }
                    } else if (obj instanceof Date) {
                        date = (Date)obj;
                        format = dateFormatMap.getOrDefault(showName, "yyyy-MM-dd");
                        sdf = new SimpleDateFormat(format, Locale.getDefault());
                        nCell.setCellValue(sdf.format(date));
                    } else {
                        if (obj instanceof List) {
                            throw new UnsupportedOperationException("List not support");
                        }
                        nCell.setCellValue(obj.toString());
                    }
lbl81:
                    // 10 sources

                    oldMaxLength = (Integer)lengthMap.get(showName);
                    valueLength = obj.toString().length() * 2 * 256;
                    if (obj instanceof Date) {
                        valueLength = 2560;
                    }
                    maxLength = Math.max(oldMaxLength, valueLength);
                    if (showName.equals("\u5907\u6ce8")) {
                        sheet.setColumnWidth(cellNo - 1, Math.min(maxLength, 2560));
                    }
                    lengthMap.put(showName, maxLength);
                }
                nCell.setCellStyle(contentStyle);
            }
            cellNo = 0;
        }
    }

    private static <T> void recurveGetFieldList(T t, Field[] fields, List<String> fieldList, Set<Class<?>> classSet, Map<String, Boolean> percentMap, Map<String, Integer> percentLengthMap, Map<String, String> dateFormatMap, boolean hasFieldInfo) throws IllegalAccessException {
        classSet.add(t.getClass());
        String dynamicExportValue = "";
        if (t instanceof DynamicExport) {
            dynamicExportValue = ((DynamicExport)t).dynamicValue();
        }
        for (Field field : fields) {
            FieldDesc fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
            if (fieldDesc == null) continue;
            if (!field.getType().equals(List.class)) {
                String desc = String.format(fieldDesc.desc(), dynamicExportValue);
                if (!hasFieldInfo) {
                    fieldList.add(desc);
                }
                percentMap.put(desc, fieldDesc.percent());
                percentLengthMap.put(desc, fieldDesc.percentLenth());
                dateFormatMap.put(desc, fieldDesc.dateFormat());
                continue;
            }
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Class cl = (Class)type.getActualTypeArguments()[0];
            if (cl == null || classSet.contains(cl)) continue;
            field.setAccessible(true);
            List list = (List)field.get(t);
            for (Object o : list) {
                PojoExport2Excel.recurveGetFieldList(o, cl.getDeclaredFields(), fieldList, classSet, percentMap, percentLengthMap, dateFormatMap, hasFieldInfo);
            }
        }
    }

    private static <T> void recurveFillValueMap(T t, Field[] fields, Map<String, Object> valueMap, Set<Class<?>> classSet) throws IllegalAccessException {
        classSet.add(t.getClass());
        String dynamicExportValue = "";
        if (t instanceof DynamicExport) {
            dynamicExportValue = ((DynamicExport)t).dynamicValue();
        }
        for (Field field : fields) {
            FieldDesc fieldDesc = field.getDeclaredAnnotation(FieldDesc.class);
            if (fieldDesc == null) continue;
            if (!field.getType().equals(List.class)) {
                field.setAccessible(true);
                valueMap.put(String.format(fieldDesc.desc(), dynamicExportValue), field.get(t));
                continue;
            }
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            Class cl = (Class)type.getActualTypeArguments()[0];
            if (cl == null || classSet.contains(cl) || !PojoExport2Excel.hasInterface(cl, ListObjExportable.class)) continue;
            List list = (List)field.get(t);
            for (Object o : list) {
                PojoExport2Excel.recurveFillValueMap(o, cl.getDeclaredFields(), valueMap, classSet);
            }
        }
    }

    private static boolean hasInterface(Class<?> child, Class<?> parent) {
        Class<?>[] interfaces;
        for (Class<?> fInterface : interfaces = child.getInterfaces()) {
            if (fInterface != parent) continue;
            return true;
        }
        return false;
    }

    private static CellStyle getCellStyle(XSSFWorkbook wb, boolean bold) {
        XSSFCellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        XSSFFont font = wb.createFont();
        font.setFontName("\u9ed1\u4f53");
        font.setBold(bold);
        font.setFontHeightInPoints((short)12);
        cellStyle.setFont((Font)font);
        return cellStyle;
    }
}

