/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.utils;

import cn.kinyun.scrm.weixin.recommend.common.dto.Condition;
import cn.kinyun.scrm.weixin.recommend.common.dto.Edge;
import cn.kinyun.scrm.weixin.recommend.common.dto.Expression;
import cn.kinyun.scrm.weixin.recommend.common.dto.Node;
import cn.kinyun.scrm.weixin.recommend.common.dto.Op;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;

public final class ActivityGraphUtils {
    private ActivityGraphUtils() {
    }

    public static Node buildNode(int nodeId, List<Op> ops) {
        Node node = new Node();
        node.setId(nodeId);
        node.setOps(ops);
        return node;
    }

    public static Condition buildCondition(int behaviorConfId, Expression ... expression) {
        Condition condition = new Condition();
        condition.setBehaviorConfId(behaviorConfId);
        condition.setExps(Lists.newArrayList((Object[])expression));
        return condition;
    }

    public static Expression buildExp(String field, int op, List<String> values) {
        Expression expression = new Expression();
        expression.setField(field);
        expression.setOp(op);
        expression.setValues(values);
        return expression;
    }

    public static Op buildOp(int opConfId, Map<String, String> context) {
        Op op = new Op();
        op.setConfId(opConfId);
        op.setContext(context);
        return op;
    }

    public static Edge buildEdge(int fromNodeId, int toNodeId, int conditionRelation, Condition ... conditions) {
        Edge edge = new Edge();
        edge.setFromNodeId(fromNodeId);
        edge.setToNodeId(toNodeId);
        edge.setConditionRelation(conditionRelation);
        edge.setConditions(Lists.newArrayList((Object[])conditions));
        return edge;
    }
}

