/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.recommend.common.dto;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Expression
implements Serializable {
    private static final long serialVersionUID = -269925685400153787L;
    private String field;
    private int op;
    private List<String> values;

    public boolean match(Map<String, String> context) {
        String value = context.get(this.field);
        if (value == null) {
            return false;
        }
        try {
            if (this.op == ActExpOpType.EQ.type) {
                return StringUtils.equals((CharSequence)String.valueOf(this.values.get(0)), (CharSequence)value);
            }
            if (this.op == ActExpOpType.NOT_EQ.type) {
                return !StringUtils.equals((CharSequence)String.valueOf(this.values.get(0)), (CharSequence)value);
            }
            if (this.op == ActExpOpType.IN.type) {
                return this.values.contains(value);
            }
            if (this.op == ActExpOpType.NOT_IN.type) {
                return !this.values.contains(value);
            }
            if (this.op == ActExpOpType.CONTAINS.type) {
                return this.values.get(0).contains(value);
            }
            if (this.op == ActExpOpType.NOT_CONTAINS.type) {
                return !this.values.get(0).contains(value);
            }
            Double dValue = Double.parseDouble(value);
            Double dExp = Double.parseDouble(this.values.get(0));
            if (this.op == ActExpOpType.LT.type) {
                return dValue < dExp;
            }
            if (this.op == ActExpOpType.LE.type) {
                return dValue <= dExp;
            }
            if (this.op == ActExpOpType.GT.type) {
                return dValue > dExp;
            }
            if (this.op == ActExpOpType.GE.type) {
                return dValue >= dExp;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.field).append(ActExpOpType.getOp(this.op).desc).append(StringUtils.join(this.values, (String)","));
        return sb.toString();
    }

    public String getField() {
        return this.field;
    }

    public int getOp() {
        return this.op;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setOp(int op) {
        this.op = op;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOp() != other.getOp()) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Expression;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOp();
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public static enum ActExpOpType {
        EQ(1, " == "),
        NOT_EQ(2, " != "),
        IN(3, " in "),
        NOT_IN(4, " not in "),
        LT(5, " < "),
        LE(6, " <= "),
        GT(7, " > "),
        GE(8, " >= "),
        CONTAINS(9, " contain "),
        NOT_CONTAINS(10, " not contain ");

        private int type;
        private String desc;
        private static Map<Integer, ActExpOpType> map;

        public static ActExpOpType getOp(int op) {
            return map.get(op);
        }

        public int getType() {
            return this.type;
        }

        public String getDesc() {
            return this.desc;
        }

        private ActExpOpType(int type, String desc) {
            this.type = type;
            this.desc = desc;
        }

        static {
            map = Maps.newHashMap();
            for (ActExpOpType op : ActExpOpType.values()) {
                map.put(op.type, op);
            }
        }
    }
}

