/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.officialaccount.dto.req.CodeReqDto;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialService;
import cn.kinyun.scrm.weixin.sdk.api.WxOAuth2API;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsAccessToken;
import cn.kinyun.scrm.weixin.sdk.entity.sns.SnsUserinfo;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.ComponentTokenService;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import java.io.IOException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class OfficialServiceImpl
implements OfficialService {
    private static final Logger log = LoggerFactory.getLogger(OfficialServiceImpl.class);
    @Resource
    private ComponentTokenService platformInfoService;
    @Resource
    private WxOAuth2API wxOAuth2API;
    @Value(value="${wx.component.appid}")
    private String componentAppId;

    @Override
    public String getOpenIdByAppIdAndCode(CodeReqDto dto) {
        SnsAccessToken snsAccessToken;
        log.info("getOpenIdByAppIdAndCode dto:{}", (Object)dto);
        dto.validate();
        String componentToken = this.platformInfoService.getComponentAccessToken();
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(dto.getAppId(), dto.getCode(), this.componentAppId, componentToken);
        }
        catch (WeixinException e) {
            log.error("getOpenIdByAppIdAndCode getComponentAccessToken error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        return snsAccessToken.getOpenId();
    }

    @Override
    public void userAuthRedirect(String redirectUrl, String code, String appId, HttpServletResponse response, Integer getUserinfo) {
        SnsAccessToken snsAccessToken;
        log.info("userAuthRedirect redirectUrl:{} code:{} getUserinfo:{}", new Object[]{redirectUrl, code, getUserinfo});
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, code})) {
            try {
                response.sendRedirect(redirectUrl);
                return;
            }
            catch (IOException e) {
                log.error("userAuthRedirect sendRedirect error", (Throwable)e);
            }
        }
        String componentToken = this.platformInfoService.getComponentAccessToken();
        try {
            snsAccessToken = this.wxOAuth2API.getComponentAccessToken(appId, code, this.componentAppId, componentToken);
        }
        catch (WeixinException e) {
            log.error("userAuthRedirect getComponentAccessToken error", (Throwable)e);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f51\u7edc\u5f02\u5e38\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String openId = snsAccessToken.getOpenId();
        redirectUrl = redirectUrl.contains("?") ? redirectUrl + "&openId=" + openId : redirectUrl + "?openId=" + openId;
        redirectUrl = redirectUrl + "&appId=" + appId;
        if (NumberUtils.INTEGER_ONE.equals(getUserinfo)) {
            String accessToken = snsAccessToken.getAccessToken();
            try {
                SnsUserinfo snsUserinfo = this.wxOAuth2API.getUserinfo(accessToken, openId, "zh_CN");
                String avatar = snsUserinfo.getHeadImgUrl();
                String nickname = snsUserinfo.getNickname();
                String unionId = snsUserinfo.getUnionId();
                if (StringUtils.isNotBlank((CharSequence)avatar)) {
                    redirectUrl = redirectUrl + "&avatar=" + URLEncoder.encode(avatar, "utf-8");
                }
                if (StringUtils.isNotBlank((CharSequence)nickname)) {
                    redirectUrl = redirectUrl + "&nickname=" + URLEncoder.encode(nickname, "utf-8");
                }
                if (StringUtils.isNotBlank((CharSequence)unionId)) {
                    redirectUrl = redirectUrl + "&unionId=" + URLEncoder.encode(unionId, "utf-8");
                }
            }
            catch (Exception e) {
                log.error("userAuthRedirect getUserinfo error", (Throwable)e);
            }
        }
        try {
            log.info("userAuthRedirect redirectUrl:{}", (Object)redirectUrl);
            response.sendRedirect(redirectUrl);
        }
        catch (IOException e) {
            log.error("userAuthRedirect sendRedirect error", (Throwable)e);
        }
    }
}

