/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.officialaccount.service.impl;

import cn.kinyun.scrm.weixin.message.dto.MassMessageSendCondition;
import cn.kinyun.scrm.weixin.officialaccount.service.OfficialAccountFansTagService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.MD5Utils;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import com.kuaike.scrm.dal.official.fans.entity.OfficialAccountFansTag;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansMapper;
import com.kuaike.scrm.dal.official.fans.mapper.OfficialAccountFansTagMapper;
import com.kuaike.scrm.dal.weworktag.WeworkTagDto;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class OfficialAccountFansTagServiceImpl
implements OfficialAccountFansTagService {
    private static final Logger log = LoggerFactory.getLogger(OfficialAccountFansTagServiceImpl.class);
    @Resource
    private OfficialAccountFansTagMapper fansTagMapper;
    @Resource
    private OfficialAccountFansMapper officialAccountFansMapper;
    @Resource
    private WeworkTagMapper weworkTagMapper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;

    @Override
    public Map<String, List<String>> queryAppPostTagIds(Collection<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyMap();
        }
        return this.fansTagMapper.queryAppPostTagIds(appIds);
    }

    @Override
    public Map<String, List<WeworkTagDto>> queryFansTagInfo(Collection<String> uniqueIds) {
        if (CollectionUtils.isEmpty(uniqueIds)) {
            return Collections.emptyMap();
        }
        List list = this.fansTagMapper.queryTagsByFansIds(uniqueIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        Set wechatGroupIds = list.stream().map(OfficialAccountFansTag::getOfficialAccountTagId).filter(Objects::nonNull).collect(Collectors.toSet());
        Map tagMap = this.weworkTagMapper.selectTagIdAndNameByCorpIdAndTagIds(LoginUtils.getCurrentUserCorpId(), wechatGroupIds);
        return list.stream().collect(Collectors.groupingBy(OfficialAccountFansTag::getOfficialAccountFansId, Collectors.mapping(a -> {
            WeworkTagDto dto = new WeworkTagDto();
            String tagId = a.getOfficialAccountTagId();
            dto.setId(tagId);
            dto.setName((String)tagMap.get(tagId));
            return dto;
        }, Collectors.toList())));
    }

    @Override
    public List<String> queryDistinctAppPostTagIds(List<String> appIds) {
        if (CollectionUtils.isEmpty(appIds)) {
            return Collections.emptyList();
        }
        return this.fansTagMapper.queryDistinctAppPostTagIds(appIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void buildFansTags(String appId, String openId, List<String> tagIds, Long creatorId) {
        if (CollectionUtils.isEmpty(tagIds)) {
            return;
        }
        OfficialAccount account = this.officialAccountMapper.getByAppId(appId);
        String fansId = MD5Utils.MD5((String)(appId + "_" + openId));
        List existFansTags = this.fansTagMapper.queryTagsByFansIds((Collection)Lists.newArrayList((Object[])new String[]{fansId}));
        List existFanTagIds = existFansTags.stream().map(OfficialAccountFansTag::getOfficialAccountTagId).collect(Collectors.toList());
        ArrayList fansTags = Lists.newArrayList();
        for (String tagId : tagIds) {
            if (existFanTagIds.contains(tagId)) continue;
            OfficialAccountFansTag fansTag = new OfficialAccountFansTag();
            fansTag.setBizId(account.getBizId());
            fansTag.setCorpId(account.getCorpId());
            fansTag.setOfficialAccountTagId(tagId);
            fansTag.setOfficialAccountFansId(fansId);
            fansTag.setCreatorId(Long.valueOf(-1L));
            fansTags.add(fansTag);
        }
        if (CollectionUtils.isNotEmpty((Collection)fansTags)) {
            this.fansTagMapper.saveAll((List)fansTags);
        }
    }

    @Override
    public Map<String, Integer> statFansCount(List<String> appIds, List<String> tagIds, Integer sendScope, Integer tagRelation, List<IdAndNameDto> areaInfo, Integer sex) {
        Map appId2FansCountMap = Maps.newHashMap();
        List areaNames = Optional.ofNullable(areaInfo).map(a -> a.stream().map(IdAndNameDto::getName).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty(tagIds) && CollectionUtils.isEmpty(areaInfo) && sex == null) {
            log.debug("tagIds, areaNames, sex are both empty, SCOPE={}", (Object)sendScope);
            if (sendScope.intValue() == MassMessageSendCondition.SendScope.EXCLUDE.getValue()) {
                sendScope = MassMessageSendCondition.SendScope.ALL.getValue();
            } else if (sendScope.intValue() == MassMessageSendCondition.SendScope.PART.getValue()) {
                return appId2FansCountMap;
            }
        }
        if (sendScope.intValue() == MassMessageSendCondition.SendScope.ALL.getValue()) {
            return this.officialAccountFansMapper.countAllFansByAppIds(appIds);
        }
        if (tagRelation.intValue() == MassMessageSendCondition.TagRelation.OR.getValue()) {
            appId2FansCountMap = sendScope.intValue() == MassMessageSendCondition.SendScope.EXCLUDE.getValue() ? this.officialAccountFansMapper.countOpenIdsByTagOrExclude(appIds, tagIds, areaNames, sex) : this.officialAccountFansMapper.countOpenIdsByTagOrInclude(appIds, tagIds, areaNames, sex);
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6682\u4e0d\u652f\u6301\u7684\u9009\u62e9\u7c7b\u578b");
        }
        return appId2FansCountMap;
    }

    @Override
    public Map<String, List<String>> getOpenIdsByCondition(List<String> appIds, List<String> tagIds, Integer tagRelation, Integer sendScope, List<IdAndNameDto> areaInfo, Integer sex, PageDto pageDto) {
        Map app2OpenIds = Maps.newHashMap();
        Map appCountMap = Maps.newHashMap();
        List areaNames = Optional.ofNullable(areaInfo).map(a -> a.stream().map(IdAndNameDto::getName).collect(Collectors.toList())).orElse(Lists.newArrayList());
        if (CollectionUtils.isEmpty(tagIds) && CollectionUtils.isEmpty((Collection)areaNames) && sex == null) {
            if (sendScope.intValue() == MassMessageSendCondition.SendScope.EXCLUDE.getValue()) {
                sendScope = MassMessageSendCondition.SendScope.ALL.getValue();
            } else if (sendScope.intValue() == MassMessageSendCondition.SendScope.PART.getValue()) {
                this.buildPage(pageDto, appCountMap, app2OpenIds);
                return app2OpenIds;
            }
        }
        if (sendScope.intValue() == MassMessageSendCondition.SendScope.ALL.getValue()) {
            app2OpenIds = this.officialAccountFansMapper.queryAllFansByAppIds(appIds, pageDto);
            if (pageDto != null) {
                appCountMap = this.officialAccountFansMapper.countAllFansByAppIds(appIds);
            }
        } else if (tagRelation.intValue() == MassMessageSendCondition.TagRelation.OR.getValue()) {
            if (sendScope.intValue() == MassMessageSendCondition.SendScope.EXCLUDE.getValue()) {
                app2OpenIds = this.officialAccountFansMapper.queryOpenIdsByTagOrExclude(appIds, tagIds, areaNames, sex, pageDto);
                if (pageDto != null) {
                    appCountMap = this.officialAccountFansMapper.countOpenIdsByTagOrExclude(appIds, tagIds, areaNames, sex);
                }
            } else {
                app2OpenIds = this.officialAccountFansMapper.queryOpenIdsByTagOrInclude(appIds, tagIds, areaNames, sex, pageDto);
                if (pageDto != null) {
                    appCountMap = this.officialAccountFansMapper.countOpenIdsByTagOrInclude(appIds, tagIds, areaNames, sex);
                }
            }
        } else {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6682\u4e0d\u652f\u6301\u7684\u9009\u62e9\u7c7b\u578b");
        }
        this.buildPage(pageDto, appCountMap, app2OpenIds);
        return app2OpenIds;
    }

    private void buildPage(PageDto pageDto, Map<String, Integer> appCountMap, Map<String, List<String>> app2OpenIds) {
        if (pageDto != null) {
            int count = appCountMap.values().stream().reduce(Integer::sum).orElse(0);
            int[] curPageSize = new int[]{0};
            app2OpenIds.forEach((k, v) -> {
                curPageSize[0] = curPageSize[0] + v.size();
            });
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(curPageSize[0]));
        }
    }
}

