/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.material.service.impl;

import cn.kinyun.scrm.weixin.enums.MsgSyncStatus;
import cn.kinyun.scrm.weixin.material.service.FansMediaUploadService;
import cn.kinyun.scrm.weixin.message.dto.MsgData;
import cn.kinyun.scrm.weixin.message.service.EsMessageService;
import cn.kinyun.scrm.weixin.message.service.MessageService;
import cn.kinyun.scrm.weixin.sdk.api.WxMediaAPI;
import cn.kinyun.scrm.weixin.sdk.api.material.MaterialApi;
import cn.kinyun.scrm.weixin.sdk.entity.material.dto.VideoMaterialDto;
import cn.kinyun.scrm.weixin.sdk.entity.material.resp.GetMaterialResp;
import cn.kinyun.scrm.weixin.sdk.entity.media.Attachment;
import cn.kinyun.scrm.weixin.sdk.enums.WxMsgType;
import cn.kinyun.scrm.weixin.sdk.exception.WeixinException;
import cn.kinyun.scrm.weixin.token.OfficialTokenService;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.scrm.common.component.AliyunOss;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccountMessage;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMessageMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FansMediaUploadServiceImpl
implements FansMediaUploadService {
    private static final Logger log = LoggerFactory.getLogger(FansMediaUploadServiceImpl.class);
    @Autowired
    private AliyunOss aliyunOss;
    @Autowired
    private MessageService messageService;
    @Autowired
    private EsMessageService esMessageService;
    @Autowired
    private OfficialAccountMessageMapper officialAccountMessageMapper;
    @Autowired
    private MaterialApi materialApi;
    @Autowired
    private WxMediaAPI mediaApi;
    @Autowired
    private OfficialTokenService tokenService;
    private static final ExecutorService asyncExecutor = Executors.newFixedThreadPool(20);

    @Override
    public boolean needSync(String msgType) {
        WxMsgType type = WxMsgType.get((String)msgType);
        if (type == null) {
            return false;
        }
        return type == WxMsgType.Image || type == WxMsgType.Voice || type == WxMsgType.Video || type == WxMsgType.ShortVideo;
    }

    @Override
    public void asyncUpload(OfficialAccountMessage message, MsgData msgData) {
        asyncExecutor.submit(new AsyncMediaTask(message, msgData));
    }

    public String getMediaUrl(String appId, String mediaId) {
        File file = this.download(appId, mediaId);
        if (file != null) {
            return this.aliyunOss.uploadFile(appId, file, file.getName());
        }
        return null;
    }

    @Override
    public File download(String appId, String mediaId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{appId, mediaId})) {
            return null;
        }
        File file = null;
        Attachment attachment = null;
        try {
            String accessToken;
            if (mediaId.length() >= 64) {
                log.info("\u4e0b\u8f7d\u7c89\u4e1d\u4e34\u65f6\u7d20\u6750, appId={}, mediaId={}", (Object)appId, (Object)mediaId);
                accessToken = this.tokenService.getOfficialAccessToken(appId);
                attachment = this.mediaApi.get(accessToken, mediaId);
            } else {
                log.info("\u4e0b\u8f7d\u7c89\u4e1d\u6c38\u4e45\u7d20\u6750, appId={}, mediaId={}", (Object)appId, (Object)mediaId);
                accessToken = this.tokenService.getOfficialAccessToken(appId);
                GetMaterialResp resp = this.materialApi.getMaterial(accessToken, mediaId);
                if (resp.getType() == 3) {
                    attachment = resp.getAttachment();
                } else if (resp.getType() == 2) {
                    VideoMaterialDto video = resp.getVideo();
                    attachment = video.getAttachment();
                } else {
                    log.warn("\u63a5\u6536\u5230\u6765\u81ea\u7c89\u4e1d\u7684\u56fe\u6587\u7d20\u6750\uff0c\u4e0d\u662f\u4e00\u4e2a\u5408\u6cd5\u7684\u6d88\u606f\u3002appId={}, mediaId={}", (Object)appId, (Object)mediaId);
                }
            }
        }
        catch (WeixinException | IOException | GeneralSecurityException e) {
            log.error("\u4e0b\u8f7d\u5931\u8d25", e);
        }
        if (attachment != null) {
            String fileName = attachment.getFileName();
            if (fileName.endsWith("\"")) {
                fileName = fileName.substring(0, fileName.length() - 1);
            }
            String path = this.getClass().getResource("/").getPath() + File.pathSeparator + fileName;
            try {
                file = new File(path);
                FileUtils.copyInputStreamToFile((InputStream)attachment.getInputStream(), (File)file);
            }
            catch (IOException e) {
                file = null;
            }
        }
        return file;
    }

    private class AsyncMediaTask
    implements Runnable {
        private final OfficialAccountMessage message;
        private final MsgData msgData;

        public AsyncMediaTask(OfficialAccountMessage message, MsgData msgData) {
            this.message = message;
            this.msgData = msgData;
        }

        @Override
        public void run() {
            String thumbMediaUrl;
            File file;
            String mediaUrl;
            boolean modified = false;
            String appId = this.message.getAppId();
            WxMsgType msgType = WxMsgType.get((String)this.message.getMsgType());
            if ((msgType == WxMsgType.Image || msgType == WxMsgType.Video || msgType == WxMsgType.ShortVideo) && (mediaUrl = FansMediaUploadServiceImpl.this.getMediaUrl(appId, this.msgData.getMediaId())) != null) {
                this.msgData.setMediaUrl(mediaUrl);
                modified = true;
            }
            if (msgType == WxMsgType.Voice && (file = FansMediaUploadServiceImpl.this.download(appId, this.msgData.getMediaId())) != null) {
                FansMediaUploadServiceImpl.this.messageService.setVoiceTranscodeInfo(appId, file, this.msgData);
                modified = true;
            }
            if ((msgType == WxMsgType.Video || msgType == WxMsgType.ShortVideo) && (thumbMediaUrl = FansMediaUploadServiceImpl.this.getMediaUrl(appId, this.msgData.getThumbMediaId())) != null) {
                this.msgData.setThumbMediaUrl(thumbMediaUrl);
                modified = true;
            }
            if (modified) {
                this.message.setContent(JacksonUtil.obj2Str((Object)this.msgData));
                this.message.setSyncStatus(Integer.valueOf(MsgSyncStatus.SUCCESS.getValue()));
            } else {
                this.message.setSyncStatus(Integer.valueOf(MsgSyncStatus.FAILED.getValue()));
            }
            try {
                FansMediaUploadServiceImpl.this.officialAccountMessageMapper.updateByPrimaryKeySelective((Object)this.message);
                FansMediaUploadServiceImpl.this.esMessageService.save(this.message);
            }
            catch (Exception e) {
                log.error("\u6d88\u606f\u6570\u636e\u66f4\u65b0\u5931\u8d25", (Throwable)e);
            }
        }
    }
}

