/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.enums.autoreply;

import com.kuaike.common.enums.EnumService;
import java.util.HashMap;
import java.util.Map;

public enum AutoReplyMessageType implements EnumService
{
    MATERIAL(0, "\u7d20\u6750"),
    TEXT(1, "\u6587\u672c"),
    LEAD(2, "\u6f0f\u6597"),
    FISSION(3, "\u88c2\u53d8"),
    OFFICIAL_FISSION(4, "\u516c\u4f17\u53f7\u88c2\u53d8"),
    TEMPLATE_MSG(5, "\u6a21\u677f\u6d88\u606f"),
    NEWS(495, "\u56fe\u6587\u94fe\u63a5");

    private static final Map<Integer, AutoReplyMessageType> CACHE;
    private final int value;
    private final String desc;

    private AutoReplyMessageType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static AutoReplyMessageType getType(Integer value) {
        return CACHE.get(value);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public static Integer getValueByDesc(String desc) {
        for (AutoReplyMessageType type : CACHE.values()) {
            if (!type.getDesc().equals(desc)) continue;
            return type.getValue();
        }
        return null;
    }

    public static String getDescByValue(Integer value) {
        AutoReplyMessageType type = AutoReplyMessageType.getType(value);
        if (type != null) {
            return type.getDesc();
        }
        return null;
    }

    static {
        CACHE = new HashMap<Integer, AutoReplyMessageType>();
        for (AutoReplyMessageType e : AutoReplyMessageType.values()) {
            CACHE.put(e.value, e);
        }
    }
}

