/*
 * Decompiled with CFR 0.152.
 */
package cn.kinyun.scrm.weixin.autoreply.service.impl;

import cn.kinyun.scrm.weixin.activity.service.ActivityHelper;
import cn.kinyun.scrm.weixin.autoreply.service.ClickEventReplyService;
import cn.kinyun.scrm.weixin.enums.TriggerType;
import cn.kinyun.scrm.weixin.enums.biz.ClickEventBizType;
import cn.kinyun.scrm.weixin.enums.biz.recommend.BehaviorType;
import cn.kinyun.scrm.weixin.event.dto.ClickKeyPackDto;
import cn.kinyun.scrm.weixin.menu.service.MenuTextReplyService;
import cn.kinyun.scrm.weixin.message.service.OfficialAccountReplyService;
import cn.kinyun.scrm.weixin.recommend.service.RecommendService;
import cn.kinyun.scrm.weixin.sdk.entity.message.event.menu.ClickEvent;
import com.google.common.base.Preconditions;
import com.kuaike.scrm.dal.official.base.entity.OfficialAccount;
import com.kuaike.scrm.dal.official.base.mapper.OfficialAccountMapper;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClickEventReplyServiceImpl
implements ClickEventReplyService {
    private static final Logger log = LoggerFactory.getLogger(ClickEventReplyServiceImpl.class);
    @Autowired
    private OfficialAccountReplyService officialAccountReplyService;
    @Autowired
    private ActivityHelper activityHelper;
    @Resource
    private OfficialAccountMapper officialAccountMapper;
    @Autowired
    private MenuTextReplyService menuTextReplyService;
    @Autowired
    private RecommendService recommendService;

    @Override
    public void onClick(ClickEvent event) {
        log.info("click event reply, event={}", (Object)event);
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)event.getFromUserName()), (Object)"fromUserName is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)event.getToUserName()), (Object)"toUserName is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)event.getEventKey()), (Object)"eventKey is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)event.getEvent()), (Object)"event is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)event.getMsgType()), (Object)"msgType is null");
        String openId = event.getFromUserName();
        String userName = event.getToUserName();
        String eventKey = event.getEventKey();
        ClickKeyPackDto dto = ClickKeyPackDto.unpack(eventKey);
        if (dto == null) {
            return;
        }
        OfficialAccount account = this.officialAccountMapper.getByUserName(userName);
        if (account == null) {
            log.warn("\u4e0d\u5b58\u5728\u6b64\u516c\u4f17\u53f7:{}", (Object)userName);
            return;
        }
        String appId = account.getAppId();
        if (ClickEventBizType.OFFICIAL_FISSION.getKey().equals(dto.getType())) {
            this.officialAccountFission(Long.valueOf(dto.getKey()), appId, openId);
        } else if (ClickEventBizType.MATERIAL.getKey().equals(dto.getType())) {
            this.officialAccountReplyService.saveMatMsgAndSend2Fans(Long.valueOf(dto.getKey()), appId, openId, TriggerType.CLICK_MENU.getValue());
        } else if (ClickEventBizType.MENU_TEXT.getKey().equals(dto.getType())) {
            this.menuTextReplyService.receiveTextMenuClickEvent(Long.valueOf(dto.getKey()), appId, openId);
        }
        this.recommendService.trigger(account, openId, BehaviorType.CLICK_MENU.getValue(), eventKey);
    }

    public void officialAccountFission(Long actiId, String appId, String openId) {
        log.info("officialAccountFission with id={}, appId={}, openId={}", new Object[]{actiId, appId, openId});
        this.activityHelper.receiveTask(actiId, appId, openId, TriggerType.CLICK_MENU.getValue());
    }
}

