/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.request;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.dal.meeting.dto.QueryMeetingListParam;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class MeetingListReqDto {
    private String title;
    private String updateName;
    private Integer type;
    private Integer isPushType;
    private Integer status;
    private int isNeedStatics = NumberUtils.INTEGER_ONE;
    private Integer sendStatus;
    private String weworkContactId;
    private PageDto pageDto;

    public void validate() {
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            Preconditions.checkArgument((this.title.length() < 50 ? 1 : 0) != 0, (Object)"\u6807\u9898\u4e0d\u80fd\u8d85\u8fc750\u4e2a\u5b57\u7b26");
        }
        if (Objects.nonNull(this.type)) {
            Preconditions.checkArgument((this.type == 1 || this.type == 2 ? 1 : 0) != 0, (Object)"\u7c7b\u578b\u9519\u8bef");
        }
        if (Objects.nonNull(this.status)) {
            Preconditions.checkArgument((MeetingStatus.get((int)this.status) != null ? 1 : 0) != 0, (Object)"\u72b6\u6001\u9519\u8bef");
        }
    }

    public QueryMeetingListParam convertToParams(Long bizId, String corpId, Set<Long> updateIds, Set<Long> userIds) {
        QueryMeetingListParam param = new QueryMeetingListParam();
        param.setBizId(bizId);
        param.setCorpId(corpId);
        param.setTitle(this.title);
        param.setUpdateIds(updateIds);
        param.setType(this.type);
        param.setPushType(this.isPushType);
        if (this.status != null) {
            param.setStatusList((Set)Sets.newHashSet((Object[])new Integer[]{this.status}));
        }
        if (Objects.nonNull(this.pageDto)) {
            param.setOffset(Integer.valueOf((this.pageDto.getPageNum() - 1) * this.pageDto.getPageSize()));
            param.setLimit(this.pageDto.getPageSize());
        }
        param.setUserIds(userIds);
        return param;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUpdateName() {
        return this.updateName;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getIsPushType() {
        return this.isPushType;
    }

    public Integer getStatus() {
        return this.status;
    }

    public int getIsNeedStatics() {
        return this.isNeedStatics;
    }

    public Integer getSendStatus() {
        return this.sendStatus;
    }

    public String getWeworkContactId() {
        return this.weworkContactId;
    }

    public PageDto getPageDto() {
        return this.pageDto;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public void setIsPushType(Integer isPushType) {
        this.isPushType = isPushType;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setIsNeedStatics(int isNeedStatics) {
        this.isNeedStatics = isNeedStatics;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public void setWeworkContactId(String weworkContactId) {
        this.weworkContactId = weworkContactId;
    }

    public void setPageDto(PageDto pageDto) {
        this.pageDto = pageDto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MeetingListReqDto)) {
            return false;
        }
        MeetingListReqDto other = (MeetingListReqDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIsNeedStatics() != other.getIsNeedStatics()) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$isPushType = this.getIsPushType();
        Integer other$isPushType = other.getIsPushType();
        if (this$isPushType == null ? other$isPushType != null : !((Object)this$isPushType).equals(other$isPushType)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$sendStatus = this.getSendStatus();
        Integer other$sendStatus = other.getSendStatus();
        if (this$sendStatus == null ? other$sendStatus != null : !((Object)this$sendStatus).equals(other$sendStatus)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$updateName = this.getUpdateName();
        String other$updateName = other.getUpdateName();
        if (this$updateName == null ? other$updateName != null : !this$updateName.equals(other$updateName)) {
            return false;
        }
        String this$weworkContactId = this.getWeworkContactId();
        String other$weworkContactId = other.getWeworkContactId();
        if (this$weworkContactId == null ? other$weworkContactId != null : !this$weworkContactId.equals(other$weworkContactId)) {
            return false;
        }
        PageDto this$pageDto = this.getPageDto();
        PageDto other$pageDto = other.getPageDto();
        return !(this$pageDto == null ? other$pageDto != null : !this$pageDto.equals(other$pageDto));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MeetingListReqDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIsNeedStatics();
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $isPushType = this.getIsPushType();
        result = result * 59 + ($isPushType == null ? 43 : ((Object)$isPushType).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $sendStatus = this.getSendStatus();
        result = result * 59 + ($sendStatus == null ? 43 : ((Object)$sendStatus).hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $updateName = this.getUpdateName();
        result = result * 59 + ($updateName == null ? 43 : $updateName.hashCode());
        String $weworkContactId = this.getWeworkContactId();
        result = result * 59 + ($weworkContactId == null ? 43 : $weworkContactId.hashCode());
        PageDto $pageDto = this.getPageDto();
        result = result * 59 + ($pageDto == null ? 43 : $pageDto.hashCode());
        return result;
    }

    public String toString() {
        return "MeetingListReqDto(title=" + this.getTitle() + ", updateName=" + this.getUpdateName() + ", type=" + this.getType() + ", isPushType=" + this.getIsPushType() + ", status=" + this.getStatus() + ", isNeedStatics=" + this.getIsNeedStatics() + ", sendStatus=" + this.getSendStatus() + ", weworkContactId=" + this.getWeworkContactId() + ", pageDto=" + this.getPageDto() + ")";
    }
}

