/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.dto.reponse;

import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import com.kuaike.scrm.common.enums.MeetingSource;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingJoinQuitLog;
import com.kuaike.scrm.dal.meeting.entity.MeetingSendDetail;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.meeting.dto.reponse.MeetingTimeDto;
import com.kuaike.scrm.meeting.dto.request.JoinMeetingReqDto;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class JoinMeetingRespDto {
    private String weworkUserNum;
    private String memberNickname;
    private String memberAvatar;
    private Date memberJoinTime;
    private Date memberQuitTime;
    private Integer memberDuration;
    private Integer memberCount;
    private String customerId;
    private String customerNickname;
    private String customerAvatar;
    private Date customerJoinTime;
    private Date customerQuitTime;
    private Integer customerDuration;
    private Integer customerCount;
    private Integer customerSource;
    private String customerSourceDesc;
    private String customerBjyNumber;
    private Integer forwardCount;
    private Integer sendStatus;
    private Integer joinStatus;
    private String customerCorpName;
    private String customerPhone;
    private String completePercent;
    private String customerNum;

    public static JoinMeetingRespDto buildDto(MeetingSendDetail detail, Map<String, WeworkUser> userMap, Map<String, WeworkContact> contactMap, Map<String, List<MeetingJoinQuitLog>> hasJoinMap, Map<String, Integer> bjyNumAndCountMap, Map<String, Integer> forwardCountMap, Map<Long, String> channelMap, Map<String, List<MeetingSendDetail>> hasRemindMap, JoinMeetingReqDto reqDto, Map<String, String> weworkUserNum2IdMap, Map<String, WeworkContactRelation> weworkContactRelationMap, Map<String, MeetingTimeDto> timeDtoMap, Long meetingLength) {
        MeetingJoinQuitLog log;
        List<MeetingJoinQuitLog> logList;
        String key;
        String key2;
        WeworkContactRelation relation;
        WeworkContact weworkContact;
        JoinMeetingRespDto respDto = new JoinMeetingRespDto();
        respDto.setWeworkUserNum(detail.getWeworkUserNum());
        respDto.setCustomerId(detail.getContactId());
        WeworkUser weworkUser = userMap.get(detail.getWeworkUserNum());
        if (Objects.nonNull(weworkUser)) {
            respDto.setMemberNickname(weworkUser.getName());
            respDto.setMemberAvatar(weworkUser.getAvatar());
        }
        if (Objects.nonNull(weworkContact = contactMap.get(detail.getContactId()))) {
            respDto.setCustomerId(weworkContact.getContactId());
            respDto.setCustomerNickname(weworkContact.getName());
            respDto.setCustomerAvatar(weworkContact.getAvatar());
            respDto.setCustomerNum(weworkContact.getCustomerNum());
            respDto.setCustomerCorpName(weworkContact.getCorpName());
            respDto.setCustomerNum(weworkContact.getCustomerNum());
        }
        if (Objects.nonNull(weworkUserNum2IdMap) && Objects.nonNull(weworkContactRelationMap) && Objects.nonNull(detail.getContactId()) && Objects.nonNull(relation = weworkContactRelationMap.get(key2 = JoinMeetingRespDto.buildKey(weworkUserNum2IdMap.get(detail.getWeworkUserNum()), detail.getContactId()))) && Objects.nonNull(relation.getRemark())) {
            respDto.setCustomerNickname(relation.getRemark());
        }
        int sendStatus = reqDto.getSendStatus() == null ? NumberUtils.INTEGER_ZERO : reqDto.getSendStatus();
        respDto.setSendStatus(sendStatus);
        if (Objects.nonNull(hasRemindMap) && hasRemindMap.containsKey(JoinMeetingRespDto.buildKey(detail.getWeworkUserNum(), detail.getContactId()))) {
            respDto.setSendStatus(NumberUtils.INTEGER_ONE);
        }
        respDto.setJoinStatus(NumberUtils.INTEGER_ZERO);
        if (Objects.nonNull(hasJoinMap) && hasJoinMap.containsKey(key = JoinMeetingRespDto.buildKey(detail.getWeworkUserNum(), detail.getContactId())) && CollectionUtils.isNotEmpty(logList = hasJoinMap.get(key)) && Objects.nonNull(log = logList.get(0))) {
            String bjyNumber;
            MeetingTimeDto timeDto;
            Long channelId;
            if (Objects.nonNull(bjyNumAndCountMap)) {
                respDto.setCustomerCount(bjyNumAndCountMap.get(log.getBjyNumber()));
            }
            if ((channelId = log.getChannelId()) != null && channelMap.containsKey(channelId)) {
                String channelName = channelMap.get(channelId);
                respDto.setCustomerSource(channelId.intValue());
                respDto.setCustomerSourceDesc(channelName);
            }
            if (Objects.nonNull(forwardCountMap)) {
                respDto.setForwardCount(forwardCountMap.get(JoinMeetingRespDto.buildKey(log.getWeworkUserNum(), log.getContactId())));
            }
            if ((timeDto = timeDtoMap.get(bjyNumber = log.getBjyNumber())) != null) {
                respDto.setCustomerJoinTime(timeDto.getFirstJoinTime());
                respDto.setCustomerQuitTime(timeDto.getLastQuitTime());
                Integer duration = JoinMeetingRespDto.getDurationNoZero(timeDto.getTotalDuration());
                respDto.setCustomerDuration(duration);
                String percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            } else {
                respDto.setCustomerJoinTime(log.getJoinTime());
                respDto.setCustomerQuitTime(log.getQuitTime());
                Integer duration = JoinMeetingRespDto.getDurationNoZero(log.getDuration());
                respDto.setCustomerDuration(duration);
                String percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            }
            respDto.setCustomerSource(log.getSource());
            respDto.setCustomerSourceDesc(MeetingSource.get((int)log.getSource()).getDesc());
            respDto.setJoinStatus(NumberUtils.INTEGER_ONE);
            respDto.setCustomerBjyNumber(log.getBjyNumber());
        }
        return respDto;
    }

    public static JoinMeetingRespDto buildDto(MeetingJoinQuitLog log, Meeting meeting, Map<String, WeworkUser> userMap, Map<String, WeworkContact> contactMap, Map<String, Integer> bjyNumAndCountMap, Map<String, Integer> forwardCountMap, Map<Long, String> channelMap, Set<String> hasRemindSet, Map<String, String> weworkUserNum2IdMap, Map<String, WeworkContactRelation> weworkContactRelationMap, Map<String, MeetingTimeDto> timeDtoMap, Long meetingLength, Map<String, CustomerDetailResp> customerDetailRespMap) {
        Long channelId;
        String percent;
        Integer duration;
        String key;
        WeworkContactRelation relation;
        CustomerDetailResp meetingCustomerInfos;
        WeworkContact weworkContact;
        JoinMeetingRespDto respDto = new JoinMeetingRespDto();
        respDto.setWeworkUserNum(log.getWeworkUserNum());
        respDto.setCustomerId(log.getContactId());
        WeworkUser weworkUser = userMap.get(log.getWeworkUserNum());
        if (Objects.nonNull(weworkUser)) {
            respDto.setMemberNickname(weworkUser.getName());
            respDto.setMemberAvatar(weworkUser.getAvatar());
        }
        if (Objects.nonNull(weworkContact = contactMap.get(log.getContactId()))) {
            respDto.setCustomerId(weworkContact.getContactId());
            respDto.setCustomerNickname(weworkContact.getName());
            respDto.setCustomerAvatar(weworkContact.getAvatar());
            respDto.setCustomerCorpName(weworkContact.getCorpName());
            respDto.setCustomerNum(weworkContact.getCustomerNum());
        }
        if (Objects.nonNull(meetingCustomerInfos = customerDetailRespMap.get(log.getNum()))) {
            if (StringUtils.isBlank((CharSequence)respDto.getCustomerAvatar())) {
                respDto.setCustomerAvatar(meetingCustomerInfos.getAvatar());
            }
            if (StringUtils.isBlank((CharSequence)respDto.getCustomerNum())) {
                respDto.setCustomerNum(meetingCustomerInfos.getCustomerNum());
            }
        }
        if (Objects.nonNull(weworkUserNum2IdMap) && Objects.nonNull(weworkContactRelationMap) && Objects.nonNull(log.getContactId()) && Objects.nonNull(relation = weworkContactRelationMap.get(key = JoinMeetingRespDto.buildKey(weworkUserNum2IdMap.get(log.getWeworkUserNum()), log.getContactId()))) && Objects.nonNull(relation.getRemark())) {
            respDto.setCustomerNickname(relation.getRemark());
        }
        String bjyNumber = log.getBjyNumber();
        MeetingTimeDto timeDto = timeDtoMap.get(bjyNumber);
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            if (timeDto != null) {
                respDto.setCustomerJoinTime(timeDto.getFirstJoinTime());
                respDto.setCustomerQuitTime(timeDto.getLastQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(timeDto.getTotalDuration());
                respDto.setCustomerDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            } else {
                respDto.setCustomerJoinTime(log.getJoinTime());
                respDto.setCustomerQuitTime(log.getQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(log.getDuration());
                respDto.setCustomerDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            }
            respDto.setCustomerSource(log.getSource());
            respDto.setCustomerSourceDesc(MeetingSource.get((int)log.getSource()).getDesc());
            if (CollectionUtils.isNotEmpty(hasRemindSet) && hasRemindSet.contains(JoinMeetingRespDto.buildKey(log.getWeworkUserNum(), log.getContactId()))) {
                respDto.setSendStatus(NumberUtils.INTEGER_ONE);
            } else {
                respDto.setSendStatus(NumberUtils.INTEGER_ZERO);
            }
            if (Objects.nonNull(bjyNumAndCountMap)) {
                respDto.setCustomerCount(bjyNumAndCountMap.get(log.getBjyNumber()));
            }
        } else if (MeetingType.INTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            if (timeDto != null) {
                respDto.setMemberJoinTime(timeDto.getFirstJoinTime());
                respDto.setMemberQuitTime(timeDto.getLastQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(timeDto.getTotalDuration());
                respDto.setMemberDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            } else {
                respDto.setMemberJoinTime(log.getJoinTime());
                respDto.setMemberQuitTime(log.getQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(log.getDuration());
                respDto.setMemberDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            }
            if (CollectionUtils.isNotEmpty(hasRemindSet) && hasRemindSet.contains(log.getWeworkUserNum())) {
                respDto.setSendStatus(NumberUtils.INTEGER_ONE);
            } else {
                respDto.setSendStatus(NumberUtils.INTEGER_ZERO);
            }
            if (Objects.nonNull(bjyNumAndCountMap)) {
                respDto.setMemberCount(bjyNumAndCountMap.get(log.getBjyNumber()));
            }
        }
        if ((channelId = log.getChannelId()) != null && channelMap.containsKey(channelId)) {
            String channelName = channelMap.get(channelId);
            respDto.setCustomerSource(channelId.intValue());
            respDto.setCustomerSourceDesc(channelName);
        }
        if (Objects.nonNull(forwardCountMap)) {
            respDto.setForwardCount(forwardCountMap.get(JoinMeetingRespDto.buildKey(log.getWeworkUserNum(), log.getContactId())));
        }
        respDto.setCustomerBjyNumber(log.getBjyNumber());
        respDto.setJoinStatus(NumberUtils.INTEGER_ONE);
        if (StringUtils.isNotBlank((CharSequence)log.getBjyMobile())) {
            respDto.setCustomerPhone(log.getBjyMobile());
        }
        if (StringUtils.isBlank((CharSequence)respDto.getCustomerNickname())) {
            respDto.setCustomerNickname(log.getBjyName());
        }
        if (StringUtils.isBlank((CharSequence)respDto.getCustomerAvatar())) {
            respDto.setCustomerAvatar(log.getBjyAvatar());
        }
        return respDto;
    }

    public static JoinMeetingRespDto buildDto(String userNum, Map<String, WeworkUser> userMap, Map<String, MeetingJoinQuitLog> hasJoinUserMap, Map<String, Integer> bjyNumAndCountMap, Map<String, Integer> forwardCountMap, Map<Long, String> channelMap, Map<String, MeetingTimeDto> timeDtoMap, Long meetingLength) {
        MeetingJoinQuitLog log;
        JoinMeetingRespDto respDto = new JoinMeetingRespDto();
        respDto.setWeworkUserNum(userNum);
        WeworkUser weworkUser = userMap.get(userNum);
        if (Objects.nonNull(weworkUser)) {
            respDto.setMemberNickname(weworkUser.getName());
            respDto.setMemberAvatar(weworkUser.getAvatar());
        }
        respDto.setJoinStatus(NumberUtils.INTEGER_ZERO);
        if (Objects.nonNull(hasJoinUserMap) && hasJoinUserMap.containsKey(userNum) && Objects.nonNull(log = hasJoinUserMap.get(userNum))) {
            Long channelId;
            String percent;
            Integer duration;
            respDto.setJoinStatus(NumberUtils.INTEGER_ONE);
            String bjyNumber = log.getBjyNumber();
            MeetingTimeDto timeDto = timeDtoMap.get(bjyNumber);
            if (timeDto != null) {
                respDto.setMemberJoinTime(timeDto.getFirstJoinTime());
                respDto.setMemberQuitTime(timeDto.getLastQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(timeDto.getTotalDuration());
                respDto.setMemberDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            } else {
                respDto.setMemberJoinTime(log.getJoinTime());
                respDto.setMemberQuitTime(log.getQuitTime());
                duration = JoinMeetingRespDto.getDurationNoZero(log.getDuration());
                respDto.setMemberDuration(duration);
                percent = JoinMeetingRespDto.getCompletePercent(duration, meetingLength);
                respDto.setCompletePercent(percent);
            }
            respDto.setCustomerBjyNumber(log.getBjyNumber());
            respDto.setCustomerSource(log.getSource());
            respDto.setCustomerSourceDesc(MeetingSource.get((int)log.getSource()).getDesc());
            if (Objects.nonNull(bjyNumAndCountMap)) {
                respDto.setMemberCount(bjyNumAndCountMap.get(log.getBjyNumber()));
            }
            if ((channelId = log.getChannelId()) != null && channelMap.containsKey(channelId)) {
                String channelName = channelMap.get(channelId);
                respDto.setCustomerSource(channelId.intValue());
                respDto.setCustomerSourceDesc(channelName);
            }
            if (Objects.nonNull(forwardCountMap)) {
                respDto.setForwardCount(forwardCountMap.get(JoinMeetingRespDto.buildKey(log.getWeworkUserNum(), log.getContactId())));
            }
        }
        return respDto;
    }

    private static String buildKey(String key, String value) {
        return key + "_" + value;
    }

    private static Integer getDurationNoZero(Integer duration) {
        return duration != null && duration == 0 ? null : duration;
    }

    private static String getCompletePercent(Integer duration, Long meetingLength) {
        String format = "0.0000";
        if (Objects.isNull(duration) || Objects.isNull(meetingLength)) {
            return format;
        }
        Double percent = (double)duration.intValue() / (double)meetingLength.longValue();
        DecimalFormat df = new DecimalFormat(format);
        return df.format(percent);
    }

    public String getWeworkUserNum() {
        return this.weworkUserNum;
    }

    public String getMemberNickname() {
        return this.memberNickname;
    }

    public String getMemberAvatar() {
        return this.memberAvatar;
    }

    public Date getMemberJoinTime() {
        return this.memberJoinTime;
    }

    public Date getMemberQuitTime() {
        return this.memberQuitTime;
    }

    public Integer getMemberDuration() {
        return this.memberDuration;
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCustomerNickname() {
        return this.customerNickname;
    }

    public String getCustomerAvatar() {
        return this.customerAvatar;
    }

    public Date getCustomerJoinTime() {
        return this.customerJoinTime;
    }

    public Date getCustomerQuitTime() {
        return this.customerQuitTime;
    }

    public Integer getCustomerDuration() {
        return this.customerDuration;
    }

    public Integer getCustomerCount() {
        return this.customerCount;
    }

    public Integer getCustomerSource() {
        return this.customerSource;
    }

    public String getCustomerSourceDesc() {
        return this.customerSourceDesc;
    }

    public String getCustomerBjyNumber() {
        return this.customerBjyNumber;
    }

    public Integer getForwardCount() {
        return this.forwardCount;
    }

    public Integer getSendStatus() {
        return this.sendStatus;
    }

    public Integer getJoinStatus() {
        return this.joinStatus;
    }

    public String getCustomerCorpName() {
        return this.customerCorpName;
    }

    public String getCustomerPhone() {
        return this.customerPhone;
    }

    public String getCompletePercent() {
        return this.completePercent;
    }

    public String getCustomerNum() {
        return this.customerNum;
    }

    public void setWeworkUserNum(String weworkUserNum) {
        this.weworkUserNum = weworkUserNum;
    }

    public void setMemberNickname(String memberNickname) {
        this.memberNickname = memberNickname;
    }

    public void setMemberAvatar(String memberAvatar) {
        this.memberAvatar = memberAvatar;
    }

    public void setMemberJoinTime(Date memberJoinTime) {
        this.memberJoinTime = memberJoinTime;
    }

    public void setMemberQuitTime(Date memberQuitTime) {
        this.memberQuitTime = memberQuitTime;
    }

    public void setMemberDuration(Integer memberDuration) {
        this.memberDuration = memberDuration;
    }

    public void setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public void setCustomerNickname(String customerNickname) {
        this.customerNickname = customerNickname;
    }

    public void setCustomerAvatar(String customerAvatar) {
        this.customerAvatar = customerAvatar;
    }

    public void setCustomerJoinTime(Date customerJoinTime) {
        this.customerJoinTime = customerJoinTime;
    }

    public void setCustomerQuitTime(Date customerQuitTime) {
        this.customerQuitTime = customerQuitTime;
    }

    public void setCustomerDuration(Integer customerDuration) {
        this.customerDuration = customerDuration;
    }

    public void setCustomerCount(Integer customerCount) {
        this.customerCount = customerCount;
    }

    public void setCustomerSource(Integer customerSource) {
        this.customerSource = customerSource;
    }

    public void setCustomerSourceDesc(String customerSourceDesc) {
        this.customerSourceDesc = customerSourceDesc;
    }

    public void setCustomerBjyNumber(String customerBjyNumber) {
        this.customerBjyNumber = customerBjyNumber;
    }

    public void setForwardCount(Integer forwardCount) {
        this.forwardCount = forwardCount;
    }

    public void setSendStatus(Integer sendStatus) {
        this.sendStatus = sendStatus;
    }

    public void setJoinStatus(Integer joinStatus) {
        this.joinStatus = joinStatus;
    }

    public void setCustomerCorpName(String customerCorpName) {
        this.customerCorpName = customerCorpName;
    }

    public void setCustomerPhone(String customerPhone) {
        this.customerPhone = customerPhone;
    }

    public void setCompletePercent(String completePercent) {
        this.completePercent = completePercent;
    }

    public void setCustomerNum(String customerNum) {
        this.customerNum = customerNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JoinMeetingRespDto)) {
            return false;
        }
        JoinMeetingRespDto other = (JoinMeetingRespDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$memberDuration = this.getMemberDuration();
        Integer other$memberDuration = other.getMemberDuration();
        if (this$memberDuration == null ? other$memberDuration != null : !((Object)this$memberDuration).equals(other$memberDuration)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        Integer this$customerDuration = this.getCustomerDuration();
        Integer other$customerDuration = other.getCustomerDuration();
        if (this$customerDuration == null ? other$customerDuration != null : !((Object)this$customerDuration).equals(other$customerDuration)) {
            return false;
        }
        Integer this$customerCount = this.getCustomerCount();
        Integer other$customerCount = other.getCustomerCount();
        if (this$customerCount == null ? other$customerCount != null : !((Object)this$customerCount).equals(other$customerCount)) {
            return false;
        }
        Integer this$customerSource = this.getCustomerSource();
        Integer other$customerSource = other.getCustomerSource();
        if (this$customerSource == null ? other$customerSource != null : !((Object)this$customerSource).equals(other$customerSource)) {
            return false;
        }
        Integer this$forwardCount = this.getForwardCount();
        Integer other$forwardCount = other.getForwardCount();
        if (this$forwardCount == null ? other$forwardCount != null : !((Object)this$forwardCount).equals(other$forwardCount)) {
            return false;
        }
        Integer this$sendStatus = this.getSendStatus();
        Integer other$sendStatus = other.getSendStatus();
        if (this$sendStatus == null ? other$sendStatus != null : !((Object)this$sendStatus).equals(other$sendStatus)) {
            return false;
        }
        Integer this$joinStatus = this.getJoinStatus();
        Integer other$joinStatus = other.getJoinStatus();
        if (this$joinStatus == null ? other$joinStatus != null : !((Object)this$joinStatus).equals(other$joinStatus)) {
            return false;
        }
        String this$weworkUserNum = this.getWeworkUserNum();
        String other$weworkUserNum = other.getWeworkUserNum();
        if (this$weworkUserNum == null ? other$weworkUserNum != null : !this$weworkUserNum.equals(other$weworkUserNum)) {
            return false;
        }
        String this$memberNickname = this.getMemberNickname();
        String other$memberNickname = other.getMemberNickname();
        if (this$memberNickname == null ? other$memberNickname != null : !this$memberNickname.equals(other$memberNickname)) {
            return false;
        }
        String this$memberAvatar = this.getMemberAvatar();
        String other$memberAvatar = other.getMemberAvatar();
        if (this$memberAvatar == null ? other$memberAvatar != null : !this$memberAvatar.equals(other$memberAvatar)) {
            return false;
        }
        Date this$memberJoinTime = this.getMemberJoinTime();
        Date other$memberJoinTime = other.getMemberJoinTime();
        if (this$memberJoinTime == null ? other$memberJoinTime != null : !((Object)this$memberJoinTime).equals(other$memberJoinTime)) {
            return false;
        }
        Date this$memberQuitTime = this.getMemberQuitTime();
        Date other$memberQuitTime = other.getMemberQuitTime();
        if (this$memberQuitTime == null ? other$memberQuitTime != null : !((Object)this$memberQuitTime).equals(other$memberQuitTime)) {
            return false;
        }
        String this$customerId = this.getCustomerId();
        String other$customerId = other.getCustomerId();
        if (this$customerId == null ? other$customerId != null : !this$customerId.equals(other$customerId)) {
            return false;
        }
        String this$customerNickname = this.getCustomerNickname();
        String other$customerNickname = other.getCustomerNickname();
        if (this$customerNickname == null ? other$customerNickname != null : !this$customerNickname.equals(other$customerNickname)) {
            return false;
        }
        String this$customerAvatar = this.getCustomerAvatar();
        String other$customerAvatar = other.getCustomerAvatar();
        if (this$customerAvatar == null ? other$customerAvatar != null : !this$customerAvatar.equals(other$customerAvatar)) {
            return false;
        }
        Date this$customerJoinTime = this.getCustomerJoinTime();
        Date other$customerJoinTime = other.getCustomerJoinTime();
        if (this$customerJoinTime == null ? other$customerJoinTime != null : !((Object)this$customerJoinTime).equals(other$customerJoinTime)) {
            return false;
        }
        Date this$customerQuitTime = this.getCustomerQuitTime();
        Date other$customerQuitTime = other.getCustomerQuitTime();
        if (this$customerQuitTime == null ? other$customerQuitTime != null : !((Object)this$customerQuitTime).equals(other$customerQuitTime)) {
            return false;
        }
        String this$customerSourceDesc = this.getCustomerSourceDesc();
        String other$customerSourceDesc = other.getCustomerSourceDesc();
        if (this$customerSourceDesc == null ? other$customerSourceDesc != null : !this$customerSourceDesc.equals(other$customerSourceDesc)) {
            return false;
        }
        String this$customerBjyNumber = this.getCustomerBjyNumber();
        String other$customerBjyNumber = other.getCustomerBjyNumber();
        if (this$customerBjyNumber == null ? other$customerBjyNumber != null : !this$customerBjyNumber.equals(other$customerBjyNumber)) {
            return false;
        }
        String this$customerCorpName = this.getCustomerCorpName();
        String other$customerCorpName = other.getCustomerCorpName();
        if (this$customerCorpName == null ? other$customerCorpName != null : !this$customerCorpName.equals(other$customerCorpName)) {
            return false;
        }
        String this$customerPhone = this.getCustomerPhone();
        String other$customerPhone = other.getCustomerPhone();
        if (this$customerPhone == null ? other$customerPhone != null : !this$customerPhone.equals(other$customerPhone)) {
            return false;
        }
        String this$completePercent = this.getCompletePercent();
        String other$completePercent = other.getCompletePercent();
        if (this$completePercent == null ? other$completePercent != null : !this$completePercent.equals(other$completePercent)) {
            return false;
        }
        String this$customerNum = this.getCustomerNum();
        String other$customerNum = other.getCustomerNum();
        return !(this$customerNum == null ? other$customerNum != null : !this$customerNum.equals(other$customerNum));
    }

    protected boolean canEqual(Object other) {
        return other instanceof JoinMeetingRespDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $memberDuration = this.getMemberDuration();
        result = result * 59 + ($memberDuration == null ? 43 : ((Object)$memberDuration).hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        Integer $customerDuration = this.getCustomerDuration();
        result = result * 59 + ($customerDuration == null ? 43 : ((Object)$customerDuration).hashCode());
        Integer $customerCount = this.getCustomerCount();
        result = result * 59 + ($customerCount == null ? 43 : ((Object)$customerCount).hashCode());
        Integer $customerSource = this.getCustomerSource();
        result = result * 59 + ($customerSource == null ? 43 : ((Object)$customerSource).hashCode());
        Integer $forwardCount = this.getForwardCount();
        result = result * 59 + ($forwardCount == null ? 43 : ((Object)$forwardCount).hashCode());
        Integer $sendStatus = this.getSendStatus();
        result = result * 59 + ($sendStatus == null ? 43 : ((Object)$sendStatus).hashCode());
        Integer $joinStatus = this.getJoinStatus();
        result = result * 59 + ($joinStatus == null ? 43 : ((Object)$joinStatus).hashCode());
        String $weworkUserNum = this.getWeworkUserNum();
        result = result * 59 + ($weworkUserNum == null ? 43 : $weworkUserNum.hashCode());
        String $memberNickname = this.getMemberNickname();
        result = result * 59 + ($memberNickname == null ? 43 : $memberNickname.hashCode());
        String $memberAvatar = this.getMemberAvatar();
        result = result * 59 + ($memberAvatar == null ? 43 : $memberAvatar.hashCode());
        Date $memberJoinTime = this.getMemberJoinTime();
        result = result * 59 + ($memberJoinTime == null ? 43 : ((Object)$memberJoinTime).hashCode());
        Date $memberQuitTime = this.getMemberQuitTime();
        result = result * 59 + ($memberQuitTime == null ? 43 : ((Object)$memberQuitTime).hashCode());
        String $customerId = this.getCustomerId();
        result = result * 59 + ($customerId == null ? 43 : $customerId.hashCode());
        String $customerNickname = this.getCustomerNickname();
        result = result * 59 + ($customerNickname == null ? 43 : $customerNickname.hashCode());
        String $customerAvatar = this.getCustomerAvatar();
        result = result * 59 + ($customerAvatar == null ? 43 : $customerAvatar.hashCode());
        Date $customerJoinTime = this.getCustomerJoinTime();
        result = result * 59 + ($customerJoinTime == null ? 43 : ((Object)$customerJoinTime).hashCode());
        Date $customerQuitTime = this.getCustomerQuitTime();
        result = result * 59 + ($customerQuitTime == null ? 43 : ((Object)$customerQuitTime).hashCode());
        String $customerSourceDesc = this.getCustomerSourceDesc();
        result = result * 59 + ($customerSourceDesc == null ? 43 : $customerSourceDesc.hashCode());
        String $customerBjyNumber = this.getCustomerBjyNumber();
        result = result * 59 + ($customerBjyNumber == null ? 43 : $customerBjyNumber.hashCode());
        String $customerCorpName = this.getCustomerCorpName();
        result = result * 59 + ($customerCorpName == null ? 43 : $customerCorpName.hashCode());
        String $customerPhone = this.getCustomerPhone();
        result = result * 59 + ($customerPhone == null ? 43 : $customerPhone.hashCode());
        String $completePercent = this.getCompletePercent();
        result = result * 59 + ($completePercent == null ? 43 : $completePercent.hashCode());
        String $customerNum = this.getCustomerNum();
        result = result * 59 + ($customerNum == null ? 43 : $customerNum.hashCode());
        return result;
    }

    public String toString() {
        return "JoinMeetingRespDto(weworkUserNum=" + this.getWeworkUserNum() + ", memberNickname=" + this.getMemberNickname() + ", memberAvatar=" + this.getMemberAvatar() + ", memberJoinTime=" + this.getMemberJoinTime() + ", memberQuitTime=" + this.getMemberQuitTime() + ", memberDuration=" + this.getMemberDuration() + ", memberCount=" + this.getMemberCount() + ", customerId=" + this.getCustomerId() + ", customerNickname=" + this.getCustomerNickname() + ", customerAvatar=" + this.getCustomerAvatar() + ", customerJoinTime=" + this.getCustomerJoinTime() + ", customerQuitTime=" + this.getCustomerQuitTime() + ", customerDuration=" + this.getCustomerDuration() + ", customerCount=" + this.getCustomerCount() + ", customerSource=" + this.getCustomerSource() + ", customerSourceDesc=" + this.getCustomerSourceDesc() + ", customerBjyNumber=" + this.getCustomerBjyNumber() + ", forwardCount=" + this.getForwardCount() + ", sendStatus=" + this.getSendStatus() + ", joinStatus=" + this.getJoinStatus() + ", customerCorpName=" + this.getCustomerCorpName() + ", customerPhone=" + this.getCustomerPhone() + ", completePercent=" + this.getCompletePercent() + ", customerNum=" + this.getCustomerNum() + ")";
    }
}

