/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.meeting.service.impl;

import cn.kinyun.customer.center.dto.req.CustomerDetailReq;
import cn.kinyun.customer.center.dto.req.CustomerEventReq;
import cn.kinyun.customer.center.dto.req.event.EventData;
import cn.kinyun.customer.center.dto.req.event.EventModule;
import cn.kinyun.customer.center.dto.req.event.EventVisitor;
import cn.kinyun.customer.center.dto.resp.CustomerDetailResp;
import cn.kinyun.customer.center.enums.EventType;
import cn.kinyun.customer.center.enums.ModuleType;
import cn.kinyun.customer.center.service.CcCustomerDetailService;
import cn.kinyun.customer.center.service.CcCustomerEventService;
import cn.kinyun.customer.center.service.CcCustomerNumService;
import cn.kinyun.wework.sdk.api.CalendarClient;
import cn.kinyun.wework.sdk.api.ScheduleClient;
import cn.kinyun.wework.sdk.api.req.AddCalendarReq;
import cn.kinyun.wework.sdk.api.req.AddScheduleReq;
import cn.kinyun.wework.sdk.api.req.Attendee;
import cn.kinyun.wework.sdk.api.req.CalendarDetailReq;
import cn.kinyun.wework.sdk.api.req.DelScheduleReq;
import cn.kinyun.wework.sdk.api.req.QyCalendar;
import cn.kinyun.wework.sdk.api.req.Schedule;
import cn.kinyun.wework.sdk.entity.calendar.CalendarAddResp;
import cn.kinyun.wework.sdk.entity.calendar.CalendarDetailResp;
import cn.kinyun.wework.sdk.entity.calendar.ScheduleAddResp;
import cn.kinyun.wework.sdk.exception.WeworkException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kuaike.common.dto.resp.IdAndNameDto;
import com.kuaike.common.dto.resp.Node;
import com.kuaike.common.errorcode.CommonErrorCode;
import com.kuaike.common.errorcode.UniverseErrorCode;
import com.kuaike.common.exception.BusinessException;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import com.kuaike.common.utils.BaseUtils;
import com.kuaike.common.utils.JacksonUtil;
import com.kuaike.common.utils.JsonUtil;
import com.kuaike.scrm.call.dto.req.CallRecordReqDto;
import com.kuaike.scrm.call.dto.req.CallTaskReqDto;
import com.kuaike.scrm.call.service.CallTaskService;
import com.kuaike.scrm.common.dto.BDataValueDto;
import com.kuaike.scrm.common.dto.CurrentUserInfo;
import com.kuaike.scrm.common.dto.IdDto;
import com.kuaike.scrm.common.dto.jsmsg.UniformMsgDto;
import com.kuaike.scrm.common.enums.CallTaskFkTypeEnum;
import com.kuaike.scrm.common.enums.CallTypeEnum;
import com.kuaike.scrm.common.enums.GroupSendFkType;
import com.kuaike.scrm.common.enums.GroupSendSource;
import com.kuaike.scrm.common.enums.GroupSendTaskType;
import com.kuaike.scrm.common.enums.JsMsgType;
import com.kuaike.scrm.common.enums.MeetingCountType;
import com.kuaike.scrm.common.enums.MeetingStatus;
import com.kuaike.scrm.common.enums.MeetingType;
import com.kuaike.scrm.common.enums.YnEnum;
import com.kuaike.scrm.common.enums.meeting.MeetingLiveDeliveryAuthMode;
import com.kuaike.scrm.common.perm.service.UserRoleCommonService;
import com.kuaike.scrm.common.service.NodeService;
import com.kuaike.scrm.common.service.SettingService;
import com.kuaike.scrm.common.service.dto.MeetingParams;
import com.kuaike.scrm.common.service.dto.SelectedContact2WeworkUserDto;
import com.kuaike.scrm.common.service.dto.WeworkUserDto;
import com.kuaike.scrm.common.utils.DateUtil;
import com.kuaike.scrm.common.utils.IdGen;
import com.kuaike.scrm.common.utils.LoginUtils;
import com.kuaike.scrm.common.utils.MobileUtils;
import com.kuaike.scrm.dal.biz.mapper.BusinessCustomerMapper;
import com.kuaike.scrm.dal.call.entity.CallTask;
import com.kuaike.scrm.dal.channel.mapper.ChannelMapper;
import com.kuaike.scrm.dal.groupsend.entity.MessageGroupSendTask;
import com.kuaike.scrm.dal.marketing.mapper.MarketingPlanMapper;
import com.kuaike.scrm.dal.meeting.dto.MeetingBaseInfo;
import com.kuaike.scrm.dal.meeting.dto.MeetingForwardInfo;
import com.kuaike.scrm.dal.meeting.dto.MeetingTagInfo;
import com.kuaike.scrm.dal.meeting.dto.MeetingWeworkUser;
import com.kuaike.scrm.dal.meeting.dto.QueryCustomSubscribeMeetingParam;
import com.kuaike.scrm.dal.meeting.dto.QueryJoinMeetingParam;
import com.kuaike.scrm.dal.meeting.dto.QueryMeetingListParam;
import com.kuaike.scrm.dal.meeting.entity.Meeting;
import com.kuaike.scrm.dal.meeting.entity.MeetingBjy;
import com.kuaike.scrm.dal.meeting.entity.MeetingBjyStudentInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerInfo;
import com.kuaike.scrm.dal.meeting.entity.MeetingCustomerParamEncryRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingGoodsClickLog;
import com.kuaike.scrm.dal.meeting.entity.MeetingGroupSendRelation;
import com.kuaike.scrm.dal.meeting.entity.MeetingJoinQuitLog;
import com.kuaike.scrm.dal.meeting.entity.MeetingReportMembers;
import com.kuaike.scrm.dal.meeting.entity.MeetingRoomChatDetail;
import com.kuaike.scrm.dal.meeting.entity.MeetingSendDetail;
import com.kuaike.scrm.dal.meeting.entity.MeetingSetting;
import com.kuaike.scrm.dal.meeting.entity.MeetingShareMembers;
import com.kuaike.scrm.dal.meeting.entity.MeetingTag;
import com.kuaike.scrm.dal.meeting.entity.ParamEncry;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingBjyStudentInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerInfoMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingCustomerParamEncryRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGoodsClickLogMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingGroupSendRelationMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingJoinQuitLogMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingReportMembersMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingRoomChatDetailMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSendDetailMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingSettingMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingShareMembersMapper;
import com.kuaike.scrm.dal.meeting.mapper.MeetingTagMapper;
import com.kuaike.scrm.dal.meeting.mapper.ParamEncryMapper;
import com.kuaike.scrm.dal.permission.entity.User;
import com.kuaike.scrm.dal.permission.mapper.UserMapper;
import com.kuaike.scrm.dal.remind.entity.QyRemind;
import com.kuaike.scrm.dal.remind.entity.QyRemindDetail;
import com.kuaike.scrm.dal.remind.mapper.QyRemindDetailMapper;
import com.kuaike.scrm.dal.remind.mapper.QyRemindMapper;
import com.kuaike.scrm.dal.shop.entity.ShopSpu;
import com.kuaike.scrm.dal.shop.mapper.ShopSpuMapper;
import com.kuaike.scrm.dal.system.entity.CustomerStage;
import com.kuaike.scrm.dal.system.mapper.CustomerStageMapper;
import com.kuaike.scrm.dal.wework.entity.WeworkChatRoom;
import com.kuaike.scrm.dal.wework.entity.WeworkContact;
import com.kuaike.scrm.dal.wework.entity.WeworkContactRelation;
import com.kuaike.scrm.dal.wework.entity.WeworkUser;
import com.kuaike.scrm.dal.wework.mapper.WeworkChatRoomMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkContactRelationMapper;
import com.kuaike.scrm.dal.wework.mapper.WeworkUserMapper;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupPair;
import com.kuaike.scrm.dal.weworktag.dto.TagGroupParams;
import com.kuaike.scrm.dal.weworktag.dto.WeworkTagParams;
import com.kuaike.scrm.dal.weworktag.mapper.WeworkTagMapper;
import com.kuaike.scrm.goods.req.SpuCreateReq;
import com.kuaike.scrm.groupsend.dto.request.AddOrModReq;
import com.kuaike.scrm.groupsend.dto.request.EditTaskStatusReq;
import com.kuaike.scrm.groupsend.dto.request.IdReq;
import com.kuaike.scrm.groupsend.dto.request.MultiSearchContactReq;
import com.kuaike.scrm.groupsend.dto.request.UpdateGroupSendReq;
import com.kuaike.scrm.groupsend.dto.response.AddOrModResp;
import com.kuaike.scrm.groupsend.dto.response.MsgGroupSendTaskProcessRespDto;
import com.kuaike.scrm.groupsend.dto.response.MultiSearchContactResp;
import com.kuaike.scrm.groupsend.service.GroupSendService;
import com.kuaike.scrm.groupsend.service.GroupSendTaskService;
import com.kuaike.scrm.groupsend.service.MultiSelectService;
import com.kuaike.scrm.material.dto.request.AddMaterialReqDto;
import com.kuaike.scrm.material.dto.request.MaterialReqDto;
import com.kuaike.scrm.material.dto.request.QueryMaterialReqDto;
import com.kuaike.scrm.material.dto.response.MaterialListRespDto;
import com.kuaike.scrm.material.dto.response.MaterialRespDto;
import com.kuaike.scrm.material.service.MaterialManagerService;
import com.kuaike.scrm.meeting.dto.BuildMeetingUrlResDto;
import com.kuaike.scrm.meeting.dto.ShareMemberDto;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudCreateRoomResponse;
import com.kuaike.scrm.meeting.dto.reponse.BaijiacloudExportChatMsgResponse;
import com.kuaike.scrm.meeting.dto.reponse.GetRoomPlaybackTokenResponse;
import com.kuaike.scrm.meeting.dto.reponse.InvitedCustomerRespDto;
import com.kuaike.scrm.meeting.dto.reponse.JoinMeetingCountRespDto;
import com.kuaike.scrm.meeting.dto.reponse.JoinMeetingDetailByMemberRespDto;
import com.kuaike.scrm.meeting.dto.reponse.JoinMeetingRespDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingAssociateRespDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingChatListResponseDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingDetailRespDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingRespDto;
import com.kuaike.scrm.meeting.dto.reponse.MeetingStatisticsVo;
import com.kuaike.scrm.meeting.dto.reponse.MeetingTimeDto;
import com.kuaike.scrm.meeting.dto.reponse.PlaybackUrlRespDto;
import com.kuaike.scrm.meeting.dto.reponse.SelectParamRespDto;
import com.kuaike.scrm.meeting.dto.reponse.SimpleMeetingDto;
import com.kuaike.scrm.meeting.dto.reponse.TransferListResp;
import com.kuaike.scrm.meeting.dto.request.AddOrEditLiveRequestDto;
import com.kuaike.scrm.meeting.dto.request.AssociateMeetingReqDto;
import com.kuaike.scrm.meeting.dto.request.BaijiacloudBaseReqDto;
import com.kuaike.scrm.meeting.dto.request.CustomerMeettingReq;
import com.kuaike.scrm.meeting.dto.request.ExportChatMsgRequestDto;
import com.kuaike.scrm.meeting.dto.request.GetRoomPlaybackTokenRequest;
import com.kuaike.scrm.meeting.dto.request.GoodsClickReq;
import com.kuaike.scrm.meeting.dto.request.InvitedCustomerReqDto;
import com.kuaike.scrm.meeting.dto.request.JoinMeetingCountReqDto;
import com.kuaike.scrm.meeting.dto.request.JoinMeetingDetailByMemberReqDto;
import com.kuaike.scrm.meeting.dto.request.JoinMeetingReqDto;
import com.kuaike.scrm.meeting.dto.request.MajorCustomerReq;
import com.kuaike.scrm.meeting.dto.request.MeetingAddOrModReqDto;
import com.kuaike.scrm.meeting.dto.request.MeetingCancelReqDto;
import com.kuaike.scrm.meeting.dto.request.MeetingChatListRequestDto;
import com.kuaike.scrm.meeting.dto.request.MeetingDetailReqDto;
import com.kuaike.scrm.meeting.dto.request.MeetingGroupSendReq;
import com.kuaike.scrm.meeting.dto.request.MeetingListReqDto;
import com.kuaike.scrm.meeting.dto.request.PlaybackUrlReqDto;
import com.kuaike.scrm.meeting.dto.request.SendMeetingMaterialReqDto;
import com.kuaike.scrm.meeting.dto.request.SetShareInfoDto;
import com.kuaike.scrm.meeting.dto.request.SideMeetingListReqDto;
import com.kuaike.scrm.meeting.dto.request.TransferListReq;
import com.kuaike.scrm.meeting.service.BaijiacloudApiService;
import com.kuaike.scrm.meeting.service.MeetingKeywordService;
import com.kuaike.scrm.meeting.service.MeetingService;
import com.kuaike.scrm.meeting.service.MeetingShareMemberService;
import com.kuaike.scrm.meeting.service.MeetingStatisticService;
import com.kuaike.scrm.order.enums.OrderStatus;
import com.kuaike.scrm.order.service.GoodsOrderEsService;
import com.kuaike.scrm.remind.dto.req.AddRemindReqDto;
import com.kuaike.scrm.remind.dto.req.DisableRemindReqDto;
import com.kuaike.scrm.remind.dto.req.RemindDetailReqDto;
import com.kuaike.scrm.remind.service.RemindService;
import com.kuaike.scrm.service.MeetingCacheService;
import com.kuaike.scrm.service.MeetingCusParamEncryRelService;
import com.kuaike.scrm.service.MeetingUrlCommonService;
import com.kuaike.scrm.sms.dto.SmsTemplateReqDto;
import com.kuaike.scrm.vip.dto.enums.SystemParamName;
import com.kuaike.scrm.wework.contact.dto.ModifyTagDto;
import com.kuaike.scrm.wework.contact.service.ContactOpService;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MeetingServiceImpl
implements MeetingService {
    private static final Logger log = LoggerFactory.getLogger(MeetingServiceImpl.class);
    @Autowired
    private MeetingMapper meetingMapper;
    @Autowired
    private MeetingSendDetailMapper meetingSendDetailMapper;
    @Autowired
    private MeetingShareMembersMapper meetingShareMembersMapper;
    @Autowired
    private MeetingJoinQuitLogMapper meetingJoinQuitLogMapper;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private WeworkContactMapper weworkContactMapper;
    @Autowired
    private MeetingShareMemberService meetingShareMemberService;
    @Autowired
    private WeworkUserMapper weworkUserMapper;
    @Autowired
    private MeetingSettingMapper meetingSettingMapper;
    @Autowired
    private BaijiacloudApiService baijiacloudApiService;
    @Autowired
    private MultiSelectService multiSelectService;
    @Autowired
    private IdGen idGen;
    @Autowired
    private GroupSendService groupSendService;
    @Autowired
    private RemindService remindService;
    @Autowired
    private CalendarClient calendarClient;
    @Autowired
    private ScheduleClient scheduleClient;
    @Autowired
    private CcCustomerNumService ccCustomerNumService;
    @Autowired
    private MeetingGroupSendRelationMapper meetingGroupSendRelationMapper;
    @Value(value="${baijiacloud.quickenter.url}")
    private String quickEnterUrl;
    @Value(value="${baijiacloud.web.playback.url}")
    private String webPlaybackUrl;
    @Value(value="${baijiacloud.private.meeting.url}")
    private String privateEnterUrl;
    @Value(value="${scrm.meeting.commonDomainSiteUrl}")
    private String commonDomainSiteUrl;
    @Autowired
    private NodeService nodeService;
    @Autowired
    private UserRoleCommonService userRoleCommonService;
    @Autowired
    private WeworkChatRoomMapper weworkChatRoomMapper;
    @Autowired
    private MarketingPlanMapper marketingPlanMapper;
    @Autowired
    private CustomerStageMapper customerStageMapper;
    @Autowired
    private WeworkTagMapper weworkTagMapper;
    @Autowired
    private GroupSendTaskService groupSendTaskService;
    @Autowired
    private MeetingTagMapper meetingTagMapper;
    @Autowired
    private MaterialManagerService materialManagerService;
    @Autowired
    private MeetingReportMembersMapper meetingReportMembersMapper;
    @Autowired
    private ParamEncryMapper paramEncryMapper;
    @Autowired
    private ContactOpService contactOpService;
    @Autowired
    private ChannelMapper channelMapper;
    @Autowired
    private QyRemindDetailMapper remindDetailMapper;
    @Autowired
    private QyRemindMapper remindMapper;
    @Autowired
    private MeetingRoomChatDetailMapper meetingRoomChatDetailMapper;
    @Autowired
    private WeworkContactRelationMapper weworkContactRelationMapper;
    @Autowired
    private MeetingBjyMapper meetingBjyMapper;
    @Autowired
    private MeetingBjyStudentInfoMapper studentInfoMapper;
    @Resource
    private MeetingCustomerInfoMapper meetingCustomerInfoMapper;
    @Autowired
    private MeetingKeywordService keywordService;
    @Autowired
    private CallTaskService callTaskService;
    @Resource
    private MeetingCusParamEncryRelService meetingCusParamEncryRelService;
    @Resource
    private MeetingStatisticService meetingStatisticService;
    @Resource
    private GoodsOrderEsService goodsOrderEsService;
    @Resource
    private SettingService settingService;
    @Resource
    private MeetingUrlCommonService meetingUrlCommonService;
    @Resource
    private MeetingCacheService meetingCacheService;
    @Resource
    private CcCustomerDetailService customerDetailService;
    @Resource
    private BusinessCustomerMapper businessCustomerMapper;
    @Resource
    private MeetingGoodsClickLogMapper meetingGoodsClickLogMapper;
    @Resource
    private CcCustomerEventService ccCustomerEventService;
    @Resource
    private ShopSpuMapper shopSpuMapper;
    @Resource
    private MeetingCustomerParamEncryRelationMapper meetingCustomerParamEncryRelationMapper;
    private static final List<Integer> needCreateCalendarCodes = Lists.newArrayList((Object[])new Integer[]{90457, 90459, 90461, 90466});

    public List<BDataValueDto> getBDataOption(String query, PageDto pageDto) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query meeting list, bizId={}, userId={}, query={}, pageDto={}", new Object[]{bizId, userId, query, pageDto});
        Preconditions.checkArgument((bizId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        List list = this.meetingMapper.queryBDataOption(bizId, query, Integer.valueOf(MeetingType.EXTERNAL_MEETING.getValue()), pageDto);
        if (pageDto != null) {
            int count = this.meetingMapper.queryBDataOptionCount(bizId, query, Integer.valueOf(MeetingType.EXTERNAL_MEETING.getValue()));
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Meeting it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setLabel(it.getTitle());
                dto.setValue(it.getNum());
                result.add(dto);
            }
        }
        return result;
    }

    public List<BDataValueDto> getBDataValues(String values) {
        Long userId = LoginUtils.getCurrentUserId();
        Long bizId = LoginUtils.getCurrentUserBizId();
        log.info("query meeting list, bizId={}, userId={}, values={}", new Object[]{bizId, userId, values});
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"\u7528\u6237\u672a\u767b\u5f55");
        ArrayList result = Lists.newArrayList();
        String[] args = StringUtils.split((String)values, (String)",");
        HashSet nums = Sets.newHashSet();
        for (String it : args) {
            if (!StringUtils.isNotBlank((CharSequence)it)) continue;
            nums.add(it.trim());
        }
        List list = this.meetingMapper.selectByNums(bizId, (Collection)nums);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (Meeting it : list) {
                BDataValueDto dto = new BDataValueDto();
                dto.setLabel(it.getTitle());
                dto.setValue(it.getNum());
                result.add(dto);
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<MeetingRespDto> list(MeetingListReqDto reqDto) {
        List meetings;
        Set<Long> meetingIds;
        log.info("list: reqDto: {}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("list: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        Set updateIds = null;
        boolean noRecordByUpdate = false;
        if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateName())) {
            updateIds = this.userMapper.queryIdsByName(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getUpdateName());
            log.info("list: updateIds:{}", (Object)updateIds);
            if (CollectionUtils.isEmpty((Collection)updateIds)) {
                noRecordByUpdate = true;
            }
        }
        Set<Long> createIds = this.getAuthorizedCreateIdForMeeting(userInfo);
        QueryMeetingListParam param = reqDto.convertToParams(userInfo.getBizId(), userInfo.getCorpId(), updateIds, createIds);
        log.info("list: param:{}", (Object)param);
        if (noRecordByUpdate) {
            log.info("list: \u66f4\u65b0\u4eba\u65e0\u6cd5\u67e5\u8be2\u5230\u5217\u8868: {}", (Object)reqDto.getUpdateName());
            return Collections.emptyList();
        }
        if (StringUtils.isNotBlank((CharSequence)reqDto.getWeworkContactId())) {
            param.setType(Integer.valueOf(MeetingType.EXTERNAL_MEETING.getValue()));
            param.setStatusList((Set)Sets.newHashSet((Object[])new Integer[]{MeetingStatus.UN_START.getValue(), MeetingStatus.MEETING.getValue()}));
            meetingIds = this.meetingSendDetailMapper.querySendDetailListByParams(null, userInfo.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", reqDto.getSendStatus(), Integer.valueOf(reqDto.getPageDto().getOffset()), reqDto.getPageDto().getPageSize());
            if (!CollectionUtils.isNotEmpty(meetingIds)) return Lists.newArrayList();
            int count = this.meetingSendDetailMapper.querySendDetailCountByParams(null, userInfo.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", reqDto.getSendStatus());
            meetings = this.meetingMapper.queryByIds(reqDto.getTitle(), userInfo.getBizId(), userInfo.getCorpId(), meetingIds);
            if (Objects.nonNull(reqDto.getPageDto())) {
                reqDto.getPageDto().setCount(Integer.valueOf(count));
                reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
            }
        } else {
            meetings = this.meetingMapper.queryByCondition(param);
            if (CollectionUtils.isEmpty((Collection)meetings)) {
                log.info("list: \u65e0\u6cd5\u67e5\u627e\u5230\u4f1a\u8bae\u5217\u8868\uff0c\u6761\u4ef6\uff1a{}", (Object)reqDto);
                return Collections.emptyList();
            }
            if (Objects.nonNull(reqDto.getPageDto())) {
                int count = this.meetingMapper.getCountByCondition(param);
                reqDto.getPageDto().setCount(Integer.valueOf(count));
                reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
            }
        }
        meetingIds = meetings.stream().map(Meeting::getId).collect(Collectors.toSet());
        log.info("list : meetingIds: {}", meetingIds);
        Set userIds = meetings.stream().map(Meeting::getUpdateBy).collect(Collectors.toSet());
        Map userId2NameMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), userIds);
        Set roomIds = meetings.stream().map(Meeting::getRoomId).collect(Collectors.toSet());
        Map roomIdPrivateMap = null;
        Map roomStudentCount = null;
        if (CollectionUtils.isNotEmpty(roomIds)) {
            roomIdPrivateMap = this.meetingBjyMapper.queryRoomPrivate(roomIds, userInfo.getBizId(), userInfo.getCorpId());
            roomStudentCount = this.studentInfoMapper.queryCount(roomIds, userInfo.getBizId());
            log.info("list roomStudentCount : {}, bizId: {}", (Object)roomStudentCount, (Object)userInfo.getBizId());
        }
        ArrayList respDtos = Lists.newArrayList();
        for (Meeting meeting : meetings) {
            Integer getPrivate;
            String updateName = (String)userId2NameMap.get(meeting.getUpdateBy());
            Integer isPrivate = 0;
            if (roomIdPrivateMap != null && (getPrivate = (Integer)roomIdPrivateMap.get(meeting.getRoomId())) != null) {
                isPrivate = getPrivate;
            }
            Integer count = 0;
            if (roomStudentCount != null) {
                count = (Integer)roomStudentCount.get(meeting.getRoomId());
            }
            MeetingRespDto respDto = MeetingRespDto.buildDto(meeting, userInfo.getId(), updateName, isPrivate);
            respDto.setStudentCount(count);
            if (meeting.getLiveDeliverySwitch() == 1 && StringUtils.isNotBlank((CharSequence)respDto.getPlaybackUrl())) {
                respDto.setPlaybackUrl(this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), null, true, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode()));
            }
            respDtos.add(respDto);
        }
        if (StringUtils.isBlank((CharSequence)reqDto.getWeworkContactId())) {
            Map joinCountMap = this.meetingJoinQuitLogMapper.queryMeetingAndJoinCount(meetingIds, null, userInfo.getBizId());
            Map predictNumMap = this.meetingSendDetailMapper.getRemindNumByIds(userInfo.getBizId(), userInfo.getCorpId(), Integer.valueOf(MeetingCountType.PREDICT_REMIND_NUM.getValue()), meetingIds);
            Map realNumMap = this.meetingSendDetailMapper.getRemindNumByIds(userInfo.getBizId(), userInfo.getCorpId(), Integer.valueOf(MeetingCountType.REAL_REMIND_NUM.getValue()), meetingIds);
            Map<Long, Integer> unJoinNumMap = this.getExternalUnJoinMap(userInfo, meetingIds);
            List remindIds = this.remindMapper.getRemindIdByMeetingId(meetingIds);
            Map remindIdAndMeetingId = this.remindMapper.getRemindIdAndMeetingId(meetingIds);
            Map meetingIdAndRemindId = this.remindMapper.getMeetingIdAndRemindId(meetingIds);
            Map inPredictNumMap = Maps.newHashMap();
            Map inRealNumMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty((Collection)remindIds)) {
                inPredictNumMap = this.remindDetailMapper.queryPredictRemindCount((Collection)remindIds, userInfo.getBizId());
                inRealNumMap = this.remindDetailMapper.queryRealRemindCount((Collection)remindIds, userInfo.getBizId());
            }
            Map<Long, Integer> inUnJoinCountMap = this.getInternalUnJoinMap(userInfo, remindIds, remindIdAndMeetingId, meetingIds);
            Map<Long, MeetingStatisticsVo> statisticsVoMap = this.buildStatisticData(meetings);
            for (MeetingRespDto respDto : respDtos) {
                if (MeetingType.EXTERNAL_MEETING.getValue() == respDto.getType().intValue()) {
                    respDto.setPredictRemindNum((Integer)predictNumMap.get(respDto.getMeetingId()));
                    respDto.setRealRemindNum((Integer)realNumMap.get(respDto.getMeetingId()));
                    respDto.setUnJoinMeetingNum(unJoinNumMap.get(respDto.getMeetingId()));
                    respDto.setMeetingStatistics(statisticsVoMap.get(respDto.getMeetingId()));
                } else if (MeetingType.INTERNAL_MEETING.getValue() == respDto.getType().intValue()) {
                    respDto.setPredictRemindNum((Integer)inPredictNumMap.get(meetingIdAndRemindId.get(respDto.getMeetingId())));
                    respDto.setRealRemindNum((Integer)inRealNumMap.get(meetingIdAndRemindId.get(respDto.getMeetingId())));
                    respDto.setUnJoinMeetingNum(inUnJoinCountMap.get(respDto.getMeetingId()));
                }
                respDto.setJoinMeetingNum((Integer)joinCountMap.get(respDto.getMeetingId()));
            }
            return respDtos;
        } else if (NumberUtils.INTEGER_ONE.equals(reqDto.getSendStatus())) {
            if (!CollectionUtils.isNotEmpty((Collection)respDtos)) return respDtos;
            for (MeetingRespDto respDto : respDtos) {
                respDto.setSendStatus(NumberUtils.INTEGER_ONE);
                respDto.setSendStatusDesc("\u5df2\u53d1\u9001");
            }
            return respDtos;
        } else {
            Map<Long, Integer> map = this.getMeetingSendMapByMeetingIds(meetingIds, userInfo.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", reqDto.getSendStatus());
            if (!CollectionUtils.isNotEmpty((Collection)respDtos)) return respDtos;
            Iterator iterator = respDtos.iterator();
            while (iterator.hasNext()) {
                MeetingRespDto respDto;
                long meetingId = (respDto = (MeetingRespDto)iterator.next()).getMeetingId();
                respDto.setSendStatus(map.containsKey(meetingId) ? map.get(meetingId).intValue() : NumberUtils.INTEGER_ZERO.intValue());
                respDto.setSendStatusDesc(respDto.getSendStatus() == NumberUtils.INTEGER_ONE.intValue() ? "\u5df2\u53d1\u9001" : "\u672a\u53d1\u9001");
            }
        }
        return respDtos;
    }

    private Map<Long, MeetingStatisticsVo> buildStatisticData(List<Meeting> meetings) {
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(meetings)) {
            return resultMap;
        }
        List groupSendTaskNums = meetings.stream().map(Meeting::getDeadlineGpTaskNum).filter(Objects::nonNull).collect(Collectors.toList());
        Map respDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(groupSendTaskNums)) {
            List groupSendTasks = this.groupSendService.queryEntityByTaskNum(groupSendTaskNums);
            respDtoMap = this.groupSendService.buildTaskProcessDto(groupSendTasks);
        }
        List callTaskIds = meetings.stream().map(Meeting::getDeadlineVoisId).filter(Objects::nonNull).collect(Collectors.toList());
        Map<Object, Object> groupByCallTaskId = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(callTaskIds)) {
            CallTaskReqDto callTaskReqDto = new CallTaskReqDto();
            callTaskReqDto.setType(Integer.valueOf(CallTypeEnum.VOICE.getValue()));
            callTaskReqDto.setCallTaskIds(callTaskIds);
            List statisticRespDtos = this.callTaskService.taskDetailStatisticList(callTaskReqDto);
            if (CollectionUtils.isNotEmpty((Collection)statisticRespDtos)) {
                groupByCallTaskId = statisticRespDtos.stream().filter(item -> Objects.nonNull(item.getCallTaskId())).collect(Collectors.toMap(CallRecordReqDto.CallTaskDetailStatisticRespDto::getCallTaskId, Function.identity(), (exiting, replace) -> exiting));
            }
        }
        List<Long> meetingIds = meetings.stream().map(Meeting::getId).collect(Collectors.toList());
        Map<Long, Integer> vipMap = this.meetingStatisticService.queryMajorCustomerCount(meetingIds);
        Map searchResponse = this.goodsOrderEsService.orderStatistics(meetingIds);
        log.info("meetingIds:{};goodsList: {}", (Object)JSON.toJSONString(meetingIds), (Object)searchResponse);
        for (Meeting meeting : meetings) {
            Map statusCount;
            if (Objects.isNull(meeting.getLiveDeliverySwitch())) continue;
            MeetingStatisticsVo statisticsVo = new MeetingStatisticsVo();
            if (StringUtils.isNotBlank((CharSequence)meeting.getDeadlineGpTaskNum())) {
                MsgGroupSendTaskProcessRespDto processRespDto = Optional.ofNullable(respDtoMap.get(meeting.getDeadlineGpTaskNum())).orElse(new MsgGroupSendTaskProcessRespDto());
                statisticsVo.setAllGroupSendTaskCount(processRespDto.getAllTaskNum());
                statisticsVo.setHadGroupSendCount(processRespDto.getAlreadySendTaskNum());
                statisticsVo.setWaitGroupSendCount(processRespDto.getTobeSendTaskNum());
                statisticsVo.setFailGroupSendCount(processRespDto.getExpireTaskNum());
                statisticsVo.setGroupSendProcess(processRespDto.getProcess());
            }
            if (Objects.nonNull(meeting.getDeadlineVoisId())) {
                CallTaskReqDto callTaskReqDto = new CallTaskReqDto();
                callTaskReqDto.setType(Integer.valueOf(CallTypeEnum.VOICE.getValue()));
                callTaskReqDto.setCallTaskId(meeting.getDeadlineVoisId());
                CallRecordReqDto.CallTaskDetailStatisticRespDto callTaskStatis = (CallRecordReqDto.CallTaskDetailStatisticRespDto)Optional.ofNullable(groupByCallTaskId.get(meeting.getDeadlineVoisId())).orElse(new CallRecordReqDto.CallTaskDetailStatisticRespDto());
                statisticsVo.setSuccessVoisCount(callTaskStatis.getCalledSuccessCount());
                statisticsVo.setNobodyVoisCount(callTaskStatis.getNobodyVoisCount());
                statisticsVo.setNotSendVoisCount(callTaskStatis.getNotSendVoisCount());
                statisticsVo.setStartVoisCount(callTaskStatis.getStartVoisCount());
                statisticsVo.setNotSupportVoisCount(callTaskStatis.getNotSupportVoisCount());
                statisticsVo.setVoisProgress(callTaskStatis.getCallProgress());
            }
            MajorCustomerReq customerReq = new MajorCustomerReq();
            customerReq.setMeetingId(meeting.getId());
            statisticsVo.setVipStudentCount(Optional.ofNullable(vipMap.get(meeting.getId())).orElse(0));
            if (org.apache.commons.collections.MapUtils.isNotEmpty((Map)searchResponse) && org.apache.commons.collections.MapUtils.isNotEmpty((Map)(statusCount = (Map)searchResponse.get(meeting.getId())))) {
                Integer waitPayCount = (Integer)statusCount.get(OrderStatus.WAIT_PAY.getStatus());
                Integer successPayCount = (Integer)statusCount.get(OrderStatus.PAID.getStatus());
                Integer failPayCount = (Integer)statusCount.get(OrderStatus.FAIL.getStatus());
                statisticsVo.setUnPayCount(waitPayCount);
                statisticsVo.setFailPayCount(failPayCount);
                statisticsVo.setSuccessPayCount(successPayCount);
            }
            resultMap.put(meeting.getId(), statisticsVo);
        }
        return resultMap;
    }

    private Set<Long> getAuthorizedCreateIdForMeeting(CurrentUserInfo userInfo) {
        List createBysByIds;
        Set<Long> chargeUserShareingMeetingIds;
        List users;
        Set<String> chargeUserNums;
        Set chargeUserIds = this.userRoleCommonService.getManageUserIds();
        log.info("getAuthorizedCreateIdForMeeting chargeUserIds: {}", (Object)chargeUserIds);
        if (CollectionUtils.isNotEmpty((Collection)chargeUserIds) && CollectionUtils.isNotEmpty(chargeUserNums = (users = this.userMapper.getUserInfoByIds((Collection)chargeUserIds)).stream().map(User::getWeworkUserNum).collect(Collectors.toSet())) && CollectionUtils.isNotEmpty(chargeUserShareingMeetingIds = this.getShareToChargeUserMeetings(userInfo, chargeUserNums)) && CollectionUtils.isNotEmpty((Collection)(createBysByIds = this.meetingMapper.queryCreateBysByIds(userInfo.getBizId(), userInfo.getCorpId(), chargeUserShareingMeetingIds)))) {
            chargeUserIds.addAll(createBysByIds);
        }
        log.info("getAuthorizedCreateIdForMeeting total chargeUserIds: {}", (Object)chargeUserIds);
        return chargeUserIds;
    }

    private Map<Long, Integer> getInternalUnJoinMap(CurrentUserInfo userInfo, List<Long> remindIds, Map<Long, Long> remindIdAndMeetingId, Set<Long> meetingIds) {
        if (CollectionUtils.isEmpty(remindIds)) {
            return Maps.newHashMap();
        }
        List qyRemindDetails = this.remindDetailMapper.getRemindIdAndNums(remindIds, userInfo.getBizId(), Integer.valueOf(1));
        List logList = this.meetingJoinQuitLogMapper.queryUserNumByMeetingId(userInfo.getBizId(), meetingIds);
        Set keySet = logList.stream().map(item -> this.buildKey(String.valueOf(item.getMeetingId()), item.getWeworkUserNum())).collect(Collectors.toSet());
        Map<Long, List<QyRemindDetail>> qyDetailMap = qyRemindDetails.stream().collect(Collectors.groupingBy(QyRemindDetail::getRemindId));
        HashMap inUnJoinCountMap = Maps.newHashMap();
        HashSet remindIdSet = Sets.newHashSet();
        remindIdSet.addAll(remindIds);
        for (Long remindId : remindIdSet) {
            Long meetingId = remindIdAndMeetingId.get(remindId);
            List<QyRemindDetail> detailList = qyDetailMap.get(remindId);
            int unJoinCount = 0;
            if (CollectionUtils.isNotEmpty(detailList)) {
                for (QyRemindDetail detail : qyRemindDetails) {
                    String key;
                    if (!remindId.equals(detail.getRemindId()) || keySet.contains(key = this.buildKey(String.valueOf(remindIdAndMeetingId.get(detail.getRemindId())), detail.getWeworkUserNum()))) continue;
                    ++unJoinCount;
                }
            }
            inUnJoinCountMap.put(meetingId, unJoinCount);
        }
        return inUnJoinCountMap;
    }

    private Map<Long, Integer> getExternalUnJoinMap(CurrentUserInfo userInfo, Set<Long> meetingIds) {
        HashMap unJoinCountMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(meetingIds)) {
            return unJoinCountMap;
        }
        List hasRemindList = this.meetingSendDetailMapper.queryRemindByMeetingIds(userInfo.getBizId(), meetingIds);
        List logList = this.meetingJoinQuitLogMapper.queryExternalUserNumByMeetingId(userInfo.getBizId(), meetingIds);
        Set keySet = logList.stream().map(item -> this.buildKey(String.valueOf(item.getMeetingId()), item.getWeworkUserNum(), item.getContactId())).collect(Collectors.toSet());
        Map<Long, List<MeetingSendDetail>> sendDetailMap = hasRemindList.stream().collect(Collectors.groupingBy(MeetingSendDetail::getMeetingId));
        for (Long meetingId : meetingIds) {
            List<MeetingSendDetail> sendDetails = sendDetailMap.get(meetingId);
            int unJoinCount = 0;
            if (CollectionUtils.isNotEmpty(sendDetails)) {
                for (MeetingSendDetail detail : sendDetails) {
                    String key;
                    if (!meetingId.equals(detail.getMeetingId()) || keySet.contains(key = this.buildKey(String.valueOf(detail.getMeetingId()), detail.getWeworkUserNum(), detail.getContactId()))) continue;
                    ++unJoinCount;
                }
            }
            unJoinCountMap.put(meetingId, unJoinCount);
        }
        return unJoinCountMap;
    }

    @Override
    public List<MeetingRespDto> sideBarList(SideMeetingListReqDto reqDto) {
        List meetings;
        log.info("sideBarList: reqDto: {}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("sideBarList: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        if (StringUtils.isBlank((CharSequence)reqDto.getWeworkContactId())) {
            return null;
        }
        Integer offset = null;
        Integer limit = null;
        if (Objects.nonNull(reqDto.getPageDto())) {
            offset = (reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize();
            limit = reqDto.getPageDto().getPageSize();
        }
        if (reqDto.getIsAll() == 1) {
            HashSet statusSet = Sets.newHashSet((Object[])new Integer[]{MeetingStatus.UN_START.getValue(), MeetingStatus.MEETING.getValue()});
            meetings = this.meetingMapper.querySideBarListBy(userInfo.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", userInfo.getBizId(), userInfo.getCorpId(), (Set)statusSet, reqDto.getTitle(), offset, limit);
            log.info("sideBarList: meetings1 : {}", (Object)meetings);
            if (CollectionUtils.isEmpty((Collection)meetings)) {
                log.info("sideBarList: \u65e0\u6cd5\u67e5\u627e\u5230\u4f1a\u8bae\u5217\u8868\uff0c\u6761\u4ef6\uff1a{}", (Object)reqDto);
                return Collections.emptyList();
            }
            if (Objects.nonNull(reqDto.getPageDto())) {
                int count = this.meetingMapper.getCountSideBarBy(userInfo.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", userInfo.getBizId(), userInfo.getCorpId(), (Set)statusSet, reqDto.getTitle());
                reqDto.getPageDto().setCount(Integer.valueOf(count));
                reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
            }
        } else {
            meetings = this.meetingMapper.querySideBarList(reqDto.getTitle(), userInfo.getWeworkUserNum(), userInfo.getBizId(), userInfo.getCorpId(), offset, limit);
            log.info("sideBarList: meetings2 : {}", (Object)meetings);
            if (CollectionUtils.isEmpty((Collection)meetings)) {
                log.info("sideBarList: \u65e0\u6cd5\u67e5\u627e\u5230\u4f1a\u8bae\u5217\u8868\uff0c\u6761\u4ef6\uff1a{}", (Object)reqDto);
                return Collections.emptyList();
            }
            if (Objects.nonNull(reqDto.getPageDto())) {
                int count = this.meetingMapper.getCountQuerySideBar(reqDto.getTitle(), userInfo.getWeworkUserNum(), userInfo.getBizId(), userInfo.getCorpId());
                reqDto.getPageDto().setCount(Integer.valueOf(count));
                reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
            }
        }
        if (CollectionUtils.isEmpty((Collection)meetings)) {
            log.info("sideBarList get meetings is null");
            return null;
        }
        Set meetingIds = meetings.stream().map(Meeting::getId).collect(Collectors.toSet());
        log.info("sideBarList : meetingIds: {}", meetingIds);
        Set userIds = meetings.stream().map(Meeting::getUpdateBy).collect(Collectors.toSet());
        Map userId2NameMap = this.userMapper.selectUserIdAndNameByIds(userInfo.getBizId(), userInfo.getCorpId(), userIds);
        ArrayList respDtos = Lists.newArrayList();
        for (Meeting meeting : meetings) {
            String updateName = (String)userId2NameMap.get(meeting.getUpdateBy());
            MeetingRespDto respDto = MeetingRespDto.buildDto(meeting, userInfo.getId(), updateName, 0);
            respDtos.add(respDto);
        }
        return respDtos;
    }

    private String buildKey(String key, String value) {
        return key + "_" + value;
    }

    private String buildKey(String value1, String value2, String value3) {
        return value1 + "_" + value2 + "_" + value3;
    }

    @Override
    public List<MeetingRespDto> getWeworkSidebarMeetingList(MeetingListReqDto reqDto) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        reqDto.setType(1);
        List<Meeting> meetings = reqDto.getSendStatus() == null ? (StringUtils.isNotBlank((CharSequence)reqDto.getWeworkContactId()) ? this.getMyChargeMeetingList(user, reqDto, NumberUtils.INTEGER_ONE) : this.getMyChargeMeetingList(user, reqDto, NumberUtils.INTEGER_ZERO)) : this.getSubscribeMeetingList(user, reqDto);
        ArrayList respDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(meetings)) {
            Map<Long, Integer> map = this.getMeetingSendMapByMeetingIds(meetings.stream().map(Meeting::getId).collect(Collectors.toSet()), user.getWeworkUserNum(), reqDto.getWeworkContactId(), "-1", reqDto.getSendStatus());
            Set updateIds = meetings.stream().filter(meeting -> meeting.getUpdateBy() != null).map(Meeting::getUpdateBy).collect(Collectors.toSet());
            Map updateUserMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(updateIds)) {
                updateUserMap = this.userMapper.selectUserIdAndNameByIds(user.getBizId(), user.getCorpId(), updateIds);
            }
            WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(user.getWeworkUserNum());
            String weworkUserName = weworkUser.getName();
            log.info("getWeworkSidebarMeetingList weworkUserName: {}", (Object)weworkUserName);
            for (Meeting meeting2 : meetings) {
                String updateName = "";
                if (meeting2.getUpdateBy() != null && updateUserMap.containsKey(meeting2.getUpdateBy())) {
                    updateName = (String)updateUserMap.get(meeting2.getUpdateBy());
                }
                MeetingRespDto respDto = MeetingRespDto.buildDto(meeting2, user.getId(), updateName, 0);
                String meetingInfo = meeting2.getMeetingInfo().replace("{\u6210\u5458\u6635\u79f0}", weworkUserName);
                respDto.setMeetingInfo(meetingInfo);
                long meetingId = respDto.getMeetingId();
                Integer sendStatus = map.get(meetingId);
                if (sendStatus != null) {
                    respDto.setSendStatus(sendStatus);
                    respDto.setSendStatusDesc(respDto.getSendStatus() == NumberUtils.INTEGER_ONE.intValue() ? "\u5df2\u9884\u7ea6" : "\u672a\u9884\u7ea6");
                } else {
                    respDto.setSendStatus(NumberUtils.INTEGER_ZERO);
                    respDto.setSendStatusDesc("\u672a\u9884\u7ea6");
                }
                respDtos.add(respDto);
            }
        }
        return respDtos;
    }

    List<Meeting> getSubscribeMeetingList(CurrentUserInfo user, MeetingListReqDto reqDto) {
        Set chargeUserIds = this.userRoleCommonService.getManageUserIds();
        List meetings = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)chargeUserIds)) {
            List users = this.weworkUserMapper.queryWeworkUserByUserIds(user.getCorpId(), (Collection)chargeUserIds);
            Set chargeUserNums = users.stream().map(WeworkUser::getNum).collect(Collectors.toSet());
            QueryMeetingListParam param = this.constructQueryParams(user, reqDto, chargeUserIds, NumberUtils.INTEGER_TWO);
            QueryCustomSubscribeMeetingParam queryParam = param.buildToParam();
            queryParam.setSendStatus(NumberUtils.INTEGER_ONE);
            queryParam.setWeworkContactNum(reqDto.getWeworkContactId());
            queryParam.setTaskNum("-1");
            queryParam.setWeworkUserNums(chargeUserNums);
            Set<Long> subscribeMeetingIds = this.getSubscribeMeetingIds(queryParam);
            if (CollectionUtils.isNotEmpty(subscribeMeetingIds)) {
                param.setMeetingIds(subscribeMeetingIds);
                meetings = this.meetingMapper.queryByConditionForChargeUsers(param);
                if (CollectionUtils.isNotEmpty((Collection)meetings)) {
                    int count = this.meetingMapper.queryByConditionForChargeUsersCount(param);
                    reqDto.getPageDto().setCount(Integer.valueOf(count));
                    reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
                }
            }
        }
        return meetings;
    }

    List<Meeting> getMyChargeMeetingList(CurrentUserInfo user, MeetingListReqDto reqDto, int type) {
        Set chargeUserIds = this.userRoleCommonService.getManageUserIds();
        List meetings = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)chargeUserIds)) {
            List users = this.userMapper.getUserInfoByIds((Collection)chargeUserIds);
            Set<String> chargeUserNums = users.stream().map(User::getNum).collect(Collectors.toSet());
            QueryMeetingListParam param = this.constructQueryParams(user, reqDto, chargeUserIds, type);
            Set<Long> chargeUserCreateMeetingIds = this.getChargeUserCreateAndUpdateMeeting(param);
            if (StringUtils.isNotBlank((CharSequence)reqDto.getUpdateName()) && CollectionUtils.isEmpty(chargeUserCreateMeetingIds)) {
                return Lists.newArrayList();
            }
            Set<Long> chargeUserShareingMeetingIds = this.getShareToChargeUserMeetings(user, chargeUserNums);
            chargeUserCreateMeetingIds.addAll(chargeUserShareingMeetingIds);
            param.setMeetingIds(chargeUserShareingMeetingIds);
            meetings = this.meetingMapper.queryByConditionForChargeUsers(param);
            if (CollectionUtils.isNotEmpty((Collection)meetings)) {
                int count = this.meetingMapper.queryByConditionForChargeUsersCount(param);
                reqDto.getPageDto().setCount(Integer.valueOf(count));
                reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
            }
        }
        return meetings;
    }

    QueryMeetingListParam constructQueryParams(CurrentUserInfo user, MeetingListReqDto reqDto, Set<Long> chargeUserIds, int type) {
        Set<Object> updateIds = Sets.newHashSet();
        String updateName = reqDto.getUpdateName();
        if (StringUtils.isNotBlank((CharSequence)updateName)) {
            updateIds = this.getMeetingUpdateIds(user, updateName);
            log.info("getChargeUserCreateAndUpdateMeeting.updateIds is empty, updateName:{}", (Object)updateName);
        }
        QueryMeetingListParam param = reqDto.convertToParams(user.getBizId(), user.getCorpId(), updateIds, chargeUserIds);
        log.info("getMyMeeting.param:{}", (Object)param);
        if (type == NumberUtils.INTEGER_ZERO) {
            param.setOrderRule(NumberUtils.INTEGER_ZERO.intValue());
        } else if (type == NumberUtils.INTEGER_ONE) {
            param.setOrderRule(NumberUtils.INTEGER_ONE.intValue());
            param.setType(Integer.valueOf(MeetingType.EXTERNAL_MEETING.getValue()));
            param.setStatusList((Set)Sets.newHashSet((Object[])new Integer[]{MeetingStatus.UN_START.getValue(), MeetingStatus.MEETING.getValue()}));
        } else if (type == NumberUtils.INTEGER_TWO) {
            param.setOrderRule(NumberUtils.INTEGER_ONE.intValue());
            param.setType(Integer.valueOf(MeetingType.EXTERNAL_MEETING.getValue()));
        }
        return param;
    }

    Set<Long> getSubscribeMeetingIds(QueryCustomSubscribeMeetingParam param) {
        Set meetingIds = this.meetingSendDetailMapper.queryCustomSubscribeMeetingIds(param);
        return CollectionUtils.isNotEmpty((Collection)meetingIds) ? meetingIds : Sets.newHashSet();
    }

    Set<Long> getChargeUserCreateAndUpdateMeeting(QueryMeetingListParam param) {
        Set meetingIds = this.meetingMapper.queryByConditionNoPagination(param);
        log.info("getMyMeeting.params:{}, meetingIds:{}", (Object)param, (Object)meetingIds);
        return meetingIds;
    }

    Set<Long> getShareToChargeUserMeetings(CurrentUserInfo user, Set<String> chargeUserNums) {
        Set meetingIds = this.meetingShareMembersMapper.queryMyOwnMeetingIdByUserNums(user.getBizId(), user.getCorpId(), chargeUserNums);
        return CollectionUtils.isNotEmpty((Collection)meetingIds) ? meetingIds : Sets.newHashSet();
    }

    Set<Long> getMeetingUpdateIds(CurrentUserInfo user, String updateName) {
        Set updateIds = null;
        updateIds = this.userMapper.queryIdsByName(user.getBizId(), user.getCorpId(), updateName);
        log.info("getMyMeeting: updateIds:{}", (Object)updateIds);
        return updateIds;
    }

    Map<Long, Integer> getMeetingSendMapByMeetingIds(Collection<Long> meetingIds, String weworkUserNum, String customerId, String taskNum, Integer sendStatus) {
        log.info("getMeetingSendMapByMeetingIds: meetingIds: {}, weworkUserNum: {}, customerId: {}, taskNum: {}, sendStatus: {}", new Object[]{meetingIds.toString(), weworkUserNum, customerId, taskNum, sendStatus});
        List list = this.meetingSendDetailMapper.querySendDetailListByMeetingIds(meetingIds, weworkUserNum, customerId, taskNum, sendStatus);
        Map<Object, Object> result = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            result = list.stream().filter(p -> p.getSendStatus() != null).collect(Collectors.toMap(MeetingSendDetail::getMeetingId, MeetingSendDetail::getSendStatus));
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(MeetingAddOrModReqDto reqDto) {
        List<String> weworkUserIds;
        String weworkUserId;
        String calId;
        Meeting meeting;
        MeetingSetting meetingSetting;
        CurrentUserInfo currentUserInfo;
        block24: {
            currentUserInfo = this.baseValidate();
            Long userId = currentUserInfo.getId();
            Long bizId = currentUserInfo.getBizId();
            String corpId = currentUserInfo.getCorpId();
            log.info("add, params:{}, corpId:{}, operatorId:{}", new Object[]{reqDto, corpId, userId});
            reqDto.setType(1);
            reqDto.validateParams();
            Preconditions.checkArgument((reqDto.getEndTime().getTime() > System.currentTimeMillis() ? 1 : 0) != 0, (Object)"\u4f1a\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4");
            List<ShareMemberDto> shareMemberList = this.meetingShareMemberService.getShareMembers(bizId, corpId, reqDto.getWeworkUserNums(), reqDto.getNodeIds());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(shareMemberList), (Object)"\u5171\u4eab\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            reqDto.setShareMemberList(shareMemberList);
            MultiSearchContactResp multiSearchContactResp = null;
            MultiSearchContactReq multiSearchContactReq = null;
            if (NumberUtils.INTEGER_ONE.equals(reqDto.getType()) && NumberUtils.INTEGER_ONE.equals(reqDto.getEnableInviteCustomer())) {
                multiSearchContactReq = this.buildMultiSearchContactReq(reqDto, currentUserInfo);
                multiSearchContactResp = this.multiSelectService.multiSearchContact(multiSearchContactReq, true);
                if (Objects.isNull(multiSearchContactResp) || CollectionUtils.isEmpty((Collection)multiSearchContactResp.getList())) {
                    log.info("\u6839\u636e\u6761\u4ef6multiSearchContactReq:{}\u672a\u67e5\u8be2\u5230\u5ba2\u6237", (Object)multiSearchContactReq);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u5ba2\u6237\u4eba\u6570\u4e3a0");
                }
                multiSearchContactReq.setRequestId(multiSearchContactResp.getRequestId());
            }
            meetingSetting = this.meetingSettingMapper.getSettingByCorpId(currentUserInfo.getCorpId());
            this.checkMeetingSetting(meetingSetting);
            BaijiacloudCreateRoomResponse roomResponse = null;
            if (StringUtils.isNotBlank((CharSequence)reqDto.getRoomId())) {
                MeetingBjy meetingBjy = this.meetingBjyMapper.getBjyMeeting(reqDto.getRoomId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId());
                if (Objects.isNull(meetingBjy)) {
                    log.info("add meeting \u53c2\u6570\u4e0d\u5408\u6cd5\uff0c\u4f20\u8fdb\u6765\u7684roomId \u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u767e\u5bb6\u4e91\u4f1a\u8bae\uff0c roomId:{}", (Object)reqDto.getRoomId());
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u521b\u5efa\u4f1a\u8bae\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                roomResponse = new BaijiacloudCreateRoomResponse();
                roomResponse.setRoomId(meetingBjy.getRoomId());
                roomResponse.setAdminCode(meetingBjy.getAdminCode());
                roomResponse.setTeacherCode(meetingBjy.getTeacherCode());
                roomResponse.setStudentCode(meetingBjy.getStudentCode());
                this.meetingBjyMapper.updateOverride(reqDto.getRoomId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId());
            } else {
                AddOrEditLiveRequestDto addOrEditLiveRequestDto = this.buildAddOrEditLiveRequestDto(reqDto, meetingSetting);
                try {
                    roomResponse = this.baijiacloudApiService.createRoom(addOrEditLiveRequestDto);
                }
                catch (Exception ex) {
                    log.error("\u521b\u5efa\u767e\u5bb6\u4e91\u4f1a\u8bae\u53d1\u9001\u5f02\u5e38:", (Throwable)ex);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u521b\u5efa\u4f1a\u8bae\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            }
            String meetingNum = this.idGen.getNum();
            BuildMeetingUrlResDto buildMeetingUrlResDto = this.buildMeetingUrl(reqDto, meetingSetting, roomResponse, currentUserInfo.getBizId(), meetingNum);
            String originMeetingUrl = buildMeetingUrlResDto.getOriginMeetingUrl();
            String fullMeetingUrl = buildMeetingUrlResDto.getFullMeetingUrl();
            meeting = this.buildMeeting(reqDto, currentUserInfo, roomResponse, fullMeetingUrl, meetingNum, originMeetingUrl);
            this.meetingMapper.insertSelective((Object)meeting);
            this.meetingShareMemberService.batchSaveOrganizations(bizId, userId, meeting.getId(), reqDto.getNodeIds());
            this.meetingShareMemberService.batchSaveMembers(bizId, corpId, userId, meeting.getId(), shareMemberList);
            this.addSaveMaterial(reqDto, meeting);
            this.keywordService.associateMeetingWithKeywords(meeting, reqDto.getKeywordGroups(), currentUserInfo.getBizId(), reqDto.getType(), YnEnum.YES.getValue());
            if (NumberUtils.INTEGER_ONE.equals(reqDto.getType()) && NumberUtils.INTEGER_ONE.equals(reqDto.getEnableInviteCustomer())) {
                AddOrModReq addOrModReq = this.buildAddOrModReq(reqDto, meeting.getId(), multiSearchContactReq);
                try {
                    AddOrModResp addOrModResp = this.groupSendService.addOrModGroupSend(addOrModReq);
                    log.info("\u521b\u5efa\u7fa4\u53d1\u6210\u529f,addOrModResp:{}", (Object)addOrModResp);
                    MeetingGroupSendRelation meetingGroupSendRelation = this.buildMeetingGroupRelation(addOrModResp.getTaskNum(), meeting.getId(), NumberUtils.INTEGER_ONE, currentUserInfo.getId(), currentUserInfo.getCorpId());
                    this.meetingGroupSendRelationMapper.insert((Object)meetingGroupSendRelation);
                }
                catch (Exception ex) {
                    log.error("\u81ea\u52a8\u521b\u5efa\u7fa4\u53d1\u4efb\u52a1\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
                }
            }
            this.supportMeetingCommerceTask(currentUserInfo, reqDto, meeting, multiSearchContactResp);
            AddRemindReqDto addRemindReqDto = this.buildAddRemindReqDto(reqDto, currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), meeting.getId(), multiSearchContactResp, fullMeetingUrl);
            this.remindService.addRemind(addRemindReqDto);
            calId = this.meetingMapper.selectByCorpIdAndCreateBy(currentUserInfo.getCorpId(), currentUserInfo.getId(), meeting.getId());
            weworkUserId = this.userMapper.getWeworkUserIdByUserId(currentUserInfo.getId());
            weworkUserIds = shareMemberList.stream().map(ShareMemberDto::getWeworkUserId).collect(Collectors.toList());
            if (StringUtils.isBlank((CharSequence)weworkUserId)) {
                weworkUserId = (String)weworkUserIds.get(0);
            }
            try {
                if (StringUtils.isNotBlank((CharSequence)calId)) {
                    log.info("\u5386\u53f2\u65e5\u5386id:{}", (Object)calId);
                    CalendarDetailReq calendarDetailReq = new CalendarDetailReq();
                    calendarDetailReq.setCalIdList((List)Lists.newArrayList((Object[])new String[]{calId}));
                    CalendarDetailResp calendarDetailResp = this.calendarClient.getCalendarDetail(currentUserInfo.getCorpId(), calendarDetailReq);
                    log.info("calId:{},calendarDetailResp:{}", (Object)calId, (Object)calendarDetailResp);
                    weworkUserId = ((QyCalendar)calendarDetailResp.getCalendarList().get(0)).getOrganizer();
                } else {
                    log.info("\u91cd\u65b0\u751f\u6210\u65e5\u5386,weworkUserId:{}", (Object)weworkUserId);
                    calId = this.createCalendar(currentUserInfo, reqDto, weworkUserId);
                }
            }
            catch (Exception ex) {
                WeworkException weworkException;
                Integer errorCode;
                log.error("\u751f\u6210\u65e5\u5386\u548c\u65e5\u7a0b\u5f02\u5e38:", (Throwable)ex);
                if (!(ex instanceof WeworkException) || !needCreateCalendarCodes.contains(errorCode = (weworkException = (WeworkException)ex).getErrorCode())) break block24;
                calId = this.createCalendar(currentUserInfo, reqDto, weworkUserId);
            }
        }
        String scheduleId = "";
        if (StringUtils.isNotBlank((CharSequence)calId)) {
            try {
                scheduleId = this.createSchedule(calId, reqDto, currentUserInfo, weworkUserId, weworkUserIds);
            }
            catch (Exception ex) {
                log.error("\u751f\u6210\u65e5\u7a0b\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
            }
        }
        if (!StringUtils.isBlank((CharSequence)calId) || !StringUtils.isBlank((CharSequence)scheduleId)) {
            this.meetingMapper.updateCalIdAndScheduleIdById(calId, scheduleId, meeting.getId());
        }
        this.batchInsertMeetingTag(reqDto.getSubscribeTags(), meeting, 0);
        this.batchInsertMeetingTag(reqDto.getJoinLiveRoomTags(), meeting, 1);
        this.batchInsertMeetingReportMembers(reqDto.getReportWeworkUserNums(), meeting, currentUserInfo);
        if (YnEnum.YES.getValue().equals(reqDto.getLiveDeliverySwitch())) {
            try {
                this.setRoomShareInfo(meeting, meetingSetting);
            }
            catch (Exception e) {
                log.error("setRoomShareInfo error", (Throwable)e);
            }
            try {
                this.meetingCacheService.setMeetingCache(meeting);
            }
            catch (Exception e) {
                log.error("meetingCacheService,setMeetingCache error", (Throwable)e);
            }
        }
    }

    private void setRoomShareInfo(Meeting meeting, MeetingSetting meetingSetting) {
        SetShareInfoDto dto = new SetShareInfoDto();
        dto.setPrivateDomain(meetingSetting.getDominSite());
        dto.setPartnerId(meetingSetting.getBjyId());
        dto.setPartnerKey(meetingSetting.getBjyKey());
        dto.setTitle(meeting.getTitle());
        dto.setContent("\u7cbe\u5f69\u76f4\u64ad\u4e2d,\u5404\u4f4d\u5c0f\u4f19\u4f34\u5feb\u5feb\u524d\u6765\u56f4\u89c2");
        dto.setImg("https://img.baijiayun.com/0baijiatools/6d2b3b13c8e29eb4bec11e8581cd94f4/mini_program_invite.jpg@400h_500w");
        dto.setUrl(meeting.getMeetingUrl());
        this.baijiacloudApiService.setShareInfo(dto, meeting.getRoomId());
    }

    public void supportMeetingCommerceTask(CurrentUserInfo userInfo, MeetingAddOrModReqDto reqDto, Meeting meeting, MultiSearchContactResp multiSearchContactResp) {
        List weworkUserNums = reqDto.getShareMemberList().stream().map(ShareMemberDto::getWeworkUserNum).collect(Collectors.toList());
        CallTask callTask = null;
        if (!Objects.nonNull(meeting.getDeadlineVoisId()) || !Objects.nonNull(callTask = this.callTaskService.selectByTaskId(meeting.getDeadlineVoisId())) || !Objects.nonNull(callTask.getPlanCompleteTime()) || DateUtil.isTimeBefor((Date)new Date(), (Date)callTask.getPlanCompleteTime())) {
            // empty if block
        }
        if (StringUtils.isNotBlank((CharSequence)meeting.getDeadlineGpTaskNum())) {
            List sendTasks = this.groupSendService.queryEntityByTaskNum((List)Lists.newArrayList((Object[])new String[]{meeting.getDeadlineGpTaskNum()}));
            for (MessageGroupSendTask sendTask : sendTasks) {
                if (!DateUtil.isTimeBefor((Date)new Date(), (Date)sendTask.getDeadline())) continue;
            }
        }
        List<Object> contactIds = null;
        contactIds = Objects.isNull(multiSearchContactResp) || CollectionUtils.isEmpty((Collection)multiSearchContactResp.getList()) ? Lists.newArrayList() : multiSearchContactResp.getList().stream().map(SelectedContact2WeworkUserDto::getContactId).collect(Collectors.toList());
        Long voiceTaskId = null;
        if (YnEnum.YES.getValue().equals(reqDto.getVoiceNoticeDeadlineOn())) {
            log.info("\u8bed\u97f3\u901a\u77e5\u5ba2\u6237,meetingId:{},groupUserNums:{}", (Object)meeting.getId(), weworkUserNums);
            try {
                if (Objects.nonNull(callTask)) {
                    this.callTaskService.deleteUnUsedTaskDetail(callTask);
                }
                CallTaskReqDto callTaskReq = reqDto.getCallTaskReq();
                callTaskReq.setFkId(meeting.getId());
                callTaskReq.setFkType(Integer.valueOf(CallTaskFkTypeEnum.NO_ARRIVE_MEETING.getValue()));
                callTaskReq.setSmsNotice(YnEnum.NO.getValue());
                callTaskReq.setType(Integer.valueOf(CallTypeEnum.VOICE.getValue()));
                voiceTaskId = this.callTaskService.createNewVoiceTask(reqDto.getCallTaskReq(), userInfo, (List)Lists.newArrayList());
                log.info("[meeting add]\u672a\u5230\u5ba2\u901a\u77e5 \u8bed\u97f3\u7fa4\u53d1\uff0c\u521b\u5efa\u8bed\u97f3\u7fa4\u53d1\u4efb\u52a1Id:{},meetingId:{}: createUser:{},bizId:{}", new Object[]{voiceTaskId, meeting.getId(), userInfo.getId(), userInfo.getBizId()});
            }
            catch (Exception e) {
                log.error("[meeting add]\u672a\u5230\u5ba2\u901a\u77e5 \u8bed\u97f3\u7fa4\u53d1\u521b\u5efa\u5931\u8d25\uff0c", (Throwable)e);
            }
        }
        String groupSendTaskNum = null;
        if (YnEnum.YES.getValue().equals(reqDto.getGroupSendDeadlineOn())) {
            log.info("\u8bed\u97f3\u901a\u77e5\u5ba2\u6237info:{},meetingId:{},groupUserNums:{}", new Object[]{JSON.toJSONString((Object)contactIds), meeting.getId(), weworkUserNums});
            MultiSearchContactReq multiSearchContactReq = this.buildMultiSearchContactReq(reqDto.getWeworkUserNums(), reqDto.getNodeIds(), LoginUtils.getCurrentUser());
            multiSearchContactReq.setSelectContactType(Integer.valueOf(0));
            if (Objects.nonNull(multiSearchContactResp) && CollectionUtils.isNotEmpty((Collection)multiSearchContactResp.getList())) {
                multiSearchContactReq.setRequestId(multiSearchContactResp.getRequestId());
            }
            reqDto.getMeetingGroupSendReq().setDeadlineTime(reqDto.getEndTime());
            reqDto.getMeetingGroupSendReq().setRemindDates(Lists.newArrayList((Object[])new Date[]{reqDto.getMeetingGroupSendReq().getSendTime()}));
            AddOrModReq addOrModReq = this.buildMeetingCommerceGroupParam(reqDto, meeting.getId(), multiSearchContactReq);
            addOrModReq.setTaskNum(meeting.getDeadlineGpTaskNum());
            log.info("[meeting add]\u521b\u5efa\uff08\u7f16\u8f91\u76f4\u64ad\u95f4\uff09\u8d85\u65f6\u672a\u5230\u8fbe\u7fa4\u53d1\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)addOrModReq));
            AddOrModResp addOrModResp = this.groupSendService.addOrModGroupSend(addOrModReq);
            log.info("[meeting add]\u521b\u5efa\uff08\u7f16\u8f91\u76f4\u64ad\u95f4\uff09\u8d85\u65f6\u672a\u5230\u8fbe\u7fa4\u53d1\u54cd\u5e94\u7ed3\u679c\u4e3a:{}", (Object)addOrModResp);
            groupSendTaskNum = addOrModResp.getTaskNum();
        }
        meeting.setDeadlineVoisId(voiceTaskId);
        meeting.setDeadlineGpTaskNum(groupSendTaskNum);
        if (Objects.nonNull(voiceTaskId) || Objects.nonNull(groupSendTaskNum)) {
            Meeting update = new Meeting();
            update.setId(meeting.getId());
            update.setDeadlineVoisId(voiceTaskId);
            update.setDeadlineGpTaskNum(groupSendTaskNum);
            update.setInviteInfoType(reqDto.getInviteInfoType());
            this.meetingMapper.updateByPrimaryKeySelective((Object)update);
        }
    }

    void batchInsertMeetingTag(List<TagGroupParams> tagGroups, Meeting meeting, int type) {
        if (CollectionUtils.isNotEmpty(tagGroups)) {
            CurrentUserInfo user = LoginUtils.getCurrentUser();
            ArrayList mts = Lists.newArrayList();
            MeetingTag mt = null;
            Date now = new Date();
            for (TagGroupParams group : tagGroups) {
                for (WeworkTagParams tag : group.getWeworkTags()) {
                    mt = new MeetingTag();
                    mt.setBizId(user.getBizId().longValue());
                    mt.setCorpId(user.getCorpId());
                    mt.setCreateBy(user.getWeworkUserNum());
                    mt.setCreateByName(user.getName());
                    mt.setCreateTime(now);
                    mt.setUpdateTime(now);
                    mt.setMeetingId(meeting.getNum());
                    mt.setNum(this.idGen.getNum());
                    mt.setTagGroupId(group.getGroupId());
                    mt.setTagGroupName(group.getGroupName());
                    mt.setTagId(tag.getId());
                    mt.setTagName(tag.getName());
                    mt.setType(type);
                    mts.add(mt);
                }
            }
            this.meetingTagMapper.batchInsert((Collection)mts);
        }
    }

    void modMeetingTags(List<TagGroupParams> tagGroups, Meeting meeting, int type) {
        this.meetingTagMapper.deleteByMeetingIdAndType(meeting.getNum(), Integer.valueOf(type));
        this.batchInsertMeetingTag(tagGroups, meeting, type);
    }

    @Override
    public void cancelMeeting(MeetingCancelReqDto reqDto) {
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("cancelMeeting,params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getCorpId()});
        reqDto.validateParams();
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)reqDto.getId());
        this.checkIsCanCancel(meeting, reqDto);
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(currentUserInfo.getCorpId());
        this.checkMeetingSetting(meetingSetting);
        BaijiacloudBaseReqDto baijiacloudBaseReqDto = new BaijiacloudBaseReqDto();
        baijiacloudBaseReqDto.setPartnerId(meetingSetting.getBjyId());
        baijiacloudBaseReqDto.setPartnerKey(meetingSetting.getBjyKey());
        baijiacloudBaseReqDto.setPrivateDomain(meetingSetting.getDominSite());
        try {
            log.info("\u5f00\u59cb\u5220\u9664\u767e\u5bb6\u4e91\u4f1a\u8bae,params:{}", (Object)baijiacloudBaseReqDto);
            this.baijiacloudApiService.delRoom(baijiacloudBaseReqDto, meeting.getRoomId());
        }
        catch (Exception ex) {
            log.error("\u5220\u9664\u767e\u5bb6\u4e91\u4f1a\u8bae\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u53d6\u6d88\u4f1a\u8bae\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue() && StringUtils.isNotBlank((CharSequence)meeting.getGroupSendNum())) {
            Set groupSendNums = this.meetingGroupSendRelationMapper.selectGroupSendNumsByMeetingId(meeting.getId());
            EditTaskStatusReq editTaskStatusReq = new EditTaskStatusReq();
            editTaskStatusReq.setFkTaskId(meeting.getId());
            editTaskStatusReq.setFkType(NumberUtils.INTEGER_ONE.intValue());
            editTaskStatusReq.setTaskStatus(NumberUtils.INTEGER_ZERO);
            for (String groupSendNum : groupSendNums) {
                try {
                    editTaskStatusReq.setTaskNum(groupSendNum);
                    log.info("\u5f00\u59cb\u53d6\u6d88\u7fa4\u53d1\u4efb\u52a1,params:{}", (Object)editTaskStatusReq);
                    this.groupSendService.editTaskStatus(editTaskStatusReq);
                }
                catch (Exception ex) {
                    log.error("\u53d6\u6d88\u7fa4\u53d1\u4efb\u52a1\u5f02\u5e38:", (Throwable)ex);
                }
            }
        }
        DisableRemindReqDto disableRemindReqDto = new DisableRemindReqDto(meeting.getId(), NumberUtils.INTEGER_ONE);
        this.remindService.disableRemind(disableRemindReqDto);
        this.delSchedule(meeting.getScheduleId(), currentUserInfo.getCorpId());
        this.meetingMapper.updateStatusById(Integer.valueOf(MeetingStatus.CANCELED.getValue()), meeting.getId(), currentUserInfo.getId());
    }

    @Override
    public void mod(MeetingAddOrModReqDto reqDto) {
        List<String> weworkUserIds;
        String weworkUserId;
        String calId;
        String fullMeetingUrl;
        Meeting meeting;
        CurrentUserInfo currentUserInfo;
        block11: {
            currentUserInfo = this.baseValidate();
            Long bizId = currentUserInfo.getBizId();
            String corpId = currentUserInfo.getCorpId();
            log.info("mod params:{}, operatorId:{}, corpId:{}", new Object[]{reqDto, currentUserInfo.getId(), currentUserInfo.getCorpId()});
            reqDto.validateModParams();
            reqDto.setType(1);
            List<ShareMemberDto> shareMemberList = this.meetingShareMemberService.getShareMembers(bizId, corpId, reqDto.getWeworkUserNums(), reqDto.getNodeIds());
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(shareMemberList), (Object)"\u5171\u4eab\u6210\u5458\u4e0d\u80fd\u4e3a\u7a7a");
            reqDto.setShareMemberList(shareMemberList);
            meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)reqDto.getId());
            this.checkIsCanMod(meeting, reqDto);
            MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(currentUserInfo.getCorpId());
            this.checkMeetingSetting(meetingSetting);
            String meetingInfo = ((UniformMsgDto)reqDto.getContentList().stream().filter(uniformMsgDto -> uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())).collect(Collectors.toList()).get(0)).getContent();
            fullMeetingUrl = meeting.getMeetingUrl();
            String resultStr = meetingInfo.replace("${nickname}", "{\u6210\u5458\u6635\u79f0}");
            resultStr = resultStr.replace("${meetingUrl}", fullMeetingUrl);
            String finalResultStr = resultStr = resultStr.replace("${roomId}", meeting.getStudentCode());
            reqDto.getContentList().forEach(uniformMsgDto -> {
                if (uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())) {
                    uniformMsgDto.setContent(finalResultStr);
                }
            });
            this.keywordService.associateMeetingWithKeywords(meeting, reqDto.getKeywordGroups(), currentUserInfo.getBizId(), reqDto.getType(), YnEnum.NO.getValue());
            MultiSearchContactResp multiSearchContactResp = null;
            MultiSearchContactReq multiSearchContactReq = null;
            if (MeetingType.EXTERNAL_MEETING.getValue() == reqDto.getType().intValue() && NumberUtils.INTEGER_ONE.equals(reqDto.getEnableInviteCustomer())) {
                multiSearchContactReq = this.buildMultiSearchContactReq(reqDto, currentUserInfo);
                multiSearchContactResp = this.multiSelectService.multiSearchContact(multiSearchContactReq, true);
                if (Objects.isNull(multiSearchContactResp) || CollectionUtils.isEmpty((Collection)multiSearchContactResp.getList())) {
                    log.info("\u6839\u636e\u6761\u4ef6multiSearchContactReq:{}\u672a\u67e5\u8be2\u5230\u5ba2\u6237", (Object)multiSearchContactReq);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u5ba2\u6237\u4eba\u6570\u4e3a0");
                }
                multiSearchContactReq.setRequestId(multiSearchContactResp.getRequestId());
            }
            this.supportMeetingCommerceTask(currentUserInfo, reqDto, meeting, multiSearchContactResp);
            if (MeetingType.EXTERNAL_MEETING.getValue() == reqDto.getType().intValue()) {
                try {
                    this.handleGroupSend(reqDto, meeting, currentUserInfo, multiSearchContactReq);
                }
                catch (Exception ex) {
                    log.error("\u7f16\u8f91\u4f1a\u8bae\u5904\u7406\u7fa4\u53d1\u4efb\u52a1\u5f02\u5e38:", (Throwable)ex);
                    if (ex instanceof BusinessException) {
                        BusinessException businessException = (BusinessException)((Object)ex);
                        if (!"\u4efb\u52a1\u5df2\u7ecf\u53d1\u9001\u6210\u529f\u4e0d\u53ef\u66f4\u65b0".equals(businessException.getMessage())) {
                            throw ex;
                        }
                    }
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7f16\u8f91\u4f1a\u8bae\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
            }
            this.handleRemind(reqDto, meeting.getId(), currentUserInfo.getId(), currentUserInfo.getBizId(), currentUserInfo.getCorpId(), multiSearchContactResp, fullMeetingUrl);
            this.delSchedule(meeting.getScheduleId(), currentUserInfo.getCorpId());
            calId = meeting.getCalId();
            weworkUserId = this.userMapper.getWeworkUserIdByUserId(currentUserInfo.getId());
            weworkUserIds = shareMemberList.stream().map(ShareMemberDto::getWeworkUserId).collect(Collectors.toList());
            if (StringUtils.isBlank((CharSequence)weworkUserId)) {
                weworkUserId = (String)weworkUserIds.get(0);
            }
            try {
                CalendarDetailReq calendarDetailReq = new CalendarDetailReq();
                calendarDetailReq.setCalIdList((List)Lists.newArrayList((Object[])new String[]{calId}));
                CalendarDetailResp calendarDetailResp = this.calendarClient.getCalendarDetail(currentUserInfo.getCorpId(), calendarDetailReq);
                weworkUserId = ((QyCalendar)calendarDetailResp.getCalendarList().get(0)).getOrganizer();
            }
            catch (Exception ex) {
                WeworkException weworkException;
                Integer errorCode;
                log.error("\u751f\u6210\u65e5\u5386\u548c\u65e5\u7a0b\u5f02\u5e38:", (Throwable)ex);
                if (!(ex instanceof WeworkException) || !needCreateCalendarCodes.contains(errorCode = (weworkException = (WeworkException)ex).getErrorCode())) break block11;
                calId = this.createCalendar(currentUserInfo, reqDto, weworkUserId);
            }
        }
        meeting.setCalId(calId);
        String scheduleId = "";
        if (StringUtils.isNotBlank((CharSequence)calId)) {
            scheduleId = this.createSchedule(calId, reqDto, currentUserInfo, weworkUserId, weworkUserIds);
        }
        meeting.setScheduleId(scheduleId);
        this.updateMeetingInfo(reqDto, meeting, currentUserInfo, fullMeetingUrl);
        this.addSaveMaterial(reqDto, meeting);
        this.modMeetingTags(reqDto.getSubscribeTags(), meeting, 0);
        this.modMeetingTags(reqDto.getJoinLiveRoomTags(), meeting, 1);
        this.modMeetingReportMembers(reqDto.getReportWeworkUserNums(), meeting, currentUserInfo);
    }

    @Override
    public MeetingDetailRespDto detail(MeetingDetailReqDto dto) {
        log.info("detail: meetingDetailReqDto:{}", (Object)dto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("detail: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        dto.validate();
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), dto.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.info("detail, \u67e5\u8be2\u4e0d\u5230\u4f1a\u8bae:{}", (Object)dto.getMeetingId());
            return null;
        }
        ArrayList roomIds = Lists.newArrayList();
        roomIds.add(meeting.getRoomId());
        Map roomIdPrivateMap = null;
        if (CollectionUtils.isNotEmpty((Collection)roomIds)) {
            roomIdPrivateMap = this.meetingBjyMapper.queryRoomPrivate((Collection)roomIds, userInfo.getBizId(), userInfo.getCorpId());
        }
        List infoList = this.studentInfoMapper.queryStudentList(meeting.getRoomId(), userInfo.getBizId());
        log.info("detail: size: {}, roomId: {}, bizId: {}", new Object[]{infoList.size(), meeting.getRoomId(), userInfo.getBizId()});
        return this.buildMeetingDetailRespDto(userInfo, meeting, roomIdPrivateMap, infoList);
    }

    void getAndSetMeetingGroupTag(MeetingDetailRespDto dto, String meetingId) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        List mts = this.meetingTagMapper.queryByMeetingId(meetingId, user.getBizId().longValue(), user.getCorpId());
        if (CollectionUtils.isNotEmpty((Collection)mts)) {
            List subscribeList = mts.stream().filter(p -> p.getType() == NumberUtils.INTEGER_ZERO.intValue()).collect(Collectors.toList());
            dto.setSubscribeTags(MeetingTag.convertPOToDto(subscribeList));
            List joinLiveRoomList = mts.stream().filter(p -> p.getType() == NumberUtils.INTEGER_ONE.intValue()).collect(Collectors.toList());
            dto.setJoinLiveRoomTags(MeetingTag.convertPOToDto(joinLiveRoomList));
        }
    }

    @Override
    public List<JoinMeetingRespDto> joinMeetingDetail(JoinMeetingReqDto dto) {
        log.info("joinMeetingDetail: dto:{}", (Object)dto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("joinMeetingDetail: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        dto.validate();
        Integer queryType = this.getQueryType(dto);
        if (Objects.isNull(queryType)) {
            log.info("joinMeetingDetail: \u67e5\u8be2\u7c7b\u578b\u9519\u8bef:{}", (Object)dto);
            return Collections.emptyList();
        }
        if (queryType.intValue() == MeetingCountType.UNJOIN_MEETING.getValue() && StringUtils.isNotBlank((CharSequence)dto.getSource())) {
            log.info("joinMeetingDetail: \u672a\u5165\u4f1a\u4e0b\u641c\u7d22\u6e20\u9053\u6570\u636e\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), dto.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.info("joinMeetingDetail: \u67e5\u4e0d\u5230\u8be5\u4f1a\u8bae, meetingId:{}", (Object)dto.getMeetingId());
            return null;
        }
        QueryJoinMeetingParam param = dto.convertToParam(userInfo.getBizId(), userInfo.getCorpId());
        log.info("joinMeetingDetail: param:{}", (Object)param);
        List<Object> respDtos = Lists.newArrayList();
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            respDtos = this.handleExternalMeetingDetail(userInfo, dto, meeting, queryType, param);
        } else if (MeetingType.INTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            respDtos = this.handleInternalMeetingDetail(userInfo, dto, meeting, queryType, param);
        }
        return respDtos;
    }

    private List<JoinMeetingRespDto> handleExternalMeetingDetail(CurrentUserInfo userInfo, JoinMeetingReqDto reqDto, Meeting meeting, Integer queryType, QueryJoinMeetingParam param) {
        Long bizId = userInfo.getBizId();
        List<MeetingJoinQuitLog> logList = Lists.newArrayList();
        List detailList = Lists.newArrayList();
        Integer count = 0;
        if (MeetingCountType.JOIN_NUM.getValue() == queryType.intValue()) {
            count = this.meetingJoinQuitLogMapper.queryByMeetingIdCount(param);
            if (count <= 0) {
                return Collections.emptyList();
            }
            logList = this.meetingJoinQuitLogMapper.queryByMeetingId(param);
            log.info("joinMeetingDetail: \u5916\u90e8\u4f1a\u8bae \u5165\u4f1a\u4eba\u6570\uff1a{}", (Object)logList.size());
        } else if (queryType.intValue() == MeetingCountType.UNJOIN_MEETING.getValue()) {
            count = this.meetingSendDetailMapper.queryUnJoinRemindListCount(param);
            if (count <= 0) {
                return Collections.emptyList();
            }
            detailList = this.meetingSendDetailMapper.queryUnJoinRemindList(param);
            log.info("joinMeetingDetail: \u5916\u90e8\u4f1a\u8bae \u672a\u5165\u4f1a \u901a\u77e5\u4eba\u6570\uff1a{}", (Object)detailList.size());
        } else {
            count = this.meetingSendDetailMapper.queryRemindListCount(param);
            if (count <= 0) {
                return Collections.emptyList();
            }
            detailList = this.meetingSendDetailMapper.queryRemindList(param);
            log.info("joinMeetingDetail: \u5916\u90e8\u4f1a\u8bae \u901a\u77e5\u4eba\u6570\uff1a{}", (Object)detailList.size());
        }
        Map<String, MeetingTimeDto> meetingTimeDtoMap = this.handleLogList(logList, meeting.getId());
        Long meetingLength = (meeting.getEndTime().getTime() - meeting.getStartTime().getTime()) / 1000L;
        log.info("joinMeetingDetail meetingLength: {}", (Object)meetingLength);
        ArrayList respDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(logList)) {
            List hasRemindLogIds = this.meetingSendDetailMapper.queryRemindIdByLogs(userInfo.getBizId(), reqDto.getMeetingId(), logList);
            Set<Object> hasRemindSet = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty((Collection)hasRemindLogIds)) {
                hasRemindSet = hasRemindLogIds.stream().map(a -> this.buildKey(a.getWeworkUserNum(), a.getContactId())).collect(Collectors.toSet());
            }
            Set<String> userNums = logList.stream().map(MeetingJoinQuitLog::getWeworkUserNum).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, WeworkUser> weworkUserMap = this.getWeworkUserMapByNums(userNums, userInfo.getCorpId());
            Set<String> contactIds = logList.stream().map(MeetingJoinQuitLog::getContactId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, WeworkContact> weworkContactMap = this.getContactMapByIds(contactIds, userInfo.getCorpId());
            Map<String, String> weworkUserNum2IdMap = this.getWeworkUserNum2IdMap(userNums);
            Map<String, WeworkContactRelation> weworkContactRelationMap = this.getWeworkContactRelation(userInfo.getCorpId(), contactIds, weworkUserNum2IdMap);
            Set<String> bjyNums = logList.stream().map(MeetingJoinQuitLog::getBjyNumber).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, Integer> bjyNumAndCountMap = this.getJoinCountByBjyNums(bjyNums, userInfo.getBizId(), reqDto.getMeetingId());
            Map<String, Integer> forwardCountMap = this.getForwardCountByLogs(logList, userInfo.getBizId(), reqDto.getMeetingId());
            Set<Long> channelIds = logList.stream().filter(p -> p.getChannelId() != null && p.getChannelId() > 0L).map(MeetingJoinQuitLog::getChannelId).collect(Collectors.toSet());
            Map<Long, String> channelMap = this.getChannelMapByIds(userInfo.getBizId(), channelIds);
            Set customerStrs = logList.stream().map(MeetingJoinQuitLog::getNum).collect(Collectors.toSet());
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryCustomerByStr(bizId, meeting.getId(), customerStrs);
            Map<String, List<MeetingCustomerInfo>> customerInfoMap = meetingCustomerInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUnionId())).collect(Collectors.groupingBy(MeetingCustomerInfo::getUnionId));
            Map<String, CustomerDetailResp> customerDetailRespMap = this.queryCustomerDetailInfo(bizId, customerInfoMap.keySet(), customerInfoMap);
            boolean mobileEncrypt = this.settingService.getMobileEncrypt(bizId);
            for (MeetingJoinQuitLog log : logList) {
                JoinMeetingRespDto respDto = JoinMeetingRespDto.buildDto(log, meeting, weworkUserMap, weworkContactMap, bjyNumAndCountMap, forwardCountMap, channelMap, hasRemindSet, weworkUserNum2IdMap, weworkContactRelationMap, meetingTimeDtoMap, meetingLength, customerDetailRespMap);
                if (mobileEncrypt && StringUtils.isNotBlank((CharSequence)respDto.getCustomerPhone())) {
                    respDto.setCustomerPhone(MobileUtils.encryptMobile((String)respDto.getCustomerPhone()));
                }
                respDtos.add(respDto);
            }
        }
        if (CollectionUtils.isNotEmpty(detailList)) {
            Map<Object, Object> bjyNumAndCountMap = Maps.newHashMap();
            Map<Object, Object> forwardCountMap = Maps.newHashMap();
            Map<Object, Object> channelMap = Maps.newHashMap();
            Map<Object, Object> hasJoinMap = Maps.newHashMap();
            Map<Object, Object> hasRemindMap = Maps.newHashMap();
            if (queryType.intValue() != MeetingCountType.UNJOIN_MEETING.getValue()) {
                List hasRemindList;
                List joinQuitLogs = this.meetingJoinQuitLogMapper.queryLogByUserNumAndContactId(userInfo.getBizId(), reqDto.getMeetingId(), detailList);
                if (CollectionUtils.isNotEmpty((Collection)joinQuitLogs)) {
                    hasJoinMap = joinQuitLogs.stream().collect(Collectors.groupingBy(a -> this.buildKey(a.getWeworkUserNum(), a.getContactId())));
                    Set<String> bjyNums = joinQuitLogs.stream().map(MeetingJoinQuitLog::getBjyNumber).filter(Objects::nonNull).collect(Collectors.toSet());
                    bjyNumAndCountMap = this.getJoinCountByBjyNums(bjyNums, userInfo.getBizId(), reqDto.getMeetingId());
                    forwardCountMap = this.getForwardCountByLogs(joinQuitLogs, userInfo.getBizId(), reqDto.getMeetingId());
                    Set<Long> channelIds = logList.stream().filter(p -> p.getChannelId() != null && p.getChannelId() > 0L).map(MeetingJoinQuitLog::getChannelId).collect(Collectors.toSet());
                    meetingTimeDtoMap = this.handleLogList(joinQuitLogs, meeting.getId());
                    channelMap = this.getChannelMapByIds(bizId, channelIds);
                }
                if (CollectionUtils.isNotEmpty((Collection)(hasRemindList = this.meetingSendDetailMapper.querySendListByUserNumAndContactId(userInfo.getBizId(), reqDto.getMeetingId(), detailList)))) {
                    hasRemindMap = hasRemindList.stream().collect(Collectors.groupingBy(a -> this.buildKey(a.getWeworkUserNum(), a.getContactId())));
                }
            }
            Set<String> userNums = detailList.stream().map(MeetingSendDetail::getWeworkUserNum).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, WeworkUser> weworkUserMap = this.getWeworkUserMapByNums(userNums, userInfo.getCorpId());
            Set<String> contactIds = detailList.stream().map(MeetingSendDetail::getContactId).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, WeworkContact> weworkContactMap = this.getContactMapByIds(contactIds, userInfo.getCorpId());
            Map<String, String> weworkUserNum2IdMap = this.getWeworkUserNum2IdMap(userNums);
            Map<String, WeworkContactRelation> weworkContactRelationMap = this.getWeworkContactRelation(userInfo.getCorpId(), contactIds, weworkUserNum2IdMap);
            for (MeetingSendDetail detail : detailList) {
                JoinMeetingRespDto respDto = JoinMeetingRespDto.buildDto(detail, weworkUserMap, weworkContactMap, hasJoinMap, (Map<String, Integer>)bjyNumAndCountMap, (Map<String, Integer>)forwardCountMap, (Map<Long, String>)channelMap, hasRemindMap, reqDto, weworkUserNum2IdMap, weworkContactRelationMap, meetingTimeDtoMap, meetingLength);
                respDtos.add(respDto);
            }
        }
        if (Objects.nonNull(reqDto.getPageDto())) {
            reqDto.getPageDto().setCount(count);
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(respDtos.size()));
        }
        return respDtos;
    }

    private Map<String, CustomerDetailResp> queryCustomerDetailInfo(Long bizId, Collection<String> unionIds, Map<String, List<MeetingCustomerInfo>> customerInfoMap) {
        if (CollectionUtils.isEmpty(unionIds)) {
            log.info("bizId\uff1a{};unionIds \u53c2\u6570\u4e3a\u7a7a;", (Object)bizId, unionIds);
            return Maps.newHashMap();
        }
        HashMap customerDetailRespMap = Maps.newHashMap();
        try {
            CustomerDetailReq req = new CustomerDetailReq();
            req.setBizId(bizId);
            req.setUnionIds((List)Lists.newArrayList(unionIds));
            List customerDetailResps = this.customerDetailService.queryCustomerDetailInfo(req);
            for (CustomerDetailResp customerDetailResp : customerDetailResps) {
                List<MeetingCustomerInfo> customerInfos = customerInfoMap.get(customerDetailResp.getUnionId());
                if (!CollectionUtils.isNotEmpty(customerInfos)) continue;
                for (MeetingCustomerInfo customerInfo : customerInfos) {
                    customerDetailRespMap.put(customerInfo.getCustomerStr(), customerDetailResp);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528customerDetailService.queryCustomerDetailInfo \u62a5\u9519\uff1abizId:{};param:{}", new Object[]{bizId, unionIds, e});
        }
        return customerDetailRespMap;
    }

    private Map<String, MeetingTimeDto> handleLogList(List<MeetingJoinQuitLog> logList, Long meetingId) {
        HashMap<String, MeetingTimeDto> meetingTimeMap = new HashMap<String, MeetingTimeDto>();
        for (MeetingJoinQuitLog log : logList) {
            List queryList = this.meetingJoinQuitLogMapper.queryLogList(log.getCorpId(), log.getRoomId(), log.getBjyNumber(), meetingId);
            if (queryList.size() <= 0) continue;
            MeetingJoinQuitLog last = (MeetingJoinQuitLog)queryList.get(0);
            MeetingJoinQuitLog first = (MeetingJoinQuitLog)queryList.get(queryList.size() - 1);
            int totalDuration = 0;
            for (MeetingJoinQuitLog L : queryList) {
                totalDuration += L.getDuration().intValue();
            }
            MeetingTimeDto timeDto = new MeetingTimeDto();
            timeDto.setFirstJoinTime(first.getJoinTime());
            timeDto.setLastQuitTime(last.getQuitTime());
            timeDto.setTotalDuration(totalDuration);
            meetingTimeMap.put(first.getBjyNumber(), timeDto);
        }
        log.info("handleLogList: {}", meetingTimeMap);
        return meetingTimeMap;
    }

    private List<JoinMeetingRespDto> handleInternalMeetingDetail(CurrentUserInfo userInfo, JoinMeetingReqDto reqDto, Meeting meeting, Integer queryType, QueryJoinMeetingParam param) {
        List<MeetingJoinQuitLog> logList = Lists.newArrayList();
        Set internalNums = Sets.newHashSet();
        Integer count = 0;
        Long meetingLength = (meeting.getEndTime().getTime() - meeting.getStartTime().getTime()) / 1000L;
        log.info("joinMeetingDetail \u5185\u90e8\u4f1a\u8bae meetingLength: {}", (Object)meetingLength);
        if (MeetingCountType.JOIN_NUM.getValue() == queryType.intValue()) {
            count = this.meetingJoinQuitLogMapper.queryByMeetingIdCount(param);
            if (count <= 0) {
                return Collections.emptyList();
            }
            logList = this.meetingJoinQuitLogMapper.queryByMeetingId(param);
            log.info("joinMeetingDetail: \u5185\u90e8\u4f1a\u8bae \u5165\u4f1a\u4eba\u6570\uff1a{}", (Object)logList.size());
        } else {
            QyRemind remind = this.remindMapper.getRemind(meeting.getId());
            if (Objects.isNull(remind)) {
                log.info("joinMeetingDetail remind is null");
                return null;
            }
            param.setRemindId(remind.getId());
            if (MeetingCountType.UNJOIN_MEETING.getValue() == queryType.intValue()) {
                count = this.remindDetailMapper.getUnJoinMemberCount(param);
                if (count <= 0) {
                    return Collections.emptyList();
                }
                Set unJoinNums = this.remindDetailMapper.getUnJoinMember(param);
                log.info("joinMeetingDetail: \u5185\u90e8\u4f1a\u8bae \u672a\u5165\u4f1a\u4eba\u6570\uff1a{}", (Object)unJoinNums.size());
                internalNums = unJoinNums;
            } else if (MeetingCountType.PREDICT_REMIND_NUM.getValue() == queryType.intValue()) {
                param.setIsSend(null);
                count = this.remindDetailMapper.getRemindMemberCount(param);
                if (count <= 0) {
                    return Collections.emptyList();
                }
                Set internalPredictNums = this.remindDetailMapper.getRemindMember(param);
                log.info("joinMeetingDetail: \u5185\u90e8\u4f1a\u8bae \u9884\u8ba1\u901a\u77e5\u4eba\u6570\uff1a{}", (Object)internalPredictNums.size());
                internalNums = internalPredictNums;
            } else if (MeetingCountType.REAL_REMIND_NUM.getValue() == queryType.intValue()) {
                param.setIsSend(Integer.valueOf(1));
                count = this.remindDetailMapper.getRemindMemberCount(param);
                if (count <= 0) {
                    return Collections.emptyList();
                }
                Set internalRealNums = this.remindDetailMapper.getRemindMember(param);
                log.info("joinMeetingDetail: \u5185\u90e8\u4f1a\u8bae \u5b9e\u9645\u901a\u77e5\u4eba\u6570\uff1a{}", (Object)internalRealNums.size());
                internalNums = internalRealNums;
            }
        }
        Map<String, MeetingTimeDto> meetingTimeDtoMap = this.handleLogList(logList, meeting.getId());
        ArrayList respDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(logList)) {
            Set hasRemindUsers = Sets.newHashSet();
            QyRemind remind = this.remindMapper.getRemind(meeting.getId());
            if (Objects.nonNull(remind)) {
                hasRemindUsers = this.remindDetailMapper.queryUserNumsByLogs(userInfo.getBizId(), remind.getId(), logList);
            }
            Set<String> userNums = logList.stream().map(MeetingJoinQuitLog::getWeworkUserNum).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, WeworkUser> weworkUserMap = this.getWeworkUserMapByNums(userNums, userInfo.getCorpId());
            HashMap weworkContactMap = Maps.newHashMap();
            HashMap weworkUserNum2IdMap = Maps.newHashMap();
            HashMap weworkContactRelationMap = Maps.newHashMap();
            Set<String> bjyNums = logList.stream().map(MeetingJoinQuitLog::getBjyNumber).filter(Objects::nonNull).collect(Collectors.toSet());
            Map<String, Integer> bjyNumAndCountMap = this.getJoinCountByBjyNums(bjyNums, userInfo.getBizId(), reqDto.getMeetingId());
            Map<String, Integer> forwardCountMap = this.getForwardCountByLogs(logList, userInfo.getBizId(), reqDto.getMeetingId());
            Set<Long> channelIds = logList.stream().filter(p -> p.getChannelId() != null && p.getChannelId() > 0L).map(MeetingJoinQuitLog::getChannelId).collect(Collectors.toSet());
            Map<Long, String> channelMap = this.getChannelMapByIds(userInfo.getBizId(), channelIds);
            Set customerStrs = logList.stream().map(MeetingJoinQuitLog::getNum).collect(Collectors.toSet());
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.queryCustomerByStr(userInfo.getBizId(), meeting.getId(), customerStrs);
            Map customerInfoMap = meetingCustomerInfos.stream().filter(item -> StringUtils.isNotBlank((CharSequence)item.getUnionId())).collect(Collectors.toMap(MeetingCustomerInfo::getUnionId, Function.identity()));
            HashMap customerDetailRespMap = Maps.newHashMap();
            try {
                CustomerDetailReq req = new CustomerDetailReq();
                req.setBizId(userInfo.getBizId());
                req.setUnionIds((List)Lists.newArrayList(customerInfoMap.keySet()));
                List customerDetailResps = this.customerDetailService.queryCustomerDetailInfo(req);
                for (CustomerDetailResp customerDetailResp : customerDetailResps) {
                    MeetingCustomerInfo customerInfo = (MeetingCustomerInfo)customerInfoMap.get(customerDetailResp.getUnionId());
                    if (!Objects.nonNull(customerInfo)) continue;
                    customerDetailRespMap.put(customerInfo.getCustomerStr(), customerDetailResp);
                }
            }
            catch (Exception e) {
                log.error("\u8c03\u7528customerDetailService.queryCustomerDetailInfo \u62a5\u9519\uff1aparam:{}", (Object)param, (Object)e);
            }
            for (MeetingJoinQuitLog log : logList) {
                JoinMeetingRespDto respDto = JoinMeetingRespDto.buildDto(log, meeting, weworkUserMap, weworkContactMap, bjyNumAndCountMap, forwardCountMap, channelMap, hasRemindUsers, weworkUserNum2IdMap, weworkContactRelationMap, meetingTimeDtoMap, meetingLength, customerDetailRespMap);
                respDtos.add(respDto);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)internalNums)) {
            List hasJoinUserLogs;
            Map<Object, Object> hasJoinUserMap = Maps.newHashMap();
            Map<Object, Object> bjyNumAndCountMap = Maps.newHashMap();
            Map<Object, Object> forwardCountMap = Maps.newHashMap();
            Map<Object, Object> channelMap = Maps.newHashMap();
            if (MeetingCountType.UNJOIN_MEETING.getValue() != queryType.intValue() && CollectionUtils.isNotEmpty((Collection)(hasJoinUserLogs = this.meetingJoinQuitLogMapper.queryLogByUserNum(userInfo.getBizId(), reqDto.getMeetingId(), (Collection)internalNums)))) {
                hasJoinUserMap = hasJoinUserLogs.stream().collect(Collectors.toMap(MeetingJoinQuitLog::getWeworkUserNum, a -> a, (k, v) -> v));
                Set<String> bjyNums = hasJoinUserLogs.stream().map(MeetingJoinQuitLog::getBjyNumber).filter(Objects::nonNull).collect(Collectors.toSet());
                bjyNumAndCountMap = this.getJoinCountByBjyNums(bjyNums, userInfo.getBizId(), reqDto.getMeetingId());
                forwardCountMap = this.getForwardCountByLogs(hasJoinUserLogs, userInfo.getBizId(), reqDto.getMeetingId());
                Set<Long> channelIds = logList.stream().filter(p -> p.getChannelId() != null && p.getChannelId() > 0L).map(MeetingJoinQuitLog::getChannelId).collect(Collectors.toSet());
                meetingTimeDtoMap = this.handleLogList(hasJoinUserLogs, meeting.getId());
                channelMap = this.getChannelMapByIds(userInfo.getBizId(), channelIds);
            }
            Map<String, WeworkUser> weworkUserMap = this.getWeworkUserMapByNums(internalNums, userInfo.getCorpId());
            for (String userNum : internalNums) {
                JoinMeetingRespDto respDto = JoinMeetingRespDto.buildDto(userNum, weworkUserMap, hasJoinUserMap, bjyNumAndCountMap, forwardCountMap, channelMap, meetingTimeDtoMap, meetingLength);
                respDtos.add(respDto);
            }
        }
        if (Objects.nonNull(reqDto.getPageDto())) {
            reqDto.getPageDto().setCount(count);
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(respDtos.size()));
        }
        return respDtos;
    }

    private Map<String, WeworkContact> getContactMapByIds(Set<String> contactIds, String corpId) {
        List contactList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(contactIds)) {
            contactList = this.weworkContactMapper.queryWeworkContactList(corpId, contactIds);
        }
        return contactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a, (k, v) -> v));
    }

    private Map<String, String> getWeworkUserNum2IdMap(Set<String> weworkUserNums) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return Maps.newHashMap();
        }
        return this.weworkUserMapper.selectWeworkUserNumAndIdByNums(weworkUserNums);
    }

    private Map<String, WeworkContactRelation> getWeworkContactRelation(String corpId, Set<String> contactIds, Map<String, String> weworkUserNum2IdMap) {
        if (CollectionUtils.isEmpty(contactIds) || Objects.isNull(weworkUserNum2IdMap)) {
            return Maps.newHashMap();
        }
        Collection<String> weworkUserIds = weworkUserNum2IdMap.values();
        List contactRelations = this.weworkContactRelationMapper.selectByCorpIdAndContactIdsAndWeworkUserIds(corpId, contactIds, weworkUserIds);
        Map<Object, Object> contactId2RelationMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)contactRelations)) {
            contactId2RelationMap = contactRelations.stream().collect(Collectors.toMap(it -> this.buildKey(it.getWeworkUserId(), it.getContactId()), a -> a, (k, v) -> v));
        }
        return contactId2RelationMap;
    }

    private Map<String, WeworkUser> getWeworkUserMapByNums(Set<String> nums, String corpId) {
        List weworkUsers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(nums)) {
            weworkUsers = this.weworkUserMapper.queryWeworkUsersByNums(corpId, nums);
        }
        return weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, a -> a, (k, v) -> v));
    }

    private Map<String, Integer> getJoinCountByBjyNums(Set<String> bjyNums, Long bizId, Long meetingId) {
        Map bjyNumAndCountMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(bjyNums)) {
            bjyNumAndCountMap = this.meetingJoinQuitLogMapper.queryMeetingAndBjyNums(bizId, bjyNums, meetingId);
        }
        return bjyNumAndCountMap;
    }

    private Map<String, Integer> getForwardCountByLogs(List<MeetingJoinQuitLog> logList, Long bizId, Long meetingId) {
        List forwardInfos;
        HashMap forwardCountMap = Maps.newHashMap();
        List filterList = logList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getWeworkUserNum())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(filterList) && CollectionUtils.isNotEmpty((Collection)(forwardInfos = this.meetingJoinQuitLogMapper.queryTransferCount(bizId, filterList, meetingId)))) {
            for (MeetingForwardInfo info : forwardInfos) {
                if (Objects.isNull(info) || Objects.isNull(info.getWeworkUserNum())) continue;
                String key = this.buildKey(info.getWeworkUserNum(), info.getContactId());
                forwardCountMap.put(key, info.getCount());
            }
        }
        return forwardCountMap;
    }

    private Map<Long, String> getChannelMapByIds(Long bizId, Set<Long> channelIds) {
        Map channelMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(channelIds)) {
            channelMap = this.channelMapper.selectIdAndNameByIds(bizId, channelIds);
        }
        return channelMap;
    }

    private Integer getQueryType(JoinMeetingReqDto dto) {
        if (dto.getSendStatus() == null && dto.getJoinStatus() == null) {
            return MeetingCountType.PREDICT_REMIND_NUM.getValue();
        }
        if (dto.getSendStatus() == 1 && dto.getJoinStatus() == null) {
            return MeetingCountType.REAL_REMIND_NUM.getValue();
        }
        if (dto.getSendStatus() == 1 && dto.getJoinStatus() == 1) {
            return MeetingCountType.JOIN_NUM.getValue();
        }
        if (dto.getSendStatus() == 1 && dto.getJoinStatus() == 0) {
            return MeetingCountType.UNJOIN_MEETING.getValue();
        }
        return null;
    }

    @Override
    public List<JoinMeetingCountRespDto> joinMeetingCountDetail(JoinMeetingCountReqDto dto) {
        List logs;
        log.info("joinMeetingCountDetail: dto:{}", (Object)dto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("joinMeetingCountDetail: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        dto.validate();
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), dto.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.error("joinMeetingCountDetail: meeting is null, dto:{}", (Object)dto);
            return Collections.emptyList();
        }
        Integer offset = null;
        Integer limit = null;
        if (Objects.nonNull(dto.getPageDto())) {
            offset = (dto.getPageDto().getPageNum() - 1) * dto.getPageDto().getPageSize();
            limit = dto.getPageDto().getPageSize();
        }
        if (CollectionUtils.isEmpty((Collection)(logs = this.meetingJoinQuitLogMapper.queryCustomerJoinMeeting(dto.getMeetingId(), dto.getWeworkUserNum(), dto.getCustomerId(), dto.getCustomerBjyNumber(), offset, limit)))) {
            log.info("joinMeetingCountDetail: \u65e0\u6cd5\u67e5\u8be2\u5230\u5165\u4f1a\u6b21\u6570\u8be6\u60c5:{}", (Object)logs);
            return Collections.emptyList();
        }
        if (Objects.nonNull(dto.getPageDto())) {
            int count = this.meetingJoinQuitLogMapper.getCustomerJoinMeetingCount(dto.getMeetingId(), dto.getWeworkUserNum(), dto.getCustomerId(), dto.getCustomerBjyNumber());
            dto.getPageDto().setCount(Integer.valueOf(count));
            dto.getPageDto().setCurPageCount(Integer.valueOf(logs.size()));
        }
        WeworkContact weworkContact = null;
        if (Objects.nonNull(dto.getCustomerId())) {
            weworkContact = this.weworkContactMapper.queryWeworkContact(userInfo.getBizId(), userInfo.getCorpId(), dto.getCustomerId());
            log.info("joinMeetingCountDetail: weworkContact:{}", (Object)weworkContact);
        }
        Set channelIds = logs.stream().filter(p -> p.getChannelId() != null && p.getChannelId() > 0L).map(MeetingJoinQuitLog::getChannelId).collect(Collectors.toSet());
        Map channelMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(channelIds)) {
            channelMap = this.channelMapper.selectIdAndNameByIds(userInfo.getBizId(), channelIds);
        }
        WeworkUser weworkUser = null;
        if (Objects.nonNull(dto.getWeworkUserNum())) {
            weworkUser = this.weworkUserMapper.queryWeworkUserByNum(dto.getWeworkUserNum());
        }
        Map<Object, Object> weworkUserNum2IdMap = Maps.newHashMap();
        Map<Object, Object> weworkContactRelationMap = Maps.newHashMap();
        if (Objects.nonNull(dto.getWeworkUserNum()) && Objects.nonNull(dto.getCustomerId())) {
            HashSet userNums = Sets.newHashSet();
            userNums.add(dto.getWeworkUserNum());
            HashSet contactIds = Sets.newHashSet();
            contactIds.add(dto.getCustomerId());
            weworkUserNum2IdMap = this.getWeworkUserNum2IdMap(userNums);
            weworkContactRelationMap = this.getWeworkContactRelation(userInfo.getCorpId(), contactIds, weworkUserNum2IdMap);
        }
        ArrayList respDtos = Lists.newArrayList();
        for (MeetingJoinQuitLog log : logs) {
            JoinMeetingCountRespDto respDto = JoinMeetingCountRespDto.buildDto(log, meeting, weworkContact, weworkUser, weworkUserNum2IdMap, weworkContactRelationMap);
            Long channelId = log.getChannelId();
            if (channelId != null && channelMap.containsKey(channelId)) {
                String channelName = (String)channelMap.get(channelId);
                respDto.setSource(channelId.intValue());
                respDto.setSourceDesc(channelName);
            }
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public List<MeetingAssociateRespDto> associateMeetingList(AssociateMeetingReqDto reqDto) {
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("associateMeetingList: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        Integer offset = null;
        Integer limit = null;
        if (Objects.nonNull(reqDto)) {
            limit = reqDto.getPageDto().getPageSize();
            offset = (reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize();
        }
        Set<Long> userIds = this.getAuthorizedCreateIdForMeeting(userInfo);
        log.info("associateMeetingList userIds: {}", userIds);
        List meetings = this.meetingMapper.queryMeetingsByParams(userInfo.getCorpId(), reqDto != null ? reqDto.getTitle() : null, offset, limit, userIds);
        if (CollectionUtils.isEmpty((Collection)meetings)) {
            log.info("associateMeetingList: meetings is null\uff0creqDto\uff1a{}", (Object)reqDto);
            return Collections.emptyList();
        }
        if (reqDto != null && Objects.nonNull(reqDto.getPageDto())) {
            int count = this.meetingMapper.getCountByAssociateParam(userInfo.getCorpId(), reqDto.getTitle(), userIds);
            reqDto.getPageDto().setCount(Integer.valueOf(count));
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetings.size()));
        }
        ArrayList respDtos = Lists.newArrayList();
        for (Meeting meeting : meetings) {
            MeetingAssociateRespDto respDto = new MeetingAssociateRespDto();
            respDto.setMeetingId(meeting.getId());
            respDto.setMeetingTitle(meeting.getTitle());
            respDto.setInviteInfo(meeting.getInviteContent());
            respDto.setStartTime(meeting.getStartTime());
            respDto.setEndTime(meeting.getEndTime());
            respDto.setMeetingInfo(meeting.getMeetingInfo());
            respDto.setRemindContent(meeting.getRemindContent());
            respDto.setInviteInfoType(meeting.getInviteInfoType());
            log.info("associateMeetingList : meetingId: {}, inviteInfo: {}, title: {}", new Object[]{meeting.getId(), meeting.getInviteContent(), meeting.getTitle()});
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public List<InvitedCustomerRespDto> invitedCustomerDetail(InvitedCustomerReqDto reqDto) {
        List meetingSendDetails;
        log.info("invitedCustomerDetail: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("invitedCustomerDetail: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        Integer offset = null;
        Integer limit = null;
        if (Objects.nonNull(reqDto.getPageDto())) {
            offset = (reqDto.getPageDto().getPageNum() - 1) * reqDto.getPageDto().getPageSize();
            limit = reqDto.getPageDto().getPageSize();
        }
        if (CollectionUtils.isEmpty((Collection)(meetingSendDetails = this.meetingSendDetailMapper.queryInvitedCustomer(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getMeetingId(), offset, limit)))) {
            log.info("invitedCustomerDetail: \u65e0\u6cd5\u67e5\u8be2\u5230\u5df2\u9080\u8bf7\u5ba2\u6237:{}", (Object)reqDto);
            return Collections.emptyList();
        }
        if (Objects.nonNull(reqDto.getPageDto())) {
            int count = this.meetingSendDetailMapper.getInvitedCustomerCount(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getMeetingId());
            reqDto.getPageDto().setCount(Integer.valueOf(count));
            reqDto.getPageDto().setCurPageCount(Integer.valueOf(meetingSendDetails.size()));
        }
        Set<String> contactIds = meetingSendDetails.stream().map(MeetingSendDetail::getContactId).filter(Objects::nonNull).collect(Collectors.toSet());
        List contactList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(contactIds)) {
            contactList = this.weworkContactMapper.queryWeworkContactList(userInfo.getCorpId(), contactIds);
        }
        Map<String, WeworkContact> weworkContactMap = contactList.stream().collect(Collectors.toMap(WeworkContact::getContactId, a -> a, (k, v) -> v));
        Set<String> userNums = meetingSendDetails.stream().map(MeetingSendDetail::getWeworkUserNum).filter(Objects::nonNull).collect(Collectors.toSet());
        List weworkUsers = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(userNums)) {
            weworkUsers = this.weworkUserMapper.queryWeworkUsersByNums(userInfo.getCorpId(), userNums);
        }
        Map<String, WeworkUser> weworkUserMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, a -> a, (k, v) -> v));
        Map<String, String> weworkUserNum2IdMap = this.getWeworkUserNum2IdMap(userNums);
        Map<String, WeworkContactRelation> weworkContactRelationMap = this.getWeworkContactRelation(userInfo.getCorpId(), contactIds, weworkUserNum2IdMap);
        ArrayList respDtos = Lists.newArrayList();
        for (MeetingSendDetail detail : meetingSendDetails) {
            WeworkContact weworkContact = weworkContactMap.get(detail.getContactId());
            WeworkUser weworkUser = weworkUserMap.get(detail.getWeworkUserNum());
            if (!Objects.nonNull(weworkContact) || !Objects.nonNull(weworkUser)) continue;
            InvitedCustomerRespDto respDto = InvitedCustomerRespDto.build(detail, weworkContact, weworkUser, weworkUserNum2IdMap, weworkContactRelationMap);
            respDtos.add(respDto);
        }
        return respDtos;
    }

    @Override
    public JoinMeetingDetailByMemberRespDto joinMeetingDetailByMember(JoinMeetingDetailByMemberReqDto reqDto) {
        log.info("joinMeetingDetailByMember: reqDto:{}", (Object)reqDto);
        CurrentUserInfo userInfo = this.baseValidate();
        log.info("joinMeetingDetailByMember: bizId:{}, corpId:{}, id:{}", new Object[]{userInfo.getBizId(), userInfo.getCorpId(), userInfo.getId()});
        reqDto.validate();
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), reqDto.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.info("joinMeetingDetailByMember: \u67e5\u4e0d\u5230\u8be5\u4f1a\u8bae, meetingId:{}", (Object)reqDto.getMeetingId());
            return null;
        }
        QueryJoinMeetingParam param = reqDto.convertToParam(userInfo.getBizId(), userInfo.getCorpId());
        Integer predictNum = null;
        Integer realNum = null;
        Integer unJoinNum = null;
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            param.setType(Integer.valueOf(MeetingCountType.PREDICT_REMIND_NUM.getValue()));
            predictNum = this.meetingSendDetailMapper.getRemindNumByType(param);
            param.setType(Integer.valueOf(MeetingCountType.REAL_REMIND_NUM.getValue()));
            realNum = this.meetingSendDetailMapper.getRemindNumByType(param);
            param.setType(Integer.valueOf(MeetingCountType.UNJOIN_MEETING.getValue()));
            unJoinNum = this.meetingSendDetailMapper.getRemindNumByType(param);
        } else if (MeetingType.INTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            QyRemind remind = this.remindMapper.getRemind(meeting.getId());
            if (Objects.isNull(remind)) {
                log.info("joinMeetingDetail remind is null");
                return null;
            }
            param.setRemindId(remind.getId());
            param.setIsSend(null);
            predictNum = this.remindDetailMapper.getRemindMemberCount(param);
            param.setIsSend(Integer.valueOf(1));
            realNum = this.remindDetailMapper.getRemindMemberCount(param);
            unJoinNum = this.remindDetailMapper.getUnJoinMemberCount(param);
        }
        ArrayList meetingIds = Lists.newArrayList();
        meetingIds.add(reqDto.getMeetingId());
        Map joinNumMap = this.meetingJoinQuitLogMapper.queryMeetingAndJoinCount((Collection)meetingIds, reqDto.getWeworkUserNum(), userInfo.getBizId());
        Integer joinNum = (Integer)joinNumMap.get(reqDto.getMeetingId());
        JoinMeetingDetailByMemberRespDto respDto = new JoinMeetingDetailByMemberRespDto();
        respDto.setPredictRemindNum(predictNum);
        respDto.setRealRemindNum(realNum);
        respDto.setJoinMeetingNum(joinNum);
        respDto.setUnJoinMeetingNum(unJoinNum);
        return respDto;
    }

    @Override
    public PlaybackUrlRespDto getPlaybackUrl(PlaybackUrlReqDto reqDto) {
        String token;
        CurrentUserInfo currentUserInfo = this.baseValidate();
        log.info("getPlaybackUrl,params:{}, corpId:{}, operatorId:{}", new Object[]{reqDto, currentUserInfo.getCorpId(), currentUserInfo.getId()});
        reqDto.validateParams();
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)reqDto.getId());
        if (MeetingStatus.MEETING.getValue() != meeting.getStatus().intValue() && MeetingStatus.FINISHED.getValue() != meeting.getStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53ea\u6709\u5904\u4e8e\u8fdb\u884c\u4e2d\u6216\u5df2\u7ed3\u675f\u72b6\u6001\u7684\u4f1a\u8bae\u624d\u80fd\u590d\u5236\u56de\u653e\u5730\u5740");
        }
        PlaybackUrlRespDto playbackUrlRespDto = null;
        if (StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
            playbackUrlRespDto = new PlaybackUrlRespDto();
            playbackUrlRespDto.setPlaybackUrl(meeting.getPlaybackUrl());
            if (meeting.getLiveDeliverySwitch() == 1 && StringUtils.isNotBlank((CharSequence)meeting.getPlaybackUrl())) {
                playbackUrlRespDto.setPlaybackUrl(this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), null, true, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode()));
            }
            return playbackUrlRespDto;
        }
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSettingByCorpId(currentUserInfo.getCorpId());
        this.checkMeetingSetting(meetingSetting);
        GetRoomPlaybackTokenRequest getRoomPlaybackTokenRequest = new GetRoomPlaybackTokenRequest();
        getRoomPlaybackTokenRequest.setPartnerId(meetingSetting.getBjyId());
        getRoomPlaybackTokenRequest.setPartnerKey(meetingSetting.getBjyKey());
        getRoomPlaybackTokenRequest.setPrivateDomain(meetingSetting.getDominSite());
        getRoomPlaybackTokenRequest.setRoomId(meeting.getRoomId());
        getRoomPlaybackTokenRequest.setExpiresIn(NumberUtils.INTEGER_ZERO);
        try {
            GetRoomPlaybackTokenResponse getRoomPlaybackTokenResponse = this.baijiacloudApiService.getRoomPlaybackToken(getRoomPlaybackTokenRequest);
            token = getRoomPlaybackTokenResponse.getToken();
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u56de\u653e\u5730\u5740\u53d1\u751f\u5f02\u5e38:", (Throwable)ex);
            return null;
        }
        if (StringUtils.isBlank((CharSequence)token)) {
            return null;
        }
        String privateDomain = meetingSetting.getDominSite();
        if (!privateDomain.endsWith("/")) {
            privateDomain = privateDomain + "/";
        }
        String playbackUrl = privateDomain + this.webPlaybackUrl + "?classid=" + meeting.getRoomId() + "&token=" + token;
        playbackUrlRespDto = new PlaybackUrlRespDto();
        playbackUrlRespDto.setPlaybackUrl(playbackUrl);
        if (meeting.getLiveDeliverySwitch().equals(NumberUtils.INTEGER_ONE)) {
            meeting.setPlaybackUrl(playbackUrl);
            this.meetingCacheService.setMeetingCache(meeting);
        }
        this.meetingMapper.updatePlaybackUrlByMeetingId(playbackUrl, meeting.getId());
        if (meeting.getLiveDeliverySwitch() == 1 && StringUtils.isNotBlank((CharSequence)playbackUrl)) {
            playbackUrlRespDto.setPlaybackUrl(this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), null, true, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode()));
        }
        return playbackUrlRespDto;
    }

    private CurrentUserInfo baseValidate() {
        CurrentUserInfo currentUserInfo = LoginUtils.getCurrentUser();
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo), (Object)"\u5f53\u524d\u64cd\u4f5c\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)Objects.nonNull(currentUserInfo.getBizId()), (Object)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u6240\u5c5e\u5546\u6237\u4fe1\u606f\u4e0d\u80fd\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)currentUserInfo.getCorpId()), (Object)"\u5f53\u524d\u7528\u6237\u6240\u5c5e\u4f01\u4e1aid\u4e0d\u80fd\u4e3a\u7a7a");
        return currentUserInfo;
    }

    private MultiSearchContactReq buildMultiSearchContactReq(MeetingAddOrModReqDto reqDto, CurrentUserInfo currentUserInfo) {
        MultiSearchContactReq multiSearchContactReq = reqDto.getSelectParams();
        multiSearchContactReq.setWeworkUserNums(reqDto.getWeworkUserNums());
        multiSearchContactReq.setNodeIds(reqDto.getNodeIds());
        multiSearchContactReq.setCorpId(currentUserInfo.getCorpId());
        multiSearchContactReq.setBizId(currentUserInfo.getBizId());
        multiSearchContactReq.setRequestId(null);
        multiSearchContactReq.setQuery(null);
        multiSearchContactReq.setPageDto(null);
        multiSearchContactReq.setOperatorId(currentUserInfo.getId());
        return multiSearchContactReq;
    }

    private MultiSearchContactReq buildMultiSearchContactReq(List<String> weworkUserNums, List<Long> nodeIds, CurrentUserInfo currentUserInfo) {
        MultiSearchContactReq multiSearchContactReq = new MultiSearchContactReq();
        multiSearchContactReq.setSex(Integer.valueOf(3));
        multiSearchContactReq.setWeworkUserNums(weworkUserNums);
        multiSearchContactReq.setNodeIds(nodeIds);
        multiSearchContactReq.setCorpId(currentUserInfo.getCorpId());
        multiSearchContactReq.setBizId(currentUserInfo.getBizId());
        multiSearchContactReq.setRequestId(null);
        multiSearchContactReq.setQuery(null);
        multiSearchContactReq.setPageDto(null);
        multiSearchContactReq.setOperatorId(currentUserInfo.getId());
        return multiSearchContactReq;
    }

    private void checkMeetingSetting(MeetingSetting meetingSetting) {
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u672a\u8bbe\u7f6e\u767e\u5bb6\u4e91\u4f1a\u8bae\u914d\u7f6e\u4fe1\u606f");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getDominSite()), (Object)"\u4e13\u5c5e\u57df\u540d\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyId()), (Object)"\u5f00\u53d1\u8005Partner_ID\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)meetingSetting.getBjyKey()), (Object)"\u5f00\u53d1\u8005Partner_Key\u4e3a\u7a7a");
    }

    private AddOrEditLiveRequestDto buildAddOrEditLiveRequestDto(MeetingAddOrModReqDto reqDto, MeetingSetting meetingSetting) {
        AddOrEditLiveRequestDto addOrEditLiveRequestDto = new AddOrEditLiveRequestDto();
        addOrEditLiveRequestDto.setName(reqDto.getTitle());
        addOrEditLiveRequestDto.setPrivateDomain(meetingSetting.getDominSite());
        addOrEditLiveRequestDto.setPartnerId(meetingSetting.getBjyId());
        addOrEditLiveRequestDto.setPartnerKey(meetingSetting.getBjyKey());
        addOrEditLiveRequestDto.setStartTime(reqDto.getStartTime().getTime());
        addOrEditLiveRequestDto.setEndTime(reqDto.getEndTime().getTime());
        addOrEditLiveRequestDto.setType(2);
        addOrEditLiveRequestDto.setIsPushLive(reqDto.getIsPushLive());
        String templateName = "triple";
        if (reqDto.getTemplateType() != null) {
            templateName = reqDto.getTemplateType() == 1 ? "video" : "triple";
        }
        addOrEditLiveRequestDto.setTemplateName(templateName);
        addOrEditLiveRequestDto.setCapacity(NumberUtils.INTEGER_ZERO);
        if (reqDto.getIsPrivate() == 1) {
            addOrEditLiveRequestDto.setIsPrivate(6);
        } else if (reqDto.getIsPrivate() == 2) {
            addOrEditLiveRequestDto.setIsPrivate(3);
        } else {
            addOrEditLiveRequestDto.setIsPrivate(0);
        }
        if (Objects.isNull(reqDto.getLiveDeliveryTemplate())) {
            addOrEditLiveRequestDto.setLiveSellTemplate(0);
        } else {
            addOrEditLiveRequestDto.setLiveSellTemplate(reqDto.getLiveDeliveryTemplate());
        }
        return addOrEditLiveRequestDto;
    }

    private Meeting buildMeeting(MeetingAddOrModReqDto reqDto, CurrentUserInfo currentUserInfo, BaijiacloudCreateRoomResponse roomResponse, String fullMeetingUrl, String meetingNum, String originMeetingUrl) {
        Meeting meeting = new Meeting();
        meeting.setTitle(reqDto.getTitle());
        meeting.setType(reqDto.getType());
        meeting.setStartTime(reqDto.getStartTime());
        meeting.setEndTime(reqDto.getEndTime());
        if (Objects.isNull(reqDto.getEnableInviteCustomer())) {
            meeting.setEnableInviteCustomer(NumberUtils.INTEGER_ZERO);
        } else {
            meeting.setEnableInviteCustomer(reqDto.getEnableInviteCustomer());
        }
        meeting.setInviteContent(JsonUtil.toStr(reqDto.getContentList()));
        meeting.setReportType(reqDto.getReportType());
        meeting.setParams(JsonUtil.toStr((Object)reqDto));
        meeting.setBizId(currentUserInfo.getBizId());
        meeting.setCorpId(currentUserInfo.getCorpId());
        meeting.setCreateBy(currentUserInfo.getId());
        meeting.setCreateTime(new Date());
        meeting.setUpdateBy(currentUserInfo.getId());
        meeting.setUpdateTime(new Date());
        meeting.setIsDeleted(NumberUtils.INTEGER_ZERO);
        meeting.setStatus(NumberUtils.INTEGER_ZERO);
        meeting.setRoomId(roomResponse.getRoomId());
        meeting.setStudentCode(roomResponse.getStudentCode());
        meeting.setTeacherCode(roomResponse.getTeacherCode());
        meeting.setAdminCode(roomResponse.getAdminCode());
        meeting.setReportIsSend(NumberUtils.INTEGER_ZERO);
        meeting.setNum(meetingNum);
        meeting.setIsPushLive(reqDto.getIsPushLive());
        meeting.setTemplateType(reqDto.getTemplateType());
        meeting.setMeetingUrl(fullMeetingUrl);
        meeting.setOriginMeetingUrl(originMeetingUrl);
        meeting.setInviteInfoType(reqDto.getInviteInfoType());
        String meetingInfo = ((UniformMsgDto)reqDto.getContentList().stream().filter(uniformMsgDto -> uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())).collect(Collectors.toList()).get(0)).getContent();
        String resultStr = meetingInfo.replace("${nickname}", "{\u6210\u5458\u6635\u79f0}");
        resultStr = resultStr.replace("${meetingUrl}", fullMeetingUrl);
        String finalResultStr = resultStr = resultStr.replace("${roomId}", roomResponse.getStudentCode());
        reqDto.getContentList().forEach(uniformMsgDto -> {
            if (uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())) {
                uniformMsgDto.setContent(finalResultStr);
            }
        });
        meeting.setMeetingInfo(resultStr);
        meeting.setRemindContent(reqDto.getRemind());
        if (meeting.getStartTime() != null && meeting.getEndTime() != null) {
            long end = meeting.getEndTime().getTime();
            long start = meeting.getStartTime().getTime();
            int duration = (int)((end - start) / 1000L);
            meeting.setDuration(Integer.valueOf(duration));
        } else {
            meeting.setDuration(Integer.valueOf(0));
        }
        meeting.setLiveDeliverySwitch(reqDto.getLiveDeliverySwitch());
        meeting.setLiveDeliveryTemplate(reqDto.getLiveDeliveryTemplate());
        meeting.setIsPrivate(reqDto.getIsPrivate());
        meeting.setKeywordNotifySwitch(reqDto.getKeywordsNotifySwitch());
        meeting.setKeywordNotifyTemplate(reqDto.getKeywordsNotifyTemplete());
        meeting.setDeadlineGpTaskSwitch(reqDto.getGroupSendDeadlineOn());
        meeting.setDeadlineVoisSwitch(reqDto.getVoiceNoticeDeadlineOn());
        if (Objects.nonNull(reqDto.getOrderSmsTemplate())) {
            meeting.setOrderSmsSign(reqDto.getOrderSmsTemplate().getSignatureId());
            meeting.setOrderSmsTemplate(reqDto.getOrderSmsTemplate().getContent());
        }
        if (NumberUtils.INTEGER_ONE.equals(reqDto.getLiveDeliverySwitch())) {
            Integer authMode = this.settingService.getIntegerOrDefault(meeting.getBizId(), SystemParamName.MEETING_LIVE_DELIVERY_AUTH_MODE.getKey(), MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue());
            meeting.setLiveDeliveryAuthMode(authMode);
        }
        return meeting;
    }

    private AddOrModReq buildAddOrModReq(MeetingAddOrModReqDto params, Long meetingId, MultiSearchContactReq multiSearchContactReq) {
        AddOrModReq addOrModReq = new AddOrModReq();
        addOrModReq.setRemind(null);
        addOrModReq.setContentList(params.getContentList());
        addOrModReq.setDeadlineTime(params.getEndTime());
        addOrModReq.setFkType(NumberUtils.INTEGER_ONE);
        addOrModReq.setFkTaskId(meetingId);
        addOrModReq.setGroupsendContact(multiSearchContactReq);
        addOrModReq.setQueryType(NumberUtils.INTEGER_ONE);
        addOrModReq.setTaskName(params.getTitle());
        addOrModReq.setSendType(NumberUtils.INTEGER_ZERO);
        addOrModReq.setSendTime(DateUtils.addMinutes((Date)new Date(), (int)1));
        addOrModReq.setSource(Integer.valueOf(GroupSendSource.MEETING_SERVICE.getType()));
        addOrModReq.setRemind(params.getRemind());
        addOrModReq.setRemindType(params.getRemindType());
        addOrModReq.setRemindDates(params.getRemindDates());
        addOrModReq.setTaskType(Integer.valueOf(GroupSendTaskType.SIDEBAR.getValue()));
        return addOrModReq;
    }

    private AddOrModReq buildMeetingCommerceGroupParam(MeetingAddOrModReqDto param, Long meetingId, MultiSearchContactReq multiSearchContactReq) {
        MeetingGroupSendReq meetingGroupSendReq = param.getMeetingGroupSendReq();
        AddOrModReq addOrModReq = new AddOrModReq();
        addOrModReq.setContentList(meetingGroupSendReq.getContentList());
        addOrModReq.setDeadlineTime(meetingGroupSendReq.getDeadlineTime());
        addOrModReq.setFkType(Integer.valueOf(GroupSendFkType.UN_ARRIVE_MEETING.getType()));
        addOrModReq.setFkTaskId(meetingId);
        addOrModReq.setGroupsendContact(multiSearchContactReq);
        addOrModReq.setQueryType(NumberUtils.INTEGER_ONE);
        addOrModReq.setTaskName(param.getTitle() + "\uff08\u672a\u5230\u5ba2\u7fa4\u53d1\uff09");
        addOrModReq.setSendType(NumberUtils.INTEGER_ZERO);
        addOrModReq.setSendTime(meetingGroupSendReq.getSendTime());
        addOrModReq.setSource(Integer.valueOf(GroupSendSource.MEETING_SERVICE.getType()));
        addOrModReq.setRemind(meetingGroupSendReq.getRemind());
        addOrModReq.setRemindType(NumberUtils.INTEGER_ONE);
        addOrModReq.setRemindDates(meetingGroupSendReq.getRemindDates());
        addOrModReq.setTaskType(Integer.valueOf(GroupSendTaskType.SIDEBAR.getValue()));
        addOrModReq.setNotUpdateTaskStatus(Boolean.valueOf(true));
        addOrModReq.setEnableInviteCustomer(param.getEnableInviteCustomer());
        return addOrModReq;
    }

    private AddRemindReqDto buildAddRemindReqDto(MeetingAddOrModReqDto params, Long userId, Long bizId, String corpId, Long meetingId, MultiSearchContactResp multiSearchContactResp, String fullMeetingUrl) {
        AddRemindReqDto addRemindReqDto = new AddRemindReqDto();
        addRemindReqDto.setOperatorId(userId);
        addRemindReqDto.setBizId(bizId);
        addRemindReqDto.setCorpId(corpId);
        addRemindReqDto.setBizType(NumberUtils.INTEGER_ONE);
        addRemindReqDto.setRemindType(params.getRemindType());
        String remind = params.getRemind();
        if (MeetingType.INTERNAL_MEETING.getValue() == params.getType().intValue()) {
            remind = remind + "##" + fullMeetingUrl;
        }
        addRemindReqDto.setContent(remind);
        addRemindReqDto.setFkId(meetingId);
        addRemindReqDto.setFkCreateBy(userId);
        addRemindReqDto.setMeetingType(params.getType());
        ArrayList remindDetailReqDtos = Lists.newArrayList();
        addRemindReqDto.setRemindDetailReqDtos((List)remindDetailReqDtos);
        List<Date> remindDates = params.getRemindDates();
        Map<Object, Object> weworkUserNum2ContactNameMap = Maps.newHashMap();
        if (NumberUtils.INTEGER_ONE.equals(params.getType()) && NumberUtils.INTEGER_ONE.equals(params.getEnableInviteCustomer())) {
            weworkUserNum2ContactNameMap = multiSearchContactResp.getList().stream().collect(Collectors.groupingBy(SelectedContact2WeworkUserDto::getWeworkNum));
        }
        for (Date date : remindDates) {
            List weworkUserNums = params.getShareMemberList().stream().map(ShareMemberDto::getWeworkUserNum).collect(Collectors.toList());
            for (String weworkUserNum : weworkUserNums) {
                String contactId = null;
                if (NumberUtils.INTEGER_ONE.equals(params.getType()) && NumberUtils.INTEGER_ONE.equals(params.getEnableInviteCustomer()) && org.apache.commons.collections.MapUtils.isNotEmpty((Map)weworkUserNum2ContactNameMap) && weworkUserNum2ContactNameMap.containsKey(weworkUserNum)) {
                    contactId = ((SelectedContact2WeworkUserDto)((List)weworkUserNum2ContactNameMap.get(weworkUserNum)).get(0)).getContactId();
                }
                RemindDetailReqDto remindDetailReqDto = new RemindDetailReqDto(weworkUserNum, date, contactId, NumberUtils.INTEGER_ONE);
                remindDetailReqDtos.add(remindDetailReqDto);
            }
        }
        return addRemindReqDto;
    }

    private String getMeetingUrl(String privateDomain, String studentCode) {
        if (!privateDomain.endsWith("/")) {
            privateDomain = privateDomain + "/";
        }
        return privateDomain + this.quickEnterUrl + "?code=" + studentCode + "${customstr}";
    }

    private String getPrivateMeeingUrl(String privateDomain, String roomId) {
        if (!privateDomain.endsWith("/")) {
            privateDomain = privateDomain + "/";
        }
        return privateDomain + this.privateEnterUrl + "?room_id=" + roomId + "${customstr}";
    }

    private BuildMeetingUrlResDto buildMeetingUrl(MeetingAddOrModReqDto reqDto, MeetingSetting meetingSetting, BaijiacloudCreateRoomResponse roomResponse, Long bizId, String meetingNum) {
        BuildMeetingUrlResDto res = new BuildMeetingUrlResDto();
        String fullMeetingUrl = "";
        if (reqDto.getIsPrivate() == 0) {
            fullMeetingUrl = this.getMeetingUrl(meetingSetting.getDominSite(), roomResponse.getStudentCode());
        } else if (reqDto.getIsPrivate() == 1) {
            fullMeetingUrl = this.getPrivateMeeingUrl(meetingSetting.getDominSite(), roomResponse.getRoomId());
        } else if (reqDto.getIsPrivate() == 2) {
            List<String> studentUserIds = reqDto.getStudentUserIds();
            BaijiacloudBaseReqDto baseReqDto = new BaijiacloudBaseReqDto();
            baseReqDto.setPartnerId(meetingSetting.getBjyId());
            baseReqDto.setPartnerKey(meetingSetting.getBjyKey());
            baseReqDto.setPrivateDomain(meetingSetting.getDominSite());
            if (CollectionUtils.isEmpty(studentUserIds)) {
                List studentInfoList = this.studentInfoMapper.queryStudentList(roomResponse.getRoomId(), bizId);
                if (CollectionUtils.isNotEmpty((Collection)studentInfoList)) {
                    studentUserIds = studentInfoList.stream().map(MeetingBjyStudentInfo::getBjyUserId).collect(Collectors.toList());
                } else {
                    log.info("add meeting get studentInfoList is empty, roomId: {}", (Object)roomResponse.getRoomId());
                }
            }
            log.info("add meeting studentUserIds: {}", studentUserIds);
            if (CollectionUtils.isNotEmpty(studentUserIds)) {
                try {
                    this.baijiacloudApiService.classBindStudentBatch(baseReqDto, roomResponse.getRoomId(), studentUserIds);
                    log.info("add meeting classBindStudentBatch success");
                }
                catch (Exception ex) {
                    log.error("\u5b66\u5458\u4e0e\u4f1a\u8bae\u7ed1\u5b9a\u5f02\u5e38:", (Throwable)ex);
                    throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u5458\u4e0e\u4f1a\u8bae\u7ed1\u5b9a\u5f02\u5e38");
                }
            }
            fullMeetingUrl = this.getPrivateMeeingUrl(meetingSetting.getDominSite(), roomResponse.getRoomId());
        } else {
            fullMeetingUrl = this.getMeetingUrl(meetingSetting.getDominSite(), roomResponse.getStudentCode());
        }
        res.setOriginMeetingUrl(fullMeetingUrl);
        if (YnEnum.YES.getValue().equals(reqDto.getLiveDeliverySwitch())) {
            String originMeetingUrl = fullMeetingUrl.replace(meetingSetting.getDominSite(), this.commonDomainSiteUrl);
            res.setOriginMeetingUrl(originMeetingUrl);
            Integer authMode = this.settingService.getIntegerOrDefault(bizId, SystemParamName.MEETING_LIVE_DELIVERY_AUTH_MODE.getKey(), MeetingLiveDeliveryAuthMode.OFFICIAL_ACCOUNT.getValue());
            fullMeetingUrl = this.meetingUrlCommonService.getMeetingAuthUrl(bizId, null, meetingNum, null, false, roomResponse.getRoomId(), fullMeetingUrl, authMode);
        } else {
            fullMeetingUrl = this.getMeetingUrl(meetingSetting.getDominSite(), roomResponse.getStudentCode());
        }
        res.setFullMeetingUrl(fullMeetingUrl);
        return res;
    }

    private String createCalendar(CurrentUserInfo currentUserInfo, MeetingAddOrModReqDto reqDto, String weworkUserId) {
        AddCalendarReq addCalendarReq = new AddCalendarReq();
        QyCalendar qyCalendar = new QyCalendar();
        qyCalendar.setOrganizer(weworkUserId);
        qyCalendar.setReadonly(NumberUtils.INTEGER_ZERO);
        qyCalendar.setSetAsDefault(NumberUtils.INTEGER_ZERO);
        qyCalendar.setSummary("\u767e\u5bb6\u4e91\u65e5\u5386");
        qyCalendar.setColor("#FF3030");
        qyCalendar.setDescription(reqDto.getTitle());
        addCalendarReq.setCalendar(qyCalendar);
        try {
            CalendarAddResp calendarAddResp = this.calendarClient.addCalendar(currentUserInfo.getCorpId(), addCalendarReq);
            return calendarAddResp.getCalId();
        }
        catch (Exception ex) {
            log.info("\u53c2\u6570:{}\u521b\u5efa\u65e5\u5386\u5f02\u5e38:", (Object)addCalendarReq, (Object)ex);
            return "";
        }
    }

    private String createSchedule(String calId, MeetingAddOrModReqDto reqDto, CurrentUserInfo currentUserInfo, String weworkUserId, List<String> weworkUserIds) {
        if (StringUtils.isBlank((CharSequence)calId)) {
            log.info("calId\u4e3a\u7a7a");
            return "";
        }
        AddScheduleReq addScheduleReq = new AddScheduleReq();
        Schedule schedule = new Schedule();
        schedule.setOrganizer(weworkUserId);
        schedule.setStartTime(Integer.valueOf((int)(reqDto.getStartTime().getTime() / 1000L)));
        schedule.setEndTime(Integer.valueOf((int)(reqDto.getEndTime().getTime() / 1000L)));
        schedule.setSummary(reqDto.getTitle());
        schedule.setDescription(reqDto.getTitle());
        schedule.setCalId(calId);
        addScheduleReq.setSchedule(schedule);
        StringBuilder stringBuilder = new StringBuilder();
        Lists.partition(weworkUserIds, (int)2000).forEach(partitionIds -> {
            ArrayList attendees = Lists.newArrayList();
            for (String wid : partitionIds) {
                Attendee attendee = new Attendee();
                attendee.setUserId(wid);
                attendees.add(attendee);
            }
            schedule.setAttendees((List)attendees);
            try {
                ScheduleAddResp scheduleAddResp = this.scheduleClient.addSchedule(currentUserInfo.getCorpId(), addScheduleReq);
                stringBuilder.append(scheduleAddResp.getScheduleId()).append(',');
            }
            catch (Exception ex) {
                log.info("\u521b\u5efa\u65e5\u7a0b\u5f02\u5e38:", (Throwable)ex);
            }
        });
        String result = stringBuilder.toString();
        if (StringUtils.isNotBlank((CharSequence)result)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private void checkIsCanCancel(Meeting meeting, MeetingCancelReqDto reqDto) {
        if (Objects.isNull(meeting)) {
            log.info("\u6839\u636emeetingId:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8baeid\u4e0d\u5408\u6cd5");
        }
        if (MeetingStatus.UN_START.getValue() != meeting.getStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u5f00\u59cb\u72b6\u6001\u7684\u4f1a\u8bae\u624d\u80fd\u53d6\u6d88");
        }
    }

    private void checkIsCanMod(Meeting meeting, MeetingAddOrModReqDto reqDto) {
        if (Objects.isNull(meeting)) {
            log.info("\u6839\u636emeetingId:{}\u672a\u83b7\u53d6\u5230\u8bb0\u5f55", (Object)reqDto.getId());
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8baeid\u4e0d\u5408\u6cd5");
        }
        if (MeetingStatus.UN_START.getValue() != meeting.getStatus().intValue()) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u672a\u5f00\u59cb\u72b6\u6001\u7684\u4f1a\u8bae\u624d\u80fd\u7f16\u8f91");
        }
        if (!meeting.getTitle().equals(reqDto.getTitle())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8bae\u4e3b\u9898\u4e0d\u80fd\u4fee\u6539");
        }
        if (!meeting.getType().equals(reqDto.getType())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8bae\u7c7b\u578b\u4e0d\u80fd\u4fee\u6539");
        }
        if (!meeting.getStartTime().equals(reqDto.getStartTime())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8bae\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4fee\u6539");
        }
        if (!meeting.getEndTime().equals(reqDto.getEndTime())) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8bae\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4fee\u6539");
        }
    }

    private void handleGroupSend(MeetingAddOrModReqDto reqDto, Meeting meeting, CurrentUserInfo currentUserInfo, MultiSearchContactReq multiSearchContactReq) {
        block21: {
            Set groupSendNums;
            List relations;
            Integer newEnableInviteCustomer;
            Integer oldEnableInviteCustomer;
            block19: {
                block20: {
                    oldEnableInviteCustomer = meeting.getEnableInviteCustomer();
                    newEnableInviteCustomer = reqDto.getEnableInviteCustomer();
                    log.info("handleGroupSend,oldEnableInviteCustomer:{},newEnableInviteCustomer:{}", (Object)oldEnableInviteCustomer, (Object)newEnableInviteCustomer);
                    relations = this.meetingGroupSendRelationMapper.selectRelationsByMeetingId(meeting.getId());
                    groupSendNums = null;
                    if (CollectionUtils.isNotEmpty((Collection)relations)) {
                        groupSendNums = relations.stream().map(MeetingGroupSendRelation::getGroupSendNum).collect(Collectors.toSet());
                    }
                    log.info("handleGroupSend,groupSendNums:{}", groupSendNums);
                    if (!NumberUtils.INTEGER_ONE.equals(oldEnableInviteCustomer)) break block19;
                    if (!oldEnableInviteCustomer.equals(newEnableInviteCustomer)) break block20;
                    AddOrModReq addOrModReq = this.buildAddOrModReq(reqDto, meeting.getId(), multiSearchContactReq);
                    List taskNums = relations.stream().filter(relation -> relation.getCreateType() == 1).map(a -> a.getGroupSendNum()).collect(Collectors.toList());
                    for (String taskNum : taskNums) {
                        if (!StringUtils.isNotBlank((CharSequence)taskNum)) continue;
                        addOrModReq.setTaskNum(taskNum);
                        this.groupSendService.addOrModGroupSend(addOrModReq);
                    }
                    break block21;
                }
                if (!CollectionUtils.isNotEmpty(groupSendNums)) break block21;
                EditTaskStatusReq editTaskStatusReq = new EditTaskStatusReq();
                editTaskStatusReq.setFkTaskId(meeting.getId());
                editTaskStatusReq.setFkType(NumberUtils.INTEGER_ONE.intValue());
                editTaskStatusReq.setTaskStatus(NumberUtils.INTEGER_ZERO);
                for (String groupSendNum : groupSendNums) {
                    try {
                        editTaskStatusReq.setTaskNum(groupSendNum);
                        log.info("\u5f00\u59cb\u53d6\u6d88\u7fa4\u53d1\u4efb\u52a1,params:{}", (Object)editTaskStatusReq);
                        this.groupSendService.editTaskStatus(editTaskStatusReq);
                    }
                    catch (Exception ex) {
                        log.error("\u53d6\u6d88\u7fa4\u53d1\u4efb\u52a1\u5f02\u5e38:", (Throwable)ex);
                    }
                }
                break block21;
            }
            if (!oldEnableInviteCustomer.equals(newEnableInviteCustomer)) {
                if (CollectionUtils.isNotEmpty((Collection)relations)) {
                    List autoCreateRelations = relations.stream().filter(relation -> relation.getCreateType().equals(NumberUtils.INTEGER_ONE)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(autoCreateRelations)) {
                        for (MeetingGroupSendRelation relation2 : autoCreateRelations) {
                            EditTaskStatusReq editTaskStatusReq = new EditTaskStatusReq();
                            editTaskStatusReq.setTaskStatus(NumberUtils.INTEGER_ONE);
                            editTaskStatusReq.setTaskNum(relation2.getGroupSendNum());
                            editTaskStatusReq.setFkType(NumberUtils.INTEGER_ONE.intValue());
                            editTaskStatusReq.setFkTaskId(relation2.getMeetingId());
                            try {
                                this.groupSendService.editTaskStatus(editTaskStatusReq);
                            }
                            catch (Exception ex) {
                                log.error("\u542f\u7528\u7fa4\u53d1\u4efb\u52a1:{}\u53d1\u751f\u5f02\u5e38:", (Object)relation2.getGroupSendNum(), (Object)ex);
                            }
                        }
                    } else if (NumberUtils.INTEGER_ONE.equals(newEnableInviteCustomer)) {
                        AddOrModReq addOrModReq = this.buildAddOrModReq(reqDto, meeting.getId(), multiSearchContactReq);
                        AddOrModResp addOrModResp = this.groupSendService.addOrModGroupSend(addOrModReq);
                        log.info("\u521b\u5efa\u7fa4\u53d1\u6210\u529f,addOrModResp:{}", (Object)addOrModResp);
                        MeetingGroupSendRelation meetingGroupSendRelation = this.buildMeetingGroupRelation(addOrModResp.getTaskNum(), meeting.getId(), NumberUtils.INTEGER_ONE, currentUserInfo.getId(), currentUserInfo.getCorpId());
                        this.meetingGroupSendRelationMapper.insert((Object)meetingGroupSendRelation);
                    }
                } else if (NumberUtils.INTEGER_ONE.equals(newEnableInviteCustomer)) {
                    AddOrModReq addOrModReq = this.buildAddOrModReq(reqDto, meeting.getId(), multiSearchContactReq);
                    AddOrModResp addOrModResp = this.groupSendService.addOrModGroupSend(addOrModReq);
                    log.info("\u521b\u5efa\u7fa4\u53d1\u6210\u529f,addOrModResp:{}", (Object)addOrModResp);
                    MeetingGroupSendRelation meetingGroupSendRelation = this.buildMeetingGroupRelation(addOrModResp.getTaskNum(), meeting.getId(), NumberUtils.INTEGER_ONE, currentUserInfo.getId(), currentUserInfo.getCorpId());
                    this.meetingGroupSendRelationMapper.insert((Object)meetingGroupSendRelation);
                }
            }
            if (CollectionUtils.isNotEmpty(groupSendNums)) {
                UpdateGroupSendReq updateGroupSendReq = new UpdateGroupSendReq();
                updateGroupSendReq.setContents(reqDto.getContentList());
                updateGroupSendReq.setDeadline(reqDto.getEndTime());
                updateGroupSendReq.setFkId(meeting.getId());
                updateGroupSendReq.setFkType(NumberUtils.INTEGER_ONE);
                updateGroupSendReq.setOperatorId(currentUserInfo.getId());
                updateGroupSendReq.setSource(Integer.valueOf(GroupSendSource.MEETING_SERVICE.getType()));
                for (String groupSendNum : groupSendNums) {
                    updateGroupSendReq.setTaskNum(groupSendNum);
                    try {
                        this.groupSendTaskService.updateWithOutParam(updateGroupSendReq);
                    }
                    catch (Exception ex) {
                        log.error("\u66f4\u65b0\u7fa4\u53d1\u4efb\u52a1:{}\u7684\u5185\u5bb9\u53d1\u751f\u5f02\u5e38:", (Object)groupSendNum, (Object)ex);
                    }
                }
            }
        }
    }

    private MeetingGroupSendRelation buildMeetingGroupRelation(String groupSendNum, Long meetingId, Integer createType, Long userId, String corpId) {
        MeetingGroupSendRelation meetingGroupSendRelation = new MeetingGroupSendRelation();
        meetingGroupSendRelation.setGroupSendNum(groupSendNum);
        meetingGroupSendRelation.setMeetingId(meetingId);
        meetingGroupSendRelation.setCreateType(createType);
        meetingGroupSendRelation.setCreateBy(userId);
        meetingGroupSendRelation.setCreateTime(new Date());
        meetingGroupSendRelation.setUpdateTime(new Date());
        meetingGroupSendRelation.setIsDeleted(NumberUtils.INTEGER_ZERO);
        meetingGroupSendRelation.setCorpId(corpId);
        return meetingGroupSendRelation;
    }

    private void handleRemind(MeetingAddOrModReqDto reqDto, Long meetingId, Long userId, Long bizId, String corpId, MultiSearchContactResp multiSearchContactResp, String fullMeetingUrl) {
        DisableRemindReqDto disableRemindReqDto = new DisableRemindReqDto(meetingId, NumberUtils.INTEGER_ONE);
        this.remindService.disableRemind(disableRemindReqDto);
        AddRemindReqDto addRemindReqDto = this.buildAddRemindReqDto(reqDto, userId, bizId, corpId, meetingId, multiSearchContactResp, fullMeetingUrl);
        this.remindService.addRemind(addRemindReqDto);
    }

    private void delSchedule(String scheduleId, String corpId) {
        if (StringUtils.isNotBlank((CharSequence)scheduleId)) {
            String[] scheduleIds;
            log.info("\u5f00\u59cb\u5220\u9664\u65e5\u7a0b,params:{}", (Object)scheduleId);
            for (String scId : scheduleIds = scheduleId.split(",")) {
                DelScheduleReq delScheduleReq = new DelScheduleReq();
                delScheduleReq.setScheduleId(scId);
                try {
                    this.scheduleClient.asyncDelSchedule(corpId, delScheduleReq);
                }
                catch (Exception ex) {
                    log.error("\u5220\u9664\u65e5\u7a0b:{}\u53d1\u751f\u5f02\u5e38", (Object)scId, (Object)ex);
                }
            }
        }
    }

    private void updateMeetingInfo(MeetingAddOrModReqDto reqDto, Meeting meeting, CurrentUserInfo currentUserInfo, String fullMeetingUrl) {
        Long userId = currentUserInfo.getId();
        Long bizId = currentUserInfo.getBizId();
        String corpId = currentUserInfo.getCorpId();
        this.meetingShareMemberService.batchUpdateOrganizations(bizId, userId, meeting.getId(), reqDto.getNodeIds());
        this.meetingShareMemberService.batchUpdateMembers(bizId, corpId, userId, meeting.getId(), reqDto.getShareMemberList());
        meeting.setType(reqDto.getType());
        meeting.setStartTime(reqDto.getStartTime());
        meeting.setEndTime(reqDto.getEndTime());
        if (Objects.isNull(reqDto.getEnableInviteCustomer())) {
            meeting.setEnableInviteCustomer(NumberUtils.INTEGER_ZERO);
        } else {
            meeting.setEnableInviteCustomer(reqDto.getEnableInviteCustomer());
        }
        meeting.setInviteContent(JsonUtil.toStr(reqDto.getContentList()));
        meeting.setReportType(reqDto.getReportType());
        meeting.setParams(JsonUtil.toStr((Object)reqDto));
        meeting.setUpdateBy(userId);
        meeting.setUpdateTime(new Date());
        String meetingInfo = ((UniformMsgDto)reqDto.getContentList().stream().filter(uniformMsgDto -> uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())).collect(Collectors.toList()).get(0)).getContent();
        Map userId2NameMap = this.userMapper.selectUserIdAndNameByIds(bizId, corpId, (Collection)Lists.newArrayList((Object[])new Long[]{userId}));
        String resultStr = meetingInfo.replace("${nickname}", (CharSequence)userId2NameMap.get(userId));
        resultStr = resultStr.replace("${meetingUrl}", fullMeetingUrl);
        String finalResultStr = resultStr = resultStr.replace("${roomId}", meeting.getStudentCode());
        reqDto.getContentList().forEach(uniformMsgDto -> {
            if (uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())) {
                uniformMsgDto.setContent(finalResultStr);
            }
        });
        if (meeting.getStartTime() != null && meeting.getEndTime() != null) {
            long end = meeting.getEndTime().getTime();
            long start = meeting.getStartTime().getTime();
            int duration = (int)((end - start) / 1000L);
            meeting.setDuration(Integer.valueOf(duration));
        } else {
            meeting.setDuration(Integer.valueOf(0));
        }
        meeting.setMeetingInfo(resultStr);
        meeting.setRemindContent(reqDto.getRemind());
        meeting.setMeetingUrl(fullMeetingUrl);
        meeting.setInviteInfoType(reqDto.getInviteInfoType());
        meeting.setKeywordNotifySwitch(reqDto.getKeywordsNotifySwitch());
        meeting.setLiveDeliverySwitch(reqDto.getLiveDeliverySwitch());
        meeting.setLiveDeliveryTemplate(reqDto.getLiveDeliveryTemplate());
        meeting.setKeywordNotifyTemplate(reqDto.getKeywordsNotifyTemplete());
        meeting.setDeadlineVoisSwitch(reqDto.getVoiceNoticeDeadlineOn());
        meeting.setDeadlineGpTaskSwitch(reqDto.getGroupSendDeadlineOn());
        if (Objects.nonNull(reqDto.getOrderSmsTemplate())) {
            meeting.setOrderSmsSign(reqDto.getOrderSmsTemplate().getSignatureId());
            meeting.setOrderSmsTemplate(reqDto.getOrderSmsTemplate().getContent());
        }
        log.info("update meetingInfo:{}", (Object)JSON.toJSONString((Object)meeting));
        this.meetingMapper.updateByPrimaryKeySelective((Object)meeting);
    }

    private MeetingDetailRespDto buildMeetingDetailRespDto(CurrentUserInfo userInfo, Meeting meeting, Map<String, Integer> roomIdPrivateMap, List<MeetingBjyStudentInfo> studentInfoList) {
        Integer getPrivate;
        MeetingDetailRespDto dto = new MeetingDetailRespDto();
        dto.setTitle(meeting.getTitle());
        dto.setType(meeting.getType());
        dto.setStartTime(meeting.getStartTime());
        dto.setEndTime(meeting.getEndTime());
        dto.setRoomId(meeting.getRoomId());
        dto.setReportType(meeting.getReportType());
        dto.setEnableInviteCustomer(meeting.getEnableInviteCustomer());
        dto.setInviteInfoType(meeting.getInviteInfoType());
        dto.setIsPushType(meeting.getIsPushLive());
        dto.setTemplateType(meeting.getTemplateType());
        Integer isPrivate = 0;
        if (roomIdPrivateMap != null && (getPrivate = roomIdPrivateMap.get(meeting.getRoomId())) != null) {
            isPrivate = getPrivate;
        }
        dto.setIsPrivate(isPrivate);
        if (CollectionUtils.isNotEmpty(studentInfoList) && isPrivate == 2) {
            List<String> mobiles = studentInfoList.stream().map(MeetingBjyStudentInfo::getMobile).collect(Collectors.toList());
            dto.setStudentUserMobiles(mobiles);
        }
        MeetingAddOrModReqDto reqDto = null;
        try {
            reqDto = (MeetingAddOrModReqDto)JSONObject.parseObject((String)meeting.getParams(), MeetingAddOrModReqDto.class);
        }
        catch (Exception e) {
            log.error("buildMeetingDetailRespDto: e :{}", (Throwable)e);
        }
        if (Objects.isNull(reqDto)) {
            log.info("buildMeetingDetailRespDto: \u65e0\u6cd5\u89e3\u6790params, \u4f1a\u8baeid:{}", (Object)meeting.getId());
            return dto;
        }
        dto.setRemind(reqDto.getRemind());
        dto.setReportType(reqDto.getReportType());
        dto.setRemindType(reqDto.getRemindType());
        dto.setRemindDates(reqDto.getRemindDates());
        dto.setContentList(reqDto.getContentList());
        ArrayList meetingWeworkUserList = Lists.newArrayList();
        List shareMemberList = this.meetingShareMembersMapper.selectByMeetingId(meeting.getId());
        if (CollectionUtils.isNotEmpty((Collection)shareMemberList)) {
            Map<String, Integer> shareMemberHiddenMap = shareMemberList.stream().collect(Collectors.toMap(MeetingShareMembers::getWeworkUserNum, MeetingShareMembers::getHidden));
            List weworkUserNums = shareMemberList.stream().map(MeetingShareMembers::getWeworkUserNum).collect(Collectors.toList());
            List weworkUsers = this.weworkUserMapper.queryInfoListByNums(weworkUserNums);
            Iterator iterator = weworkUsers.iterator();
            while (iterator.hasNext()) {
                WeworkUser weworkUser = (WeworkUser)iterator.next();
                MeetingWeworkUser meetingWeworkUser = new MeetingWeworkUser();
                meetingWeworkUser.setWeworkUserNum(weworkUser.getNum());
                meetingWeworkUser.setNickname(weworkUser.getName());
                meetingWeworkUser.setAvatar(weworkUser.getAvatar());
                meetingWeworkUser.setHidden(shareMemberHiddenMap.getOrDefault(weworkUser.getNum(), 0));
                meetingWeworkUserList.add(meetingWeworkUser);
            }
        }
        dto.setWeworkUsers(meetingWeworkUserList);
        ArrayList orgList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(reqDto.getNodeIds())) {
            Map nodeMap = this.nodeService.getNodeByIds(reqDto.getNodeIds(), userInfo.getBizId());
            for (Long nodeId : reqDto.getNodeIds()) {
                Node node = (Node)nodeMap.get(nodeId);
                if (node != null) {
                    orgList.add(new IdAndNameDto(Long.valueOf(node.getId()), node.getName()));
                    continue;
                }
                log.info("buildMeetingDetailRespDto: node is null, nodeId:{}", (Object)nodeId);
            }
        }
        dto.setOrgList(orgList);
        MultiSearchContactReq multiSearchContactReq = reqDto.getSelectParams();
        if (Objects.isNull(multiSearchContactReq)) {
            log.info("buildMeetingDetailRespDto: multiSearchContactReq is null");
            return dto;
        }
        multiSearchContactReq.setRequestId("");
        dto.setSelectContactType(multiSearchContactReq.getSelectContactType());
        SelectParamRespDto selectParamRespDto = new SelectParamRespDto();
        if (MeetingType.EXTERNAL_MEETING.getValue() == reqDto.getType().intValue() && NumberUtils.INTEGER_ONE.equals(reqDto.getEnableInviteCustomer())) {
            QueryJoinMeetingParam param = QueryJoinMeetingParam.build((Long)userInfo.getBizId(), (String)userInfo.getCorpId(), (Long)meeting.getId());
            param.setType(Integer.valueOf(MeetingCountType.PREDICT_REMIND_NUM.getValue()));
            Integer count = this.meetingSendDetailMapper.getRemindNumByType(param);
            if (Objects.nonNull(count)) {
                selectParamRespDto.setCount(count);
            }
        }
        selectParamRespDto.setSex(multiSearchContactReq.getSex());
        selectParamRespDto.setAddStartTime(multiSearchContactReq.getAddStartTime());
        selectParamRespDto.setAddEndTime(multiSearchContactReq.getAddEndTime());
        selectParamRespDto.setTagCondition(multiSearchContactReq.getTagCondition());
        List roomIds = multiSearchContactReq.getRoomIds();
        List weworkChatRooms = this.weworkChatRoomMapper.batchQueryChatRooms(userInfo.getCorpId(), (Collection)roomIds);
        ArrayList roomInfos = Lists.newArrayList();
        for (WeworkChatRoom room : weworkChatRooms) {
            MeetingBaseInfo info = MeetingBaseInfo.build((Object)room.getWeworkRoomId(), (String)room.getName());
            roomInfos.add(info);
        }
        selectParamRespDto.setRoomInfos(roomInfos);
        List marketingPlanNums = multiSearchContactReq.getMarketingPlanNums();
        if (CollectionUtils.isNotEmpty((Collection)marketingPlanNums)) {
            List plans = this.marketingPlanMapper.queryByNums((Collection)marketingPlanNums);
            ArrayList planInfos = Lists.newArrayList();
            for (Object plan : plans) {
                MeetingBaseInfo info = MeetingBaseInfo.build((Object)plan.getId(), (String)plan.getName());
                planInfos.add(info);
            }
            selectParamRespDto.setMarketingPlans(planInfos);
        }
        Set stageIds = multiSearchContactReq.getStageIds();
        List stages = this.customerStageMapper.queryListById(userInfo.getBizId(), userInfo.getCorpId(), (Collection)stageIds);
        ArrayList stageInfos = Lists.newArrayList();
        for (CustomerStage stage : stages) {
            MeetingBaseInfo info = MeetingBaseInfo.build((Object)stage.getId(), (String)stage.getStageName());
            stageInfos.add(info);
        }
        selectParamRespDto.setStageInfos(stageInfos);
        List includeTags = multiSearchContactReq.getIncludeTags();
        Set tagIds = includeTags.stream().map(TagGroupPair::getTagId).collect(Collectors.toSet());
        Map tagAndNameMap = this.weworkTagMapper.queryTagIdAndName(userInfo.getCorpId(), tagIds);
        Map<String, String> inTagMap = includeTags.stream().collect(Collectors.toMap(TagGroupPair::getTagId, TagGroupPair::getGroupId, (u, v) -> v));
        ArrayList inTagInfos = Lists.newArrayList();
        for (Map.Entry entry : tagAndNameMap.entrySet()) {
            MeetingTagInfo info = MeetingTagInfo.build((String)((String)entry.getKey()), (String)((String)entry.getValue()), inTagMap);
            inTagInfos.add(info);
        }
        selectParamRespDto.setIncludeTags(inTagInfos);
        List excludeTags = multiSearchContactReq.getExcludeTags();
        Set exTagIds = excludeTags.stream().map(TagGroupPair::getTagId).collect(Collectors.toSet());
        Map exTagAndNameMap = this.weworkTagMapper.queryTagIdAndName(userInfo.getCorpId(), exTagIds);
        Map<String, String> exTagMap = excludeTags.stream().collect(Collectors.toMap(TagGroupPair::getTagId, TagGroupPair::getGroupId, (u, v) -> v));
        ArrayList exTagInfos = Lists.newArrayList();
        for (Map.Entry entry : exTagAndNameMap.entrySet()) {
            MeetingTagInfo info = MeetingTagInfo.build((String)((String)entry.getKey()), (String)((String)entry.getValue()), exTagMap);
            exTagInfos.add(info);
        }
        selectParamRespDto.setExcludeTags(exTagInfos);
        selectParamRespDto.setExcludeContactIds(multiSearchContactReq.getExcludeContactIds());
        dto.setSelectParams(selectParamRespDto);
        this.getAndSetMeetingGroupTag(dto, meeting.getNum());
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            this.getAndSetReportWeworkUser(dto, meeting.getId());
        }
        if (Objects.nonNull(meeting.getLiveDeliverySwitch())) {
            dto.setKeywordsNotifySwitch(meeting.getKeywordNotifySwitch());
            dto.setLiveDeliveryTemplate(meeting.getLiveDeliveryTemplate());
            dto.setLiveDeliverySwitch(meeting.getLiveDeliverySwitch());
            dto.setKeywordsNotifyTemplete(meeting.getKeywordNotifyTemplate());
            dto.setKeywordGroups(this.keywordService.detailByMeetingId(meeting.getId()));
            if (Objects.nonNull(meeting.getDeadlineVoisId())) {
                CallTask callTask = this.callTaskService.taskInfo(meeting.getDeadlineVoisId());
                CallTaskReqDto callTaskReqDto = CallTaskReqDto.entityToDto((CallTask)callTask);
                dto.setCallTaskReq(callTaskReqDto);
            }
            if (StringUtils.isNotBlank((CharSequence)meeting.getOrderSmsTemplate())) {
                dto.setOrderSmsTemplateSwitch(YnEnum.YES.getValue());
                String smsTemplate = meeting.getOrderSmsTemplate();
                String sign = meeting.getOrderSmsSign();
                SmsTemplateReqDto templateReqDto = new SmsTemplateReqDto();
                templateReqDto.setSignatureId(sign);
                templateReqDto.setContent(smsTemplate);
                dto.setOrderSmsTemplate(templateReqDto);
            }
            dto.setGroupSendDeadlineOn(meeting.getDeadlineGpTaskSwitch());
            dto.setKeywordsNotifySwitch(meeting.getKeywordNotifySwitch());
            dto.setVoiceNoticeDeadlineOn(meeting.getDeadlineVoisSwitch());
            dto.setOrderSmsTemplateSwitch(StringUtils.isNotBlank((CharSequence)meeting.getOrderSmsTemplate()) ? YnEnum.YES.getValue() : YnEnum.NO.getValue());
            if (StringUtils.isNotBlank((CharSequence)meeting.getDeadlineGpTaskNum())) {
                String taskNum = meeting.getDeadlineGpTaskNum();
                IdReq idReq = new IdReq();
                idReq.setTaskNum(taskNum);
                AddOrModReq addOrModReq = this.groupSendService.taskParamDetail(idReq);
                MeetingGroupSendReq meetingGroupSendReq = new MeetingGroupSendReq();
                meetingGroupSendReq.setRemind(addOrModReq.getRemind());
                meetingGroupSendReq.setSendTime(addOrModReq.getSendTime());
                meetingGroupSendReq.setContentList(addOrModReq.getContentList());
                meetingGroupSendReq.setDeadlineTime(addOrModReq.getDeadlineTime());
                meetingGroupSendReq.setRemindDates(addOrModReq.getRemindDates());
                dto.setMeetingGroupSendReq(meetingGroupSendReq);
            }
        }
        return dto;
    }

    @Override
    public List<TransferListResp> getTransferList(TransferListReq params) {
        log.info("query transfer list, params={}", (Object)params, (Object)LoginUtils.getCurrentUserId());
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        Long bizId = userInfo.getBizId();
        Preconditions.checkArgument((params != null ? 1 : 0) != 0, (Object)"params is null");
        Preconditions.checkArgument((params.getMeetingId() != null ? 1 : 0) != 0, (Object)"meetingId is null");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)params.getWeworkUserNum()), (Object)"weworkUserNum is null");
        Meeting meeting = this.meetingMapper.queryById(userInfo.getBizId(), userInfo.getCorpId(), params.getMeetingId());
        if (Objects.isNull(meeting)) {
            log.error("getTransferList: meeting is null, params:{}", (Object)params);
            return Collections.emptyList();
        }
        Long meetingId = params.getMeetingId();
        String weworkUserNum = params.getWeworkUserNum();
        String contactId = params.getContactId();
        PageDto pageDto = params.getPageDto();
        List list = Lists.newArrayList();
        int count = 0;
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            count = this.meetingJoinQuitLogMapper.countByContact(bizId, meetingId, weworkUserNum, contactId);
            if (count == 0) {
                return Collections.emptyList();
            }
            list = this.meetingJoinQuitLogMapper.queryByContact(bizId, meetingId, weworkUserNum, contactId, pageDto);
        } else if (MeetingType.INTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            count = this.meetingJoinQuitLogMapper.countInternalByContact(bizId, meetingId, weworkUserNum);
            if (count == 0) {
                return Collections.emptyList();
            }
            list = this.meetingJoinQuitLogMapper.queryInternalByContact(bizId, meetingId, weworkUserNum, pageDto);
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(count));
            pageDto.setCurPageCount(Integer.valueOf(list.size()));
        }
        ArrayList result = Lists.newArrayListWithCapacity((int)list.size());
        for (MeetingJoinQuitLog it : list) {
            TransferListResp dto = new TransferListResp();
            dto.setBjyName(it.getBjyName());
            dto.setJoinTime(it.getJoinTime());
            dto.setQuitTime(it.getQuitTime());
            dto.setDuration((Integer)(it.getDuration() != null && it.getDuration() == 0 ? null : it.getDuration()));
            result.add(dto);
        }
        return result;
    }

    @Override
    public Map<String, String> sendMeetingMaterial(SendMeetingMaterialReqDto params) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        params.validate();
        HashMap retData = Maps.newHashMap();
        String weworkUserNum = LoginUtils.getCurrentUser().getWeworkUserNum();
        MeetingSendDetail detail = this.meetingSendDetailMapper.querySendDetailByParams(params.getMeetingId(), weworkUserNum, params.getWeworkContactId(), "-1");
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(user.getWeworkUserNum());
        String weworkUserName = weworkUser.getName();
        log.info("sendMeetingMaterial weworkUserName: {}", (Object)weworkUserName);
        Date now = new Date();
        if (Objects.isNull(detail)) {
            detail = new MeetingSendDetail();
            detail.setBizId(user.getBizId());
            detail.setContactId(params.getWeworkContactId());
            detail.setCorpId(user.getCorpId());
            detail.setCreateTime(now);
            if (params.getOperateType() == NumberUtils.INTEGER_ZERO.intValue()) {
                detail.setIsSendMaterial(NumberUtils.INTEGER_ONE.intValue());
                detail.setSendMaterialTime(now);
                detail.setSendStatus(NumberUtils.INTEGER_ZERO);
            } else if (params.getOperateType() == NumberUtils.INTEGER_ONE.intValue()) {
                detail.setIsSendMaterial(NumberUtils.INTEGER_ZERO.intValue());
                detail.setSendStatus(NumberUtils.INTEGER_ONE);
                detail.setSendTime(now);
                detail.setTraceCode(this.idGen.getNum());
                String meetingInfo = this.buildAndSaveParamEncry(params.getMeetingId(), NumberUtils.INTEGER_ZERO.intValue(), params.getWeworkContactId(), detail.getTraceCode());
                retData.put("meetingInfo", meetingInfo);
            }
            detail.setJoinStatus(NumberUtils.INTEGER_ZERO);
            detail.setMeetingId(params.getMeetingId());
            detail.setSendType(params.getSendType());
            detail.setTaskNum("-1");
            detail.setUpdateTime(now);
            detail.setWeworkUserNum(user.getWeworkUserNum());
            log.info("sendMeetingMaterial.params:{}, insert record:{}", (Object)params, (Object)detail);
            this.meetingSendDetailMapper.insert((Object)detail);
        } else {
            if (params.getOperateType() == NumberUtils.INTEGER_ZERO.intValue()) {
                detail.setIsSendMaterial(NumberUtils.INTEGER_ONE.intValue());
                detail.setSendMaterialTime(now);
            } else if (params.getOperateType() == NumberUtils.INTEGER_ONE.intValue()) {
                detail.setSendStatus(NumberUtils.INTEGER_ONE);
                detail.setSendTime(now);
                if (StringUtils.isBlank((CharSequence)detail.getTraceCode())) {
                    detail.setTraceCode(this.idGen.getNum());
                    String meetingInfo = this.buildAndSaveParamEncry(params.getMeetingId(), NumberUtils.INTEGER_ZERO.intValue(), params.getWeworkContactId(), detail.getTraceCode());
                    retData.put("meetingInfo", meetingInfo);
                } else {
                    Meeting meeting = this.meetingMapper.queryById(user.getBizId(), user.getCorpId(), params.getMeetingId());
                    Preconditions.checkArgument((boolean)Objects.nonNull(meeting), (Object)"\u4f1a\u8bae\u4e0d\u5b58\u5728");
                    MeetingSetting meetingSetting = this.meetingSettingMapper.getSetting(user.getBizId());
                    Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u6ca1\u6709\u914d\u7f6e\u767e\u5bb6\u4e91\u76f4\u64ad\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u4f01\u5fae\u7ba1\u7406\u5458");
                    String mInfo = meeting.getMeetingInfo();
                    if (meeting.getMeetingInfo().contains("{\u6210\u5458\u6635\u79f0}")) {
                        mInfo = meeting.getMeetingInfo().replace("{\u6210\u5458\u6635\u79f0}", weworkUserName);
                    }
                    String meetingInfo = this.getMeetingChannelUrl(mInfo, detail.getTraceCode());
                    if (meeting.getLiveDeliverySwitch() == 1) {
                        String wechatAuthMeetingCommerceUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), weworkUser.getNum(), false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
                        meetingInfo = meetingInfo.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
                        try {
                            this.meetingCacheService.setInviteUserId(meeting.getBizId(), weworkUser.getNum(), meeting.getEndTime(), user.getId());
                        }
                        catch (Exception e) {
                            log.error("setInviteUserId error", (Throwable)e);
                        }
                    }
                    if (StringUtils.isNotBlank((CharSequence)meetingInfo)) {
                        retData.put("meetingInfo", meetingInfo);
                    }
                }
            }
            detail.setUpdateTime(now);
            this.meetingSendDetailMapper.updateByPrimaryKey((Object)detail);
        }
        return retData;
    }

    String buildAndSaveParamEncry(long meetingId, long channelId, String weworkContactId, String traceCode) {
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        ParamEncry param = new ParamEncry();
        Date now = new Date();
        Meeting meeting = this.meetingMapper.queryById(user.getBizId(), user.getCorpId(), Long.valueOf(meetingId));
        Preconditions.checkArgument((boolean)Objects.nonNull(meeting), (Object)"\u4f1a\u8bae\u4e0d\u5b58\u5728");
        MeetingSetting meetingSetting = this.meetingSettingMapper.getSetting(user.getBizId());
        Preconditions.checkArgument((boolean)Objects.nonNull(meetingSetting), (Object)"\u6ca1\u6709\u914d\u7f6e\u767e\u5bb6\u4e91\u76f4\u64ad\u53c2\u6570\uff0c\u8bf7\u8054\u7cfb\u4f01\u5fae\u7ba1\u7406\u5458");
        param.setCreateTime(now);
        param.setNum(traceCode);
        WeworkUser weworkUser = this.weworkUserMapper.queryWeworkUserByNum(user.getWeworkUserNum());
        String weworkUserName = weworkUser.getName();
        log.info("sendMeetingMaterial weworkUserName: {}", (Object)weworkUserName);
        param.setType(Integer.valueOf(NumberUtils.INTEGER_ONE));
        MeetingParams mp = new MeetingParams(meeting.getId(), "-1", user.getWeworkUserNum(), weworkContactId, Integer.valueOf(NumberUtils.INTEGER_MINUS_ONE), Long.valueOf(channelId));
        param.setParams(JacksonUtil.obj2Str((Object)mp));
        this.paramEncryMapper.insert((Object)param);
        log.info("buildParamEncryList.meeting:{}, channelId:{}, param:{}", new Object[]{meeting, channelId, param});
        String mInfo = meeting.getMeetingInfo();
        if (meeting.getMeetingInfo().contains("{\u6210\u5458\u6635\u79f0}")) {
            mInfo = meeting.getMeetingInfo().replace("{\u6210\u5458\u6635\u79f0}", weworkUserName);
        }
        String meetingInfo = this.getMeetingChannelUrl(mInfo, traceCode);
        if (meeting.getLiveDeliverySwitch() == 1) {
            String wechatAuthMeetingCommerceUrl = this.meetingUrlCommonService.getMeetingAuthUrl(meeting.getBizId(), null, meeting.getNum(), weworkUser.getNum(), false, meeting.getRoomId(), meeting.getMeetingUrl(), meeting.getLiveDeliveryAuthMode());
            meetingInfo = meetingInfo.replace(meeting.getMeetingUrl(), wechatAuthMeetingCommerceUrl);
            try {
                this.meetingCacheService.setInviteUserId(meeting.getBizId(), weworkUser.getNum(), meeting.getEndTime(), user.getId());
            }
            catch (Exception e) {
                log.error("meetingCacheService,setInviteUserId error", (Throwable)e);
            }
            try {
                WeworkContact weworkContact = this.weworkContactMapper.queryWeworkContact(meeting.getBizId(), meeting.getCorpId(), weworkContactId);
                if (weworkContact != null && StringUtils.isNotBlank((CharSequence)weworkContact.getUnionid())) {
                    this.meetingCacheService.setMeetingParamWhenSidebarGenInvite(meeting.getBizId(), meeting.getId(), weworkContact.getUnionid(), param, meeting.getEndTime());
                }
            }
            catch (Exception e) {
                log.error("meetingCacheService,setMeetingParamWhenSidebarGenInvite error", (Throwable)e);
            }
        }
        this.meetingCusParamEncryRelService.insertWhenInsertParamEncry(meeting.getBizId(), traceCode, meeting.getId(), weworkContactId, Long.valueOf(channelId));
        this.getAndSetMeetingTags(meeting.getNum(), weworkContactId);
        return meetingInfo;
    }

    void getAndSetMeetingTags(String meetingId, String weworkContactId) {
        String corpId;
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        long bizId = user.getBizId();
        List tags = this.meetingTagMapper.queryByMeetingIdAndType(meetingId, bizId, corpId = user.getCorpId(), NumberUtils.INTEGER_ZERO.intValue());
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            List addTags = tags.stream().map(MeetingTag::getTagId).collect(Collectors.toList());
            ModifyTagDto params = new ModifyTagDto();
            params.setBizId(Long.valueOf(bizId));
            params.setCorpId(corpId);
            params.setWeworkUserId(user.getWeworkUserId());
            params.setContactId(weworkContactId);
            params.setAddTagIds(addTags);
            log.info("getAndSetMeetingTags: \u6253\u6807\u7b7e:{}", (Object)params);
            this.contactOpService.modifyTag(params);
        }
    }

    String getMeetingChannelUrl(String meetingInfo, String encryNum) {
        if (StringUtils.isNotBlank((CharSequence)meetingInfo)) {
            if (meetingInfo.contains("&${customstr}")) {
                meetingInfo = meetingInfo.replace("${customstr}", "customstr=" + encryNum);
            } else if (meetingInfo.contains("${customstr}")) {
                meetingInfo = meetingInfo.replace("${customstr}", "&customstr=" + encryNum);
            }
        }
        return meetingInfo;
    }

    @Override
    public List<UniformMsgDto> getMaterialDetail(IdDto params) {
        List<UniformMsgDto> msgDtos;
        log.info("getMaterialDetail,params:{}", (Object)params);
        params.validateParams();
        Long meetingId = params.getId();
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)meetingId);
        if (Objects.isNull(meeting)) {
            log.warn("\u6839\u636e\u4f1a\u8baeid:{}\u672a\u67e5\u8be2\u5230\u8bb0\u5f55", (Object)meetingId);
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u4f1a\u8baeid\u4e0d\u5408\u6cd5");
        }
        if (StringUtils.isBlank((CharSequence)meeting.getInviteContent())) {
            log.info("\u4f1a\u8bae:{}\u672a\u8bbe\u7f6e\u5ba3\u4f20\u6750\u6599", (Object)meetingId);
            return Collections.emptyList();
        }
        try {
            msgDtos = JacksonUtil.str2List((String)meeting.getInviteContent(), UniformMsgDto.class);
            if (CollectionUtils.isEmpty((Collection)msgDtos)) {
                return Collections.emptyList();
            }
        }
        catch (IOException ex) {
            log.error("\u8f6c\u6362\u7d20\u6750\u5f02\u5e38:", (Throwable)ex);
            return Collections.emptyList();
        }
        msgDtos = msgDtos.stream().filter(uniformMsgDto -> !uniformMsgDto.getMsgType().equals(JsMsgType.MEETING.getValue())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(msgDtos)) {
            return msgDtos;
        }
        ArrayList reqDtos = Lists.newArrayList();
        QueryMaterialReqDto queryMaterialReqDto = new QueryMaterialReqDto();
        reqDtos.add(queryMaterialReqDto);
        queryMaterialReqDto.setFkId(meetingId);
        queryMaterialReqDto.setFkType(Integer.valueOf(2));
        List materialListRespDtos = this.materialManagerService.query(meeting.getBizId(), meeting.getCorpId(), (List)reqDtos);
        Map<Long, MaterialListRespDto> materialMap = null;
        if (CollectionUtils.isNotEmpty((Collection)materialListRespDtos)) {
            materialMap = materialListRespDtos.stream().collect(Collectors.toMap(MaterialListRespDto::getFkId, a -> a));
        }
        Map<Object, Object> url2MediaDto = Maps.newHashMap();
        if (MapUtils.isNotEmpty(materialMap)) {
            MaterialListRespDto materialListRespDto = materialMap.get(meetingId);
            url2MediaDto = materialListRespDto.getMaterialReqDtoList().stream().collect(Collectors.toMap(MaterialRespDto::getFileUrl, Function.identity()));
        }
        for (UniformMsgDto msgDto : msgDtos) {
            switch (JsMsgType.get((String)msgDto.getMsgType())) {
                case FILE: 
                case VIDEO: 
                case IMAGE: {
                    String url = msgDto.getFile().getFileUrl();
                    if (!url2MediaDto.containsKey(url)) break;
                    MaterialRespDto materialRespDto = (MaterialRespDto)url2MediaDto.get(url);
                    msgDto.setMediaId(materialRespDto.getMediaId());
                    msgDto.setExpireTime(materialRespDto.getExpireTime());
                    break;
                }
            }
        }
        return msgDtos;
    }

    private void addSaveMaterial(MeetingAddOrModReqDto reqDto, Meeting meeting) {
        if (CollectionUtils.isEmpty(reqDto.getContentList())) {
            return;
        }
        List materialReqDtos = reqDto.getContentList().stream().filter(a -> a.getFile() != null && StringUtils.isNotBlank((CharSequence)a.getFile().getFileUrl())).map(a -> {
            MaterialReqDto materialReqDto = new MaterialReqDto();
            materialReqDto.setType(a.getMsgType());
            materialReqDto.setFileUrl(a.getFile().getFileUrl());
            materialReqDto.setFileName(a.getFile().getFileName());
            return materialReqDto;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(materialReqDtos)) {
            AddMaterialReqDto addMaterialReqDto = new AddMaterialReqDto();
            addMaterialReqDto.setFkId(meeting.getId());
            addMaterialReqDto.setFkType(Integer.valueOf(2));
            addMaterialReqDto.setStartTime(new Date());
            addMaterialReqDto.setEndTime(meeting.getEndTime());
            addMaterialReqDto.setMaterialReqDtoList(materialReqDtos);
            this.materialManagerService.add(addMaterialReqDto);
        }
    }

    private void batchInsertMeetingReportMembers(List<String> weworkUserNums, Meeting meeting, CurrentUserInfo currentUserInfo) {
        if (CollectionUtils.isEmpty(weworkUserNums)) {
            return;
        }
        ArrayList meetingReportMembers = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            MeetingReportMembers meetingReportMember = new MeetingReportMembers();
            meetingReportMember.setBizId(currentUserInfo.getBizId());
            meetingReportMember.setCorpId(currentUserInfo.getCorpId());
            meetingReportMember.setCreateBy(currentUserInfo.getId());
            meetingReportMember.setUpdateBy(currentUserInfo.getId());
            meetingReportMember.setCreateTime(new Date());
            meetingReportMember.setUpdateTime(new Date());
            meetingReportMember.setWeworkUserNum(weworkUserNum);
            meetingReportMember.setMeetingId(meeting.getId());
            meetingReportMember.setIsDeleted(NumberUtils.INTEGER_ZERO);
            meetingReportMembers.add(meetingReportMember);
        }
        if (CollectionUtils.isNotEmpty((Collection)meetingReportMembers)) {
            this.meetingReportMembersMapper.batchInsert((Collection)meetingReportMembers);
        }
    }

    private void modMeetingReportMembers(List<String> weworkUserNums, Meeting meeting, CurrentUserInfo currentUserInfo) {
        if (MeetingType.EXTERNAL_MEETING.getValue() == meeting.getType().intValue()) {
            this.meetingReportMembersMapper.delByMeetingId(meeting.getId(), currentUserInfo.getId());
        }
        if (CollectionUtils.isNotEmpty(weworkUserNums)) {
            this.batchInsertMeetingReportMembers(weworkUserNums, meeting, currentUserInfo);
        }
    }

    private void getAndSetReportWeworkUser(MeetingDetailRespDto dto, Long meetingId) {
        List weworkUserNums = this.meetingReportMembersMapper.selectWeworkUserNumsByMeetingId(meetingId);
        if (CollectionUtils.isEmpty((Collection)weworkUserNums)) {
            return;
        }
        List weworkUsers = this.weworkUserMapper.queryInfoListByNums((Collection)weworkUserNums);
        Map<String, String> weworkUserNum2NameMap = weworkUsers.stream().collect(Collectors.toMap(WeworkUser::getNum, WeworkUser::getName));
        dto.setReportWeworkUserNums(weworkUserNums);
        if (org.apache.commons.collections.MapUtils.isEmpty(weworkUserNum2NameMap)) {
            return;
        }
        ArrayList weworkUserDtos = Lists.newArrayList();
        for (String weworkUserNum : weworkUserNums) {
            WeworkUserDto weworkUserDto = new WeworkUserDto();
            weworkUserDto.setWeworkNum(weworkUserNum);
            weworkUserDto.setWeworkName(weworkUserNum2NameMap.get(weworkUserNum));
            weworkUserDtos.add(weworkUserDto);
        }
        dto.setReportWeworkUserDtos(weworkUserDtos);
    }

    @Override
    public List<MeetingChatListResponseDto> getChatListForMeeting(MeetingChatListRequestDto params) {
        log.info("getChatListForMeeting.params:{}", (Object)params);
        CurrentUserInfo user = LoginUtils.getCurrentUser();
        Meeting meeting = this.meetingMapper.queryById(user.getBizId(), user.getCorpId(), Long.valueOf(params.getMeetingId()));
        Preconditions.checkArgument((meeting != null ? 1 : 0) != 0, (Object)"\u65e0\u6743\u67e5\u770b");
        int count = this.meetingRoomChatDetailMapper.queryMeetingChatListCount(user.getBizId().longValue(), params.getMeetingId(), null);
        log.info("getChatListForMeeting queryMeetingChatListCount: {}", (Object)count);
        ArrayList data = Lists.newArrayList();
        if (count > 0) {
            List result = this.meetingRoomChatDetailMapper.queryMeetingChatList(user.getBizId().longValue(), params.getMeetingId(), null, params.getPageDto().getOffset(), params.getPageDto().getPageSize().intValue());
            log.info("getChatListForMeeting get result: {}", (Object)result);
            params.getPageDto().setCount(Integer.valueOf(count));
            params.getPageDto().setCurPageCount(Integer.valueOf(result.size()));
            Set<String> contactIds = result.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getContactId()) && !"-1".equals(p.getContactId())).map(MeetingRoomChatDetail::getContactId).collect(Collectors.toSet());
            log.info("getChatListForMeeting get contactIds: {}", contactIds);
            Map<String, WeworkContact> contactMap = null;
            Map<String, WeworkUser> userMap = null;
            if (CollectionUtils.isNotEmpty(contactIds)) {
                contactMap = this.getContactMap(user.getCorpId(), contactIds);
                log.info("getChatListForMeeting get contactIdMap: {}", contactMap);
            } else {
                Set<String> weworkUserNum = result.stream().filter(r -> StringUtils.isNotBlank((CharSequence)r.getWeworkUserNum())).map(MeetingRoomChatDetail::getWeworkUserNum).collect(Collectors.toSet());
                log.info("getChatListForMeeting By RoomId And BjyNumber get weworkUserNum: {}", weworkUserNum);
                if (CollectionUtils.isNotEmpty(weworkUserNum)) {
                    userMap = this.getWeworkUserMapByNums(weworkUserNum, user.getCorpId());
                }
            }
            for (MeetingRoomChatDetail source : result) {
                MeetingChatListResponseDto target = MeetingChatListResponseDto.convertPOToDto(source, contactMap, userMap);
                data.add(target);
            }
        }
        return data;
    }

    Map<String, WeworkContact> getContactMap(String corpId, Collection<String> contactIds) {
        List contacts = this.weworkContactMapper.selectByCorpIdAndContactIds(corpId, contactIds);
        Map<Object, Object> map = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)contacts)) {
            map = contacts.stream().collect(Collectors.toMap(WeworkContact::getContactId, p -> p));
        }
        return map;
    }

    @Override
    public void syncMeetingRoomChatDetail(Meeting meeting, MeetingSetting setting) {
        Long meetingId = meeting.getId();
        String roomId = meeting.getRoomId();
        Long bizId = meeting.getBizId();
        log.info("syncMeetingRoomChatDetail meetingId:{}, roomId:{}", (Object)meetingId, (Object)roomId);
        Integer isLongTerm = 0;
        MeetingBjy meetingBjy = this.meetingBjyMapper.getBjyMeeting(roomId, setting.getBizId(), setting.getCorpId());
        if (Objects.nonNull(meetingBjy)) {
            isLongTerm = meetingBjy.getIsLongTerm();
            log.info("syncMeetingRoomChatDetail get isLongTerm: {}", (Object)isLongTerm);
        }
        ExportChatMsgRequestDto params = new ExportChatMsgRequestDto();
        params.setRoomId(roomId);
        params.setPartnerId(setting.getBjyId());
        params.setPartnerKey(setting.getBjyKey());
        params.setPrivateDomain(setting.getDominSite());
        params.setDate("");
        if (isLongTerm == 1) {
            Date startTime = meeting.getStartTime();
            String dateStr = DateUtil.dateToDateString((Date)startTime, (String)"yyyy-MM-dd");
            params.setDate(dateStr);
            log.info("syncMeetingRoomChatDetail pull chat date: {}", (Object)dateStr);
        }
        log.info("syncMeetingRoomChatDetail.params:{}", (Object)params);
        List<BaijiacloudExportChatMsgResponse> result = this.baijiacloudApiService.exportChatMsg(params);
        log.info("syncMeetingRoomChatDetail get result: {}", result);
        if (CollectionUtils.isNotEmpty(result)) {
            Set bjyNumbers = result.stream().map(BaijiacloudExportChatMsgResponse::getUserNumber).collect(Collectors.toSet());
            List quitLogList = this.meetingJoinQuitLogMapper.queryJoinQuitLogByNumbers(setting.getBizId(), bjyNumbers, meetingId);
            Map<String, MeetingJoinQuitLog> weworkUserMap = quitLogList.stream().collect(Collectors.toMap(MeetingJoinQuitLog::getBjyNumber, a -> a));
            log.info("syncMeetingRoomChatDetail weworkUserMap: {}", weworkUserMap);
            ArrayList details = Lists.newArrayList();
            HashMap chatCountMap = Maps.newHashMap();
            for (BaijiacloudExportChatMsgResponse resp : result) {
                MeetingRoomChatDetail detail = this.buildChatDetail(meetingId, roomId, resp, setting, weworkUserMap);
                if (chatCountMap.containsKey(detail.getBjyNumber())) {
                    int count = (Integer)chatCountMap.get(detail.getBjyNumber()) + 1;
                    chatCountMap.put(detail.getBjyNumber(), count);
                } else {
                    chatCountMap.put(detail.getBjyNumber(), 1);
                }
                details.add(detail);
            }
            if (meeting.getLiveDeliverySwitch() == 1) {
                List customerInfos = this.meetingCustomerInfoMapper.queryMeetingCustomerByNumber(bizId, meetingId, chatCountMap.keySet());
                Map customerInfoMap = customerInfos.stream().collect(Collectors.toMap(MeetingCustomerInfo::getBjyNumber, Function.identity()));
                ArrayList updateList = Lists.newArrayList();
                chatCountMap.forEach((bjyNumber, value) -> {
                    MeetingCustomerInfo customerInfo = (MeetingCustomerInfo)customerInfoMap.get(bjyNumber);
                    if (customerInfo != null && !Objects.equals(customerInfo.getSendMsgCount(), value)) {
                        customerInfo.setSendMsgCount(value);
                        updateList.add(customerInfo);
                    }
                });
                if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                    log.info("update customerinfo send msg count: {}", (Object)updateList);
                    this.meetingCustomerInfoMapper.batchUpdateSendMsgCount((Collection)updateList);
                }
            }
            log.info("syncMeetingRoomChatDetail details size: {}", (Object)details.size());
            if (CollectionUtils.isNotEmpty((Collection)details)) {
                this.meetingRoomChatDetailMapper.batchInsert((List)details);
                log.info("syncMeetingRoomChatDetail.params:{}, batchInsert chat detail.size:{}", (Object)params, (Object)details.size());
            }
        }
    }

    @Override
    public List<SimpleMeetingDto> getCustomerMeeting(CustomerMeettingReq params) {
        List meetings;
        CurrentUserInfo userInfo = LoginUtils.getCurrentUser();
        if (StringUtils.isBlank((CharSequence)params.getContactId()) && StringUtils.isBlank((CharSequence)params.getMobile())) {
            return Lists.newArrayList();
        }
        if (params.getPageDto() != null) {
            PageDto pageDto = params.getPageDto();
            Page page = PageHelper.startPage((int)pageDto.getPageNum(), (int)pageDto.getPageSize()).doSelectPage(() -> this.meetingMapper.queryCustomerJoinMeeting(userInfo.getBizId(), userInfo.getCorpId(), params.getContactId(), params.getMobile()));
            pageDto.setCount(Integer.valueOf((int)page.getTotal()));
            meetings = page.getResult();
        } else {
            meetings = this.meetingMapper.queryCustomerJoinMeeting(userInfo.getBizId(), userInfo.getCorpId(), params.getContactId(), params.getMobile());
        }
        if (CollectionUtils.isEmpty((Collection)meetings)) {
            return Lists.newArrayList();
        }
        List meetingIds = meetings.stream().map(Meeting::getId).collect(Collectors.toList());
        List quitLogList = this.meetingJoinQuitLogMapper.queryLogListBy(userInfo.getCorpId(), params.getContactId(), params.getMobile(), meetingIds);
        ArrayList result = Lists.newArrayListWithCapacity((int)meetings.size());
        for (Meeting meeting : meetings) {
            SimpleMeetingDto dto = new SimpleMeetingDto();
            dto.setId(meeting.getId());
            dto.setTitle(meeting.getTitle());
            dto.setStatus(meeting.getStatus());
            if (CollectionUtils.isNotEmpty((Collection)quitLogList)) {
                List logs = quitLogList.stream().filter(a -> a.getMeetingId().equals(meeting.getId())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(logs)) {
                    dto.setJoinQuitCount(logs.size());
                    MeetingJoinQuitLog last = (MeetingJoinQuitLog)logs.get(0);
                    MeetingJoinQuitLog first = (MeetingJoinQuitLog)logs.get(logs.size() - 1);
                    dto.setEndTime(last.getQuitTime());
                    dto.setStartTime(first.getJoinTime());
                    long meetingLength = (meeting.getEndTime().getTime() - meeting.getStartTime().getTime()) / 1000L;
                    log.info("getCustomerMeeting meetingLength: {}", (Object)meetingLength);
                    int totalDuration = 0;
                    for (MeetingJoinQuitLog L : logs) {
                        totalDuration += L.getDuration().intValue();
                    }
                    log.info("getCustomerMeeting totalDuration: {}", (Object)totalDuration);
                    String format = "0.0000";
                    Double percent = (double)totalDuration / (double)meetingLength;
                    DecimalFormat df = new DecimalFormat(format);
                    dto.setCompletePercent(df.format(percent));
                    dto.setDuration(totalDuration);
                }
            } else {
                log.info("getCustomerMeeting quitLogList is null");
            }
            result.add(dto);
        }
        return result;
    }

    @Override
    public void supportCommerceTask(MeetingAddOrModReqDto reqDto) {
        Meeting meeting = (Meeting)this.meetingMapper.selectByPrimaryKey((Object)reqDto.getId());
        MultiSearchContactResp multiSearchContactResp = null;
        MultiSearchContactReq multiSearchContactReq = null;
        if (MeetingType.EXTERNAL_MEETING.getValue() == reqDto.getType().intValue()) {
            multiSearchContactReq = this.buildMultiSearchContactReq(reqDto, LoginUtils.getCurrentUser());
            multiSearchContactResp = this.multiSelectService.multiSearchContact(multiSearchContactReq, true);
            if (Objects.isNull(multiSearchContactResp) || CollectionUtils.isEmpty((Collection)multiSearchContactResp.getList())) {
                log.info("\u6839\u636e\u6761\u4ef6multiSearchContactReq:{}\u672a\u67e5\u8be2\u5230\u5ba2\u6237", (Object)multiSearchContactReq);
                throw new BusinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u6240\u9009\u5ba2\u6237\u4eba\u6570\u4e3a0");
            }
            multiSearchContactReq.setRequestId(multiSearchContactResp.getRequestId());
        }
        this.supportMeetingCommerceTask(LoginUtils.getCurrentUser(), reqDto, meeting, multiSearchContactResp);
    }

    @Override
    @Transactional
    public void meetingGoodsClickReport(GoodsClickReq req) {
        log.info("meeting goods click report req: {}", (Object)req);
        if (req == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u53c2\u6570\u4e3a\u7a7a");
        }
        req.validate();
        Meeting meeting = this.meetingMapper.selectByNum(req.getMeetingId());
        if (meeting == null) {
            throw new BusinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u627e\u4e0d\u5230\u76f4\u64ad");
        }
        MeetingGoodsClickLog select = new MeetingGoodsClickLog();
        select.setNum(req.getAccessNum());
        select = (MeetingGoodsClickLog)this.meetingGoodsClickLogMapper.selectOne((Object)select);
        if (select != null) {
            log.info("accessNum is use");
            return;
        }
        EventVisitor visitor = new EventVisitor();
        String customerNum = null;
        String infoId = req.getBjyNumber();
        if (StringUtils.isNotBlank((CharSequence)req.getCustomerStr())) {
            MeetingCustomerParamEncryRelation selectRelation = new MeetingCustomerParamEncryRelation();
            selectRelation.setMeetingId(meeting.getId());
            selectRelation.setEncryNum(req.getCustomerStr());
            List relations = this.meetingCustomerParamEncryRelationMapper.select((Object)selectRelation);
            if (CollectionUtils.isNotEmpty((Collection)relations)) {
                MeetingCustomerParamEncryRelation relation = (MeetingCustomerParamEncryRelation)relations.get(0);
                if (StringUtils.isNotBlank((CharSequence)relation.getContactId())) {
                    infoId = relation.getContactId();
                    customerNum = this.ccCustomerNumService.getCustomerNumByWeworkContactId(meeting.getBizId(), infoId, null);
                } else if (StringUtils.isNotBlank((CharSequence)relation.getUnionId())) {
                    infoId = relation.getUnionId();
                    CustomerDetailReq detailReq = new CustomerDetailReq();
                    detailReq.setBizId(meeting.getBizId());
                    detailReq.setUnionIds((List)Lists.newArrayList((Object[])new String[]{infoId}));
                    List customerDetails = this.customerDetailService.queryCustomerDetailInfo(detailReq);
                    if (CollectionUtils.isNotEmpty((Collection)customerDetails)) {
                        customerNum = ((CustomerDetailResp)customerDetails.get(0)).getCustomerNum();
                    }
                } else if (StringUtils.isNotBlank((CharSequence)relation.getOpenId())) {
                    infoId = relation.getAppId() + relation.getOpenId();
                    customerNum = this.ccCustomerNumService.getCustomerNumByWeworkOpenId(meeting.getBizId(), relation.getOpenId());
                }
                visitor.setName(relation.getBjyName());
                visitor.setAvatar(relation.getBjyAvatar());
                visitor.setContactId(relation.getContactId());
                visitor.setAppId(relation.getAppId());
                visitor.setOpenId(relation.getOpenId());
                visitor.setUnionId(relation.getUnionId());
            }
        } else if (StringUtils.isNotBlank((CharSequence)req.getBjyNumber())) {
            MeetingCustomerInfo customerInfo = new MeetingCustomerInfo();
            customerInfo.setBizId(meeting.getBizId());
            customerInfo.setMeetingId(meeting.getId());
            customerInfo.setBjyNumber(req.getBjyNumber());
            List meetingCustomerInfos = this.meetingCustomerInfoMapper.select((Object)customerInfo);
            if (CollectionUtils.isNotEmpty((Collection)meetingCustomerInfos)) {
                customerInfo = (MeetingCustomerInfo)meetingCustomerInfos.get(0);
                if (StringUtils.isNotBlank((CharSequence)customerInfo.getBjyMobile())) {
                    customerNum = this.ccCustomerNumService.getCustomerNumByMobile(meeting.getBizId(), customerInfo.getBjyMobile());
                }
                visitor.setName(customerInfo.getName());
                visitor.setMobile(customerInfo.getBjyMobile());
            }
        }
        MeetingGoodsClickLog clickLog = new MeetingGoodsClickLog();
        clickLog.setNum(req.getAccessNum());
        clickLog.setBizId(meeting.getBizId());
        clickLog.setMeetingId(meeting.getId());
        clickLog.setGoodsProductId(req.getProductId());
        clickLog.setCustomerStr(req.getCustomerStr());
        clickLog.setBjyNumber(req.getBjyNumber());
        clickLog.setInfoId(infoId);
        clickLog.setCreateBy(Long.valueOf(-1L));
        clickLog.setCreateTime(new Date());
        this.meetingGoodsClickLogMapper.insertSelective((Object)clickLog);
        if (StringUtils.isBlank((CharSequence)customerNum)) {
            log.info("customerNum is blank");
            return;
        }
        CustomerEventReq eventReq = new CustomerEventReq();
        eventReq.setEventType(EventType.VISIT_PAGE.getCode());
        eventReq.setEventTime(clickLog.getCreateTime());
        eventReq.setBizId(clickLog.getBizId());
        eventReq.setSource("scrm");
        eventReq.setCustomerNum(customerNum);
        EventData eventData = new EventData();
        eventData.setAccessNum(req.getAccessNum());
        EventModule module = new EventModule();
        module.setType(ModuleType.MEETING_GOODS.getCode());
        module.setName(meeting.getTitle());
        module.setMeetingId(meeting.getId());
        module.setMeetingType(meeting.getType());
        module.setProductId(req.getProductId());
        ShopSpu shopSpu = this.shopSpuMapper.queryByBizIdAndProductId(clickLog.getBizId(), req.getProductId());
        if (shopSpu != null) {
            if (StringUtils.isNotBlank((CharSequence)shopSpu.getTitle())) {
                module.setProductName(shopSpu.getTitle());
            } else {
                try {
                    SpuCreateReq spuBody = (SpuCreateReq)JacksonUtil.str2Obj((String)shopSpu.getSpuBody(), SpuCreateReq.class);
                    module.setProductName(spuBody.getTitle());
                }
                catch (Exception e) {
                    log.error("parse spu body json error:", (Throwable)e);
                }
            }
        }
        eventData.setModule(module);
        eventData.setVisitor(visitor);
        eventReq.setEventData(eventData);
        log.info("goods click eventReq write: {}", (Object)eventReq);
        try {
            this.ccCustomerEventService.add(eventReq);
        }
        catch (Exception e) {
            log.error("goods click eventReq error: ", (Throwable)e);
        }
    }

    MeetingRoomChatDetail buildChatDetail(long meetingId, String roomId, BaijiacloudExportChatMsgResponse resp, MeetingSetting setting, Map<String, MeetingJoinQuitLog> cache) {
        MeetingRoomChatDetail detail = new MeetingRoomChatDetail();
        detail.setBizId(setting.getBizId());
        detail.setBjyName(resp.getUserName());
        detail.setBjyNumber(resp.getUserNumber());
        detail.setChatTime(BaseUtils.getDate((String)resp.getTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        if (cache.containsKey(resp.getUserNumber())) {
            MeetingJoinQuitLog quitLog = cache.get(resp.getUserNumber());
            detail.setWeworkUserNum(quitLog.getWeworkUserNum());
            if (StringUtils.isNotBlank((CharSequence)quitLog.getContactId())) {
                detail.setContactId(quitLog.getContactId());
            } else {
                detail.setContactId("");
            }
        } else {
            detail.setContactId("");
            detail.setWeworkUserNum("");
        }
        detail.setContent(resp.getContent());
        detail.setCorpId(setting.getCorpId());
        detail.setCreateTime(new Date());
        detail.setMeetingId(Long.valueOf(meetingId));
        detail.setRoomId(roomId);
        detail.setUserRole(Integer.valueOf(resp.getUserRole()));
        return detail;
    }
}

